#!/usr/bin/perl
# Do not normalise this test file. It has deliberately unnormalised characters in it.
use v5.10;
use strict;
use warnings;
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Test::More tests => 290;
use Test::Exception;

use ok 'Locale::CLDR';

my $locale = Locale::CLDR->new('de_DE');

is($locale->unit(1, 'acre', 'narrow'), '1 ac', 'German narrow 1 acre');
is($locale->unit(2, 'acre', 'narrow'), '2 ac', 'German narrow 2 acres');
is($locale->unit(1, 'acre', 'short'), '1 ac', 'German short 1 acre');
is($locale->unit(2, 'acre', 'short'), '2 ac', 'German short 2 acres');
is($locale->unit(1, 'acre'), '1 Acre', 'German long 1 acre');
is($locale->unit(2, 'acre'), '2 Acres', 'German long 2 acres');
is($locale->unit(1, 'arc-minute', 'narrow'), '1′', 'German narrow 1 minute');
is($locale->unit(2, 'arc-minute', 'narrow'), '2′', 'German narrow 2 minutes');
is($locale->unit(1, 'arc-minute', 'short'), '1′', 'German short 1 arc minute');
is($locale->unit(2, 'arc-minute', 'short'), '2′', 'German short 2 arc minutes');
is($locale->unit(1, 'arc-minute'), '1 Winkelminute', 'German long 1 arc minute');
is($locale->unit(2, 'arc-minute'), '2 Winkelminuten', 'German long 2 arc minutes');
is($locale->unit(1, 'arc-second', 'narrow'), '1″', 'German narrow 1 second');
is($locale->unit(2, 'arc-second', 'narrow'), '2″', 'German narrow 2 seconds');
is($locale->unit(1, 'arc-second', 'short'), '1″', 'German short 1 arc second');
is($locale->unit(2, 'arc-second', 'short'), '2″', 'German short 2 arc seconds');
is($locale->unit(1, 'arc-second'), '1 Winkelsekunde', 'German long 1 arc second');
is($locale->unit(2, 'arc-second'), '2 Winkelsekunden', 'German long 2 arc seconds');
is($locale->unit(1, 'celsius', 'narrow'), '1°', 'German narrow 1 degree Celsius');
is($locale->unit(2, 'celsius', 'narrow'), '2°', 'German narrow 2 degrees Celsius');
is($locale->unit(1, 'celsius', 'short'), '1 °C', 'German short 1 degree Celsius');
is($locale->unit(2, 'celsius', 'short'), '2 °C', 'German short 2 degrees Celsius');
is($locale->unit(1, 'celsius'), '1 Grad Celsius', 'German long 1 degree Celsius');
is($locale->unit(2, 'celsius'), '2 Grad Celsius', 'German long 2 degrees Celsius');
is($locale->unit(1, 'centimeter', 'narrow'), '1 cm', 'German narrow 1 centimetre');
is($locale->unit(2, 'centimeter', 'narrow'), '2 cm', 'German narrow 2 centimetres');
is($locale->unit(1, 'centimeter', 'short'), '1 cm', 'German short 1 centimetre');
is($locale->unit(2, 'centimeter', 'short'), '2 cm', 'German short 2 centimetres');
is($locale->unit(1, 'centimeter'), '1 Zentimeter', 'German long 1 centimetre');
is($locale->unit(2, 'centimeter'), '2 Zentimeter', 'German long 2 centimetres');
is($locale->unit(1, 'cubic-kilometer', 'narrow'), '1 km³', 'German narrow 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer', 'narrow'), '2 km³', 'German narrow 2 cubic kilometres');
is($locale->unit(1, 'cubic-kilometer', 'short'), '1 km³', 'German short 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer', 'short'), '2 km³', 'German short 2 cubic kilometres');
is($locale->unit(1, 'cubic-kilometer'), '1 Kubikkilometer', 'German long 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer'), '2 Kubikkilometer', 'German long 2 cubic kilometres');
is($locale->unit(1, 'cubic-mile', 'narrow'), '1 mi³', 'German narrow 1 cubic mile');
is($locale->unit(2, 'cubic-mile', 'narrow'), '2 mi³', 'German narrow 2 cubic miles');
is($locale->unit(1, 'cubic-mile', 'short'), '1 mi³', 'German short 1 cubic mile');
is($locale->unit(2, 'cubic-mile', 'short'), '2 mi³', 'German short 2 cubic miles');
is($locale->unit(1, 'cubic-mile'), '1 Kubikmeile', 'German long 1 cubic mile');
is($locale->unit(2, 'cubic-mile'), '2 Kubikmeilen', 'German long 2 cubic miles');
is($locale->unit(1, 'day', 'narrow'), '1 T', 'German narrow 1 day');
is($locale->unit(2, 'day', 'narrow'), '2 T', 'German narrow 2 days');
is($locale->unit(1, 'day', 'short'), '1 Tg.', 'German short 1 day');
is($locale->unit(2, 'day', 'short'), '2 Tg.', 'German short 2 days');
is($locale->unit(1, 'day'), '1 Tag', 'German long 1 day');
is($locale->unit(2, 'day'), '2 Tage', 'German long 2 days');
is($locale->unit(1, 'degree', 'narrow'), '1°', 'German narrow 1 degree');
is($locale->unit(2, 'degree', 'narrow'), '2°', 'German narrow 2 degrees');
is($locale->unit(1, 'degree', 'short'), '1°', 'German short 1 degree');
is($locale->unit(2, 'degree', 'short'), '2°', 'German short 2 degree');
is($locale->unit(1, 'degree'), '1 Grad', 'German long 1 degree');
is($locale->unit(2, 'degree'), '2 Grad', 'German long 2 degrees');
is($locale->unit(1, 'fahrenheit', 'narrow'), '1°F', 'German narrow 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit', 'narrow'), '2°F', 'German narrow 2 degrees Fahrenheit');
is($locale->unit(1, 'fahrenheit', 'short'), '1°F', 'German short 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit', 'short'), '2°F', 'German short 2 degrees Fahrenheit');
is($locale->unit(1, 'fahrenheit'), '1 Grad Fahrenheit', 'German long 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit'), '2 Grad Fahrenheit', 'German long 2 degrees Fahrenheit');
is($locale->unit(1, 'foot', 'narrow'), '1 ft', 'German narrow 1 foot');
is($locale->unit(2, 'foot', 'narrow'), '2 ft', 'German narrow 2 feet');
is($locale->unit(1, 'foot', 'short'), '1 ft', 'German short 1 foot');
is($locale->unit(2, 'foot', 'short'), '2 ft', 'German short 2 feet');
is($locale->unit(1, 'foot'), '1 Fuß', 'German long 1 foot');
is($locale->unit(2, 'foot'), '2 Fuß', 'German long 2 feet');
is($locale->unit(1, 'g-force', 'narrow'), '1 G', 'German narrow 1 g-force');
is($locale->unit(2, 'g-force', 'narrow'), '2 G', 'German narrow 2 g-force');
is($locale->unit(1, 'g-force', 'short'), '1 G', 'German short 1 g-force');
is($locale->unit(2, 'g-force', 'short'), '2 G', 'German short 2 g-force');
is($locale->unit(1, 'g-force'), '1-fache Erdbeschleunigung', 'German long 1 g-force');
is($locale->unit(2, 'g-force'), '2-fache Erdbeschleunigung', 'German long 2 g-force');
is($locale->unit(1, 'gram', 'narrow'), '1 g', 'German narrow 1 gram');
is($locale->unit(2, 'gram', 'narrow'), '2 g', 'German narrow 2 grams');
is($locale->unit(1, 'gram', 'short'), '1 g', 'German short 1 gram');
is($locale->unit(2, 'gram', 'short'), '2 g', 'German short 2 grams');
is($locale->unit(1, 'gram'), '1 Gramm', 'German long 1 gram');
is($locale->unit(2, 'gram'), '2 Gramm', 'German long 2 grams');
is($locale->unit(1, 'hectare', 'narrow'), '1 ha', 'German narrow 1 hectare');
is($locale->unit(2, 'hectare', 'narrow'), '2 ha', 'German narrow 2 hectares');
is($locale->unit(1, 'hectare', 'short'), '1 ha', 'German short 1 hectare');
is($locale->unit(2, 'hectare', 'short'), '2 ha', 'German short 2 hectares');
is($locale->unit(1, 'hectare'), '1 Hektar', 'German long 1 hectare');
is($locale->unit(2, 'hectare'), '2 Hektar', 'German long 2 hectares');
is($locale->unit(1, 'hectopascal', 'narrow'), '1 hPa', 'German narrow 1 hectopascal');
is($locale->unit(2, 'hectopascal', 'narrow'), '2 hPa', 'German narrow 2 hectopascals');
is($locale->unit(1, 'hectopascal', 'short'), '1 hPa', 'German short 1 hectopascal');
is($locale->unit(2, 'hectopascal', 'short'), '2 hPa', 'German short 2 hectopascals');
is($locale->unit(1, 'hectopascal'), '1 Hektopascal', 'German long 1 hectopascal');
is($locale->unit(2, 'hectopascal'), '2 Hektopascal', 'German long 2 hectopascals');
is($locale->unit(1, 'horsepower', 'narrow'), '1 PS', 'German narrow 1 horsepower');
is($locale->unit(2, 'horsepower', 'narrow'), '2 PS', 'German narrow 2 horsepower');
is($locale->unit(1, 'horsepower', 'short'), '1 PS', 'German short 1 horsepower');
is($locale->unit(2, 'horsepower', 'short'), '2 PS', 'German short 2 horsepower');
is($locale->unit(1, 'horsepower'), '1 Pferdestärke', 'German long 1 horsepower');
is($locale->unit(2, 'horsepower'), '2 Pferdestärken', 'German long 2 horsepower');
is($locale->unit(1, 'hour', 'narrow'), '1 Std.', 'German narrow 1 hour');
is($locale->unit(2, 'hour', 'narrow'), '2 Std.', 'German narrow 2 hours');
is($locale->unit(1, 'hour', 'short'), '1 Std.', 'German short 1 hour');
is($locale->unit(2, 'hour', 'short'), '2 Std.', 'German short 2 hours');
is($locale->unit(1, 'hour'), '1 Stunde', 'German long 1 hour');
is($locale->unit(2, 'hour'), '2 Stunden', 'German long 2 hours');
is($locale->unit(1, 'inch', 'narrow'), '1 in', 'German narrow 1 inch');
is($locale->unit(2, 'inch', 'narrow'), '2 in', 'German narrow 2 inches');
is($locale->unit(1, 'inch', 'short'), '1 in', 'German short 1 inch');
is($locale->unit(2, 'inch', 'short'), '2 in', 'German short 2 inches');
is($locale->unit(1, 'inch'), '1 Zoll', 'German long 1 inch');
is($locale->unit(2, 'inch'), '2 Zoll', 'German long 2 inches');
is($locale->unit(1, 'inch-hg', 'narrow'), '1 inHg', 'German narrow 1 inch of mercury');
is($locale->unit(2, 'inch-hg', 'narrow'), '2 inHg', 'German narrow 2 inches of mercury');
is($locale->unit(1, 'inch-hg', 'short'), '1 inHg', 'German short 1 inch of mercury');
is($locale->unit(2, 'inch-hg', 'short'), '2 inHg', 'German short 2 inches of mercury');
is($locale->unit(1, 'inch-hg'), '1 Zoll Quecksilbersäule', 'German long 1 inch of mercury');
is($locale->unit(2, 'inch-hg'), '2 Zoll Quecksilbersäule', 'German long 2 inches of mercury');
is($locale->unit(1, 'kilogram', 'narrow'), '1 kg', 'German narrow 1 kilogram');
is($locale->unit(2, 'kilogram', 'narrow'), '2 kg', 'German narrow 2 kilograms');
is($locale->unit(1, 'kilogram', 'short'), '1 kg', 'German short 1 kilogram');
is($locale->unit(2, 'kilogram', 'short'), '2 kg', 'German short 2 kilograms');
is($locale->unit(1, 'kilogram'), '1 Kilogramm', 'German long 1 kilogram');
is($locale->unit(2, 'kilogram'), '2 Kilogramm', 'German long 2 kilograms');
is($locale->unit(1, 'kilometer', 'narrow'), '1 km', 'German narrow 1 kilometre');
is($locale->unit(2, 'kilometer', 'narrow'), '2 km', 'German narrow 2 kilometres');
is($locale->unit(1, 'kilometer', 'short'), '1 km', 'German short 1 kilometre');
is($locale->unit(2, 'kilometer', 'short'), '2 km', 'German short 2 kilometres');
is($locale->unit(1, 'kilometer'), '1 Kilometer', 'German long 1 kilometre');
is($locale->unit(2, 'kilometer'), '2 Kilometer', 'German long 2 kilometres');
is($locale->unit(1, 'kilometer-per-hour', 'narrow'), '1 km/h', 'German narrow 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour', 'narrow'), '2 km/h', 'German narrow 2 kilometres per hour');
is($locale->unit(1, 'kilometer-per-hour', 'short'), '1 km/h', 'German short 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour', 'short'), '2 km/h', 'German short 2 kilometres per hour');
is($locale->unit(1, 'kilometer-per-hour'), '1 Kilometer pro Stunde', 'German long 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour'), '2 Kilometer pro Stunde', 'German long 2 kilometres per hour');
is($locale->unit(1, 'kilowatt', 'narrow'), '1 kW', 'German narrow 1 kilowatt');
is($locale->unit(2, 'kilowatt', 'narrow'), '2 kW', 'German narrow 2 kilowatts');
is($locale->unit(1, 'kilowatt', 'short'), '1 kW', 'German short 1 kilowatt');
is($locale->unit(2, 'kilowatt', 'short'), '2 kW', 'German short 2 kilowatts');
is($locale->unit(1, 'kilowatt'), '1 Kilowatt', 'German long 1 kilowatt');
is($locale->unit(2, 'kilowatt'), '2 Kilowatt', 'German long 2 kilowatts');
is($locale->unit(1, 'light-year', 'narrow'), '1 ly', 'German narrow 1 light year');
is($locale->unit(2, 'light-year', 'narrow'), '2 ly', 'German narrow 2 light years');
is($locale->unit(1, 'light-year', 'short'), '1 Lj', 'German short 1 light year');
is($locale->unit(2, 'light-year', 'short'), '2 Lj', 'German short 2 light years');
is($locale->unit(1, 'light-year'), '1 Lichtjahr', 'German long 1 light year');
is($locale->unit(2, 'light-year'), '2 Lichtjahre', 'German long 2 light years');
is($locale->unit(1, 'liter', 'narrow'), '1 l', 'German narrow 1 litre');
is($locale->unit(2, 'liter', 'narrow'), '2 l', 'German narrow 2 litres');
is($locale->unit(1, 'liter', 'short'), '1 l', 'German short 1 litre');
is($locale->unit(2, 'liter', 'short'), '2 l', 'German short 2 litres');
is($locale->unit(1, 'liter'), '1 Liter', 'German long 1 litre');
is($locale->unit(2, 'liter'), '2 Liter', 'German long 2 litres');
is($locale->unit(1, 'meter', 'narrow'), '1 m', 'German narrow 1 meter');
is($locale->unit(2, 'meter', 'narrow'), '2 m', 'German narrow 2 meters');
is($locale->unit(1, 'meter', 'short'), '1 m', 'German short 1 meter');
is($locale->unit(2, 'meter', 'short'), '2 m', 'German short 2 meters');
is($locale->unit(1, 'meter'), '1 Meter', 'German long 1 meter');
is($locale->unit(2, 'meter'), '2 Meter', 'German long 2 meters');
is($locale->unit(1, 'meter-per-second', 'narrow'), '1 m/s', 'German narrow 1 meter per second');
is($locale->unit(2, 'meter-per-second', 'narrow'), '2 m/s', 'German narrow 2 meters per second');
is($locale->unit(1, 'meter-per-second', 'short'), '1 m/s', 'German short 1 meter per second');
is($locale->unit(2, 'meter-per-second', 'short'), '2 m/s', 'German short 2 meters per second');
is($locale->unit(1, 'meter-per-second'), '1 Meter pro Sekunde', 'German long 1 meter per second');
is($locale->unit(2, 'meter-per-second'), '2 Meter pro Sekunde', 'German long 2 meters per second');
is($locale->unit(1, 'mile', 'narrow'), '1 mi', 'German narrow 1 mile');
is($locale->unit(2, 'mile', 'narrow'), '2 mi', 'German narrow 2 miles');
is($locale->unit(1, 'mile', 'short'), '1 mi', 'German short 1 mile');
is($locale->unit(2, 'mile', 'short'), '2 mi', 'German short 2 miles');
is($locale->unit(1, 'mile'), '1 Meile', 'German long 1 mile');
is($locale->unit(2, 'mile'), '2 Meilen', 'German long 2 miles');
is($locale->unit(1, 'mile-per-hour', 'narrow'), '1 mi/h', 'German narrow 1 mile per hour');
is($locale->unit(2, 'mile-per-hour', 'narrow'), '2 mi/h', 'German narrow 2 miles per hour');
is($locale->unit(1, 'mile-per-hour', 'short'), '1 mi/h', 'German short 1 mile per hour');
is($locale->unit(2, 'mile-per-hour', 'short'), '2 mi/h', 'German short 2 miles per hour');
is($locale->unit(1, 'mile-per-hour'), '1 Meile pro Stunde', 'German long 1 mile per hour');
is($locale->unit(2, 'mile-per-hour'), '2 Meilen pro Stunde', 'German long 2 miles per hour');
is($locale->unit(1, 'millibar', 'narrow'), '1 mbar', 'German narrow 1 millibar');
is($locale->unit(2, 'millibar', 'narrow'), '2 mbar', 'German narrow 2 millibars');
is($locale->unit(1, 'millibar', 'short'), '1 mbar', 'German short 1 millibar');
is($locale->unit(2, 'millibar', 'short'), '2 mbar', 'German short 2 millibars');
is($locale->unit(1, 'millibar'), '1 Millibar', 'German long 1 millibar');
is($locale->unit(2, 'millibar'), '2 Millibar', 'German long 2 millibars');
is($locale->unit(1, 'millimeter', 'narrow'), '1 mm', 'German narrow 1 millimetre');
is($locale->unit(2, 'millimeter', 'narrow'), '2 mm', 'German narrow 2 millimetres');
is($locale->unit(1, 'millimeter', 'short'), '1 mm', 'German short 1 millimetre');
is($locale->unit(2, 'millimeter', 'short'), '2 mm', 'German short 2 millimetres');
is($locale->unit(1, 'millimeter'), '1 Millimeter', 'German long 1 millimetre');
is($locale->unit(2, 'millimeter'), '2 Millimeter', 'German long 2 millimetres');
is($locale->unit(1, 'millisecond', 'narrow'), '1 ms', 'German narrow 1 millisecond');
is($locale->unit(2, 'millisecond', 'narrow'), '2 ms', 'German narrow 2 milliseconds');
is($locale->unit(1, 'millisecond', 'short'), '1 ms', 'German short 1 millisecond');
is($locale->unit(2, 'millisecond', 'short'), '2 ms', 'German short 2 milliseconds');
is($locale->unit(1, 'millisecond'), '1 Millisekunde', 'German long 1 millisecond');
is($locale->unit(2, 'millisecond'), '2 Millisekunden', 'German long 2 milliseconds');
is($locale->unit(1, 'minute', 'narrow'), '1 Min.', 'German narrow 1 minute');
is($locale->unit(2, 'minute', 'narrow'), '2 Min.', 'German narrow 2 minutes');
is($locale->unit(1, 'minute', 'short'), '1 Min.', 'German short 1 minute');
is($locale->unit(2, 'minute', 'short'), '2 Min.', 'German short 2 minutes');
is($locale->unit(1, 'minute'), '1 Minute', 'German long 1 minute');
is($locale->unit(2, 'minute'), '2 Minuten', 'German long 2 minutes');
is($locale->unit(1, 'month', 'narrow'), '1 M', 'German narrow 1 month');
is($locale->unit(2, 'month', 'narrow'), '2 M', 'German narrow 2 months');
is($locale->unit(1, 'month', 'short'), '1 Mon.', 'German short 1 month');
is($locale->unit(2, 'month', 'short'), '2 Mon.', 'German short 2 months');
is($locale->unit(1, 'month'), '1 Monat', 'German long 1 month');
is($locale->unit(2, 'month'), '2 Monate', 'German long 2 months');
is($locale->unit(1, 'ounce', 'narrow'), '1 oz', 'German narrow 1 ounce');
is($locale->unit(2, 'ounce', 'narrow'), '2 oz', 'German narrow 2 ounces');
is($locale->unit(1, 'ounce', 'short'), '1 oz', 'German short 1 ounce');
is($locale->unit(2, 'ounce', 'short'), '2 oz', 'German short 2 ounces');
is($locale->unit(1, 'ounce'), '1 Unze', 'German long 1 ounce');
is($locale->unit(2, 'ounce'), '2 Unzen', 'German long 2 ounces');
is($locale->unit(1, 'millimeter-per-second', 'narrow'), '1 mm/s', 'German narrow 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second', 'narrow'), '2 mm/s', 'German narrow 2 millimetres per second');
is($locale->unit(1, 'millimeter-per-second', 'short'), '1 mm/s', 'German short 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second', 'short'), '2 mm/s', 'German short 2 millimetres per second');
is($locale->unit(1, 'millimeter-per-second'), '1 Millimeter pro Sekunde', 'German long 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second'), '2 Millimeter pro Sekunde', 'German long 2 millimetres per second');
is($locale->unit(1, 'picometer', 'narrow'), '1 pm', 'German narrow 1 picometre');
is($locale->unit(2, 'picometer', 'narrow'), '2 pm', 'German narrow 2 picometres');
is($locale->unit(1, 'picometer', 'short'), '1 pm', 'German short 1 picometre');
is($locale->unit(2, 'picometer', 'short'), '2 pm', 'German short 2 picometres');
is($locale->unit(1, 'picometer'), '1 Pikometer', 'German long 1 picometre');
is($locale->unit(2, 'picometer'), '2 Pikometer', 'German long 2 picometres');
is($locale->unit(1, 'pound', 'narrow'), '1 lb', 'German narrow 1 pound');
is($locale->unit(2, 'pound', 'narrow'), '2 lb', 'German narrow 2 pounds');
is($locale->unit(1, 'pound', 'short'), '1 lb', 'German short 1 pound');
is($locale->unit(2, 'pound', 'short'), '2 lb', 'German short 2 pounds');
is($locale->unit(1, 'pound'), '1 Pfund', 'German long 1 pound');
is($locale->unit(2, 'pound'), '2 Pfund', 'German long 2 pounds');
is($locale->unit(1, 'second', 'narrow'), '1 s', 'German narrow 1 second');
is($locale->unit(2, 'second', 'narrow'), '2 s', 'German narrow 2 seconds');
is($locale->unit(1, 'second', 'short'), '1 Sek.', 'German short 1 second');
is($locale->unit(2, 'second', 'short'), '2 Sek.', 'German short 2 seconds');
is($locale->unit(1, 'second'), '1 Sekunde', 'German long 1 second');
is($locale->unit(2, 'second'), '2 Sekunden', 'German long 2 seconds');
is($locale->unit(1, 'square-foot', 'narrow'), '1 ft²', 'German narrow 1 square foot');
is($locale->unit(2, 'square-foot', 'narrow'), '2 ft²', 'German narrow 2 square feet');
is($locale->unit(1, 'square-foot', 'short'), '1 ft²', 'German short 1 square foot');
is($locale->unit(2, 'square-foot', 'short'), '2 ft²', 'German short 2 square feet');
is($locale->unit(1, 'square-foot'), '1 Quadratfuß', 'German long 1 square foot');
is($locale->unit(2, 'square-foot'), '2 Quadratfuß', 'German long 2 square feet');
is($locale->unit(1, 'square-kilometer', 'narrow'), '1 km²', 'German narrow 1 square kilometre');
is($locale->unit(2, 'square-kilometer', 'narrow'), '2 km²', 'German narrow 2 square kilometres');
is($locale->unit(1, 'square-kilometer', 'short'), '1 km²', 'German short 1 square kilometre');
is($locale->unit(2, 'square-kilometer', 'short'), '2 km²', 'German short 2 square kilometres');
is($locale->unit(1, 'square-kilometer'), '1 Quadratkilometer', 'German long 1 square kilometre');
is($locale->unit(2, 'square-kilometer'), '2 Quadratkilometer', 'German long 2 square kilometres');
is($locale->unit(1, 'square-meter', 'narrow'), '1 m²', 'German narrow 1 square meter');
is($locale->unit(2, 'square-meter', 'narrow'), '2 m²', 'German narrow 2 square meters');
is($locale->unit(1, 'square-meter', 'short'), '1 m²', 'German short 1 square meter');
is($locale->unit(2, 'square-meter', 'short'), '2 m²', 'German short 2 square metres');
is($locale->unit(1, 'square-meter'), '1 Quadratmeter', 'German long 1 square metre');
is($locale->unit(2, 'square-meter'), '2 Quadratmeter', 'German long 2 square metres');
is($locale->unit(1, 'square-mile', 'narrow'), '1 mi²', 'German narrow 1 square mile');
is($locale->unit(2, 'square-mile', 'narrow'), '2 mi²', 'German narrow 2 square miles');
is($locale->unit(1, 'square-mile', 'short'), '1 mi²', 'German short 1 square mile');
is($locale->unit(2, 'square-mile', 'short'), '2 mi²', 'German short 2 square miles');
is($locale->unit(1, 'square-mile'), '1 Quadratmeile', 'German long 1 square mile');
is($locale->unit(2, 'square-mile'), '2 Quadratmeilen', 'German long 2 square miles');
is($locale->unit(1, 'watt', 'narrow'), '1 W', 'German narrow 1 watt');
is($locale->unit(2, 'watt', 'narrow'), '2 W', 'German narrow 2 watts');
is($locale->unit(1, 'watt', 'short'), '1 W', 'German short 1 watt');
is($locale->unit(2, 'watt', 'short'), '2 W', 'German short 2 watts');
is($locale->unit(1, 'watt'), '1 Watt', 'German long 1 watt');
is($locale->unit(2, 'watt'), '2 Watt', 'German long 2 watts');
is($locale->unit(1, 'week', 'narrow'), '1 W', 'German narrow 1 week');
is($locale->unit(2, 'week', 'narrow'), '2 W', 'German narrow 2 weeks');
is($locale->unit(1, 'week', 'short'), '1 Wo.', 'German short 1 week');
is($locale->unit(2, 'week', 'short'), '2 Wo.', 'German short 2 weeks');
is($locale->unit(1, 'week'), '1 Woche', 'German long 1 week');
is($locale->unit(2, 'week'), '2 Wochen', 'German long 2 weeks');
is($locale->unit(1, 'yard', 'narrow'), '1 yd', 'German narrow 1 yard');
is($locale->unit(2, 'yard', 'narrow'), '2 yd', 'German narrow 2 yards');
is($locale->unit(1, 'yard', 'short'), '1 yd', 'German short 1 yard');
is($locale->unit(2, 'yard', 'short'), '2 yd', 'German short 2 yards');
is($locale->unit(1, 'yard'), '1 Yard', 'German long 1 yard');
is($locale->unit(2, 'yard'), '2 Yards', 'German long 2 yards');
is($locale->unit(1, 'year', 'narrow'), '1 J', 'German narrow 1 year');
is($locale->unit(2, 'year', 'narrow'), '2 J', 'German narrow 2 years');
is($locale->unit(1, 'year', 'short'), '1 J', 'German short 1 year');
is($locale->unit(2, 'year', 'short'), '2 J', 'German short 2 years');
is($locale->unit(1, 'year'), '1 Jahr', 'German long 1 year');
is($locale->unit(2, 'year'), '2 Jahre', 'German long 2 years');
is($locale->duration_unit('hm', 1, 2), '1:02', 'German duration hour, minuet');
is($locale->duration_unit('hms', 1, 2, 3 ), '1:02:03', 'German duration hour, minuet, second');
is($locale->duration_unit('ms', 1, 2 ), '1:02', 'German duration minuet, second');
is($locale->is_yes('Yes'), 1, 'German is yes');
is($locale->is_yes('es'), 0, 'German is not yes');
is($locale->is_no('nein'), 1, 'German is no');
is($locale->is_no('N&'), 0, 'German is not no');