=head1

Locale::CLDR::Locales::Ce - Package for language Chechen

=cut

package Locale::CLDR::Locales::Ce;
# This file auto generated from Data\common\main\ce.xml
#	on Sun  4 Mar  1:05:34 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.32.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афарийн',
 				'ab' => 'абхазхойн',
 				'ace' => 'ачехийн',
 				'ada' => 'адангме',
 				'ady' => 'адигейн',
 				'af' => 'африкаанс',
 				'agq' => 'агхӀем',
 				'ain' => 'айнийн',
 				'ak' => 'акан',
 				'ale' => 'алеутийн',
 				'alt' => 'къилба алтайн',
 				'am' => 'амхаройн',
 				'an' => 'арагонойн',
 				'anp' => 'ангика',
 				'ar' => 'Ӏаьрбийн',
 				'ar_001' => 'ХӀинца болу стандартан Ӏаьрбийн',
 				'arn' => 'арауканхойн',
 				'arp' => 'арапахо',
 				'as' => 'ассамийн',
 				'asa' => 'асу',
 				'ast' => 'астурийн',
 				'av' => 'суьйлийн',
 				'awa' => 'авадхи',
 				'ay' => 'аймара',
 				'az' => 'азербайджанийн',
 				'az@alt=short' => 'азербайджанийн',
 				'ba' => 'башкирийн',
 				'ban' => 'балийн',
 				'bas' => 'баса',
 				'be' => 'белорусийн',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'болгарийн',
 				'bgn' => 'малхбузен-белуджийн',
 				'bho' => 'бходжпури',
 				'bi' => 'бислама',
 				'bin' => 'бини',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалийн',
 				'bo' => 'тибетхойн',
 				'br' => 'бретонийн',
 				'brx' => 'бодо',
 				'bs' => 'боснийн',
 				'bug' => 'бугийн',
 				'byn' => 'билийн',
 				'ca' => 'каталонийн',
 				'ce' => 'нохчийн',
 				'ceb' => 'себуано',
 				'cgg' => 'чига',
 				'ch' => 'чаморро',
 				'chk' => 'чукчийн',
 				'chm' => 'марийн',
 				'cho' => 'чоктавийн',
 				'chr' => 'чероки',
 				'chy' => 'шайенийн',
 				'ckb' => 'юккъерчу курдийн',
 				'co' => 'корсиканийн',
 				'crs' => 'сейшелийн креолийн',
 				'cs' => 'чехийн',
 				'cu' => 'килсславянийн',
 				'cv' => 'чувашийн',
 				'cy' => 'валлийн',
 				'da' => 'датхойн',
 				'dak' => 'дакота',
 				'dar' => 'даьргӀойн',
 				'dav' => 'таита',
 				'de' => 'немцойн',
 				'de_AT' => 'австрин немцойн',
 				'de_CH' => 'швейцарин литературин немцойн',
 				'dgr' => 'догриб',
 				'dje' => 'зарма',
 				'dsb' => 'сорбийн',
 				'dua' => 'дуала',
 				'dv' => 'мальдивийн',
 				'dyo' => 'дьола-фоньи',
 				'dz' => 'дзонг-кэ',
 				'dzg' => 'даза',
 				'ebu' => 'эмбу',
 				'ee' => 'эве',
 				'efi' => 'эфик',
 				'eka' => 'экаджук',
 				'el' => 'грекийн',
 				'en' => 'ингалсан',
 				'en_AU' => 'Австралин ингалсан',
 				'en_CA' => 'канадан ингалсан',
 				'en_GB' => 'британин ингалсан',
 				'en_GB@alt=short' => 'ингалсан (Британи)',
 				'en_US' => 'американ ингалсан',
 				'en_US@alt=short' => 'ингалсан (АЦШ)',
 				'eo' => 'эсперанто',
 				'es' => 'испанхойн',
 				'es_419' => 'латинан американ испанхойн',
 				'es_ES' => 'европан испанхойн',
 				'es_MX' => 'мексикан испанхойн',
 				'et' => 'эстонийн',
 				'eu' => 'баскийн',
 				'ewo' => 'эвондо',
 				'fa' => 'гӀажарийн',
 				'ff' => 'фулах',
 				'fi' => 'финнийн',
 				'fil' => 'филиппинийн',
 				'fj' => 'фиджи',
 				'fo' => 'фарерийн',
 				'fon' => 'фон',
 				'fr' => 'французийн',
 				'fr_CA' => 'канадан французийн',
 				'fr_CH' => 'швейцарин французийн',
 				'fur' => 'фриулийн',
 				'fy' => 'малхбузен-фризийн',
 				'ga' => 'ирландхойн',
 				'gaa' => 'га',
 				'gag' => 'гагаузийн',
 				'gd' => 'гэлийн',
 				'gez' => 'геэз',
 				'gil' => 'гильбертийн',
 				'gl' => 'галисийн',
 				'gn' => 'гуарани',
 				'gor' => 'горонтало',
 				'gsw' => 'швейцарин немцойн',
 				'gu' => 'гуджарати',
 				'guz' => 'гусии',
 				'gv' => 'мэнийн',
 				'gwi' => 'гвичин',
 				'ha' => 'хауса',
 				'haw' => 'гавайн',
 				'he' => 'жугтийн',
 				'hi' => 'хӀинди',
 				'hil' => 'хилигайнон',
 				'hmn' => 'хмонг',
 				'hr' => 'хорватийн',
 				'hsb' => 'лакхара сербийн',
 				'ht' => 'гаитийн',
 				'hu' => 'венгрийн',
 				'hup' => 'хупа',
 				'hy' => 'эрмалойн',
 				'hz' => 'гереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибанийн',
 				'ibb' => 'ибибио',
 				'id' => 'индонезихойн',
 				'ig' => 'игбо',
 				'ii' => 'сычуань',
 				'ilo' => 'илоко',
 				'inh' => 'гӀалгӀайн',
 				'io' => 'идо',
 				'is' => 'исландхойн',
 				'it' => 'итальянийн',
 				'iu' => 'инуктитут',
 				'ja' => 'японийн',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jv' => 'яванийн',
 				'ka' => 'гуьржийн',
 				'kab' => 'кабилийн',
 				'kac' => 'качинийн',
 				'kaj' => 'каджи',
 				'kam' => 'камба',
 				'kbd' => 'гӀебартойн',
 				'kcg' => 'тьяп',
 				'kde' => 'маконде',
 				'kea' => 'кабувердьяну',
 				'kfo' => 'коро',
 				'kha' => 'кхаси',
 				'khq' => 'койра чиини',
 				'ki' => 'кикуйю',
 				'kj' => 'кунама',
 				'kk' => 'кхазакхийн',
 				'kkj' => 'како',
 				'kl' => 'гренландхойн',
 				'kln' => 'календжин',
 				'km' => 'кхмерийн',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'корейн',
 				'koi' => 'коми-пермякийн',
 				'kok' => 'конкани',
 				'kpe' => 'кпелле',
 				'kr' => 'канури',
 				'krc' => 'кхарачойн-балкхаройн',
 				'krl' => 'карелийн',
 				'kru' => 'курух',
 				'ks' => 'кашмири',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафиа',
 				'ksh' => 'коьлнийн',
 				'ku' => 'курдийн',
 				'kum' => 'гӀумкийн',
 				'kv' => 'комийн',
 				'kw' => 'корнуоллийн',
 				'ky' => 'гӀиргӀизойн',
 				'la' => 'латинан',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lb' => 'люксембургхойн',
 				'lez' => 'лаьзгийн',
 				'lg' => 'ганда',
 				'li' => 'лимбургийн',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаоссийн',
 				'loz' => 'лози',
 				'lrc' => 'къилбаседа лури',
 				'lt' => 'литвахойн',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lun' => 'лунда',
 				'luo' => 'луо (Кени а, Танзани а)',
 				'lus' => 'лушей',
 				'luy' => 'лухья',
 				'lv' => 'латышийн',
 				'mad' => 'мадурийн',
 				'mag' => 'магахи',
 				'mai' => 'майтхили',
 				'mak' => 'макасарийн',
 				'mas' => 'масаи',
 				'mdf' => 'мокшанойн',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'маврикин креолийн',
 				'mg' => 'малагасийн',
 				'mgh' => 'макуа-меетто',
 				'mgo' => 'мета',
 				'mh' => 'маршаллийн',
 				'mi' => 'маори',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонхойн',
 				'ml' => 'малаялам',
 				'mn' => 'монголийн',
 				'mni' => 'манипурийн',
 				'moh' => 'мохаук',
 				'mos' => 'моси',
 				'mr' => 'маратхи',
 				'ms' => 'малайн',
 				'mt' => 'мальтойн',
 				'mua' => 'мунданг',
 				'mul' => 'тайп-тайпа доьзалан меттанаш',
 				'mus' => 'крик',
 				'mwl' => 'мирандойн',
 				'my' => 'бирманийн',
 				'myv' => 'эрзянийн',
 				'mzn' => 'мазандеранхойн',
 				'na' => 'науру',
 				'nap' => 'неаполитанойн',
 				'naq' => 'нама',
 				'nb' => 'норвегийн букмол',
 				'nd' => 'къилбаседа ндебели',
 				'nds' => 'лахара германхойн',
 				'nds_NL' => 'лахара саксонийн',
 				'ne' => 'непалхойн',
 				'new' => 'неваройн',
 				'ng' => 'ндонга',
 				'nia' => 'ниас',
 				'niu' => 'ниуэ',
 				'nl' => 'голландхойн',
 				'nl_BE' => 'фламандийн',
 				'nmg' => 'квасио',
 				'nn' => 'норвегийн нюнорск',
 				'nnh' => 'нгиембунд',
 				'nog' => 'ногӀийн',
 				'nqo' => 'нко',
 				'nr' => 'къилба ндебеле',
 				'nso' => 'къилбаседа сото',
 				'nus' => 'нуэр',
 				'nv' => 'навахо',
 				'ny' => 'ньянджа',
 				'nyn' => 'ньянколе',
 				'oc' => 'окситанойн',
 				'om' => 'оромо',
 				'or' => 'ори',
 				'os' => 'хӀирийн',
 				'pa' => 'панджаби',
 				'pag' => 'пангасинан',
 				'pam' => 'пампанга',
 				'pap' => 'папьяменто',
 				'pau' => 'палау',
 				'pcm' => 'нигерийн-креолийн',
 				'pl' => 'полякийн',
 				'prg' => 'пруссийн',
 				'ps' => 'пушту',
 				'pt' => 'португалихойн',
 				'pt_BR' => 'бразилин португалихойн',
 				'pt_PT' => 'европан португалихойн',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'rap' => 'рапануйн',
 				'rar' => 'раротонга',
 				'rm' => 'романшийн',
 				'rn' => 'рунди',
 				'ro' => 'румынийн',
 				'ro_MD' => 'молдавийн',
 				'rof' => 'ромбо',
 				'root' => 'ораман мотт',
 				'ru' => 'оьрсийн',
 				'rup' => 'аруминийн',
 				'rw' => 'киньяруанда',
 				'rwk' => 'руанда',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'якутийн',
 				'saq' => 'самбуру',
 				'sat' => 'сантали',
 				'sba' => 'нгамбайн',
 				'sbp' => 'сангу',
 				'sc' => 'сардинийн',
 				'scn' => 'сицилийн',
 				'sco' => 'шотландхойн',
 				'sd' => 'синдхи',
 				'se' => 'къилбаседа саамийн',
 				'seh' => 'сена',
 				'ses' => 'койраборо сенни',
 				'sg' => 'санго',
 				'shi' => 'тахелхит',
 				'shn' => 'шанойн',
 				'si' => 'сингалхойн',
 				'sk' => 'словакийн',
 				'sl' => 'словенийн',
 				'sm' => 'самоанойн',
 				'sma' => 'саамийн (къилба)',
 				'smj' => 'луле-саамийн',
 				'smn' => 'инари-саамийн',
 				'sms' => 'скольт-саамийн',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомали',
 				'sq' => 'албанойн',
 				'sr' => 'сербийн',
 				'srn' => 'сранан-тонго',
 				'ss' => 'свази',
 				'ssy' => 'сахо',
 				'st' => 'къилба сото',
 				'su' => 'сунданхойн',
 				'suk' => 'сукума',
 				'sv' => 'шведийн',
 				'sw' => 'суахили',
 				'sw_CD' => 'суахили (Конго)',
 				'swb' => 'коморийн',
 				'syr' => 'шемахойн',
 				'ta' => 'тамилхойн',
 				'te' => 'телугу',
 				'tem' => 'темне',
 				'teo' => 'тесо',
 				'tet' => 'тетум',
 				'tg' => 'таджикийн',
 				'th' => 'тайн',
 				'ti' => 'тигринья',
 				'tig' => 'тигре',
 				'tk' => 'туркменийн',
 				'tlh' => 'клингонин',
 				'tn' => 'тсвана',
 				'to' => 'тонганийн',
 				'tpi' => 'ток-писин',
 				'tr' => 'туркойн',
 				'trv' => 'седекойн',
 				'ts' => 'тсонга',
 				'tt' => 'гӀезалойн',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'twq' => 'тасавак',
 				'ty' => 'таитянойн',
 				'tyv' => 'тувинийн',
 				'tzm' => 'тамазигхтийн',
 				'udm' => 'удмуртийн',
 				'ug' => 'уйгурийн',
 				'uk' => 'украинийн',
 				'umb' => 'умбунду',
 				'und' => 'боьвзуш боцу мотт',
 				'ur' => 'урду',
 				'uz' => 'узбекийн',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'вьетнамхойн',
 				'vo' => 'волапюк',
 				'vun' => 'вунджо',
 				'wa' => 'валлонойн',
 				'wae' => 'валлисийн',
 				'wal' => 'воламо',
 				'war' => 'варай',
 				'wbp' => 'варлпири',
 				'wo' => 'волоф',
 				'xal' => 'гӀалмакхойн',
 				'xh' => 'коса',
 				'xog' => 'сога',
 				'yav' => 'янгбен',
 				'ybb' => 'йемба',
 				'yi' => 'идиш',
 				'yo' => 'йоруба',
 				'yue' => 'кантонийн',
 				'zgh' => 'мороккон стандартан тамазигхтийн',
 				'zh' => 'цийн',
 				'zh_Hans' => 'атта цийн',
 				'zh_Hant' => 'ламастан цийн',
 				'zu' => 'зулу',
 				'zun' => 'зуньи',
 				'zxx' => 'меттан чулацам боцуш',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'Ӏаьрбийн',
 			'Armn' => 'эрмалойн',
 			'Beng' => 'бенгалхойн',
 			'Bopo' => 'бопомофо',
 			'Brai' => 'брайля',
 			'Cyrl' => 'кириллица',
 			'Deva' => 'деванагари',
 			'Ethi' => 'эфиопин',
 			'Geor' => 'гуьржийн',
 			'Grek' => 'грекийн',
 			'Gujr' => 'гуджарати',
 			'Guru' => 'гурмукхи',
 			'Hanb' => 'ханьб',
 			'Hang' => 'хангыль',
 			'Hani' => 'китайн',
 			'Hans' => 'атта китайн',
 			'Hans@alt=stand-alone' => 'атта китайн',
 			'Hant' => 'ламастан китайн',
 			'Hant@alt=stand-alone' => 'ламастан китайн',
 			'Hebr' => 'жугтийн',
 			'Hira' => 'хирагана',
 			'Hrkt' => 'катакана я хирагана',
 			'Jamo' => 'джамо',
 			'Jpan' => 'японийн',
 			'Kana' => 'катакана',
 			'Khmr' => 'кхмерийн',
 			'Knda' => 'каннада',
 			'Kore' => 'корейн',
 			'Laoo' => 'лаоссийн',
 			'Latn' => 'латинан',
 			'Mlym' => 'малаялийн',
 			'Mong' => 'монголийн',
 			'Mymr' => 'мьянманийн',
 			'Orya' => 'ори',
 			'Sinh' => 'сингалхойн',
 			'Taml' => 'тамилхойн',
 			'Telu' => 'телугу',
 			'Thaa' => 'таана',
 			'Thai' => 'тайн',
 			'Tibt' => 'тибетхойн',
 			'Zmth' => 'математикан маьӀна',
 			'Zsye' => 'эмодзи',
 			'Zsym' => 'символаш',
 			'Zxxx' => 'йоза доцу',
 			'Zyyy' => 'массара а тӀеэцна',
 			'Zzzz' => 'доьвзуш доцу йоза',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Дерригдуьненан',
 			'002' => 'Африка',
 			'003' => 'Къилбаседа Америка',
 			'005' => 'Къилба Америка',
 			'009' => 'Океани',
 			'011' => 'Малхбузен Африка',
 			'013' => 'Юккъера Америка',
 			'014' => 'Малхбален Африка',
 			'015' => 'Къилбаседа Африка',
 			'017' => 'Юккъера Африка',
 			'018' => 'Къилба Африка',
 			'019' => 'Къилбаседа а, къилба а Америка',
 			'021' => 'Къилбаседа Америка – АЦШ а, Канада а',
 			'029' => 'Карибаш',
 			'030' => 'Юккъера Ази',
 			'034' => 'Къилба Ази',
 			'035' => 'Къилба-малхбален Ази',
 			'039' => 'Къилба Европа',
 			'053' => 'Австралази',
 			'054' => 'Меланези',
 			'057' => 'Микронези',
 			'061' => 'Полинези',
 			'142' => 'Ази',
 			'143' => 'Юккъера Малхбале',
 			'145' => 'Юккъера а, Гергара а Малхбале',
 			'150' => 'Европа',
 			'151' => 'Малхбален Европа',
 			'154' => 'Къилбаседа Европа',
 			'155' => 'Малхбузен Европа',
 			'419' => 'Латинан Америка',
 			'AC' => 'Айъадаларан гӀайре',
 			'AD' => 'Андорра',
 			'AE' => 'Ӏарбийн Цхьанатоьхна Эмираташ',
 			'AF' => 'ОвхӀан мохк',
 			'AG' => 'Антигуа а, Барбуда а',
 			'AI' => 'Ангилья',
 			'AL' => 'Албани',
 			'AM' => 'Эрмалойчоь',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Американ Самоа',
 			'AT' => 'Австри',
 			'AU' => 'Австрали',
 			'AW' => 'Аруба',
 			'AX' => 'Аландан гӀайренаш',
 			'AZ' => 'Азербайджан',
 			'BA' => 'Босни а, Герцеговина а',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельги',
 			'BF' => 'Буркина- Фасо',
 			'BG' => 'Болгари',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартельми',
 			'BM' => 'Бермудан гӀайренаш',
 			'BN' => 'Бруней-Даруссалам',
 			'BO' => 'Боливи',
 			'BQ' => 'Бонэйр, Синт-Эстатиус а, Саба а',
 			'BR' => 'Бразили',
 			'BS' => 'Багаман гӀайренаш',
 			'BT' => 'Бутан',
 			'BV' => 'Бувен гӀайре',
 			'BW' => 'Ботсвана',
 			'BY' => 'Белорусси',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокосийн гӀайренаш',
 			'CD' => 'Демократин Республика Конго',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Юккъерчу Африкин Республика',
 			'CG' => 'Конго - Браззавиль',
 			'CG@alt=variant' => 'Республика Конго',
 			'CH' => 'Швейцари',
 			'CI' => 'Кот-Д’ивуар',
 			'CI@alt=variant' => 'Кот-д’Ивуар',
 			'CK' => 'Кукан гӀайренаш',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Цийчоь',
 			'CO' => 'Колумби',
 			'CP' => 'Клиппертон',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'ГӀайре ӏиса пайхӏамар вина де',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехи',
 			'DE' => 'Германи',
 			'DG' => 'Диего-Гарси',
 			'DJ' => 'Джибути',
 			'DK' => 'Дани',
 			'DM' => 'Доминика',
 			'DO' => 'Доминикан Республика',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута а, Мелилья а',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстони',
 			'EG' => 'Мисар',
 			'EH' => 'Малхбузен Саьхьара',
 			'ER' => 'Эритрей',
 			'ES' => 'Испани',
 			'ET' => 'Эфиопи',
 			'EU' => 'Евробарт',
 			'EZ' => 'еврозона',
 			'FI' => 'Финлянди',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолклендан гӀайренаш',
 			'FK@alt=variant' => 'Фолклендан гӀайренаш (Мальвинаш)',
 			'FM' => 'Микронезин Федеративни штаташ',
 			'FO' => 'Фарерийн гӀайренаш',
 			'FR' => 'Франци',
 			'GA' => 'Габон',
 			'GB' => 'Йоккха Британи',
 			'GB@alt=short' => 'Йоккха Британи',
 			'GD' => 'Гренада',
 			'GE' => 'Гуьржийчоь',
 			'GF' => 'Французийн Гвиана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланди',
 			'GM' => 'Гамби',
 			'GN' => 'Гвиней',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экваторан Гвиней',
 			'GR' => 'Греци',
 			'GS' => 'Къилба Джорджи а, Къилба Гавайн гӀайренаш а',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвиней-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Гонконг (ша-къаьстина кӀошт)',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Херд гӀайре а, Макдональд гӀайренаш а',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорвати',
 			'HT' => 'Гаити',
 			'HU' => 'Венгри',
 			'IC' => 'Канаран гӀайренаш',
 			'ID' => 'Индонези',
 			'IE' => 'Ирланди',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн гӀайре',
 			'IN' => 'ХӀинди',
 			'IO' => 'Британин латта Индин океанехь',
 			'IQ' => 'Ӏиракъ',
 			'IR' => 'ГӀажарийчоь',
 			'IS' => 'Исланди',
 			'IT' => 'Итали',
 			'JE' => 'Джерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Урдан',
 			'JP' => 'Япони',
 			'KE' => 'Кени',
 			'KG' => 'Киргизи',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комораш',
 			'KN' => 'Сент-Китс а, Невис а',
 			'KP' => 'Къилбаседа Корей',
 			'KR' => 'Къилба Корей',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман гӀайренаш',
 			'KZ' => 'Кхазакхстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люси',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либери',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латви',
 			'LY' => 'Ливи',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдави',
 			'ME' => 'Ӏаьржаламанчоь',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллан гӀайренаш',
 			'MK' => 'Македони',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Монголи',
 			'MO' => 'Макао (ша-къаьстина кӀошт)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Къилбаседа Марианан гӀайренаш',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритани',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврики',
 			'MV' => 'Мальдиваш',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзи',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намиби',
 			'NC' => 'Керла Каледони',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк гӀайре',
 			'NG' => 'Нигери',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерландаш',
 			'NO' => 'Норвеги',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Керла Зеланди',
 			'OM' => 'Ӏоман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Французийн Полинези',
 			'PG' => 'Папуа — Керла Гвиней',
 			'PH' => 'Филиппинаш',
 			'PK' => 'Пакистан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер а, Микелон а',
 			'PN' => 'Питкэрн гӀайренаш',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'ПалестӀинан латтанаш',
 			'PS@alt=short' => 'ПалестӀина',
 			'PT' => 'Португали',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Арахьара Океани',
 			'RE' => 'Реюньон',
 			'RO' => 'Румыни',
 			'RS' => 'Серби',
 			'RU' => 'Росси',
 			'RW' => 'Руанда',
 			'SA' => 'СаӀудийн Ӏаьрбийчоь',
 			'SB' => 'Соломонан гӀайренаш',
 			'SC' => 'Сейшелан гӀайренаш',
 			'SD' => 'Судан',
 			'SE' => 'Швеци',
 			'SG' => 'Сингапур',
 			'SH' => 'Сийлахьчу Еленин гӀайре',
 			'SI' => 'Словени',
 			'SJ' => 'Шпицберген а, Ян-Майен а',
 			'SK' => 'Словаки',
 			'SL' => 'Сьерра- Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Къилба Судан',
 			'ST' => 'Сан-Томе а, Принсипи а',
 			'SV' => 'Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Шема',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан-да- Кунья',
 			'TC' => 'Тёркс а, Кайкос а гӀайренаш',
 			'TD' => 'Чад',
 			'TF' => 'Французийн къилба латтанаш',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Таджикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Малхбален Тимор',
 			'TL@alt=variant' => 'Тимор-Лесте',
 			'TM' => 'Туркмени',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Туркойчоь',
 			'TT' => 'Тринидад а, Тобаго а',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзани',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'АЦШн арахьара кегийн гӀайренаш',
 			'UN' => 'Вовшахкхетта Къаьмнийн Организаци',
 			'US' => 'Цхьанатоьхна Штаташ',
 			'US@alt=short' => 'АЦШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент а, Гренадинаш а',
 			'VE' => 'Венесуэла',
 			'VG' => 'Виргинийн гӀайренаш (Британи)',
 			'VI' => 'Виргинийн гӀайренаш (АЦШ)',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис а, Футуна а',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Къилба-Африкин Республика',
 			'ZM' => 'Замби',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Йоьвзуш йоцу регион',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Календарь',
 			'currency' => 'ахча',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{григорианан},
 				'islamic' => q{исламан},
 				'japanese' => q{японийн},
 				'persian' => q{гӀажарийн},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрикин},
 			'UK' => q{Ингалсан},
 			'US' => q{Инг-американ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Мотт: {0}',
 			'script' => 'Скрипт: {0}',
 			'region' => 'Регион: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => 'top-to-bottom',
			characters => 'left-to-right',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а {аь} б в г {гӏ} д е ё ж з и {ий} й к {кк} {ккх} {кх} {кь} {кӏ} л м н о {ов} {оь} п {пп} {пӏ} р {рхӏ} с {сс} т {тт} {тӏ} у {ув} {уь} {уьй} ф х {хь} {хӏ} ц {цӏ} ч {чӏ} ш щ ъ ы ь э ю {юь} я {яь}]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . … ' ‘ ‚ " “ „ « » ( ) \[ \] \{ \} § @ * / \& #]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'astronomical-unit' => {
						'name' => q(астрономин дакъош),
						'one' => q({0} астрономин дакъа),
						'other' => q({0} астрономин дакъа),
					},
					'centimeter' => {
						'name' => q(сантиметраш),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
						'per' => q({0} сантиметрехь),
					},
					'century' => {
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'day' => {
						'name' => q(денош),
						'one' => q({0} де),
						'other' => q({0} де),
						'per' => q({0} дийнахь),
					},
					'decimeter' => {
						'name' => q(дециметраш),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					'foot' => {
						'name' => q(футаш),
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'hour' => {
						'name' => q(сахьташ),
						'one' => q({0} сахьт),
						'other' => q({0} сахьт),
						'per' => q({0} сахьтехь),
					},
					'inch' => {
						'name' => q(дюймаш),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
					},
					'kilometer' => {
						'name' => q(километраш),
						'one' => q({0} километр),
						'other' => q({0} километр),
					},
					'microsecond' => {
						'name' => q(микросекундаш),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					'millisecond' => {
						'name' => q(миллисекундаш),
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					'minute' => {
						'name' => q(миноташ),
						'one' => q({0} минот),
						'other' => q({0} минот),
						'per' => q({0} минотехь),
					},
					'month' => {
						'name' => q(беттанаш),
						'one' => q({0} бутт),
						'other' => q({0} бутт),
						'per' => q({0} баттахь),
					},
					'nanosecond' => {
						'name' => q(наносекундаш),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					'second' => {
						'name' => q(секундаш),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
						'per' => q({0} секундехь),
					},
					'week' => {
						'name' => q(кӀиранаш),
						'one' => q({0} кӀира),
						'other' => q({0} кӀира),
						'per' => q({0} кӀиранахь),
					},
					'year' => {
						'name' => q(шераш),
						'one' => q({0} шо),
						'other' => q({0} шо),
						'per' => q({0} шарахь),
					},
				},
				'narrow' => {
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} cm),
					},
					'day' => {
						'name' => q(д.),
						'one' => q({0} д.),
						'other' => q({0} д.),
					},
					'hour' => {
						'name' => q(сахь),
						'one' => q({0} сахь.),
						'other' => q({0} сахь.),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'name' => q(бут),
						'one' => q({0} б.),
						'other' => q({0} б.),
					},
					'second' => {
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'week' => {
						'name' => q(кӀир),
						'one' => q({0} кӀ.),
						'other' => q({0} кӀ.),
					},
					'year' => {
						'name' => q(ш.),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
					},
				},
				'short' => {
					'astronomical-unit' => {
						'name' => q(а. д.),
						'one' => q({0} а. д.),
						'other' => q({0} а. д.),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'century' => {
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'day' => {
						'name' => q(денош),
						'one' => q(д.),
						'other' => q({0} д.),
					},
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'foot' => {
						'name' => q(футаш),
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'hour' => {
						'name' => q(сахь),
						'one' => q({0} сахь.),
						'other' => q({0} сахь.),
						'per' => q({0} сахь.),
					},
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм.),
						'other' => q({0} дюйм.),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'microsecond' => {
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					'millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'name' => q(бут),
						'one' => q({0} бут.),
						'other' => q({0} бут.),
					},
					'nanosecond' => {
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'second' => {
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'week' => {
						'name' => q(кӀир),
						'one' => q({0} кӀир.),
						'other' => q({0} кӀир.),
					},
					'year' => {
						'name' => q(ш.),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
						'per' => q({0} ш.),
					},
				},
			} }
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'minusSign' => q(-),
			'nan' => q(Терхьаш дац),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 эзар',
					'other' => '0 эзар',
				},
				'10000' => {
					'one' => '00 эзар',
					'other' => '00 эзар',
				},
				'100000' => {
					'one' => '000 эзар',
					'other' => '000 эзар',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 эзар',
					'other' => '0 эзар',
				},
				'10000' => {
					'one' => '00 эзар',
					'other' => '00 эзар',
				},
				'100000' => {
					'one' => '000 эзар',
					'other' => '000 эзар',
				},
				'1000000' => {
					'one' => '0 миллион',
					'other' => '0 миллион',
				},
				'10000000' => {
					'one' => '00 миллион',
					'other' => '00 миллион',
				},
				'100000000' => {
					'one' => '000 миллион',
					'other' => '000 миллион',
				},
				'1000000000' => {
					'one' => '0 миллиард',
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'one' => '00 миллиард',
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'one' => '000 миллиард',
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'one' => '0 триллион',
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'one' => '00 триллион',
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'one' => '000 триллион',
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 эзар',
					'other' => '0 эзар',
				},
				'10000' => {
					'one' => '00 эзар',
					'other' => '00 эзар',
				},
				'100000' => {
					'one' => '000 эзар',
					'other' => '000 эзар',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0 %',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Дирхам ӀЦЭ),
				'one' => q(Дирхам ӀЦЭ),
				'other' => q(Дирхамаш ӀЦЭ),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ОвхӀан-пачхьалкхан афгани),
				'one' => q(ОвхӀан-пачхьалкхан афгани),
				'other' => q(ОвхӀан-пачхьалкхан афганиш),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Албанин лек),
				'one' => q(Албанин лек),
				'other' => q(Албанин лекаш),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Эрмалойчоьнан драм),
				'one' => q(Эрмалойчоьнан драм),
				'other' => q(Эрмалойчоьнан драмаш),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Нидерландин Антилин гульден),
				'one' => q(Нидерландин Антилин гульден),
				'other' => q(Нидерландин Антилин гульденш),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Анголан кванза),
				'one' => q(Анголан кванза),
				'other' => q(Анголан кванзаш),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Аргентинан песо),
				'one' => q(Аргентинан песо),
				'other' => q(Аргентинан песош),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(Австралин доллар),
				'one' => q(Австралин доллар),
				'other' => q(Австралин долларш),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Арубан флорин),
				'one' => q(Арубан флорин),
				'other' => q(Арубан флоринаш),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Азербайджанан манат),
				'one' => q(Азербайджанан манат),
				'other' => q(Азербайджанан манаташ),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(Боснин а, Герцеговинан а хийцалун марка),
				'one' => q(Боснин а, Герцеговинан а хийцалун марка),
				'other' => q(Боснин а, Герцеговинан а хийцалун маркаш),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Барбадосан доллар),
				'one' => q(Барбадосан доллар),
				'other' => q(Барбадосан долларш),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладешан така),
				'one' => q(Бангладешан така),
				'other' => q(Бангладешан такаш),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(Болгарин лев),
				'one' => q(Болгарин лев),
				'other' => q(Болгарин левш),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахрейнан динар),
				'one' => q(Бахрейнан динар),
				'other' => q(Бахрейнан динараш),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурундин франк),
				'one' => q(Бурундин франк),
				'other' => q(Бурундин франкаш),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(Бермудан доллар),
				'one' => q(Бермудан доллар),
				'other' => q(Бермудан долларш),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Брунейн доллар),
				'one' => q(Брунейн доллар),
				'other' => q(Брунейн долларш),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Боливин боливиано),
				'one' => q(Боливин боливиано),
				'other' => q(Боливин боливианош),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Бразилин реал),
				'one' => q(Бразилин реал),
				'other' => q(Бразилин реалш),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Багаман доллар),
				'one' => q(Багаман доллар),
				'other' => q(Багаман долларш),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутанан нгултрум),
				'one' => q(Бутанан нгултрум),
				'other' => q(Бутанан нгултрумаш),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Ботсванан пула),
				'one' => q(Ботсванан пула),
				'other' => q(Ботсванан пулаш),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(Белоруссин сом),
				'one' => q(Белоруссин сом),
				'other' => q(Белоруссин соьмаш),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Белоруссин сом \(2000–2016\)),
				'one' => q(Белоруссин сом \(2000–2016\)),
				'other' => q(Белоруссин соьмаш \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Белизин доллар),
				'one' => q(Белизин доллар),
				'other' => q(Белизин долларш),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Канадан доллар),
				'one' => q(Канадан доллар),
				'other' => q(Канадан долларш),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конголезин франк),
				'one' => q(Конголезин франк),
				'other' => q(Конголезин франкаш),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Швейцарин франк),
				'one' => q(Швейцарин франк),
				'other' => q(Швейцарин франкаш),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Чилин песо),
				'one' => q(Чилин песо),
				'other' => q(Чилин песош),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Китайн юань),
				'one' => q(Китайн юань),
				'other' => q(Китайн юанаш),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Колумбин песо),
				'one' => q(Колумбин песо),
				'other' => q(Колумбин песо),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Костарикан колон),
				'one' => q(Костарикан колон),
				'other' => q(Костарикан колонш),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Кубан хийцалун песо),
				'one' => q(Кубан хийцалун песо),
				'other' => q(Кубан хийцалун песош),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Кубан песо),
				'one' => q(Кубан песо),
				'other' => q(Кубан песош),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Кабо-Верден эскудо),
				'one' => q(Кабо-Верден эскудо),
				'other' => q(Кабо-Верден эскудош),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Чехин крона),
				'one' => q(Чехин крона),
				'other' => q(Чехин кронаш),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Джибутин франк),
				'one' => q(Джибутин франк),
				'other' => q(Джибутин франкаш),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Данин крона),
				'one' => q(Данин крона),
				'other' => q(Данин кронаш),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Доминикан песо),
				'one' => q(Доминикан песо),
				'other' => q(Доминикан песош),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Алжиран динар),
				'one' => q(Алжиран динар),
				'other' => q(Алжиран динараш),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Мисаран фунт),
				'one' => q(Мисаран фунт),
				'other' => q(Мисаран фунташ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Эритрейн накфа),
				'one' => q(Эритрейн накфа),
				'other' => q(Эритрейн накфаш),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Эфиопин быр),
				'one' => q(Эфиопин быр),
				'other' => q(Эфиопин быраш),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'one' => q(евро),
				'other' => q(Еврош),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фиджин доллар),
				'one' => q(Фиджин доллар),
				'other' => q(Фиджин долларш),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Фолклендан гӀайренийн фунт),
				'one' => q(Фолклендан гӀайренийн фунт),
				'other' => q(Фолклендан гӀайренийн фунташ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Англин фунт),
				'one' => q(Англин фунт),
				'other' => q(Англин фунташ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Гуьржийчоьнан лари),
				'one' => q(Гуьржийчоьнан лари),
				'other' => q(Гуьржийчоьнан лариш),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Ганан седи),
				'one' => q(Ганан седи),
				'other' => q(Ганан седиш),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Гибралтаран фунт),
				'one' => q(Гибралтаран фунт),
				'other' => q(Гибралтаран фунташ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбин даласи),
				'one' => q(Гамбин даласи),
				'other' => q(Гамбин даласиш),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвинейн франк),
				'one' => q(Гвинейн франк),
				'other' => q(Гвинейн франкаш),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Гватемалан кетсаль),
				'one' => q(Гватемалан кетсаль),
				'other' => q(Гватемалан кетсалш),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Гайанан доллар),
				'one' => q(Гайанан доллар),
				'other' => q(Гайанан долларш),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Гонконган доллар),
				'one' => q(Гонконган доллар),
				'other' => q(Гонконган долларш),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Гондурасан лемпира),
				'one' => q(Гондурасан лемпира),
				'other' => q(Гондурасан лемпираш),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Хорватин куна),
				'one' => q(Хорватин куна),
				'other' => q(Хорватин кунаш),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Гаитин гурд),
				'one' => q(Гаитин гурд),
				'other' => q(Гаитин гурдаш),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Венгрин форинт),
				'one' => q(Венгрин форинт),
				'other' => q(Венгрин форинташ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонезин рупи),
				'one' => q(Индонезин рупи),
				'other' => q(Индонезин рупиш),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Израилан керла шекель),
				'one' => q(Израилан керла шекель),
				'other' => q(Израилан керла шекелш),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Индин рупи),
				'one' => q(Индин рупи),
				'other' => q(Индин рупиш),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Ӏиракъан динар),
				'one' => q(Ӏиракъан динар),
				'other' => q(Ӏиракъан динарш),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ГӀажарийчоьнан риал),
				'one' => q(ГӀажарийчоьнан риал),
				'other' => q(ГӀажарийчоьнан риалш),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Исландин крона),
				'one' => q(Исландин крона),
				'other' => q(Исландин кронаш),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Ямайн доллар),
				'one' => q(Ямайн доллар),
				'other' => q(Ямайн долларш),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Урданан динар),
				'one' => q(Урданан динар),
				'other' => q(Урданан динарш),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(Японин иена),
				'one' => q(Японин иена),
				'other' => q(Японин иенаш),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кенин шиллинг),
				'one' => q(Кенин шиллинг),
				'other' => q(Кенин шиллингаш),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Киргизин сом),
				'one' => q(Киргизин сом),
				'other' => q(Киргизин соьмаш),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Камбоджан риель),
				'one' => q(Камбоджан риель),
				'other' => q(Камбоджан риелш),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Коморийн гӀайренийн франк),
				'one' => q(Коморийн гӀайренийн франк),
				'other' => q(Коморийн гӀайренийн франкаш),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Къилбаседа Корейн вона),
				'one' => q(Къилбаседа Корейн вона),
				'other' => q(Къилбаседа Корейн вонаш),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(Къилба Корейн вона),
				'one' => q(Къилба Корейн вона),
				'other' => q(Къилба Корейн вонаш),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувейтан динар),
				'one' => q(Кувейтан динар),
				'other' => q(Кувейтан динарш),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Кайманийн гӀайренийн доллар),
				'one' => q(Кайманийн гӀайренийн доллар),
				'other' => q(Кайманийн гӀайренийн долларш),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Кхазакхстанан тенге),
				'one' => q(Кхазакхстанан тенге),
				'other' => q(Кхазакхстанан тенгеш),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаосан кип),
				'one' => q(Лаосан кип),
				'other' => q(Лаосан кипаш),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Ливанан фунт),
				'one' => q(Ливанан фунт),
				'other' => q(Ливанан фунташ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шри-Ланкан рупи),
				'one' => q(Шри-Ланкан рупи),
				'other' => q(Шри-Ланкан рупиш),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либерин доллар),
				'one' => q(Либерин доллар),
				'other' => q(Либерин долларш),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Ливин динар),
				'one' => q(Ливийский динар),
				'other' => q(Ливийский динараш),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Мароккон дирхам),
				'one' => q(Мароккон дирхам),
				'other' => q(Мароккон дирхамаш),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Молдавин лей),
				'one' => q(Молдавин лей),
				'other' => q(Молдавин лейш),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Малагасийн ариари),
				'one' => q(Малагасийн ариари),
				'other' => q(Малагасийн ариариш),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(Македонин динар),
				'one' => q(Македонин динар),
				'other' => q(Македонин динараш),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мьянман кьят),
				'one' => q(Мьянман кьят),
				'other' => q(Мьянман кьяташ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Монголин тугрик),
				'one' => q(Монголин тугрик),
				'other' => q(Монголин тугрикаш),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Макаон патака),
				'one' => q(Макаон патака),
				'other' => q(Макаон патакаш),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавританин уги),
				'one' => q(Мавританин уги),
				'other' => q(Мавританин угиш),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Маврикин рупи),
				'one' => q(Маврикин рупи),
				'other' => q(Маврикин рупиш),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Мальдивийн руфи),
				'one' => q(Мальдивийн руфи),
				'other' => q(Мальдивийн руфиш),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малавин квача),
				'one' => q(Малавин квача),
				'other' => q(Малавин квачаш),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Мексикан песо),
				'one' => q(Мексикан песо),
				'other' => q(Мексикан песош),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малайзин ринггит),
				'one' => q(Малайзин ринггит),
				'other' => q(Малайзин ринггиташ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбикан метикал),
				'one' => q(Мозамбикан метикал),
				'other' => q(Мозамбикан метикалш),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибин доллар),
				'one' => q(Намибин доллар),
				'other' => q(Намибин долларш),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигерин найра),
				'one' => q(Нигерин найра),
				'other' => q(Нигерин найраш),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Никарагуан кордоба),
				'one' => q(Никарагуан кордоба),
				'other' => q(Никарагуан кордобаш),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Норвегин крона),
				'one' => q(Норвегин крона),
				'other' => q(Норвегин кронаш),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непалан рупи),
				'one' => q(Непалан рупи),
				'other' => q(Непалан рупиш),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(Керла Зеландин доллар),
				'one' => q(Керла Зеландин доллар),
				'other' => q(Керла Зеландин долларш),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Оманан риал),
				'one' => q(Оманан риал),
				'other' => q(Оманан риалш),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Панаман бальбоа),
				'one' => q(Панаман бальбоа),
				'other' => q(Панаман бальбоаш),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Перун соль),
				'one' => q(Перун соль),
				'other' => q(Перун солаш),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуа — Керла Гвинейн кина),
				'one' => q(Папуа — Керла Гвинейн кина),
				'other' => q(Папуа — Керла Гвинейн кинаш),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филиппинийн песо),
				'one' => q(Филиппинийн песо),
				'other' => q(Филиппинийн песош),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пакистанан рупи),
				'one' => q(Пакистанан рупи),
				'other' => q(Пакистанан рупиш),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Польшан злотый),
				'one' => q(Польшан злотый),
				'other' => q(Польшан злотыйш),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Парагвайн гуарани),
				'one' => q(Парагвайн гуарани),
				'other' => q(Парагвайн гуараниш),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катаран риал),
				'one' => q(Катаран риал),
				'other' => q(Катаран риалш),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Румынин лей),
				'one' => q(Румынин лей),
				'other' => q(Румынин лейш),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Сербин динар),
				'one' => q(Сербин динар),
				'other' => q(Сербин динараш),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(Российн сом),
				'one' => q(Российн сом),
				'other' => q(Российн соьмаш),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руандан франк),
				'one' => q(Руандан франк),
				'other' => q(Руандан франкаш),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(СаӀудийн Ӏаьрбийчоьнан риал),
				'one' => q(СаӀудийн Ӏаьрбийчоьнан риал),
				'other' => q(СаӀудийн Ӏаьрбийчоьнан риалш),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломонан гӀайренийн доллар),
				'one' => q(Соломонан гӀайренийн доллар),
				'other' => q(Соломонан гӀайренийн долларш),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сейшелан рупи),
				'one' => q(Сейшелан рупи),
				'other' => q(Сейшелан рупиш),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Суданан фунт),
				'one' => q(Суданан фунт),
				'other' => q(Суданан фунташ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Швецин крона),
				'one' => q(Швецин крона),
				'other' => q(Швецин кронаш),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапуран доллар),
				'one' => q(Сингапуран доллар),
				'other' => q(Сингапуран долларш),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Сийлахьчу Еленин гӀайрен фунт),
				'one' => q(Сийлахьчу Еленин гӀайрен фунт),
				'other' => q(Сийлахьчу Еленин гӀайрен фунташ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Леоне),
				'one' => q(леоне),
				'other' => q(леонеш),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомалин шиллинг),
				'one' => q(Сомалин шиллинг),
				'other' => q(Сомалин шиллингаш),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Суринаман доллар),
				'one' => q(Суринаман доллар),
				'other' => q(Суринаман долларш),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Къилба Суданан фунт),
				'one' => q(Къилба Суданан фунт),
				'other' => q(Къилба Суданан фунташ),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Сан-Томен а, Принсипин а добра),
				'one' => q(Сан-Томен а, Принсипин а добра),
				'other' => q(Сан-Томен а, Принсипин а добраш),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Шеман фунт),
				'one' => q(Шеман фунт),
				'other' => q(Шеман фунташ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свазилендан лилангени),
				'one' => q(Свазилендан лилангени),
				'other' => q(Свазилендан лилангениш),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(Таиландан бат),
				'one' => q(Таиландан бат),
				'other' => q(Таиландан баташ),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Таджикистанан сомони),
				'one' => q(Таджикистанан сомони),
				'other' => q(Таджикистанан сомониш),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Туркменин керла манат),
				'one' => q(Туркменин керла манат),
				'other' => q(Туркменин керла манаташ),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Тунисан динар),
				'one' => q(Тунисан динар),
				'other' => q(Тунисан динараш),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонганан паанга),
				'one' => q(Тонганан паанга),
				'other' => q(Тонганан паангаш),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Туркойчоьнан лира),
				'one' => q(Туркойчоьнан керла лира),
				'other' => q(Туркойчоьнан лираш),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Тринидадан а, Тобагон а доллар),
				'one' => q(Тринидадан а, Тобагон а доллар),
				'other' => q(Тринидадан а, Тобагон а долларш),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Тайванан керла доллар),
				'one' => q(Тайванан керла доллар),
				'other' => q(Тайванан керла долларш),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзанин шиллинг),
				'one' => q(Танзанин шиллинг),
				'other' => q(Танзанин шиллингаш),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Украинан гривна),
				'one' => q(Украинан гривна),
				'other' => q(Украинан гривнаш),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Угандан шиллинг),
				'one' => q(Угандан шиллинг),
				'other' => q(Угандан шиллингаш),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(АЦШн доллар),
				'one' => q(АЦШн доллар),
				'other' => q(АЦШн долларш),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Уругвайн песо),
				'one' => q(Уругвайн песо),
				'other' => q(Уругвайн песош),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Узбекистанан сом),
				'one' => q(Узбекистанан сом),
				'other' => q(Узбекистанан сомаш),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Венесуэлан боливар),
				'one' => q(Венесуэлан боливар),
				'other' => q(Венесуэлан боливарш),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Вьетнаман донг),
				'one' => q(Вьетнаман донг),
				'other' => q(Вьетнаман донгаш),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Вануатун вату),
				'one' => q(Вануатун вату),
				'other' => q(Вануатун ватуш),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоанан тала),
				'one' => q(Самоанан тала),
				'other' => q(Самоанан талаш),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Юккъерчу Африкан КФА франк),
				'one' => q(Юккъерчу Африкан КФА франк),
				'other' => q(Юккъерчу Африкан КФА франкаш),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Малхбален Карибийн доллар),
				'one' => q(Малхбален Карибийн доллар),
				'other' => q(Малхбален Карибийн долларш),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Малхбузен Африкан КФА франк),
				'one' => q(Малхбузен Африкан КФА франк),
				'other' => q(Малхбузен Африкан КФА франк),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(Французийн Тийна океанан франк),
				'one' => q(Французийн Тийна океанан франк),
				'other' => q(Французийн Тийна океанан франк),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(девзаш доцу я лелаш доцу ахча),
				'one' => q(девзаш доцу я лелаш доцу ахча),
				'other' => q(девзаш доцу я лелаш доцу ахча),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Йеменан риал),
				'one' => q(Йеменан риал),
				'other' => q(Йеменан риалш),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Къилба-Африкин рэнд),
				'one' => q(Къилба-Африкин рэнд),
				'other' => q(Къилба-Африкин рэндаш),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбин квача),
				'one' => q(Замбин квача),
				'other' => q(Замбин квачаш),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'янв',
							'фев',
							'мар',
							'апр',
							'май',
							'июн',
							'июл',
							'авг',
							'сен',
							'окт',
							'ноя',
							'дек'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'январь',
							'февраль',
							'март',
							'апрель',
							'май',
							'июнь',
							'июль',
							'август',
							'сентябрь',
							'октябрь',
							'ноябрь',
							'декабрь'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'январь',
							'февраль',
							'март',
							'апрель',
							'май',
							'июнь',
							'июль',
							'август',
							'сентябрь',
							'октябрь',
							'ноябрь',
							'декабрь'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ор',
						tue => 'ши',
						wed => 'кха',
						thu => 'еа',
						fri => 'пӀе',
						sat => 'шуо',
						sun => 'кӀи'
					},
					narrow => {
						mon => 'ор',
						tue => 'ши',
						wed => 'кха',
						thu => 'еа',
						fri => 'пӀе',
						sat => 'шуо',
						sun => 'кӀи'
					},
					short => {
						mon => 'ор',
						tue => 'ши',
						wed => 'кха',
						thu => 'еа',
						fri => 'пӀе',
						sat => 'шуо',
						sun => 'кӀи'
					},
					wide => {
						mon => 'оршот',
						tue => 'шинара',
						wed => 'кхаара',
						thu => 'еара',
						fri => 'пӀераска',
						sat => 'шуот',
						sun => 'кӀира'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ор',
						tue => 'ши',
						wed => 'кха',
						thu => 'еа',
						fri => 'пӀе',
						sat => 'шуо',
						sun => 'кӀи'
					},
					narrow => {
						mon => 'о',
						tue => 'ш',
						wed => 'кх',
						thu => 'е',
						fri => 'пӀ',
						sat => 'ш',
						sun => 'кӀ'
					},
					short => {
						mon => 'ор',
						tue => 'ши',
						wed => 'кха',
						thu => 'еа',
						fri => 'пӀе',
						sat => 'шуо',
						sun => 'кӀи'
					},
					wide => {
						mon => 'оршот',
						tue => 'шинара',
						wed => 'кхаара',
						thu => 'еара',
						fri => 'пӀераска',
						sat => 'шуот',
						sun => 'кӀира'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-гӀа кв.',
						1 => '2-гӀа кв.',
						2 => '3-гӀа кв.',
						3 => '4-гӀа кв.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-гӀа квартал',
						1 => '2-гӀа квартал',
						2 => '3-гӀа квартал',
						3 => '4-гӀа квартал'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-гӀа кв.',
						1 => '2-гӀа кв.',
						2 => '3-гӀа кв.',
						3 => '4-гӀа кв.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-гӀа квартал',
						1 => '2-гӀа квартал',
						2 => '3-гӀа квартал',
						3 => '4-гӀа квартал'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'в. э. тӀ. я',
				'1' => 'в. э'
			},
			wide => {
				'0' => 'Ӏийса пайхамар вина де кхачале',
				'1' => 'Ӏийса пайхамар вина дийнахь дуьйна'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			d => q{d},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0}),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#ОвхӀан мохк#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#КъахӀира#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монрови#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Юккъера Африка#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Малхбален Африка#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Къилба Африка#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Малхбузен Африка, аьхкенан хан#,
				'generic' => q#Малхбузен Африка#,
				'standard' => q#Малхбузен Африка, стандартан хан#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляска, аьхкенан хан#,
				'generic' => q#Аляска#,
				'standard' => q#Аляска, стандартан хан#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазонка, аьхкенан хан#,
				'generic' => q#Амазонка#,
				'standard' => q#Амазонка, стандартан хан#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкоридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Сальта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуая#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баи#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баия-де-Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белен#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кеймбридж-Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Гранди#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чиуауа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал-Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Денмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон-Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс-Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Готхоб#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус-Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосильо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Петерсбург#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл-Сити#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивэй#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенс#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтиселло#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анджелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуэр-Принсес-Куортер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтеррей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонха#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бойла, Къилбаседа Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Юкъ, Къилбаседа Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртанг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни-Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин-Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реджайна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Риу-Бранку#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта-Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарен#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбисунн#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартельми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люси#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт-Карент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер-Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йеллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Юккъера Америка, аьхкенан хан#,
				'generic' => q#Юккъера Америка#,
				'standard' => q#Юккъера Америка, стандартан хан#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Малхбален Америка, аьхкенан хан#,
				'generic' => q#Малхбален Америка#,
				'standard' => q#Малхбален Америка, стандартан хан#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Лаьмнийн аьхкенан хан (АЦШ)#,
				'generic' => q#Лаьмнийн хан (АЦШ)#,
				'standard' => q#Лаьмнийн стандартан хан (АЦШ)#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Тийна океанан аьхкенан хан#,
				'generic' => q#Тийна океанан хан#,
				'standard' => q#Тийна океанан стандартан хан#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дейвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон-д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролль#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#аьхкенан хан Апиа, Самоа#,
				'generic' => q#хан Апиа, Самоа#,
				'standard' => q#стандартан хан Апиа, Самоа#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#СаӀудийн Ӏаьрбийчоьнан, аьхкенан хан#,
				'generic' => q#СаӀудийн Ӏаьрбийчоь#,
				'standard' => q#СаӀудийн Ӏаьрбийчоьнан стандартан хан#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйир#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина, аьхкенан хан#,
				'generic' => q#Аргентина#,
				'standard' => q#Аргентина, стандартан хан#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Малхбузен Аргентина, аьхкенан хан#,
				'generic' => q#Малхбузен Аргентина#,
				'standard' => q#Малхбузен Аргентина, стандартан хан#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Эрмалойчоь, аьхкенан хан#,
				'generic' => q#Эрмалойчоь#,
				'standard' => q#Эрмалойчоь, стандартан хан#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алма-Ата#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Ӏамман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадырь#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атирау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#БагӀдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Бакох#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Димашкъ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джайпур#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Къудс-ГӀала#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Петропавловск-Камчатски#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никоси#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Эр-Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин гӀ-е#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбэй#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ТехӀран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантикан аьхкенан хан#,
				'generic' => q#Атлантикан хан#,
				'standard' => q#Атлантикан стандартан хан#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азоран гӀайренаш#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермудаш#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канаран гӀайренаш#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарерийн гӀайренаш#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра, гӀ-е#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Къилба Джорджи#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Езачу Еленин гӀайре#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хилл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Керри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау, гӀ-е#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Юккъера Австрали, аьхкенан хан#,
				'generic' => q#Юккъера Австрали#,
				'standard' => q#Юккъера Австрали, стандартан хан#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Юккъера Австрали, малхбузен аьхкенан хан#,
				'generic' => q#Юккъера Австрали, малхбузен хан#,
				'standard' => q#Юккъера Австрали, малхбузен стандартан хан#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Малхбален Австрали, аьхкенан хан#,
				'generic' => q#Малхбален Австрали#,
				'standard' => q#Малхбален Австрали, стандартан хан#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Малхбузен Австрали, аьхкенан хан#,
				'generic' => q#Малхбузен Австрали#,
				'standard' => q#Малхбузен Австрали, стандартан хан#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербайджан, аьхкенан хан#,
				'generic' => q#Азербайджан#,
				'standard' => q#Азербайджан, стандартан хан#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азоран гӀайренаш, аьхкенан хан#,
				'generic' => q#Азоран гӀайренаш#,
				'standard' => q#Азоран гӀайренаш, стандартан хан#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш, аьхкенан хан#,
				'generic' => q#Бангладеш#,
				'standard' => q#Бангладеш, стандартан хан#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливи#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразили, аьхкенан хан#,
				'generic' => q#Бразили#,
				'standard' => q#Бразили, стандартан хан#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней-Даруссалам#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо-Верде, аьхкенан хан#,
				'generic' => q#Кабо-Верде#,
				'standard' => q#Кабо-Верде, стандартан хан#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморро#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатем, аьхкенан хан#,
				'generic' => q#Чатем#,
				'standard' => q#Чатем, стандартан хан#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чили, аьхкенан хан#,
				'generic' => q#Чили#,
				'standard' => q#Чили, стандартан хан#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Китай, аьхкенан хан#,
				'generic' => q#Китай#,
				'standard' => q#Китай, стандартан хан#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чойбалсан, аьхкенан хан#,
				'generic' => q#Чойбалсан#,
				'standard' => q#Чойбалсан, стандартан хан#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Ӏийса пайхамар винчу ден гӀайре#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокосийн, гӀ-наш#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумби, аьхкенан хан#,
				'generic' => q#Колумби#,
				'standard' => q#Колумби, стандартан хан#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кукан, гӀ-наш, аьхкенан хан#,
				'generic' => q#Кукан, гӀ-наш#,
				'standard' => q#Кукан, гӀ-наш, стандартан хан#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба, аьхкенан хан#,
				'generic' => q#Куба#,
				'standard' => q#Куба, стандартан хан#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дейвис#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Дюмон-д’Юрвиль#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Малхбален Тимор#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Мархин гӀайре, аьхкенан хан#,
				'generic' => q#Мархин гӀайре#,
				'standard' => q#Мархин гӀайре, стандартан хан#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Эквадор#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Йоьвзуш йоцу гӀала#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Аштаркхне#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзинген-ам-Хохрайн#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Ирланди, аьхкенан хан#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн, гӀ-е#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британин, аьхкенан хан#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софи#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Юккъера Европа, аьхкенан хан#,
				'generic' => q#Юккъера Европа#,
				'standard' => q#Юккъера Европа, стандартан хан#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Малхбален Европа, аьхкенан хан#,
				'generic' => q#Малхбален Европа#,
				'standard' => q#Малхбален Европа, стандартан хан#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Калининградера а, Минскера а хан#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Малхбузен Европа, аьхкенан хан#,
				'generic' => q#Малхбузен Европа#,
				'standard' => q#Малхбузен Европа, стандартан хан#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолклендан гӀайренаш, аьхкенан хан#,
				'generic' => q#Фолклендан гӀайренаш#,
				'standard' => q#Фолклендан гӀайренаш, стандартан хан#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фиджи, аьхкенан хан#,
				'generic' => q#Фиджи#,
				'standard' => q#Фиджи, стандартан хан#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Французийн Гвиана#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Французийн къилба а, Антарктидан а хан#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвичица юкъара хан#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагосан гӀайренаш#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбье#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Гуьржийчоь, аьхкенан хан#,
				'generic' => q#Гуьржийчоь#,
				'standard' => q#Гуьржийчоь, стандартан хан#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилбертан, гӀ-наш#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Малхбален Гренланди, аьхкенан хан#,
				'generic' => q#Малхбален Гренланди#,
				'standard' => q#Малхбален Гренланди, стандартан хан#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Малхбузен Гренланди, аьхкенан хан#,
				'generic' => q#Малхбузен Гренланди#,
				'standard' => q#Малхбузен Гренланди, стандартан хан#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ГӀажарийн айма#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гайана#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Гавайн-алеутийн аьхкенан хан#,
				'generic' => q#Гавайн-алеутийн хан#,
				'standard' => q#Гавайн-алеутийн стандартан хан#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Гонконг, аьхкенан хан#,
				'generic' => q#Гонконг#,
				'standard' => q#Гонконг, стандартан хан#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд, аьхкенан хан#,
				'generic' => q#Ховд#,
				'standard' => q#Ховд, стандартан хан#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Инди#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Ӏийса пайхамар винчу ден гӀайре#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосийн, гӀ-наш#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморийн гӀайренаш#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Маэ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдиваш#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврики#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майорка#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Индин океан#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Индокитай#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Юккъера Индонези#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Малхбален Индонези#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Малхбузен Индонези#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ГӀажарийчоь, аьхкенан хан#,
				'generic' => q#ГӀажарийчоь#,
				'standard' => q#ГӀажарийчоь, стандартан хан#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркутск, аьхкенан хан#,
				'generic' => q#Иркутск#,
				'standard' => q#Иркутск, стандартан хан#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израиль, аьхкенан хан#,
				'generic' => q#Израиль#,
				'standard' => q#Израиль, стандартан хан#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Япони, аьхкенан хан#,
				'generic' => q#Япони#,
				'standard' => q#Япони, стандартан хан#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Малхбален Казахстан#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Малхбузен Казахстан#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корей, аьхкенан хан#,
				'generic' => q#Корей#,
				'standard' => q#Корей, стандартан хан#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косраэ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярск, аьхкенан хан#,
				'generic' => q#Красноярск#,
				'standard' => q#Красноярск, стандартан хан#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргизи#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн, гӀ-наш#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд-Хау, аьхкенан хан#,
				'generic' => q#Лорд-Хау#,
				'standard' => q#Лорд-Хау, стандартан хан#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Маккуори#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан, аьхкенан хан#,
				'generic' => q#Магадан#,
				'standard' => q#Магадан, стандартан хан#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзи#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдиваш#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркизан, гӀ-наш#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалан , гӀ-наш#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврики, аьхкенан хан#,
				'generic' => q#Маврики#,
				'standard' => q#Маврики, стандартан хан#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусон#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Къилбаседа Американ Мексикан аьхкенан хан#,
				'generic' => q#Къилбаседа Американ Мексикан хан#,
				'standard' => q#Къилбаседа Американ Мексикан стандартан хан#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Тийна океанан Мексикан аьхкенан хан#,
				'generic' => q#Тийна океанан Мексикан хан#,
				'standard' => q#Тийна океанан Мексикан стандартан хан#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан-Батор, аьхкенан хан#,
				'generic' => q#Улан-Батор#,
				'standard' => q#Улан-Батор, стандартан хан#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москва, аьхкенан хан#,
				'generic' => q#Москва#,
				'standard' => q#Москва, стандартан хан#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мьянма#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Керла Каледони, аьхкенан хан#,
				'generic' => q#Керла Каледони#,
				'standard' => q#Керла Каледони, стандартан хан#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Керла Зеланди, аьхкенан хан#,
				'generic' => q#Керла Зеланди#,
				'standard' => q#Керла Зеланди, стандартан хан#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Ньюфаундленд, аьхкенан хан#,
				'generic' => q#Ньюфаундленд#,
				'standard' => q#Ньюфаундленд, стандартан хан#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуэ#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#Норфолк#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернанду-ди-Норонья, аьхкенан хан#,
				'generic' => q#Фернанду-ди-Норонья#,
				'standard' => q#Фернанду-ди-Норонья, стандартан хан#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск, аьхкенан хан#,
				'generic' => q#Новосибирск#,
				'standard' => q#Новосибирск, стандартан хан#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск, аьхкенан хан#,
				'generic' => q#Омск#,
				'standard' => q#Омск, стандартан хан#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апи#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль, гӀ-е#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем, гӀ-е#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Мархин гӀайренаш#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндерберин, гӀ-е#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиджи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагосан гӀайренаш#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбьен, гӀ-наш#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Джонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркизан, гӀ-наш#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй, гӀ-наш#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе, гӀ-наш#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити, гӀ-наш#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук, гӀ-наш#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэйк, гӀ-е#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистан, аьхкенан хан#,
				'generic' => q#Пакистан#,
				'standard' => q#Пакистан, стандартан хан#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа – Керла Гвиней#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвай, аьхкенан хан#,
				'generic' => q#Парагвай#,
				'standard' => q#Парагвай, стандартан хан#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу, аьхкенан хан#,
				'generic' => q#Перу#,
				'standard' => q#Перу, стандартан хан#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппинаш, аьхкенан хан#,
				'generic' => q#Филиппинаш#,
				'standard' => q#Филиппинаш, стандартан хан#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс, гӀ-наш#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен-Пьер а, Микелон а, аьхкенан хан#,
				'generic' => q#Сен-Пьер а, Микелон а#,
				'standard' => q#Сен-Пьер а, Микелон а, стандартан хан#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкэрн#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понапе, гӀ-наш#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюньон#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин, аьхкенан хан#,
				'generic' => q#Сахалин#,
				'standard' => q#Сахалин, стандартан хан#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа, аьхкенан хан#,
				'generic' => q#Самоа#,
				'standard' => q#Самоа, стандартан хан#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшелан гӀайренаш#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломонан, гӀ-наш#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Къилба Георги#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сёва#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таити, гӀ-наш#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайвань, аьхкенан хан#,
				'generic' => q#Тайвань#,
				'standard' => q#Тайвань, стандартан хан#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Таджикистан#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга, аьхкенан хан#,
				'generic' => q#Тонга#,
				'standard' => q#Тонга, стандартан хан#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чуук#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменин аьхкенан хан#,
				'generic' => q#Туркмени#,
				'standard' => q#Туркменин стандартан хан#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвай, аьхкенан хан#,
				'generic' => q#Уругвай#,
				'standard' => q#Уругвай, стандартан хан#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбекистанан аьхкенан хан#,
				'generic' => q#Узбекистан#,
				'standard' => q#Узбекистанан стандартан хан#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату, аьхкенан хан#,
				'generic' => q#Вануату#,
				'standard' => q#Вануату, стандартан хан#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэла#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток, аьхкенан хан#,
				'generic' => q#Владивосток#,
				'standard' => q#Владивосток, стандартан хан#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград, аьхкенан хан#,
				'generic' => q#Волгоград#,
				'standard' => q#Волгоград, стандартан хан#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уэйк, гӀ-е#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уоллис а, Футуна а#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутск, аьхкенан хан#,
				'generic' => q#Якутск#,
				'standard' => q#Якутск, стандартан хан#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбург, аьхкенан хан#,
				'generic' => q#Екатеринбург#,
				'standard' => q#Екатеринбург, стандартан хан#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
