#include <stdio.h>

#include <nets/kohonen.h>
#include <utils/matrix_reader.h>

#define radius 0

void main() {
    int o;
    real *v;

    matrix_reader reader("matricies.4vectors");

    kohonen k(.9, reader.query_size(), 2);

    while(true) {
        reader.start_foreach();
        while(reader.has_a_matrix()) {
            k.set_input(reader.query_current_matrix_as_vector());
            k.linear_train(radius);
            reader.next_matrix();
        }
        if(k.update_learning_rate() < .00001)
            break;
    }

    reader.start_foreach();
    while(reader.has_a_matrix()) {
        k.set_input(reader.query_current_matrix_as_vector());
        v = reader.query_current_matrix_as_vector();
        printf("(%1.0f,%1.0f,%1.0f,%1.0f) was put in group %i\n",
            v[0], v[1], v[2], v[3],
            o = k.query_max_output()
        );
        reader.next_matrix();
    }
}
