#include <stdio.h>

#include <arch/neuron.h>
#include <utils/transfer.h>

#define  logsig(X) ( 1.0   /(1.0 + exp(-      X)))
#define blogsig(X) ((2.0   /(1.0 + exp(-      X))) - 1)
#define jblogsg(X) ((2000.0/(1.0 + exp(-0.005*X))) - 1000.0)
#define elliott(X) (X  /(1.0 + fabs(X)))

real transfer(real to_xfer, int type) {
    switch(type) {
        case SUM:     return (to_xfer);
        case SIGMOID: return logsig(to_xfer);
        case BIPOLAR: return blogsig(to_xfer);
        case JBIPOLR: return jblogsg(to_xfer);
        case ELLIOTT: return elliott(to_xfer);
        default:
            printf("Undefined transfer function [%i] requested.\n", type);
            exit(1);
    }
}

real transfer_dot(real to_xfer, int type) {
    real r1;

    switch(type) {
        case SUM:                               return (1.0);
        case SIGMOID: r1 =  logsig(to_xfer);    return (r1*(1.0-r1));
        case BIPOLAR: r1 = blogsig(to_xfer);    return  0.5*(1.0+r1)*(1.0-r1);
        case JBIPOLR: r1 = exp(-0.005*to_xfer); return 10*(r1/((1+r1)*(1+r1)));
        case ELLIOTT: r1 = 1.0 + fabs(to_xfer); return (1.0/(2.0*(r1*r1)));
        default:
            printf("Undefined transfer_dot function [%i] requested.\n", type);
            exit(1);
    }
}

void set_transfer_functions(int type, int n, ...) {
    neuron **k;
    for(int i=1; i<=n; i++) {
        k = (neuron **)(&n+i);
        (*k)->set_transfer_function(type);
    }
}
