package IMDB::Local::DB;

use 5.006;
use strict;
use warnings;

=head1 NAME

IMDB::Local::DB - The great new IMDB::Local::DB!

=head1 VERSION

Version 0.01

=cut

our $VERSION = '1.00';

=head1 SYNOPSIS

Quick summary of what the module does.

Perhaps a little code snippet.

    use IMDB::Local::DB;

    my $foo = IMDB::Local::DB->new();
    ...

=head1 EXPORT

A list of functions that can be exported.  You can delete this section
if you don't export anything, such as for a purely object-oriented module.

=head1 SUBROUTINES/METHODS

=head2 new

=cut

use base qw(IMDB::Local::DB::Base);


use Class::MethodMaker
    [ 
      scalar => [{-default => 0}, 'db_AutoCommit'],
      scalar => [{-default => 'SQLite'}, 'driver'],
      scalar => [{-default => ''}, 'driverDetail'],
      scalar => [{-default => 'imdb.db'}, 'database'],
      scalar => [{-default => ''}, 'user'],
      scalar => [{-default => ''}, 'passwd'],
      new  => [qw/ -init -hash new /] ,
    ];

=head2 function2

=cut

sub init($)
{
    my ($self)=@_;
}

=head2 function2

=cut

sub delete($)
{
    my ($self)=@_;
    unlink($self->database());
}

=head2 function2

=cut

sub connect($)
{
    my ($self)=@_;

    my $initIt=0;
    if ( ! -f  $self->database ) {
	$initIt=1;
    }

    my $c=$self->SUPER::connect();
    if ( $c ) {
	#$c->dbh->{AutoCommit}=0;
    }
    if ( $c && $initIt==1 ) {
	$self->schema_init();
    }
    return($c);
}

=head2 function2

=cut

sub schema_init($)
{
    my ($self)=@_;

    for ($self->table_list) {
	print "dropping table: $_\n";
	$self->runSQL("drop table $_");
    }

    local $/ = undef;
    my $sql = <DATA>;
    my @statements = split(/;\s*\n/, $sql);

    foreach my $stmt (@statements) {
        next if ($stmt =~ /^\s*$/o);

	if ( !$self->runSQL($stmt) ) {
            print "Error executing:\n$stmt\n\n";

            print $self->dbh->errstr()."\n";
	    return(0);
        }
    }
    $self->insert_db('Versions', undef, (schema_version=>1));
    $self->commit();
    return(1);
}

    
=head1 AUTHOR

jerryv, C<< <jerryv at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-imdb-local at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=IMDB-Local>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.




=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc IMDB::Local::DB


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=IMDB-Local>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/IMDB-Local>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/IMDB-Local>

=item * Search CPAN

L<http://search.cpan.org/dist/IMDB-Local/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2015 jerryv.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of IMDB::Local::DB

__DATA__
-- schema version is incremented with every backwards non-compatible change to the db schema
-- version 1 - initial alpha version
CREATE TABLE Versions (
    schema_version INTEGER DEFAULT 1
);

CREATE TABLE Punctuation (
    priority INTEGER,
    pattern VARCHAR NOT NULL,
    replacement VARCHAR NOT NULL
);

INSERT INTO Punctuation VALUES (10, '\\bA-', 'ahyphen');
INSERT INTO Punctuation VALUES (11, ',\\s*A$', '');
INSERT INTO Punctuation VALUES (12, '\\bA$', '123zzazz456');
INSERT INTO Punctuation VALUES (13, '\\bA\\.$', '123zzazz456.');
INSERT INTO Punctuation VALUES (15, '\\b(The|A|An)\\b', '');
INSERT INTO Punctuation VALUES (16, '123zzazz456$', 'a');
INSERT INTO Punctuation VALUES (17, '123zzazz456\\.$', 'a.');
INSERT INTO Punctuation VALUES (20, '&#8482;', '');
INSERT INTO Punctuation VALUES (21, '&', 'and');
INSERT INTO Punctuation VALUES (22, '\\+', 'and');
INSERT INTO Punctuation VALUES (23, '\@', 'at');
INSERT INTO Punctuation VALUES (25, '\\Wn\\W', 'and');
INSERT INTO Punctuation VALUES (40, '\\((?=\\s*\\d\\d?\\s*\\))', '(Part ');
INSERT INTO Punctuation VALUES (50, '\\bPt\\b', 'part');
INSERT INTO Punctuation VALUES (51, '\\bPt(?=\\s*\\d)', 'part ');
INSERT INTO Punctuation VALUES (52, '\\bVol\\b', 'volume');
INSERT INTO Punctuation VALUES (53, '\\bXmas\\b', 'christmas');
INSERT INTO Punctuation VALUES (54, '\\bit has\\b', 'its');
INSERT INTO Punctuation VALUES (55, '\\bit is\\b', 'its');
INSERT INTO Punctuation VALUES (56, '\\bversus\\b', 'vs');
INSERT INTO Punctuation VALUES (57, '\\bvs\\b', 'v');
INSERT INTO Punctuation VALUES (58, '\\bThru\\b', 'through');
INSERT INTO Punctuation VALUES (59, '\\bEp\\b', 'episode');
INSERT INTO Punctuation VALUES (60, '\\bWive$\\b', 'Wives');
INSERT INTO Punctuation VALUES (61, '\\bc''ship', 'championship');
INSERT INTO Punctuation VALUES (62, '\\bto\\b', '2');
INSERT INTO Punctuation VALUES (63, '\\bgp\\b', 'grand prix');
INSERT INTO Punctuation VALUES (64, '\\bch''ship', 'championship');
INSERT INTO Punctuation VALUES (65, '\\bb''ball\\b', 'basketball');
INSERT INTO Punctuation VALUES (66, '\\bconf\\b', 'conference');
INSERT INTO Punctuation VALUES (67, '\\ba''villa\\b', 'aston villa');
INSERT INTO Punctuation VALUES (68, '\\bb''burn\\b', 'blackburn');
INSERT INTO Punctuation VALUES (69, '\\butd\\b', 'united');
INSERT INTO Punctuation VALUES (70, '\\bl''pool\\b', 'liverpool');
INSERT INTO Punctuation VALUES (71, '\\bm''brough\\b', 'middlesbrough');
INSERT INTO Punctuation VALUES (72, '\\bceleb\\b', 'celebrity');
INSERT INTO Punctuation VALUES (73, '\\bwld\\b', 'world');
INSERT INTO Punctuation VALUES (74, '\\bchampionships\\b', 'championship');
INSERT INTO Punctuation VALUES (75, '\\btenpin\\b', 'ten pin');
INSERT INTO Punctuation VALUES (76, '\\bdr\\.?\\b', 'doctor');
INSERT INTO Punctuation VALUES (77, '\\btelevision\\b', 'TV');
INSERT INTO Punctuation VALUES (78, '\\bchamp\\b', 'championship');
INSERT INTO Punctuation VALUES (79, '\\bchamps\\b', 'championship');
INSERT INTO Punctuation VALUES (80, '\\brnd\\b', 'round');
INSERT INTO Punctuation VALUES (101, '\\b(?<=\\w)\\.', '');
INSERT INTO Punctuation VALUES (102, '\\bII\\b', '2');
INSERT INTO Punctuation VALUES (103, '\\bIII\\b', '3');
INSERT INTO Punctuation VALUES (104, '\\bIV\\b', '4');
INSERT INTO Punctuation VALUES (105, '\\bV\\b', '5');
INSERT INTO Punctuation VALUES (106, '\\bVI\\b', '6');
INSERT INTO Punctuation VALUES (107, '\\bVII\\b', '7');
INSERT INTO Punctuation VALUES (108, '\\bVIII\\b', '8');
INSERT INTO Punctuation VALUES (109, '\\bIX\\b', '9');
INSERT INTO Punctuation VALUES (110, '\\bX\\b', '10');
INSERT INTO Punctuation VALUES (111, '\\bXI\\b', '11');
INSERT INTO Punctuation VALUES (112, '\\bXII\\b', '12');
INSERT INTO Punctuation VALUES (113, '\\bXIII\\b', '13');
INSERT INTO Punctuation VALUES (114, '\\bXIV\\b', '14');
INSERT INTO Punctuation VALUES (115, '\\bXV\\b', '15');
INSERT INTO Punctuation VALUES (116, '\\bXVI\\b', '16');
INSERT INTO Punctuation VALUES (117, '\\bXVII\\b', '17');
INSERT INTO Punctuation VALUES (118, '\\bXVIII\\b', '18');
INSERT INTO Punctuation VALUES (119, '\\bXIX\\b', '19');
INSERT INTO Punctuation VALUES (120, '\\bXX\\b', '20');
INSERT INTO Punctuation VALUES (201, '\\bOne\\b', '1');
INSERT INTO Punctuation VALUES (202, '\\bTwo\\b', '2');
INSERT INTO Punctuation VALUES (203, '\\bThree\\b', '3');
INSERT INTO Punctuation VALUES (204, '\\bFour\\b', '4');
INSERT INTO Punctuation VALUES (205, '\\bFive\\b', '5');
INSERT INTO Punctuation VALUES (206, '\\bSix\\b', '6');
INSERT INTO Punctuation VALUES (207, '\\bSeven\\b', '7');
INSERT INTO Punctuation VALUES (208, '\\bEight\\b', '8');
INSERT INTO Punctuation VALUES (209, '\\bNine\\b', '9');
INSERT INTO Punctuation VALUES (210, '\\bTen\\b', '10');
INSERT INTO Punctuation VALUES (211, '\\bEleven\\b', '11');
INSERT INTO Punctuation VALUES (212, '\\bTwelve\\b', '12');
INSERT INTO Punctuation VALUES (213, '\\bThirteen\\b', '13');
INSERT INTO Punctuation VALUES (214, '\\bFourteen\\b', '14');
INSERT INTO Punctuation VALUES (215, '\\bFifteen\\b', '15');
INSERT INTO Punctuation VALUES (216, '\\bSixteen\\b', '16');
INSERT INTO Punctuation VALUES (217, '\\bSeventeen\\b', '17');
INSERT INTO Punctuation VALUES (218, '\\bEighteen\\b', '18');
INSERT INTO Punctuation VALUES (219, '\\bNineteen\\b', '19');
INSERT INTO Punctuation VALUES (220, '\\bTwenty\\b', '20');
INSERT INTO Punctuation VALUES (260, '\\bSixty\\b', '60');
INSERT INTO Punctuation VALUES (301, 'First', '1st');
INSERT INTO Punctuation VALUES (302, 'Second', '2nd');
INSERT INTO Punctuation VALUES (303, 'Third', '3rd');
INSERT INTO Punctuation VALUES (304, 'Fourth', '4th');
INSERT INTO Punctuation VALUES (305, 'Fifth', '5th');
INSERT INTO Punctuation VALUES (306, 'Sixth', '6th');
INSERT INTO Punctuation VALUES (307, 'Seventh', '7th');
INSERT INTO Punctuation VALUES (308, 'Eighth', '8th');
INSERT INTO Punctuation VALUES (309, 'Nineth', '9th');
INSERT INTO Punctuation VALUES (310, 'Tenth', '10th');
INSERT INTO Punctuation VALUES (999, '[^a-zA-Z0-9]', '');

CREATE TABLE QualifierTypes (
    QualifierTypeID INTEGER,
    Name CHAR(10)
);

INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(1, 'tv_movie');
INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(2, 'tv_mini_series');
INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(3, 'tv_series');
INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(4, 'video_movie');
INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(5, 'video_game');
INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(6, 'movie');

INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(12, 'episode_of_tv_mini_series');
INSERT INTO QualifierTypes(QualifierTypeID, Name) VALUES(13, 'episode_of_tv_series');

CREATE TABLE Titles (
    TitleID INTEGER 			PRIMARY KEY, -- AUTOINCREMENT,
    SearchTitle VARCHAR,
    Title VARCHAR,
    QualifierTypeID CHAR(1) 		NOT NULL REFERENCES QualifierTypes(QualifierTypeID),
    Year INTEGER,
    ParentID INTEGER,			-- only set for episodes
    Series INTEGER,			-- only set for episodes (and still may be 0)
    Episode INTEGER			-- only set for episodes (and still may be 0)
);

-- table to give imdb list file's title string to a Title entry
-- CREATE TABLE IMDBTitleKeys (
--     String VARCHAR
--     TitleID INTEGER, -- from Titles
-- );

---
-- IMDB list files don't give us an any order to directors by title
---
CREATE TABLE Directors (
    DirectorID INTEGER PRIMARY KEY AUTOINCREMENT,
    SearchName VARCHAR,
    Name VARCHAR
);

CREATE TABLE Titles2Directors (
    TitleID INTEGER,
    DirectorID INTEGER
);

CREATE TABLE Actors (
    ActorID INTEGER PRIMARY KEY AUTOINCREMENT,
    SearchName VARCHAR,
    Name VARCHAR
);

CREATE TABLE Titles2Actors (
    TitleID INTEGER,
    ActorID INTEGER,
    Billing INTEGER,
    IsHost INTEGER,
    IsNarrator INTEGER
);

CREATE TABLE Genres (
    GenreID INTEGER PRIMARY KEY AUTOINCREMENT,
    Name VARCHAR
);

CREATE TABLE Titles2Genres (
    TitleID INTEGER,
    GenreID INTEGER
);

CREATE TABLE Ratings (
    TitleID INTEGER,
    Distribution VARCHAR,
    Votes INTEGER,
    Rank REAL
);

CREATE TABLE Keywords (
    KeywordID INTEGER PRIMARY KEY AUTOINCREMENT,
    Name VARCHAR
);

CREATE TABLE Titles2Keywords (
    TitleID INTEGER,
    KeywordID INTEGER
);

CREATE TABLE Plots (
    TitleID INTEGER,
    Description VARCHAR
);

