# Test gaussian()

use Test::More tests => 4;
use Scalar::Util 'looks_like_number';
use Config;

BEGIN {
    use_ok('Math::Random::MT::Auto', qw/gaussian srand :!auto/);
};

can_ok('Math::Random::MT::Auto', qw/gaussian srand/);

# Known test values for gaussian()
my @base_gaus = ($Config{'uvsize'} == 8) ?
    # 64-bit randoms
  qw/
   -0.26912980  -0.61841921   1.39597901   1.21976989  -0.63040847
    0.86510010  -0.34407548   0.67838661  -0.56936326   0.13379727
   -1.49853510   1.54590325   1.24741945  -0.03820692   0.62176524
    0.74295074   0.02181866   1.03888924   0.31599423   1.08033509
   -0.38044883  -0.59131489   0.21993080   1.09954187   0.98347862
   -0.64864459   0.82553398  -2.23159665   0.64667369   0.87580024
   -0.04337952   0.51261760   0.40440601   1.05412117  -0.54450565
    0.23707698   1.51580382  -0.75656815   2.37788831   0.55000140
    0.22033117  -0.42714270   0.51264574   0.52301916  -1.87501752
   -1.56957176   0.74998451   0.34263460   0.59928105  -0.28801680
    0.18928863  -0.02656686   0.52147048   1.03537106  -1.09789445
    0.78965350  -0.82520165  -0.59605234   0.04895515   1.46156677
   -0.57435584   0.18985152  -1.25721320  -0.28251511   0.23671646
    1.01720286   0.72004480  -1.83323568  -0.50848905   1.69662988
   -1.85939590  -1.99440653  -0.11465212   0.57169696   1.41315992
   -1.62642978  -0.42160154  -1.59904761   0.95172302   1.63310188
    1.60881975   1.06668457  -0.11113497  -1.61822156  -1.27634347
   -1.60653425   2.02017657   1.95653640  -0.81851384   0.03217444
    1.15883873  -1.62637926  -0.71221831   0.60342250   0.68561110
    1.05849848   1.24334315  -0.41417918   0.41983124  -0.39280507
   -0.22443364  -0.57921338   0.45142072   0.62734356  -1.81159119
    0.29933105   1.34433963   1.04432110   0.51054052  -0.65308052
   -0.70597996  -1.85575138  -1.58197697  -0.33707757   0.33895553
   -1.10345056  -1.21719651  -0.32334256  -0.86568304   0.50448407
   -0.64730882  -0.32617252  -0.27868323  -1.11262229   0.60605073
    0.21975890   0.24613611   0.82735561  -0.29579869   1.62554260
   -0.79099815  -0.48262039  -0.16464049  -0.91732584  -0.60811087
   -0.31685673   0.77711246   0.24396652  -0.34759600  -2.00834960
   -0.68980021  -0.90272409   1.09792002  -0.72070440   0.69915678
   -0.00048681   0.00295833   0.33282059  -0.27251968  -0.09689718
    0.37914383  -0.32609345   0.69682697   1.10310391  -0.20324770
   -1.20428735   1.06937443   1.22145173   0.69789099  -0.79950624
   -0.73770042   0.06968080   0.44873055  -2.22300937  -0.48237328
    0.20537514  -1.54795716  -1.46151814  -0.62563784   0.50423634
   -0.26353071   1.03688083  -1.62671470  -0.50610170  -0.13991967
   -0.40800174   0.61092294   1.02684996   0.12167612   0.39448839
   -1.00839021   0.96995006  -0.18882971   1.54154713   0.08116456
    0.95605687   0.96253770   0.17594137  -0.40985162   0.89893801
    0.35355152  -0.87137069  -0.33522063   1.73725293   0.53309511
   -1.42203332   0.16434261   0.40961160   1.24058893   0.49311342
    0.04402102   0.40976807  -0.98680933   2.04170453  -0.45671954
    0.32037369   0.25999563   0.03750701   0.00323284  -0.84182357
   -1.17583425   0.98622497  -0.37037256  -1.47696247   3.19812843
   -0.89192645   1.35280804  -0.95747244   1.30657458  -0.18971532
   -1.07297991   0.90650694  -0.36562046   0.18715837  -0.24501399
   -2.10789683  -0.24409513  -0.10204374  -1.03279826  -0.90239488
   -0.94048263   0.52204462  -0.85668086  -0.12248797   1.06231799
   -1.56555418  -0.64314559  -0.52086359   2.33594592  -1.35416728
   -2.35200128  -0.97615995  -1.48575281  -0.80025713  -0.31231908
    1.47750301  -0.66352325   0.14897084   0.60774110  -1.76456332
    0.67669134  -0.27909565   0.21803550  -0.42101916   1.22497058
   -0.80859879  -1.60263776  -0.66889519   1.68600776  -0.74471404
   -0.54237506   0.30786220   0.09911538  -0.24683185  -0.10715483
    0.27425057  -0.84317204  -0.48794825   0.25823448   0.27021262
   -2.02399290  -0.39580724  -0.22915607   1.25871762   0.60687677
    0.09231259   0.06910199  -0.57440954   0.14843137   0.91235656
   -0.71923160  -1.28136047   0.37970984  -0.87249711   1.36302137
    1.10316773   0.43323052   1.33324001   1.21922184  -1.38007284
    1.79131515   0.40456027   0.47822739  -1.62833009  -1.48936956
   -0.84650388  -1.04087204   1.08807676   1.00739015   1.21204429
   -0.11410527   0.20830928  -1.10420374  -1.64806360   0.93367336
    0.52171480  -1.56731654   0.20463524  -1.48854017  -0.12220121
    0.72122747   1.00251404  -0.80632956  -0.85681860  -1.44907592
   -1.37775377   0.79140818   0.88985174  -1.15900445   1.84262018
   -1.00509690   1.40522931   0.53329797  -0.86030154   0.06750256
   -0.24509052  -0.91384889   1.84847348   0.84398959  -0.16465566
    0.39068291  -1.74958852   1.00343454  -1.12123219   0.95486732
    0.15140072   1.27033059   1.19821087   0.70150350  -0.82924501
   -0.01972125  -0.10398467   0.47318181  -0.19079657  -0.53130778
    0.24324903   0.83473861  -0.17861257  -0.76352883   0.45436427
    0.63526417  -0.57627018  -0.60398304  -0.01201849   0.28884910
    0.85291540  -1.16074558  -0.49915631  -0.37307855  -0.35981133
   -0.55674767   1.88393019  -0.02627927   0.75351531   0.51527807
    0.97527139  -1.57487726   0.66262152  -2.22265342  -0.64732465
   -1.09670677  -0.47230199   0.74487882  -1.78925104   0.43547002
    1.66978644  -1.05321916  -0.72642066  -0.38561567  -0.10861009
    1.20319365  -0.52174054   0.35486439   0.02339955   0.07368227
    2.08781718   1.12654494   1.20725716  -1.58572824  -1.13454949
   -2.25298299   0.96805767   0.93735400   0.52502517  -0.04694295
   -1.35219435  -0.48963553   2.05387070   0.18617421   0.90426857
   -0.86706688   0.49836245  -1.12885016  -0.39142613  -0.96849153
   -0.06600812   2.03341546  -0.95336480   0.44285100  -2.00911848
    0.40729687  -0.48631028  -0.30127147  -0.97914452  -1.07309885
    0.64354273   1.24433111  -1.87078101  -0.65683582  -0.31295616
    0.33534545   0.56016977   1.71535413   2.16829747  -0.53185851
   -0.43471340   1.54766920   0.11441271   1.65173810   0.21985806
    0.14601800   0.46972589   1.30379082   0.23235042   0.25467820
   -0.52977957  -1.14289990   2.18083490  -1.23497117  -0.17136289
   -1.40619874  -0.95847931  -0.16963324   0.40926989  -0.15191083
   -0.95009646  -0.52138654   0.15311586  -0.84392838   0.19331167
   -0.25312857   0.78895165   0.96939263  -2.28735175   0.65147503
   -0.81698338   0.23994375  -1.05181211  -0.99889103   1.22960424
    0.36822066  -0.51929540  -0.18901452   0.20193541   2.31997328
    0.15131801   0.12459348  -1.79565767  -0.11573262   0.19093435
    0.41926057  -0.46769624  -0.17652453   1.22542617   0.28227944
    0.65484013  -0.12199705   0.15140433  -0.42270228  -0.01173220
    0.79547011  -1.94855228  -1.70486074   0.66450252   0.16466369
   -0.03099778  -1.14659672  -0.15560310  -0.31231990   0.10690971
   -0.93230287   1.33281819   1.24097832   0.18309204  -0.59196915
    0.91440218   0.73020627   0.11263660   0.98992666  -0.88929891
   -0.84110411  -0.38700593  -0.07286067  -0.97752375   1.39573526
    1.00623854  -0.78606372   0.75082377   0.66317437   0.67109751
   -0.09812661  -1.76308219  -0.24205785  -0.11849584  -0.19362800
    1.38817925   0.12731919  -1.09571474  -0.25258228  -0.15638863
   -0.87902556  -1.05211649   0.82669454   0.73605253  -0.98015740
    0.22400076   0.02568500  -0.63312248  -1.61310609  -0.76564137
   -1.13396792   0.91019397   1.01452091  -0.19022648  -1.24888798
   -0.74931853   1.34362587  -0.87059260   0.97530292  -0.50974763
    1.18705406   0.45157853   0.12936097  -1.23506052  -0.42045615
    0.27480585   1.24435048  -0.53954460   0.29771588   1.08098519
   -0.52929141   1.23306318   0.99776960   1.04632566   0.21044042
    0.20713247  -0.75259273   0.75673368  -0.01374125   0.10962477
   -2.26541623   0.19580851  -0.77528124  -0.41111875  -2.14123413
    0.69875825   0.66045453   0.31049891   1.21967421   0.84074029
   -1.38751703  -0.36483280  -1.36388728  -0.15804044  -0.78944288
    1.43084964   0.31606005  -0.89024506   1.19746196   1.36573525
   -0.55007035   0.96539132  -1.02362693   0.80688226   0.06336923
   -1.01229075   0.54114177   0.87533496  -0.09798733   0.06178890
   -1.69605782   1.14237543   1.06342918   0.87810569   0.39058986
    0.63672065   2.47698451  -1.06189079  -2.10286183  -0.00215199
   -0.06516780  -0.43360827   2.71436230   0.54190611   0.80168182
   -0.46328276  -2.10514874  -0.86696188  -0.36013478   0.76667306
    1.03242342   0.69864660  -0.85717806  -0.74214967   0.00689113
    0.56285720   2.37469681   0.82381853   0.28491058   0.68905173
    0.78782150   0.06438661  -1.43068319  -1.11837040   0.76721468
    0.29825365   0.17078342  -1.00123458   1.01912263   0.53100812
    0.14878485  -0.94752378  -1.56305609   1.91119621  -0.24105822
    1.00313160   0.22699421   0.31478239   0.68820914  -0.74170040
    0.43630903  -0.84955752   3.44051399   2.10089584  -0.73974248
    0.74334077  -0.79587687   0.48598266   0.00785284  -0.61316504
   -1.68651101  -1.43851405  -0.16583189   0.26621218   2.04003892
    1.71360343  -0.01780081  -1.00269085  -0.71525077   1.12857692
   -0.97682093  -0.99998348  -0.17639544  -2.40872772   1.06524244
   -0.56668228   1.15902641  -0.22759853  -0.47520838   0.88112073
    0.23601881  -1.30083681   0.04164571  -1.69947848  -1.19793296
   -0.16697204  -0.87592770  -2.45825822  -0.83235923   1.21145555
   -1.72281538  -0.68171794   0.25698357   0.86734657  -0.74331118
    1.43352501   0.72637741   1.65296960   0.44521188  -0.48984436
    0.05418679  -1.52133621   0.81216463   1.62294909   0.71397227
   -1.22150393  -0.12649207  -0.56223986   1.95149068  -2.02068897
    1.24931625   0.93939008  -1.61036843   1.69535092  -1.10769158
    0.35240354   0.05375236  -1.49681014  -1.26838819  -1.28207433
    0.57671280  -0.21013322  -0.96612820  -1.08511751   0.45036560
   -1.45030858   0.09152321  -0.08092959  -0.72885644   0.50276340
   -0.57070345  -0.61366709  -1.28232480  -0.19295379   1.94980292
    0.88568278   2.39849458   0.52423710  -0.03314683   1.34811248
   -0.45585297   0.44206737   1.14478603  -1.03278373   0.98533991
    1.24934383   1.20691675  -0.19885305   1.63437595  -0.52071097
    0.36429125   0.69549566  -1.04312031   1.05009334  -0.41945322
   -0.44073583   0.29543463  -0.71889716   0.44500929   0.94697969
   -1.43095012   1.07916279  -1.33656114  -1.00012945   0.25171772
    0.39902427  -0.92021949   0.43285248   1.79002271   0.96247395
   -1.57825204   2.42553621  -0.42098744   0.75242184   1.80507662
   -1.62710866  -1.00121885   0.10612341   0.16052545  -0.38680091
   -0.39645217   0.30579362   0.12371361  -0.84098371   0.24000699
   -0.62095028  -0.13759551   0.95967938   0.89499869  -0.23291655
    1.54126283  -2.04946197  -0.50757405   2.42063639   0.25576926
    1.03143143  -0.09606169   1.13735459   1.69426406  -0.65342019
    0.61016273   1.78078148   0.58587932  -0.36266407   0.73414166
    0.01590708  -0.23639498  -0.89710912  -0.02855570  -0.70332573
   -0.83391348   0.64191851   1.24665560  -0.98448442   0.10846849
    0.43142162  -0.09946560   1.58651590   0.17856058   1.05070529
   -1.29842745  -0.40742987   0.90849785  -1.64162029   0.77516104
   -0.22740379  -0.89675992  -0.20118824   0.43343500   0.45770853
    0.82194807  -0.35137118  -1.38175404   0.61975126   1.08037588
   -0.16825111  -0.24695346  -2.85587495  -0.80574045   0.20349284
   -0.66732199  -1.50004514  -0.84139341   0.98658058   0.57620185
   -0.50254975   1.40603491   1.09506989   0.93000297   1.68380737
    1.16518186  -0.30971380   1.67605675   2.17056228   0.40261110
    1.03829908  -0.48121067   0.02155377   1.08799919   1.18445222
    0.93665604   0.37936108  -0.68585412  -1.85792817   0.94812498
    0.84182481  -0.22162955  -1.55280340  -0.55096531  -2.26241176
   -0.62749547  -0.68253920   0.99562521  -0.62378144  -1.05574418
    0.40001492  -0.55951926  -0.60428223   0.48041204   0.36771118
    1.71488584   0.40534554   0.16575882   0.55922326  -0.67625836
   -1.27243816  -0.48203753   0.66463328  -0.60662222  -1.07891932
   -0.52917884  -0.57234002   0.57953289  -0.09637631   0.25425811
    0.99140954   0.49235470   0.74205320   0.52329580   1.55378217
    0.71723879   1.57529560  -0.28815178   1.62357851  -1.65633880
    0.83503502  -0.43323645  -0.22620194   0.49537518  -2.04057653
   -1.26449291  -0.10887377  -0.26361921   0.45305727  -0.67378600
   -0.90684467   1.73919234   0.81762365  -1.04985124  -0.88696317
   -0.19624787   1.12519396   1.07225957  -0.74347108  -1.89307877
    1.12140437   0.78255860   0.52893306   0.22990250   0.46823269
    1.11440353  -2.01191231   0.68101688   2.04685025  -1.59766942
    0.02231869   0.32400320  -0.29809134  -1.06906533  -0.56573804
    0.48246879   0.11922388  -0.49618630  -0.91696517  -0.26497863
   -1.69358298   1.19795349   0.09371777   0.33611847   1.99971885
   -0.42940915  -0.63337170  -0.29630195   0.20869172  -0.99479763
    0.08033304   0.09879447   1.02815697   1.13411141   0.46228757
    0.52558282   0.96650747  -1.35757053   0.38595755  -0.44663697
   -0.75467954   1.09296158  -1.51746313  -1.95418189  -1.02041851
    0.17109853  -1.32230225  -0.55684376  -0.78398521  -1.66511258
    0.24647128   0.76022833  -2.37694046  -1.40854984  -0.57289212
    0.44762237  -1.19455106   1.73453006  -1.29780182   0.83582924
   -1.41099329  -0.50335218   1.63624807   0.15430914   0.15540988
    0.56078878  -0.32670485   2.77946619  -1.88841336   0.45757097
    0.36536188   0.49883683  -0.16891518  -0.00885665  -1.17398161
   -0.08052832  -0.52375984  -0.90518019  -0.19275880  -1.91736574
    0.13269427   0.53881466   0.08275030  -0.21972181  -1.60809471/
  :
    # 32-bit randoms
  qw/
    -0.67900010  -0.76353070  -1.22055314   1.70912815   2.16055966
     0.76768605   0.77652945  -1.61644663  -0.88292110   0.26198049
     0.24328359   0.69033541  -1.03393856  -0.40027470   2.27263946
    -0.62430946   1.27916708   0.67434065  -0.21996068  -0.62762867
    -0.43698433  -0.53687934   0.42856553  -0.22543321   1.29415241
     1.42726328  -2.12264560   0.13847042   0.26737712   0.68645675
     0.38605774  -0.95860332  -1.07557563  -1.52879695  -0.96806549
     0.73186775  -0.50145088   2.16420334  -0.45426248   1.12537493
    -0.02670718   1.11944719   0.48722774  -0.28728689   0.45148410
     0.13053322  -0.72644368   0.05816893  -0.02115270   0.68634808
     1.64985385  -1.63358803   0.17987764   1.09711570  -0.86123347
     0.15496576   0.35002371  -0.93026082   0.01618218  -0.16037354
     0.36703253   1.86624428   0.77299935  -1.72601245   0.71059066
    -0.91276332   0.04126098   0.52123484  -0.16453685  -0.00808668
    -2.40360676  -0.59022802   0.58972699   0.46505708  -0.72014329
     0.02179857   2.37615965   0.45401722   1.22106625   0.54072968
    -0.52864313  -1.29424897   0.10462222   0.35390484  -0.53142435
     1.13474901  -1.52782483   0.28320489   0.24346593   0.55784609
     2.18881755  -0.56508311   0.98285684  -0.67143526   0.14551121
    -0.17335697   0.52923238  -0.08619739   0.52467633  -0.69215082
    -0.39443838   0.88897785  -1.97187874   0.17645475   0.57128632
     1.29070896  -0.81455168   1.38222671   0.07108479   0.28753603
    -0.69374219   0.27003562   0.33399782  -0.11420947  -1.66122486
     0.42215373  -1.01029821   0.03676902  -1.23241263  -1.54440295
     0.95863264  -0.69771632   1.27896420  -0.40993469   0.36440376
     1.18815772   0.08987873   0.59248630  -2.90152122   0.38578120
    -1.12898624  -1.05914728  -0.50179005  -0.84609081  -0.99468041
    -0.41574952  -0.76211969  -0.20299729  -0.71325347   0.88402499
    -0.14368680   1.08816270   1.91729303  -0.20682637  -1.12362944
     1.12763703   0.61693399  -0.35387886   0.78621331  -0.97141916
     0.19239875  -1.54455109  -1.56717047   0.50680235  -0.20029765
    -0.75296394   0.92199925   0.35072992   0.51153266  -0.29514504
     0.03426061   0.55253334   1.04827075   0.61529743   0.30380821
    -0.28662049  -0.19427693  -1.30523354   1.31129013   0.11673200
    -0.71794471  -0.58214888   0.01369455   0.24879386  -0.87976113
    -0.65148067  -0.43105601  -1.63184963   2.25866025   1.92904017
     0.27176520   0.58162239  -1.50830827  -0.24356306  -0.45637866
    -0.72860127  -0.86774494  -0.15279850   1.38002969   0.28652261
     1.33609983  -1.94745000   0.17627001   1.10527031   0.73706010
     1.12969134   0.55999512  -0.76511473   0.26127602  -0.63203112
     1.19384409   0.38299677  -0.74321487   0.87226975  -0.84083218
     0.31658483   0.08890916  -1.03324471  -1.60370690  -1.07315687
     1.07578588  -0.17463034  -0.31997483   1.43186566   0.32393862
     0.42341384  -1.57653697   0.97085585   0.75623248   1.55301233
    -0.71971361  -0.76757147   1.41834869   0.23025256  -1.69996160
     0.30258519   0.71546495   0.47236540  -0.56111496  -0.13267620
     0.92803983  -0.36504838   0.02139622   0.71590681  -1.28289086
     0.13518499   1.60034312   1.34842855   0.34812205  -2.17042649
     1.14760942  -0.85513258   0.40308688   0.15660158  -0.72191595
    -0.18059661   0.15399787  -1.80457578   0.88313007   1.69640013
     0.42395761  -0.82432333  -0.21315128   0.35815099  -0.48051247
     0.70900858   0.07105364   0.52089723   0.64443754  -0.81145639
    -0.83587056   3.15928772  -2.03740685  -0.40564928   1.72690182
     0.66042581   0.43339619   0.18392800   0.99073473   0.05336630
     0.73983739  -0.04392395   0.36274058   1.16822342  -0.25872667
     2.76468656   0.35683563   0.41112267  -1.27633884   0.64155403
    -2.50564439   0.23795010  -1.72064188   1.31943865  -0.12834823
    -0.49208036   0.83591542   0.71456205  -0.21491903   2.45134727
    -0.15876076   3.02679669   0.67640287  -0.24689274   1.61840233
     0.43362910  -0.62117358  -1.47193139  -0.24586867  -0.13090489
    -0.59812169  -0.34381041  -1.68198497  -1.12370152  -0.02342749
     0.33195258   0.85231309   1.06445296  -0.92827048  -0.82057411
    -1.20948283  -0.21921034   1.30274100   0.28860582  -0.59775623
    -0.38182075   0.64385688  -0.32873730  -0.56046331  -1.43299182
     0.09149188  -0.77837133   0.32051966   0.65350950  -0.08399004
    -0.19006613   0.36516604  -2.82771563  -0.36652092   1.77646039
    -2.07098381  -1.29342376   0.86819046  -1.14505952   0.92792778
     0.07584727   0.75714209   0.67041333   1.72599838   2.03455481
     0.00861707   0.69951705   0.04180243   0.50560959  -1.55845761
     0.42819104   0.58623670   0.24897470  -0.16742131   0.45892873
     0.34027503  -0.73083727   0.22030652   0.15034567  -1.55134666
    -0.03538797  -0.18051762  -0.14874899   0.22393302  -0.39403836
     0.42915502  -2.10147850   0.06860015  -0.94066242   0.25926413
    -0.46055477  -2.15732424  -0.19283784  -0.14535494  -0.02878216
    -0.20788636  -1.51909657  -1.37963203   1.92388983  -1.08691233
    -1.73661302   0.39057554  -0.34147646  -0.35671011  -1.35244976
    -0.41230719  -0.64364491   0.59673733   1.09730624  -0.86768419
     0.96826380  -0.13674848  -1.06710164   2.66691369  -0.14188941
    -2.30539038   0.73200789  -0.59515746   1.03066293   1.36289736
    -0.30856502   1.06394156  -0.75277416  -0.61219092  -0.37327749
    -1.25177691  -0.37011232  -0.86387100  -0.72704593  -0.67622042
     0.44869145  -0.74969831   1.66012041  -0.17594821   1.32266784
     0.04690328  -0.31211411   0.44230388   0.97155470   0.90523572
    -0.84965835  -0.83840044  -0.89360810   0.43358720   0.40396575
     0.71247847   1.48216826  -1.65755942  -0.20114935  -2.95185051
     0.40528248  -0.89820915   2.44371778  -0.91240064   1.19694453
     0.42441724   0.34649062  -0.67585940  -0.49745447  -0.52383390
     0.75470185  -0.07945107  -2.08217915  -0.78998007  -0.61330454
    -0.28405933   0.18402104   0.27259858  -1.33936692   0.76848496
    -0.39010815   1.68676650   0.62789843   0.91876472   1.78332509
    -1.25903671  -0.00580486   1.00371662  -0.87967978  -0.61400856
     1.12427103  -0.27612582   0.64486982   0.90475247   0.04707521
    -0.72339994  -1.20893895  -0.83763732   0.65115287  -0.69176037
     1.17239556   3.17292548  -0.85410512  -0.48530390   0.40726012
    -0.94016253  -0.05353060   2.40470848   0.14006401   0.50718046
    -1.25837150  -0.04069010  -0.56197399   1.52747327  -0.45172723
     0.61650966   0.25511258   1.19296831  -0.80737900   0.44607527
    -0.25197867   0.78596503   0.30917724  -0.76384849   1.22184319
    -0.65125174   1.31370130   0.07587660   0.35703115  -0.22700003
     0.15612765   0.31911374   2.23410709  -0.60783103   2.08425230
     0.57574280   1.41945574  -0.28644632  -0.03503043   1.86885501
     0.21157010  -0.33770027  -0.92057709  -0.75207452  -1.20241703
    -0.42431736  -0.50687216   0.70482596   0.82602015  -0.34864225
     0.52770451  -0.62201574   0.70491460  -0.46738459  -0.30389059
    -0.52978626   0.04819083  -1.29516631   0.70534771  -2.35494299
    -0.29965748  -0.26397931   0.03529472   0.24992585   0.16213455
    -0.90899783   0.33763435   0.80475292  -1.77454331   0.09471756
    -0.16856530  -1.12924701  -1.51199859  -0.32219139   0.33629224
    -0.24672311   1.02574110  -1.05782008   1.23412914   2.60921874
     0.91047293   0.11491478   0.16603746  -1.04517079   1.28584748
    -0.88443702   0.56787488   2.74991534  -0.03169719  -0.07239003
    -0.34450677   0.83036303   1.78222223   0.53144648   0.70267110
     0.44661108   0.64836241   2.38993862  -0.53864101  -0.71251358
    -0.87798273  -0.78473551   0.51689773   0.78897968   0.99470338
    -0.07535737  -1.90432294   0.39725397  -0.44375693  -0.55825407
    -0.59380803   0.62741480   0.05573984  -0.22477983  -1.51419686
     2.69471494  -0.29968222   1.19471379  -2.73610734  -1.97556688
    -0.31920327  -1.13405590   0.20349634  -0.50584252   1.37633888
     1.96842803  -1.23781003   0.47889897  -0.17117167   0.28351957
    -2.23140751   1.22755689  -0.93293793   1.57015565  -0.53404272
    -0.63797776  -2.02507780  -0.01233693  -1.28624017  -1.34112670
     0.26112293  -0.09335167   1.65534659   0.01457528   0.78524077
     0.98986950   0.13541561   0.45548461   1.10497585   1.09772959
     0.29971907   0.87004616   0.58565753   1.37620918   0.26437745
    -1.44472854   0.62048990  -0.84613906  -1.83005566   1.16209251
    -0.90693241   0.00795211  -1.11361279  -0.15306165  -2.71460755
     0.04864673  -0.32212339   1.37043776   1.36040056   0.00485763
    -1.86224075  -1.28021191  -0.13079462  -1.51863376  -1.68756893
     1.00121586  -0.31900260  -0.21270389  -0.84799824   1.15380852
     0.46656485   0.78352523   0.52829336   1.12566205   0.29344039
     1.17386669  -0.60954282  -1.66527560   0.43893881   0.89909315
     0.57319940   0.87200371  -0.23476307   0.35353564  -1.44958196
    -0.28819623  -1.75861085  -0.76348406   1.45872715  -1.11743785
    -0.72871184  -0.57310292   0.48844415   1.24141371   1.25179089
     0.18777951   1.44216240   0.70064171  -0.44505285  -0.49686365
     0.09356023   0.60571049   1.00905904   1.23933872   1.30429660
     0.09413284   0.30320394  -0.41872836   0.92461852   0.64913337
    -0.56699722  -0.63793177  -1.73995279   0.52618610   0.38845365
     1.03770034  -1.78131510  -0.14361246  -0.26501899  -0.63027212
    -1.19650150   0.73545008   1.59556468   0.99040700   1.66094398
    -1.28378901  -1.50010525  -0.87182895  -0.30825364   1.13628886
     0.26073400   2.02099904  -2.17969509   0.71487473   1.46342663
     0.38535090  -0.13499994   0.25870324  -0.46727604  -0.44887857
    -2.19650692   1.21344560   0.53448598   0.27511196  -1.15937424
     0.36380507   0.76539227   0.28049142  -1.52529624   1.51310692
     0.58450546  -0.31188719   0.11119090  -0.20616474  -0.54427601
     2.24598035  -0.00520781   0.53495206   1.90912834  -1.25468912
     0.71422585  -1.06388042   0.33113273  -0.40648985  -0.48914519
    -1.38481711  -0.59241390   0.07675448  -0.22417277   0.38794171
    -2.21257839   0.45013826  -0.56007421  -0.30633285   1.36931495
    -1.28235511  -0.19583087   0.08210015   1.75822686   1.43177706
     0.93945616  -0.71019834  -0.44832379  -0.08488514  -2.02331507
     0.09730286   0.14973228   0.52420199   0.95155446  -0.28124707
    -0.22300503  -0.20209795  -0.85344413   0.52417473  -0.44406390
    -0.61414536  -0.01271084  -0.21018387  -0.20464778  -0.94408110
     0.15137101  -0.92074986   0.30081329   1.04919790   0.01431403
     0.21432851  -0.27597970  -1.60739819  -0.61609785  -1.79166171
    -0.41639126   0.90125814  -0.12740289   0.09465179  -0.00242445
     0.49399635  -1.31114583   0.47914316   0.25622234  -1.14812830
     0.11413797  -1.28016352  -0.94496418  -0.12273360   0.74506462
    -0.03613196   1.54218575  -0.92162945   0.91161699  -0.99204263
    -0.52060820  -0.23212847   2.02360077  -0.10092186  -2.41859424
     0.95717335   0.61941127  -0.27259332   1.78342521   0.52390593
     0.98637647  -1.28544392  -0.93234699   1.04664345  -0.10697019
    -0.86643694  -0.87314972  -0.23608421  -0.72462102  -0.32804787
    -0.54587776  -0.71103610  -0.14652763   0.45622198  -0.99007012
    -0.70127570   0.64230882  -0.10470717   0.01518823  -0.66331180
    -0.23505929   0.48128612  -0.75382861  -0.19304559   0.50224462
     1.29558266  -0.64143542   1.46595164  -0.29627956   0.04960887
     0.88403422   1.04150142   1.15166474  -0.85150060  -0.66841338
    -0.73756389   0.43600353   0.65634577   1.37230557  -1.02260958
     1.05074187   0.01614685   0.03282021   0.36296551   0.18132155
     1.31516909  -0.52085624   0.40971297   0.56009989   1.85632909
    -0.34883564   0.25913116  -0.90610859  -0.48002904  -2.44051652
     1.18654858   0.76472477  -0.03209411  -0.81089182  -1.00938077
     0.92300218   0.99042928  -0.68755277   0.84690097  -0.38771263
     0.60926947   1.02529824  -2.64065259   0.06556281  -1.20866378
     2.14964935   1.08042331  -0.15646304   1.36463578  -1.34808125
     1.51789843   0.17868856   0.35093958   0.03641585  -0.01079558
    -1.27051571  -1.08612860  -1.03895721  -0.30304907   1.32756191
    -1.05088740   0.97869833  -1.39205589   0.29077859   0.11755481
     0.11353633  -0.01374465  -1.83304416  -0.37108767  -1.37282011
    -1.08256705  -0.77676171  -0.37292585  -1.96305310  -1.35517080
    -0.48607849  -0.51845203  -0.92292995   1.13146469  -0.78121715
    -0.15295365   0.67332197  -1.16341569   0.52960308  -1.43784410
    -0.06342474   1.69156664   0.42331332   0.50942602  -0.15168407
    -0.07786868   0.90945445   1.93273584   0.86331844   0.29273466
     0.64403066   0.45582812   0.04076944   1.56181497  -0.21336070
     0.74251865  -2.04611919   0.36106936   0.28876444   0.41026358
     1.06842793   0.46735124   1.16729143   0.40085998  -1.45984892
     0.13833485  -1.79837692  -1.34281600  -0.59045746  -0.18001220
    -0.83069550   0.47093770  -0.50977588  -0.02650916  -0.38438485
     0.96292046  -0.59071751   0.75694964   0.64479339   0.93098218
    -1.00004812   0.73731488   1.03395148  -0.76814482   1.90580546
    -0.22803111  -1.17877173  -1.00023474  -1.10226675  -0.60577117
     1.51270619   0.32074401  -0.98256964   0.31197798  -0.62867788
    -1.89906688  -1.22626577  -0.68932323  -0.71990808   0.87973504
     1.15189422   1.45384544   1.23657847  -0.15840770   1.03670758
    -0.73867633   0.90969075   1.66518911   0.04534167  -0.55061938
     0.29343915   1.32344159   0.15794698  -0.45255219   0.86179561/;


### - Guassian Function - ###

# Set predetermined seed for verification test
sub myseed
{
    my $seed = $_[0];
    my $need = $_[1];  # Ignored

    if ($Config{'uvsize'} == 8) {
        push(@$seed, 0x12345, 0x23456, 0x34567, 0x45678);
    } else {
        push(@$seed, 0x123, 0x234, 0x345, 0x456);
    }
}
eval { srand(\&myseed); };
if (! ok(! $@, 'srand(\&sub) works')) {
    diag('srand(\&sub) died: ' . $@);
}


# Test Gaussian randoms
my @test_gaus;
for (my $ii=0; $ii < 1000; $ii++) {
    push(@test_gaus, sprintf('%0.8f', gaussian()));
}
is_deeply(\@test_gaus, \@base_gaus);

# EOF
