/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"

static const unsigned char greek_ISO_8859_7CharToOrderMap[] = 
{
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255, 67, 59, 45, 74, 51, 61, 69,105, 88, 99, 80, 93, 77, 95, 97,
 73,121, 92, 71, 64,110,103, 87,114,112,116,255,255,255,255,255,
255, 32, 72, 60, 43, 29, 78, 44, 58, 28, 70, 49, 41, 55, 40, 31,
 42,115, 37, 39, 38, 53, 90, 65, 98, 66,108,255,255,255,255,255,
145,140,150,180,138,144,179,155,178,154,177,176,135,175,149,174,
173,137,143,172,171,136,148,170,169,153,152,151,168,167,166,165,
164,134,107,132,127,163,162,128,147,131,161, 84,146,160,159,142,
133,126,130,129,120,141,102, 94, 89,109,118, 83, 85,139,122,125,
 91, 36, 62, 75, 57, 46,111, 82,101, 56, 54, 81, 50, 68,113, 63,
 47, 96,158, 25, 48,106, 79, 86,119,104,124,157, 17, 21, 18, 15,
123,  1, 34, 19, 23,  5, 33,  9, 27,  6, 12, 16, 13,  4, 52,  2,
 14,  7, 11,  8,  3, 10, 22, 26, 76, 24,100,117, 20, 30, 35,156,
};

static const unsigned char greek_WINDOWS_1253CharToOrderMap[] = 
{
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255, 67, 59, 45, 74, 51, 61, 69,105, 88, 99, 80, 93, 77, 95, 97,
 73,121, 92, 71, 64,110,103, 87,114,112,116,255,255,255,255,255,
255, 32, 72, 60, 43, 29, 78, 44, 58, 28, 70, 49, 41, 55, 40, 31,
 42,115, 37, 39, 38, 53, 90, 65, 98, 66,108,255,255,255,255,255,
127,180,179,178,177,176,175,174,173,172,171,170,169,168,167,166,
165,134,107,164,163,162,161,160,159,158,157,156,155,154,153,152,
151,137,102,132,150,149,148,128,139,131,147, 84,138,146,145,136,
133,126,130,129,120,144,143, 94, 89,109,118, 83, 85,135,122,125,
 91, 36, 62, 75, 57, 46,111, 82,101, 56, 54, 81, 50, 68,113, 63,
 47, 96,142, 25, 48,106, 79, 86,119,104,124,141, 17, 21, 18, 15,
123,  1, 34, 19, 23,  5, 33,  9, 27,  6, 12, 16, 13,  4, 52,  2,
 14,  7, 11,  8,  3, 10, 22, 26, 76, 24,100,117, 20, 30, 35,140,
};

static const PRUint8 greekLangModel[] = 
{
1,2,3,3,2,3,3,3,1,3,3,3,3,3,3,3,1,2,3,2,2,3,3,1,0,3,3,0,0,3,0,0,
3,3,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,3,3,3,2,3,3,3,3,3,3,3,1,3,3,1,2,3,3,1,1,3,3,0,0,3,0,0,
2,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,1,0,0,0,0,0,0,0,0,
3,3,2,1,3,3,3,3,3,3,1,1,2,1,3,3,3,3,1,3,3,1,0,3,0,1,1,0,0,3,1,0,
2,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,1,2,3,2,1,1,1,0,3,1,3,3,2,3,3,1,3,3,0,1,3,1,1,2,1,0,
1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,1,3,3,3,1,3,3,3,3,3,3,3,2,1,3,3,2,3,3,3,0,3,2,0,0,3,0,0,
2,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,1,3,3,2,1,3,3,3,3,1,3,3,2,3,3,2,3,3,2,0,2,2,0,0,1,0,0,
3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,1,0,
3,3,3,3,3,3,2,2,3,3,1,3,3,2,3,2,3,3,3,3,3,2,2,3,0,3,3,0,0,2,0,0,
1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,1,3,3,1,3,3,3,0,3,3,3,3,1,2,2,1,2,2,3,2,3,0,3,3,0,0,3,0,0,
0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,3,3,0,0,3,3,1,1,3,3,3,2,1,3,1,0,3,0,0,2,2,1,0,2,3,0,0,2,0,0,
1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,3,3,2,2,3,3,1,0,3,3,3,3,2,3,2,2,3,2,1,2,2,1,0,3,3,0,0,0,0,0,
3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
3,3,3,2,3,3,3,2,3,3,1,2,1,2,3,3,3,3,1,3,3,2,2,2,0,1,2,0,0,2,0,0,
0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,1,2,3,3,1,1,3,2,1,0,3,3,3,0,3,3,0,3,3,3,1,3,0,0,0,0,0,2,0,0,
0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,2,3,3,3,0,3,2,1,0,0,2,3,3,3,3,0,3,3,1,0,3,0,0,0,0,0,3,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,0,3,3,3,0,3,3,3,3,0,3,0,0,3,0,0,2,3,3,0,3,2,0,0,0,0,0,
3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,2,3,3,0,1,3,3,1,2,2,2,3,3,3,3,2,3,3,2,2,3,0,1,2,0,0,3,0,0,
1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,3,3,2,2,3,3,1,1,3,3,3,3,0,3,0,0,3,0,0,3,3,2,0,3,3,0,0,0,0,0,
3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,3,0,0,3,3,0,0,3,3,3,2,0,2,0,0,3,0,0,2,2,0,0,2,3,0,0,0,0,0,
1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,1,3,3,3,3,0,3,3,0,3,3,0,3,2,3,3,3,2,3,1,2,2,0,2,0,0,0,2,0,0,
0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,3,3,1,2,3,3,2,1,3,2,3,3,0,3,0,0,3,0,0,2,2,1,0,2,2,0,0,0,0,0,
2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
2,3,3,3,2,1,3,3,1,1,3,3,3,3,0,3,0,0,3,0,0,3,2,2,0,3,2,0,0,0,0,0,
2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,3,3,3,1,3,2,0,0,0,0,2,2,3,3,1,2,3,1,1,3,0,0,2,0,0,2,0,0,
0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,1,1,3,3,3,1,3,3,0,0,0,0,3,0,2,2,1,3,2,1,1,2,0,0,0,0,0,3,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,3,3,1,1,3,3,1,1,3,2,3,3,2,2,2,2,2,1,1,2,2,0,0,2,2,0,0,0,0,0,
1,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,0,2,2,0,0,2,3,0,2,1,2,1,1,2,1,0,1,1,1,0,2,1,2,0,0,0,2,0,0,
0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,0,1,0,0,0,1,0,2,1,0,0,0,0,0,1,0,
3,3,3,2,3,3,3,1,3,2,0,0,2,1,2,2,2,3,0,3,3,1,0,3,0,0,3,0,0,2,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,1,2,3,2,3,0,3,3,0,0,2,0,2,2,2,3,0,2,3,0,0,2,0,0,0,0,0,2,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,3,3,
0,0,0,0,2,3,3,3,3,3,2,3,1,0,0,0,3,0,0,0,2,0,3,0,0,1,1,3,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,2,2,
0,0,0,0,3,3,3,3,3,2,3,2,1,0,0,0,2,0,0,0,2,0,2,0,0,1,1,2,1,0,0,1,
2,3,3,3,2,1,3,3,2,0,3,2,3,3,0,3,0,0,2,0,0,2,2,2,0,2,2,0,0,0,0,0,
2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,
0,0,0,0,3,3,3,3,2,3,2,3,0,0,0,0,2,0,0,0,3,0,3,0,0,2,0,2,0,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,1,
0,0,0,0,3,3,3,3,3,2,3,3,1,0,0,0,3,0,0,0,2,0,2,0,0,2,1,2,0,0,0,1,
2,3,0,1,3,2,0,0,2,2,0,0,1,0,2,0,2,3,0,3,2,0,0,2,0,1,0,0,0,2,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,1,0,3,2,3,1,2,2,0,0,0,0,2,3,3,2,2,2,2,0,2,2,0,0,0,0,0,2,0,1,
0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,3,3,1,1,3,3,1,0,3,2,3,2,0,2,0,0,2,0,0,2,2,1,0,1,2,0,0,0,0,0,
1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,2,3,1,2,3,2,0,3,1,2,2,3,1,2,0,0,3,0,0,2,2,0,2,2,2,0,0,1,0,0,
1,1,0,1,0,0,0,0,0,0,0,0,0,1,2,2,0,1,0,2,0,2,0,2,1,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,
0,0,0,0,2,2,2,2,2,2,2,3,1,0,0,0,2,0,0,0,2,0,2,0,0,1,1,2,0,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,
0,0,0,0,2,3,2,1,2,3,1,1,1,0,0,0,1,0,0,0,2,0,2,0,0,3,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,2,
0,0,0,0,2,3,2,2,2,2,1,1,1,0,0,0,2,0,1,0,2,0,2,0,0,2,1,2,1,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,
0,0,0,0,1,3,2,2,2,1,3,3,1,0,0,0,2,0,1,0,2,0,1,0,0,1,1,2,1,0,0,1,
0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,3,3,
0,0,0,0,1,2,2,1,2,1,2,1,0,0,0,0,2,0,0,0,2,0,2,0,0,1,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,3,2,
0,0,0,0,2,2,2,3,2,2,1,3,0,0,0,0,1,0,0,0,2,0,1,0,0,2,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,2,3,
0,0,0,0,2,1,3,1,1,1,2,1,0,0,0,0,1,0,0,0,2,0,1,0,0,1,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,2,2,
0,0,0,0,2,1,1,2,2,1,1,1,1,0,0,0,1,0,0,0,2,0,1,0,0,3,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,2,2,
0,0,0,0,2,1,1,0,1,1,1,0,1,0,0,0,1,0,3,0,1,0,1,0,0,2,1,1,3,0,0,2,
1,1,1,3,0,3,2,2,0,2,1,2,3,3,3,3,2,0,2,0,0,2,2,0,2,1,2,0,0,1,0,0,
1,1,0,1,0,0,0,0,0,0,0,0,0,1,2,1,0,1,0,2,0,1,0,2,1,0,0,0,0,1,1,0,
3,3,1,1,3,2,3,0,2,1,0,0,0,0,2,3,2,1,0,2,2,0,0,1,2,0,0,0,0,2,0,0,
0,0,2,2,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,2,0,
2,3,0,0,2,2,3,2,2,2,0,0,1,0,2,0,1,1,0,2,2,0,0,1,1,0,0,0,0,1,0,0,
2,0,2,2,0,0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,0,0,2,0,1,0,0,0,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,0,2,2,
0,0,0,0,2,2,2,1,2,1,1,1,0,0,0,0,2,0,0,0,1,0,1,0,0,1,1,1,0,0,0,0,
3,2,1,1,3,2,0,0,2,2,0,0,0,3,1,0,2,1,0,2,2,0,0,2,0,0,0,0,0,1,0,0,
0,0,1,2,0,0,0,0,0,0,0,0,0,2,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,2,0,
0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,
0,0,0,0,1,1,2,2,2,1,2,1,2,0,0,0,1,0,1,0,2,0,1,0,0,0,1,1,1,0,0,1,
3,2,1,0,3,3,0,0,2,2,0,0,0,1,2,1,2,2,1,1,2,0,1,2,0,0,0,0,0,2,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,1,2,
0,0,0,0,2,2,3,3,3,2,2,2,0,0,0,0,2,0,0,0,1,0,2,0,0,1,0,2,0,0,0,0,
3,3,1,1,2,2,2,0,1,2,0,0,0,0,1,2,2,1,0,2,1,0,0,2,0,0,0,0,0,2,0,0,
0,1,2,2,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,0,0,0,0,1,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,2,3,
0,0,0,0,1,1,2,1,2,2,1,1,0,0,0,0,1,0,0,0,2,0,2,0,0,1,0,1,0,0,0,0,
3,3,1,1,2,0,1,2,2,0,0,1,1,1,0,1,1,0,1,1,0,0,2,2,2,1,0,0,0,0,0,0,
0,1,1,2,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,2,0,1,1,0,0,0,0,1,2,0,
2,2,0,1,3,2,2,0,3,2,0,0,0,0,2,0,1,2,0,1,1,0,0,2,1,0,0,0,0,1,0,0,
0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,2,2,
0,0,0,0,2,3,1,2,1,2,2,1,0,0,0,0,1,0,0,0,2,0,1,0,0,1,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,3,
0,0,0,0,2,0,0,1,2,1,0,1,1,0,0,0,1,0,1,0,2,0,0,0,0,0,1,1,2,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,3,2,
0,0,0,0,2,2,2,1,2,1,1,1,1,0,0,0,2,0,0,0,2,0,1,0,0,2,1,2,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,3,2,
0,0,0,0,2,1,1,0,2,0,0,0,1,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,2,0,0,1,
2,3,0,0,2,3,2,0,1,1,0,0,0,0,2,2,2,1,1,2,1,0,0,0,0,0,0,0,0,1,0,0,
0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,
0,0,1,1,0,2,2,1,0,2,0,3,2,1,1,2,0,0,0,0,0,1,2,0,2,1,1,0,0,2,0,0,
0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,1,0,1,1,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,3,2,
0,0,0,0,2,1,1,0,0,0,1,0,1,0,1,0,1,1,1,0,1,1,1,0,0,2,0,0,1,0,0,1,
};

const SequenceModel ISO_8859_7greekModel = 
{
  greek_ISO_8859_7CharToOrderMap,
  greekLangModel,
  (float)0.944928,
  PR_TRUE,
  "ISO-8859-7",
  "greek"
};

const SequenceModel WINDOWS_1253greekModel = 
{
  greek_WINDOWS_1253CharToOrderMap,
  greekLangModel,
  (float)0.944928,
  PR_TRUE,
  "WINDOWS-1253",
  "greek"
};
