#!perl -T
use strict;
use warnings FATAL => 'all';
use Test::More tests => 2;
use File::Spec;
use charnames ':full';
use Path::Tiny qw/path/;

my $path;

BEGIN { $path = path(File::Spec->curdir)->absolute->stringify;
        $path =~ /(.*)/;
        $path = $1;
}

use Test::File::ShareDir
    -root  =>  $path,
    -share =>  {
	-module => { 'MarpaX::Database::Terminfo' => File::Spec->curdir },
	-dist => { 'MarpaX-Database-Terminfo' => File::Spec->curdir },
};
#------------------------------------------------------
BEGIN {
    use_ok( 'MarpaX::Database::Terminfo::Interface', qw/:all/ ) || print "Bail out!\n";
}
my $t = MarpaX::Database::Terminfo::Interface->new();
$t->tgetent('ibcs2');
#
# cm is the cursor adress
#
my $cmp = $t->tgetstr('cm');
#
# Note: arguments are column and row
#
is ($t->tgoto(${$cmp}, 40, 18), "\N{ESCAPE}[19;41H", 'ibcs2 cursor_adress');
