/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator.handler.shared;

import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.generator.handler.Handlers;
import com.javonet.core.generator.handler.shared.IHandler;
import com.javonet.core.generator.internal.SharedHandlerType;
import com.javonet.utils.Command;
import com.javonet.utils.JType;
import java.io.File;

public class SharedTypeHandler
implements IHandler {
    @Override
    public Object generateCommand(Object analyzedObject, Command parentCommand, Handlers handlers) {
        String type;
        switch (type = (String)analyzedObject) {
            case "void": {
                return JType.COMMAND.ordinal();
            }
            case "java.lang.String": {
                return JType.STRING.ordinal();
            }
            case "int": 
            case "UNSIGNED_INTEGER": {
                return JType.INTEGER.ordinal();
            }
            case "boolean": {
                return JType.BOOLEAN.ordinal();
            }
            case "float": {
                return JType.FLOAT.ordinal();
            }
            case "byte": {
                return JType.BYTE.ordinal();
            }
            case "char": {
                return JType.CHAR.ordinal();
            }
            case "long": 
            case "UNSIGNED_LONG_LONG": {
                return JType.LONG.ordinal();
            }
            case "double": {
                return JType.DOUBLE.ordinal();
            }
            case "[Z": {
                return JType.COMMAND.ordinal();
            }
            case "[B": {
                return JType.COMMAND.ordinal();
            }
            case "[S": {
                return JType.COMMAND.ordinal();
            }
            case "[I": {
                return JType.COMMAND.ordinal();
            }
            case "[J": {
                return JType.COMMAND.ordinal();
            }
            case "[F": {
                return JType.COMMAND.ordinal();
            }
            case "[D": {
                return JType.COMMAND.ordinal();
            }
            case "[C": {
                return JType.COMMAND.ordinal();
            }
            case "[Ljava.lang.String;": {
                return JType.COMMAND.ordinal();
            }
            case "[Ljava.lang.Double;": {
                return JType.COMMAND.ordinal();
            }
            case "[[I": {
                return JType.COMMAND.ordinal();
            }
            case "[[[I": {
                return JType.COMMAND.ordinal();
            }
        }
        this.complexCommandTypeGenerator(handlers, analyzedObject);
        return analyzedObject.toString();
    }

    @Override
    public void generateCode(StringBuilder existingStringBuilder, Command commonCommand, Object usedObject, Handlers handlers) {
        if (JType.COMMAND.equals(usedObject)) {
            existingStringBuilder.append("void");
            existingStringBuilder.append(" ");
        } else if (JType.STRING.equals(usedObject)) {
            existingStringBuilder.append("String");
            existingStringBuilder.append(" ");
        } else if (JType.INTEGER.equals(usedObject) || JType.UNSIGNED_INTEGER.equals(usedObject)) {
            existingStringBuilder.append("int");
            existingStringBuilder.append(" ");
        } else if (JType.BOOLEAN.equals(usedObject)) {
            existingStringBuilder.append("boolean");
            existingStringBuilder.append(" ");
        } else if (JType.FLOAT.equals(usedObject)) {
            existingStringBuilder.append("float");
            existingStringBuilder.append(" ");
        } else if (JType.BYTE.equals(usedObject)) {
            existingStringBuilder.append("byte");
            existingStringBuilder.append(" ");
        } else if (JType.CHAR.equals(usedObject)) {
            existingStringBuilder.append("char");
            existingStringBuilder.append(" ");
        } else if (JType.LONG.equals(usedObject) || JType.UNSIGNED_LONG_LONG.equals(usedObject)) {
            existingStringBuilder.append("long");
            existingStringBuilder.append(" ");
        } else if (JType.DOUBLE.equals(usedObject)) {
            existingStringBuilder.append("double");
            existingStringBuilder.append(" ");
        } else {
            handlers.SHARED_HANDLER.get((Object)SharedHandlerType.CLASS_NAME).generateCode(existingStringBuilder, commonCommand, usedObject, handlers);
            existingStringBuilder.append(" ");
        }
    }

    private void complexCommandTypeGenerator(Handlers handlers, Object analyzedObject) {
        String clazzName = analyzedObject.toString();
        if (analyzedObject.toString().startsWith("[L")) {
            clazzName = clazzName.replace("[L", "");
        }
        String finalClazzName = clazzName;
        if (handlers.typesToAnalyze.stream().noneMatch(clazz -> clazz.getName().equals(finalClazzName))) {
            Class<?> classToBeGenerated = GeneratorHandler.getClass(finalClazzName, new File(System.getProperty("user.dir")));
            handlers.typesToAnalyze.add(classToBeGenerated);
        }
    }
}

