/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.core.receiver.Receiver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClasspathScanner {
    public Set<String> getClasses() throws IOException {
        HashSet<String> classes = new HashSet<String>();
        try {
            URL[] urls;
            ClassLoader classLoader = Receiver.class.getClassLoader();
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                File file = new File(url.getFile());
                if (file.isDirectory()) {
                    classes.addAll(this.getClassesFromDirectory(file));
                    continue;
                }
                if (file.getName().equals("JavonetJvmRuntime.jar")) continue;
                classes.addAll(this.getClassesFromJar(file));
            }
        }
        catch (Exception ignored) {
            classes.add("Cannot scan for available classes. Review the classpath.");
        }
        return classes;
    }

    private Set<String> getClassesFromDirectory(File directory) {
        HashSet<String> classes = new HashSet<String>();
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (file.isDirectory()) {
                classes.addAll(this.getClassesFromDirectory(file));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(file.getName().replace(".class", ""));
        }
        return classes;
    }

    private Set<String> getClassesFromJar(File jarFile) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            classes.add(entry.getName().replace(".class", "").replace("/", "."));
        }
        return classes;
    }
}

