/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.core.handler.loadlibrary.JvmClassLoader;
import com.javonet.core.namespacecache.NamespaceCache;
import com.javonet.core.typecache.TypeCache;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class GetTypeHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 1;
    private final JvmClassLoader jvmClassLoader = new JvmClassLoader(new URL[0], this.getClass().getClassLoader());
    private final Map<String, Class<?>> primitiveTypeMap;

    GetTypeHandler() {
        try {
            this.jvmClassLoader.addUrl(new File(System.getProperty("user.dir")).toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.primitiveTypeMap = new HashMap();
        this.primitiveTypeMap.put("boolean", Boolean.TYPE);
        this.primitiveTypeMap.put("byte", Byte.TYPE);
        this.primitiveTypeMap.put("char", Character.TYPE);
        this.primitiveTypeMap.put("short", Short.TYPE);
        this.primitiveTypeMap.put("int", Integer.TYPE);
        this.primitiveTypeMap.put("long", Long.TYPE);
        this.primitiveTypeMap.put("float", Float.TYPE);
        this.primitiveTypeMap.put("double", Double.TYPE);
    }

    @Override
    public Class<?> process(Command command) throws Exception {
        if (command.getPayload().length < 1) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 1);
        }
        Class<Object> typeToReturn = null;
        String typeName = "";
        typeName = command.getPayload()[0] instanceof String ? (String)command.getPayload()[0] : (command.getPayload()[0] instanceof Class ? ((Class)command.getPayload()[0]).getName() : command.getPayload()[0].getClass().getName());
        if (this.primitiveTypeMap.containsKey(typeName)) {
            typeToReturn = this.primitiveTypeMap.get(typeName);
        } else {
            try {
                typeToReturn = Class.forName(typeName, false, this.jvmClassLoader);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException(String.format("Error while loading type %s\n%s", typeName, ex.getMessage()));
            }
            catch (Error | Exception ex) {
                throw new Exception(String.format("Error while loading type %s\n%s", typeName, ex.getMessage()));
            }
        }
        if (command.getPayload().length > 1) {
            typeToReturn = typeToReturn.asSubclass((Class)command.getPayload()[1]);
        }
        NamespaceCache namespaceCache = NamespaceCache.getInstance();
        TypeCache typeCache = TypeCache.getInstance();
        if (!(namespaceCache.isNamespaceCacheEmpty() && typeCache.isTypeCacheEmpty() || namespaceCache.isTypeAllowed(typeToReturn) || typeCache.isTypeAllowed(typeToReturn))) {
            String allowedNamespaces = String.join((CharSequence)", ", namespaceCache.getCachedNamespaces());
            String allowedTypes = String.join((CharSequence)", ", typeCache.getCachedTypes());
            throw new IllegalArgumentException(String.format("Type %s not allowed. \nAllowed namespaces: %s.\nAllowed types: %s", typeToReturn.getName(), allowedNamespaces, allowedTypes));
        }
        return typeToReturn;
    }
}

