/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class JsonFileResolver {
    private String path_;
    private JsonObject jsonObject;
    private JsonElement runtimes;

    public JsonFileResolver(String path) {
        this.path_ = path;
        if (!Files.exists(Paths.get(this.path_, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("Configuration file " + this.path_ + " not found. Please check your configuration file.");
        }
        try {
            String jsonText = new String(Files.readAllBytes(Paths.get(this.path_, new String[0])));
            this.jsonObject = JsonParser.parseString((String)jsonText).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLicenseKey() {
        try {
            return this.jsonObject.get("licenseKey").getAsString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("License key not found in configuration file. Please check your configuration file.");
        }
    }

    private void getRuntimes() {
        this.runtimes = this.jsonObject.get("runtimes");
    }

    private JsonElement getRuntime(String runtimeName, String configName) {
        this.getRuntimes();
        JsonElement runtime = this.runtimes.getAsJsonObject().get(runtimeName);
        if (runtime.isJsonArray()) {
            for (JsonElement item : runtime.getAsJsonArray()) {
                if (!item.getAsJsonObject().get("name").getAsString().equals(configName)) continue;
                return item;
            }
        } else if (runtime.getAsJsonObject().get("name").getAsString().equals(configName)) {
            return runtime;
        }
        throw new IllegalArgumentException("Runtime config " + configName + " not found in configuration file for runtime " + runtimeName + ". Please check your configuration file.");
    }

    private String getRuntimeName(String runtimeName, String configName) {
        JsonElement runtime = this.getRuntime(runtimeName, configName);
        return runtime.getAsJsonObject().get("name").getAsString();
    }

    private JsonElement getChannel(String runtimeName, String configName) {
        JsonElement runtime = this.getRuntime(runtimeName, configName);
        return runtime.getAsJsonObject().get("channel");
    }

    public String getChannelType(String runtimeName, String configName) {
        JsonElement channel = this.getChannel(runtimeName, configName);
        return channel.getAsJsonObject().get("type").getAsString();
    }

    public String getChannelHost(String runtimeName, String configName) {
        JsonElement channel = this.getChannel(runtimeName, configName);
        return channel.getAsJsonObject().get("host").getAsString();
    }

    public int getChannelPort(String runtimeName, String configName) {
        JsonElement channel = this.getChannel(runtimeName, configName);
        return channel.getAsJsonObject().get("port").getAsInt();
    }
}

