/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.interpreter;

import com.javonet.core.handler.Handler;
import com.javonet.core.protocol.CommandDeserializer;
import com.javonet.core.protocol.CommandSerializer;
import com.javonet.core.receiver.Receiver;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;

public class Interpreter {
    private final Handler handler = new Handler();

    public Command execute(Command command, ConnectionType connectionType, TcpConnectionData tcpConnectionData) {
        CommandSerializer commandSerializer = new CommandSerializer();
        byte[] messageByteArray = commandSerializer.serialize(command, connectionType, tcpConnectionData);
        byte[] response = new byte[]{};
        response = command.getRuntimeName() == RuntimeName.Jvm && connectionType == ConnectionType.IN_MEMORY ? new Receiver().sendCommand(messageByteArray) : Transmitter.sendCommand(messageByteArray);
        return new CommandDeserializer(response).deserialize();
    }

    public Command process(byte[] byteArray) {
        Command receivedCommand = new CommandDeserializer(byteArray).deserialize();
        return this.handler.handleCommand(receivedCommand);
    }
}

