/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.handler.Handler;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.sdk.internal.AbstractModuleContext;
import com.javonet.sdk.internal.AbstractRuntimeContext;
import com.javonet.sdk.internal.AbstractTypeContext;
import com.javonet.sdk.internal.InvocationContext;
import com.javonet.utils.BinariesUnloader;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import java.util.HashMap;
import java.util.Optional;

public class RuntimeContext
implements AbstractTypeContext,
AbstractModuleContext,
AbstractRuntimeContext {
    private final RuntimeName runtimeName;
    private final ConnectionType connectionType;
    private final Optional<TcpConnectionData> tcpAddress;
    private Command currentCommand;
    private Command responseCommand;
    private final Handler handler = new Handler();
    private final Interpreter interpreter = new Interpreter();
    private static final HashMap<RuntimeName, RuntimeContext> memoryRuntimeContexts = new HashMap();
    private static final HashMap<TcpConnectionData, RuntimeContext> networkRuntimeContexts = new HashMap();
    private final GeneratorHandler generatorHandler = new GeneratorHandler();

    public static RuntimeContext getInstance(RuntimeName runtimeName, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        if (ConnectionType.TCP.equals((Object)connectionType) && tcpAddress.isPresent()) {
            if (networkRuntimeContexts.containsKey(tcpAddress.get())) {
                RuntimeContext runtimeCtx = networkRuntimeContexts.get(tcpAddress.get());
                runtimeCtx.currentCommand = null;
                return runtimeCtx;
            }
            RuntimeContext currentContext = new RuntimeContext(runtimeName, connectionType, tcpAddress);
            networkRuntimeContexts.put(tcpAddress.get(), currentContext);
            return currentContext;
        }
        if (memoryRuntimeContexts.containsKey((Object)runtimeName)) {
            RuntimeContext runtimeCtx = memoryRuntimeContexts.get((Object)runtimeName);
            runtimeCtx.currentCommand = null;
            return runtimeCtx;
        }
        RuntimeContext currentContext = new RuntimeContext(runtimeName, connectionType, tcpAddress);
        memoryRuntimeContexts.put(runtimeName, currentContext);
        return currentContext;
    }

    private RuntimeContext(RuntimeName runtimeName, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.runtimeName = runtimeName;
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
        if (RuntimeName.Jvm != runtimeName) {
            BinariesUnloader.extractBinariesFromJar(runtimeName);
        }
    }

    @Override
    public void execute() {
        this.responseCommand = this.interpreter.execute(this.currentCommand, this.connectionType, this.tcpAddress);
        this.currentCommand = null;
        if (this.responseCommand.getCommandType() == CommandType.EXCEPTION) {
            ExceptionThrower.throwException(this.responseCommand);
        }
    }

    @Override
    public RuntimeContext loadLibrary(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.LOAD_LIBRARY, args);
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
        return this;
    }

    @Override
    public InvocationContext getType(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_TYPE, args);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    public InvocationContext cast(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.CAST, args);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    public InvocationContext invokeGlobalMethod(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GLOBAL_METHOD, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    public RuntimeContext generateLibrary(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.GENERATE_LIB, args);
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
        this.generatorHandler.generate(this.responseCommand, System.getProperty("user.dir"));
        return this;
    }

    private Command buildCommand(Command command) {
        for (int i = 0; i < command.getPayload().length; ++i) {
            command.setPayload(this.encapsulatePayloadItem(command.getPayload()[i]), i);
        }
        return command.prependArgumentToPayload(this.currentCommand);
    }

    private Command encapsulatePayloadItem(Object payloadItem) {
        if (payloadItem instanceof Command) {
            for (int i = 0; i < ((Command)payloadItem).getPayload().length; ++i) {
                ((Command)payloadItem).setPayload(this.encapsulatePayloadItem(((Command)payloadItem).getPayload()[i]), i);
            }
            return (Command)payloadItem;
        }
        if (payloadItem instanceof InvocationContext) {
            return ((InvocationContext)payloadItem).getCurrentCommand();
        }
        if (payloadItem.getClass().isArray()) {
            Object[] objectArray = new Object[((Object[])payloadItem).length];
            for (int i = 0; i < ((Object[])payloadItem).length; ++i) {
                objectArray[i] = this.encapsulatePayloadItem(((Object[])payloadItem)[i]);
            }
            return new Command(this.runtimeName, CommandType.ARRAY, objectArray);
        }
        return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
    }
}

