/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeEncoder;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;

public class CommandEncoder {
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private Deque<Command> deque = new ArrayDeque<Command>();

    public byte[] encode(Command root, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.byteBuffer = ByteBuffer.allocate(0);
        this.deque.push(root);
        this.insertIntoBuffer(new byte[]{(byte)root.getRuntimeName().ordinal(), 0});
        this.serializeTcp(connectionType, tcpAddress);
        this.insertIntoBuffer(new byte[]{(byte)RuntimeName.Jvm.ordinal(), (byte)root.getCommandType().ordinal()});
        return this.encodeRecursively(this.deque);
    }

    private void serializeTcp(ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        if (ConnectionType.TCP.equals((Object)connectionType) && tcpAddress.isPresent()) {
            String[] ipAddress = tcpAddress.get().getHostname().split("\\.");
            int port = tcpAddress.get().getPort();
            this.insertIntoBuffer(new byte[]{(byte)connectionType.ordinal()});
            for (String address : ipAddress) {
                this.insertIntoBuffer(new byte[]{(byte)Integer.parseInt(address)});
            }
            this.insertIntoBuffer(new byte[]{(byte)port, (byte)(port >>> 8 & 0xFF)});
        } else {
            this.insertIntoBuffer(new byte[]{(byte)connectionType.ordinal()});
            this.insertIntoBuffer(new byte[]{0, 0, 0, 0, 0, 0});
        }
    }

    private byte[] encodeRecursively(Deque<Command> deque) {
        if (deque.isEmpty()) {
            return this.byteBuffer.array();
        }
        Command cmd = deque.pop();
        deque.push(cmd.dropFirstPayloadArg());
        if (cmd.getPayload().length > 0 && cmd.getPayload()[0] != null) {
            Class<?> targetClass = cmd.getPayload()[0].getClass();
            if (targetClass == Command.class) {
                Command innerCommand = (Command)cmd.getPayload()[0];
                this.insertIntoBuffer(TypeEncoder.encodeCommand(innerCommand));
                deque.push(innerCommand);
            } else if (targetClass.isArray()) {
                for (int i = 0; i < ((Object[])cmd.getPayload()[0]).length; ++i) {
                    byte[] result = TypeEncoder.encodePrimitive(((Object[])cmd.getPayload()[0])[i]);
                    this.insertIntoBuffer(result);
                }
            } else {
                byte[] result = TypeEncoder.encodePrimitive(cmd.getPayload()[0]);
                this.insertIntoBuffer(result);
            }
        } else {
            deque.pop();
        }
        return this.encodeRecursively(deque);
    }

    private void insertIntoBuffer(byte[] arg) {
        ByteBuffer newByteBuffer = ByteBuffer.allocate(arg.length + this.byteBuffer.limit());
        newByteBuffer.put(this.byteBuffer.array());
        newByteBuffer.put(arg);
        this.byteBuffer = newByteBuffer;
    }
}

