package Test::WSSE;
use strict;
use warnings;
use base 'CGI::Application';
use CGI::Application::Plugin::LogDispatch;
use CGI::Application::Plugin::WSSE;

sub setup {
    my ($self) = @_;

    $self->run_modes([ 'default' ]);
    $self->error_mode('error');
    $self->start_mode('default');

    my $q = $self->query;

    if ( defined $q->param('noconfig') ) {
        return;
    }    

    if ( defined $q->param('nolog') ) {
        $self->wsse_config(
            callback => \&getpassword,
        );
        return;
    }

    $self->log_config(
        LOG_DISPATCH_MODULES => [
            {
                module      => 'Log::Dispatch::File',
                name        => 'test',
                filename    => 'log',
                min_level   => 'debug',
            },
        ],
        APPEND_NEWLINE       => 1,
        #LOG_METHOD_EXECUTION => [qw(__PACKAGE__ CGI::Application CGI)],
    );
    $self->wsse_config(
        callback => \&getpassword,
        log      => $self->log,
    );
    return;
}

sub getpassword {
    my ($self, $user) = @_;

    if ( defined $self->query->param('boguspassword') ) {
        return;
    }

    return reverse $user;
}

sub default {
    my ($self) = @_;

    if ( !$self->wsse_authenticate() ) {
            return q{};
    }

    $self->header_add(-X_Hello => 'CGIApp auth succeeded');
    my $q = $self->query;
    return $q->start_html('CGIApp auth succeeded'),
       $q->end_html;
}

sub error {
    my ($self, $msg) = @_;
    
    my $q = $self->query;

    return $q->start_html($msg) .
    $q->end_html;
}

1;
