use strict;
use warnings;
use Test::More;
use ReadLine;

open my $fh, ">", "/dev/null" or die "Can't open /dev/null: $!\n";
ReadLine::outstream($fh);

my ($input, $output);
ReadLine::getc_function(sub {
    my $c = substr($input, 0, 1);
    $input = substr($input, 1);
    return ord($c);
});

$input = "Hello\n";
$output = ReadLine::readline("prompt: ");
ok $output eq "Hello", "readline works";

ReadLine::add_history($output);
my $string = ReadLine::history_get(ReadLine::history_base());
ok $string eq "Hello", "add_history works";

done_testing();

