## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Grc 0.102;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Grc::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Grc> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/tex/hyph-grc.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% ****************************************************************
%
% File name: hyph-grc.tex
%
% Created:       June 6, 2008
% Last modified: Sept. 12, 2011
%
% Unicode hyphenation patterns for Ancient Greek.
%
% Author:        Dimitrios Filippou, (c) 2008-2011
% Licence:       LaTeX Project Public Licence
%
% This file was first created by mechanical translation from
% GRAhyph5.tex via "elhyph-utf8 -a -c" (version 0.1 by Peter
% Heslin -- p.j.heslin at durham dot ac dot uk). Some additions
% were also made by hand.
%
% Created by Dimitrios Filippou with some ideas borrowed from
% Yannis Haralambous, Kostis Dryllerakis and Claudio Beccari.
% Mojca Miklavec adapted it for the "hyph-utf8" package.
%
% These hyphenation patterns are explained in "ancient.pdf", which
% can be found in the "elhyphen" or "hyphenation-greek" package.
% Hyphenation examples are given in the file "anc-test.pdf", also
% to be found in the "elhyphen" or "hyphenation-greek" package.
% Questionable patterns are marked by three question marks "???".
%
% Documentation in English can be found in: D. Filippou,
% "Hyphenation patterns for Ancient and Modern Greek," in
% "TeX, XML, and Digital Typography" (A. Syropoulos et al.,
% eds.), Lecture Notes in Computer Science 3130, Springer-Verlag
% Berlin-Heidelberg, 2004. ISBN 3-540-22801-2.
%
% Thanks to Thomas Schmitz (thomas.schmitz at uni-bonn dot de)
% for pointing out a few mistakes. (Marked by %%%TS%%%)
%
% ****************************************************************
%
% \message{UTF-8 hyphenation patterns for Ancient Greek}
%
\patterns{%
%%%% vowels
%-- Vowel patterns (pre-combined)
α1 ε1 η1 ι1 ο1 υ1 ω1 ϊ1 ϋ1 ἀ1 ἁ1 ἂ1 ἃ1 ἄ1 ἅ1 ἆ1 ἇ1 ἐ1 ἑ1 ἒ1 ἓ1 ἔ1 ἕ1 ἠ1 ἡ1 ἢ1 ἣ1 ἤ1 ἥ1 ἦ1 ἧ1 ἰ1 ἱ1 ἲ1 ἳ1 ἴ1 ἵ1 ἶ1 ἷ1 ὀ1 ὁ1 ὂ1 ὃ1 ὄ1 ὅ1 ὐ1 ὑ1 ὒ1 ὓ1 ὔ1 ὕ1 ὖ1 ὗ1 ὠ1 ὡ1 ὢ1 ὣ1 ὤ1 ὥ1 ὦ1 ὧ1 ὰ1 ὲ1 ὴ1 ὶ1 ὸ1 ὺ1 ὼ1 ᾀ1 ᾁ1 ᾂ1 ᾃ1 ᾄ1 ᾅ1 ᾆ1 ᾇ1 ᾐ1 ᾑ1 ᾒ1 ᾓ1 ᾔ1 ᾕ1 ᾖ1 ᾗ1 ᾠ1 ᾡ1 ᾢ1 ᾣ1 ᾤ1 ᾥ1 ᾦ1 ᾧ1 ᾲ1 ᾳ1 ᾴ1 ᾶ1 ᾷ1 ῂ1 ῃ1 ῄ1 ῆ1 ῇ1 ῒ1 ῖ1 ῗ1 ῢ1 ῦ1 ῧ1 ῲ1 ῳ1 ῴ1 ῶ1 ῷ1 ά1 έ1 ή1 ί1 ό1 ύ1 ώ1 ΐ1 ΰ1 ά1 έ1 ή1 ί1 ό1 ύ1 ώ1 ΐ1 ΰ1
%%%% diphthogs and exceptions
α2ι
α2ί α2ί
α2ὶ
α2ῖ
α2ἰ
α2ἴ
α2ἲ
α2ἶ
α2ἱ
α2ἵ
α2ἳ
α2ἷ
ά3ι ά3ι
ᾶ3ι
ἀ3ι
ἁ3ι
α2υ
α2ύ α2ύ
α2ὺ
α2ῦ
α2ὐ
α2ὔ
α2ὒ
α2ὖ
α2ὑ
α2ὕ
α2ὓ
α2ὗ
ά3υ ά3υ
ᾶ3υ
ἀ3υ
ἁ3υ
ε2ι
ε2ί ε2ί
ε2ὶ
ε2ῖ
ε2ἰ
ε2ἴ
ε2ἲ
ε2ἶ
ε2ἱ
ε2ἵ
ε2ἳ
ε2ἷ
έ3ι έ3ι
ἐ3ι
ἑ3ι
ε2υ
ε2ύ ε2ύ
ε2ὺ
ε2ῦ
ε2ὐ
ε2ὔ
ε2ὒ
ε2ὖ
ε2ὑ
ε2ὕ
ε2ὓ
ε2ὗ
έ3υ έ3υ
ἑ3υ
ἐ3υ
η2υ
η2ύ η2ύ
η2ὺ
η2ῦ
η2ὐ
η2ὔ
η2ὒ
η2ὖ
η2ὑ
η2ὕ
η2ὓ
η2ὗ
ή3υ ή3υ
ῆ3υ
ἠ3υ
ἡ3υ
ο2ι
ο2ί ο2ί
ο2ὶ
ο2ῖ
ο2ἰ
ο2ἴ
ο2ἲ
ο2ἶ
ο2ἱ
ο2ἵ
ο2ἳ
ο2ἷ
ό3ι ό3ι
ὀ3ι
ὁ3ι
ο2υ
ο2ύ ο2ύ
ο2ὺ
ο2ῦ
ο2ὐ
ο2ὔ
ο2ὒ
ο2ὖ
ο2ὑ
ο2ὕ
ο2ὓ
ο2ὗ
ό3υ ό3υ
ὀ3υ
ὁ3υ
υ2ι
υ2ί υ2ί
υ2ὶ
υ2ῖ
υ2ἰ
υ2ἴ
υ2ἲ
υ2ἶ
υ2ἱ
υ2ἵ
υ2ἳ
υ2ἷ
ύ3ι ύ3ι
ῦ3ι
ὐ3ι
ὑ3ι
ου3ι
όυ4ι όυ4ι
ὀυ4ι
ὁυ4ι
ο3υί ο3υί
ο3υῖ
%%%% consonants at the end of words
4β.
4γ.
4δ.
4ζ.
4θ.
4κ.
4λ.
4μ.
4ν.
4ξ.
4π.
4ρ.
4σ. 4ϲ.
4ς.
4τ.
4φ.
4χ.
4ψ.
%%%% consonants with right apostrophe
4' 4ʼ 4᾿
4β' 4βʼ 4β᾿
4γ' 4γʼ 4γ᾿
4δ' 4δʼ 4δ᾿
4ζ' 4ζʼ 4ζ᾿
4θ' 4θʼ 4θ᾿
4κ' 4κʼ 4κ᾿
4λ' 4λʼ 4λ᾿
4μ' 4μʼ 4μ᾿
4ν' 4νʼ 4ν᾿
4ξ' 4ξʼ 4ξ᾿
4π' 4πʼ 4π᾿
4ρ' 4ρʼ 4ρ᾿
4σ' 4σʼ 4σ᾿ 4ϲ' 4ϲʼ 4ϲ᾿
4τ' 4τʼ 4τ᾿
4φ' 4φʼ 4φ᾿
4χ' 4χʼ 4χ᾿
4ψ' 4ψʼ 4ψ᾿
%%%% consonants at the beggining of words
.β4
.γ4
.δ4
.ζ4
.θ4
.κ4
.λ4
.μ4
.ν4
.ξ4
.π4
.ρ4
.σ4 .ϲ4
.τ4
.φ4
.χ4
.ψ4
%%%% double consonants
2β1β
2γ1γ
2δ1δ
2ζ1ζ
2θ1θ
2κ1κ
2λ1λ
2μ1μ
2ν1ν
2π1π
2ρ1ρ
2ῤ1ῥ   %%%TS%%%
2σ1σ 2ϲ1ϲ
2τ1τ
2φ1φ
2χ1χ
2ψ1ψ
%%%% other divisable consonant combinations
2β1γ
2β1ζ
2β1θ
2β1κ
2β1ξ
2β1π
2β1σ 2β1ϲ
2β1τ
2β1φ
2β1χ
2β1ψ
%
2γ1β
2γ1ζ
2γ1θ
2γ1κ
2γ1ξ
2γ1π
2γ1σ 2γ1ϲ
2γ1τ
2γ1φ
2γ1χ
2γ1ψ
%
2δ1β
2δ1γ
2δ1ζ
2δ1θ
2δ1κ
2δ1λ
2δ1ξ
2δ1π
2δ1σ 2δ1ϲ
2δ1τ
2δ1φ
2δ1χ
2δ1ψ
%
2ζ1β   % Liddell-Scott lexicon: Zbelgo~urdoc ???
2ζ1γ
2ζ1δ
2ζ1θ
2ζ1κ
2ζ1λ
2ζ1μ
2ζ1ν
2ζ1ξ
2ζ1π
2ζ1ρ
2ζ1σ 2ζ1ϲ
2ζ1τ
2ζ1φ
2ζ1χ
2ζ1ψ
%
2θ1β
2θ1γ
2θ1δ
2θ1ζ
2θ1κ
2θ1ξ
2θ1π
2θ1σ 2θ1ϲ
2θ1τ
2θ1φ
2θ1χ
2θ1ψ
%
2κ1β
2κ1γ
2κ1δ
2κ1ζ
2κ1θ
2κ1ξ
2κ1π
2κ1σ 2κ1ϲ
2κ1φ
2κ1χ
2κ1ψ
%
2λ1β
2λ1γ
2λ1δ
2λ1ζ
2λ1θ
2λ1κ
2λ1μ
2λ1ν
2λ1ξ
2λ1π
2λ1ρ
2λ1σ 2λ1ϲ
2λ1τ
2λ1φ
2λ1χ
2λ1ψ
%
2μ1β
2μ1γ
2μ1δ
2μ1ζ
2μ1θ
2μ1κ
2μ1λ
2μ1ξ
2μ1π
2μ1ρ
2μ1σ 2μ1ϲ
2μ1τ
2μ1φ
2μ1χ
2μ1ψ
%
2ν1β
2ν1γ
2ν1δ
2ν1ζ
2ν1θ
2ν1κ
2ν1λ
2ν1μ
2ν1ξ
2ν1π
2ν1ρ
2ν1σ 2ν1ϲ
2νς. 2νϲ.
2ν1τ
2ν1φ
2ν1χ
2ν1ψ
%
2ξ1β
2ξ1γ
2ξ1δ
2ξ1ζ
2ξ1θ
2ξ1κ
2ξ1λ
2ξ1μ
2ξ1ν
2ξ1π
2ξ1ρ
2ξ1σ 2ξ1ϲ
2ξ1τ
2ξ1φ
2ξ1χ
2ξ1ψ
%
2π1β
2π1γ
2π1δ
2π1ζ
2π1θ
2π1κ
2π1ξ
2π1σ 2π1ϲ
2π1φ
2π1χ
2π1ψ
%
2ρ1β
2ρ1γ
2ρ1δ
2ρ1ζ
2ρ1θ
2ρ1κ
2ρ1λ
2ρ1μ
2ρ1ν
2ρ1ξ
2ρ1π
2ρ1σ 2ρ1ϲ
2ρ1τ
2ρ1φ
2ρ1χ
2ρ1ψ
%
% 2s1g % Liddell-Scott lexicon: sg'alh = sk'ala
2σ1δ 2ϲ1δ   % Liddell-Scott lexicon: sde'ugla = ze'ugla, sd = z ???
2σ1ζ 2ϲ1ζ
2σ1λ 2ϲ1λ
2σ1ν 2ϲ1ν
2σ1ξ 2ϲ1ξ
2σ1ρ 2ϲ1ρ
2σ1ψ 2ϲ1ψ
%
2τ1β
2τ1γ
2τ1δ
2τ1ζ
2τ1θ
2τ1κ
2τ1ξ
2τ1π
2τ1σ 2τ1ϲ
2τ1φ
2τ1χ
2τ1ψ
%
2φ1β
2φ1γ
2φ1δ
2φ1ζ
2φ1κ
2φ1ξ
2φ1π
2φ1σ 2φ1ϲ
2φ1τ
2φ1χ
2φ1ψ
%
2χ1β
2χ1γ
2χ1δ
2χ1ζ
2χ1κ
2χ1ξ
2χ1π
2χ1σ 2χ1ϲ
2χ1τ
2χ1φ
2χ1ψ
%
2ψ1β
2ψ1γ
2ψ1δ
2ψ1ζ
2ψ1θ
2ψ1κ
2ψ1λ
2ψ1μ
2ψ1ν
2ψ1ξ
2ψ1π
2ψ1ρ
2ψ1σ 2ψ1ϲ
2ψ1τ
2ψ1φ
2ψ1χ
%%%% troublesome double-consonant-apostrophe endings (mostly in poetry)
4βδ' 4βδ’ 4βδʼ 4βδ᾽ 4βδ᾿
4βλ' 4βλ’ 4βλʼ 4βλ᾽ 4βλ᾿
4βμ' 4βμ’ 4βμʼ 4βμ᾽ 4βμ᾿
4βν' 4βν’ 4βνʼ 4βν᾽ 4βν᾿
4βρ' 4βρ’ 4βρʼ 4βρ᾽ 4βρ᾿
%
4γδ' 4γδ’ 4γδʼ 4γδ᾽ 4γδ᾿
4γλ' 4γλ’ 4γλʼ 4γλ᾽ 4γλ᾿
4γμ' 4γμ’ 4γμʼ 4γμ᾽ 4γμ᾿
4γν' 4γν’ 4γνʼ 4γν᾽ 4γν᾿
4γρ' 4γρ’ 4γρʼ 4γρ᾽ 4γρ᾿
%
4δμ' 4δμ’ 4δμʼ 4δμ᾽ 4δμ᾿
4δν' 4δν’ 4δνʼ 4δν᾽ 4δν᾿
4δρ' 4δρ’ 4δρʼ 4δρ᾽ 4δρ᾿
%
4ζβ' 4ζβ’ 4ζβʼ 4ζβ᾽ 4ζβ᾿
%
4θλ' 4θλ’ 4θλʼ 4θλ᾽ 4θλ᾿
4λμ' 4λμ’ 4λμʼ 4λμ᾽ 4λμ᾿
4θν' 4θν’ 4θνʼ 4θν᾽ 4θν᾿
4θρ' 4θρ’ 4θρʼ 4θρ᾽ 4θρ᾿
%
4κλ' 4κλ’ 4κλʼ 4κλ᾽ 4κλ᾿
4κμ' 4κμ’ 4κμʼ 4κμ᾽ 4κμ᾿
4κν' 4κν’ 4κνʼ 4κν᾽ 4κν᾿
4κρ' 4κρ’ 4κρʼ 4κρ᾽ 4κρ᾿
4κτ' 4κτ’ 4κτʼ 4κτ᾽ 4κτ᾿
%
4μν' 4μν’ 4μνʼ 4μν᾽ 4μν᾿
%
4πλ' 4πλ’ 4πλʼ 4πλ᾽ 4πλ᾿
4πμ' 4πμ’ 4πμʼ 4πμ᾽ 4πμ᾿
4πν' 4πν’ 4πνʼ 4πν᾽ 4πν᾿
4πρ' 4πρ’ 4πρʼ 4πρ᾽ 4πρ᾿
4πτ' 4πτ’ 4πτʼ 4πτ᾽ 4πτ᾿
%
4σβ' 4σβ’ 4σβʼ 4σβ᾽ 4σβ᾿ 4ϲβ' 4ϲβ’ 4ϲβʼ 4ϲβ᾽ 4ϲβ᾿
4σγ' 4σγ’ 4σγʼ 4σγ᾽ 4σγ᾿ 4ϲγ' 4ϲγ’ 4ϲγʼ 4ϲγ᾽ 4ϲγ᾿
4σδ' 4σδ’ 4σδʼ 4σδ᾽ 4σδ᾿ 4ϲδ' 4ϲδ’ 4ϲδʼ 4ϲδ᾽ 4ϲδ᾿
4σθ' 4σθ’ 4σθʼ 4σθ᾽ 4σθ᾿ 4ϲθ' 4ϲθ’ 4ϲθʼ 4ϲθ᾽ 4ϲθ᾿
4σκ' 4σκ’ 4σκʼ 4σκ᾽ 4σκ᾿ 4ϲκ' 4ϲκ’ 4ϲκʼ 4ϲκ᾽ 4ϲκ᾿
4σμ' 4σμ’ 4σμʼ 4σμ᾽ 4σμ᾿ 4ϲμ' 4ϲμ’ 4ϲμʼ 4ϲμ᾽ 4ϲμ᾿
4σπ' 4σπ’ 4σπʼ 4σπ᾽ 4σπ᾿ 4ϲπ' 4ϲπ’ 4ϲπʼ 4ϲπ᾽ 4ϲπ᾿
4στ' 4στ’ 4στʼ 4στ᾽ 4στ᾿ 4ϲτ' 4ϲτ’ 4ϲτʼ 4ϲτ᾽ 4ϲτ᾿
4σφ' 4σφ’ 4σφʼ 4σφ᾽ 4σφ᾿ 4ϲφ' 4ϲφ’ 4ϲφʼ 4ϲφ᾽ 4ϲφ᾿
4σχ' 4σχ’ 4σχʼ 4σχ᾽ 4σχ᾿ 4ϲχ' 4ϲχ’ 4ϲχʼ 4ϲχ᾽ 4ϲχ᾿
%
4φθ' 4φθ’ 4φθʼ 4φθ᾽ 4φθ᾿
4φλ' 4φλ’ 4φλʼ 4φλ᾽ 4φλ᾿
4φμ' 4φμ’ 4φμʼ 4φμ᾽ 4φμ᾿
4φν' 4φν’ 4φνʼ 4φν᾽ 4φν᾿
4φρ' 4φρ’ 4φρʼ 4φρ᾽ 4φρ᾿
%
4χθ' 4χθ’ 4χθʼ 4χθ᾽ 4χθ᾿
4χλ' 4χλ’ 4χλʼ 4χλ᾽ 4χλ᾿
4χμ' 4χμ’ 4χμʼ 4χμ᾽ 4χμ᾿
4χν' 4χν’ 4χνʼ 4χν᾽ 4χν᾿
4χρ' 4χρ’ 4χρʼ 4χρ᾽ 4χρ᾿
%%%% compound words / hyphenated according to DF
%%%%
%%%% check for ??? for problematic words!
%
ἀγω2ν1άρ ἀγω2ν1άρ   % >agwn-'arqhc
ἀγω2ν1αρ
ἀδιέ2ξ1 ἀδιέ2ξ1   % >adi'ex-odoc
ἀδιε2ξ1
ἀδυ2σ1ώ ἀδυ2σ1ώ ἀδυ2ϲ1ώ ἀδυ2ϲ1ώ   % >adus-'wphtoc
ἀδυ2σ1ω ἀδυ2ϲ1ω
ἁλό2σ1 ἁλό2σ1 ἁλό2ϲ1 ἁλό2ϲ1   % <al'os-anjoc
ἁλο2σ1 ἁλο2ϲ1
ἀμπαλί2ν1 ἀμπαλί2ν1   % >ampal'in-orroc
ἀμπαλι2ν1
ἀμφί2σ1β ἀμφί2σ1β ἀμφί2ϲ1β ἀμφί2ϲ1β   % >amf'is-baina
ἀμφι2σ1β ἀμφι2ϲ1β
% >hmfe2s1b 		% (>a'or. to~u >amfisbht~w) ???
% >hmfi2s1b
ἀμφί2σ1ω ἀμφί2σ1ω ἀμφί2ϲ1ω ἀμφί2ϲ1ω   % >amf'is-wpoc
ἀμφι2σ1ώ ἀμφι2σ1ώ ἀμφι2ϲ1ώ ἀμφι2ϲ1ώ
ἀ2ν1αγής. ἀ2ν1αγής. ἀ2ν1αγήϲ. ἀ2ν1αγήϲ.   % >an-ag'hc
ἀ2ν1αγὴς. ἀ2ν1αγὴϲ.
ἀ2ν1αγήσ. ἀ2ν1αγήσ.
ἀ2ν1αγὴσ.
ἀ2ν1αγο
ἀ2ν1αγεῖ.
ἀ2ν1αγῆ.
ἀ2ν1αγές. ἀ2ν1αγές. ἀ2ν1αγέϲ. ἀ2ν1αγέϲ.
ἀ2ν1αγὲς. ἀ2ν1αγὲϲ.
ἀ2ν1αγέσ. ἀ2ν1αγέσ.
ἀ2ν1αγὲσ.
ἀ2ν1αγεῖς. ἀ2ν1αγεῖϲ.
ἀ2ν1αγεῖσ.
ἀ2ν1αγῶν.
ἀ2ν1αγέσι ἀ2ν1αγέσι ἀ2ν1αγέϲι ἀ2ν1αγέϲι
ἀ2ν1αγῆ
ἀ2ν1άγκυ ἀ2ν1άγκυ   % >an-'agkuloc
ἀ2ν1αγκύ ἀ2ν1αγκύ
ἄ2ν1αγν   % >'anagnoc
ἀ2ν1άγν ἀ2ν1άγν
ἀ2ν1αγν   % >an-agne'ia
ἀ3ν2αγνά ἀ3ν2αγνά   % >ana-gn'amptw
ἀ3ν2αγνω   % >ana-gnwr'izw
ἀ3ν2άγνω ἀ3ν2άγνω   % >an'a-gnwsic
ἀ3ν2αγνώ ἀ3ν2αγνώ
ἀ2ν1αγρί ἀ2ν1αγρί   % >an-agr'ia
ἀ2ν1αγρῖ   % >an-agr~iai
ἀ2ν1αγρι   % >an-agri~wn
ἀ2ν1άγωγ ἀ2ν1άγωγ   % >an-'agwgoc
ἀ2ν1αγώγ ἀ2ν1αγώγ
ἀ3ν2αγώγι ἀ3ν2αγώγι   % >ana-g'wgioc
ἀ3ν2αγωγί ἀ3ν2αγωγί
ἀ4ν3αγωγία ἀ4ν3αγωγία   % >an-agwg'ia
ἀ2ν1άδελ ἀ2ν1άδελ   % >an-'adelfoc
ἀ2ν1αδέλ ἀ2ν1αδέλ
ἀ2ν1άελπ ἀ2ν1άελπ   % >an-'aelptoc
ἀ2ν1αέλπ ἀ2ν1αέλπ
ἄ2ν1αθλ   % >'an-ajloc
ἀ2ν1άθλ ἀ2ν1άθλ
ἀ2ν1αίδ ἀ2ν1αίδ   % >an-a'ideia
ἀ2ν1αιδ   % >an-aid'hc
ἄ2ν1αιμ   % >'an-aimoc
ἀ2ν1αίμ ἀ2ν1αίμ
ἀ2ν1αιμ   % >an-aim'ia
ἀ2ν1αίσθ ἀ2ν1αίσθ ἀ2ν1αίϲθ ἀ2ν1αίϲθ   % >an-a'isjhtoc
ἀ2ν1αισθ ἀ2ν1αιϲθ
ἀ2ν1αισι ἀ2ν1αιϲι   % >an-aisim'ow
ἀ2ν1αισί ἀ2ν1αισί ἀ2ν1αιϲί ἀ2ν1αιϲί
ἀ2ν1αίσχ ἀ2ν1αίσχ ἀ2ν1αίϲχ ἀ2ν1αίϲχ   % >an-a'isquntoc
ἀ2ν1αισχ ἀ2ν1αιϲχ
ἀ2ν1αίτ ἀ2ν1αίτ   % >an-a'itioc
ἀ2ν1αιτ
ἀ2ν1άκαν ἀ2ν1άκαν   % >an-'akanjoc
ἀ2ν1ακάν ἀ2ν1ακάν
ἀ2ν1ακόλο ἀ2ν1ακόλο   % >an-ak'oloujoc
ἀ2ν1ακολο
ἀ2ν1αλγ   % >an-alg'hc
ἀ2ν1αλδ   % >an-ald'hc
ἀ3ν2αλδα   % >anal-da'inw
ἀ3ν2αλδήσκ ἀ3ν2αλδήσκ ἀ3ν2αλδήϲκ ἀ3ν2αλδήϲκ   % >anal-d'hskw
ἀ2ν1άλειπ ἀ2ν1άλειπ   % >an-'aleiptoc
ἀ2ν1αλείπ ἀ2ν1αλείπ
ἀ2ν1αλειφ   % >an-aleif'ih
ἀ2ν1άλειφ ἀ2ν1άλειφ   % >an-'aleifoc
ἀ2ν1αλείφ ἀ2ν1αλείφ
ἀ2ν1αλήθ ἀ2ν1αλήθ   % >an-al'hjhc
ἀ2ν1αληθ
ἀ2ν1άλθ ἀ2ν1άλθ   % >an-'aljhtoc
ἀ2ν1αλθ
ἀ2ν1άλιπ ἀ2ν1άλιπ   % >an-'alipoc
ἀ2ν1αλίπ ἀ2ν1αλίπ
ἀ2ν1άλιστ ἀ2ν1άλιστ ἀ2ν1άλιϲτ ἀ2ν1άλιϲτ   % >an-'alistoc
ἀ2ν1αλίστ ἀ2ν1αλίστ ἀ2ν1αλίϲτ ἀ2ν1αλίϲτ
ἀ2ν1αλκ   % >an-alk'hc
ἄ2ν1αλκ   % >an-'alkic
ἀ2ν1άλκ ἀ2ν1άλκ
ἀ2ν1άλλ ἀ2ν1άλλ   % >an-'allaktoc
ἀ2ν1αλλ
ἀ3ν2άλλο ἀ3ν2άλλο   % an'al-lomai
ἀ3ν2άλλε ἀ3ν2άλλε
ἄ2ν1αλμ   % >'an-almoc
ἀ2ν1άλμ ἀ2ν1άλμ   % >an-'almuroc
ἀ2ν1αλμ
ἄ2ν1αλο   % >'an-aloc
ἀ2ν1άλου ἀ2ν1άλου
ἀ2ν1άλῳ. ἀ2ν1άλῳ.
ἄ2ν1αλε.
ἀ2ν1άλοι ἀ2ν1άλοι
ἀ2ν1άλων. ἀ2ν1άλων.
ἄ2ν1αλτ   % >'an-altoc
ἀ2ν1άλτ ἀ2ν1άλτ
ἀ2ν1αμάξ ἀ2ν1αμάξ   % >an-am'axeutoc
ἀ2ν1αμαξ
ἀ2ν1αμάρτ ἀ2ν1αμάρτ   % >an-am'arthtoc
ἀ2ν1αμαρτ
ἀ2ν1αμέλγ ἀ2ν1αμέλγ   % >an-am'elghtoc
ἀ2ν1αμελγ
ἀ2ν1αμπ   % >an-amp'eqonoc
ἀ2ν1άμπ ἀ2ν1άμπ   % >an-'ampux
ἀ2ν1αμφ   % >an-amf'hristoc
ἀναμφι2σ1 ἀναμφι2ϲ1   % >an-amfis-b'hthtoc
ἀ2ν1ανάγκ ἀ2ν1ανάγκ   % >an-an'agkastoc
ἀ2ν1αναγκ
ἄ2ν1ανδ   % >'an-androc
ἀ2ν1άνδ ἀ2ν1άνδ
ἀ2ν1ανθ   % >an-anj'hc
ἀ3ν2ανθέ ἀ3ν2ανθέ   % >anan-j'ew
ἀ4ν3ανθές. ἀ4ν3ανθές. ἀ4ν3ανθέϲ. ἀ4ν3ανθέϲ.   % >an-anj'ec
ἀ4ν3ανθὲς. ἀ4ν3ανθὲϲ.
ἀ4ν3ανθέσ. ἀ4ν3ανθέσ.
ἀ4ν3ανθὲσ.
ἀ4ν3ανθέσι ἀ4ν3ανθέσι ἀ4ν3ανθέϲι ἀ4ν3ανθέϲι
ἀ2ν1άνιο ἀ2ν1άνιο   % >an-'anioc
ἀ2ν1ανίο ἀ2ν1ανίο
ἀ2ν1ανίω ἀ2ν1ανίω
ἀ2ν1ανταγ   % >an-antag'wnistoc
ἀ2ν1ανταπ   % >an-antap'odotoc
ἀ2ν1αντί ἀ2ν1αντί   % >an-ant'ijetoc
ἀ2ν1αντι
ἀνα2ξ1αγ   % >Anax-ag'orac
ἀνά2ξ1αν ἀνά2ξ1αν   % >An'ax-androc
ἀνα2ξ1άν ἀνα2ξ1άν
ἀνα2ξ1αν   % >Anax-andr'idhc
ἀνά2ξ1αρ ἀνά2ξ1αρ   % >An'ax-arqoc
ἀνα2ξ1άρ ἀνα2ξ1άρ
ἀνά2ξ1ιπ ἀνά2ξ1ιπ   % >An'ax-ippoc
ἀνα2ξ1ίπ ἀνα2ξ1ίπ
ἀ2ν1αξιόλ ἀ2ν1αξιόλ   % >an-axi'ologoc
ἀ2ν1αξιολ
ἀ2ν1αξιόπ ἀ2ν1αξιόπ   % >an-axi'opistoc
ἀ2ν1αξιοπ
ἀ2ν1άξιο ἀ2ν1άξιο   % >an-'axioc
ἀ2ν1αξίο ἀ2ν1αξίο
ἀ2ν1αξίω ἀ2ν1αξίω
ἀ2ν1αξία ἀ2ν1αξία
ἀ2ν1αξῖα
ἀ2ν1απάλλα ἀ2ν1απάλλα   % >an-ap'allaktoc
ἀ2ν1απαλλά ἀ2ν1απαλλά
ἀ2ν1απάρτ ἀ2ν1απάρτ   % >an-ap'artistoc
ἀ2ν1απαρτ
ἀ2ν1απαύδ ἀ2ν1απαύδ   % >an-apa'udhtoc
ἀ2ν1απαυδ
ἀ2ν1απόβ ἀ2ν1απόβ   % >an-ap'oblhtoc
ἀ2ν1αποβ
ἀ2ν1απόγ ἀ2ν1απόγ   % >an-ap'ografoc
ἀ2ν1απογ
ἀ2ν1αποδή ἀ2ν1αποδή   % >an-apod'hmhtoc
ἀ2ν1αποδη
ἀ2ν1απόδο ἀ2ν1απόδο   % >an-ap'odotoc
ἀ2ν1αποδό ἀ2ν1αποδό
ἀ2ν1απόδρ ἀ2ν1απόδρ   % >an-ap'odrastoc
ἀ2ν1αποδρ
ἀ2ν1απόλαυ ἀ2ν1απόλαυ   % >an-ap'olaustoc
ἀ2ν1απολαύ ἀ2ν1απολαύ
ἀ2ν1απολό ἀ2ν1απολό   % >an-apol'oghtoc
ἀ2ν1απολο
ἀ2ν1απόλυ ἀ2ν1απόλυ   % >an-ap'olutoc
ἀ2ν1απολύ ἀ2ν1απολύ
ἀ2ν1απόν ἀ2ν1απόν   % >an-ap'oniptoc
ἀ2ν1απον
ἀ2ν1απόπ ἀ2ν1απόπ   % >an-ap'oplutoc
ἀ2ν1αποπ
ἀ2ν1απόσ ἀ2ν1απόσ ἀ2ν1απόϲ ἀ2ν1απόϲ   % >an-ap'ostratoc
ἀ2ν1αποσ ἀ2ν1αποϲ
ἀ2ν1απότε ἀ2ν1απότε   % >an-ap'oteuktoc
ἀ2ν1αποτε
ἀ2ν1απότμ ἀ2ν1απότμ   % >an-ap'otmhtoc
ἀ2ν1αποτμ
ἀ2ν1απότρ ἀ2ν1απότρ   % >an-ap'otriptoc
ἀ2ν1αποτρ
ἀ2ν1αρά ἀ2ν1αρά   % >an-ar'aomai
ἀ2ν1αρα
ἀ2ν1άρ ἀ2ν1άρ   % >an-'arbuloc
ἀ2ν1αρ
ἄ2ν1αρ   % >'an-arktoc
ἀ3ν2αρίτ ἀ3ν2αρίτ   % >ana-r'ithc
ἀ3ν2αρῖτ   % >ana-r~itai
ἀ3ν2αριτ   % >ana-rit~wn
ἀ3ν2αρπ   % >anar-p'azw
ἀ3ν2άρρ ἀ3ν2άρρ   % >an'ar-riyic
ἀ3ν2αρρ
ἀ4ν3αρραγ   % >an-arrag'hc
ἀ3ν2αρτ   % >anar-t'aw
ἀ3ν2αρύτ ἀ3ν2αρύτ   % >ana-r'utw
ἀ2ν1άσκη ἀ2ν1άσκη ἀ2ν1άϲκη ἀ2ν1άϲκη   % >an-'askhtoc
ἀ2ν1ασκή ἀ2ν1ασκή ἀ2ν1αϲκή ἀ2ν1αϲκή
ἄ2ν1ασπι ἄ2ν1αϲπι   % >'an-aspic
ἀ2ν1ασπί ἀ2ν1ασπί ἀ2ν1αϲπί ἀ2ν1αϲπί
ἀ2ν1άσσατ ἀ2ν1άσσατ ἀ2ν1άϲϲατ ἀ2ν1άϲϲατ   % >an-'assatoc
ἀ2ν1ασσάτ ἀ2ν1ασσάτ ἀ2ν1αϲϲάτ ἀ2ν1αϲϲάτ
ἀ2ν1άστει ἀ2ν1άστει ἀ2ν1άϲτει ἀ2ν1άϲτει   % >an-'asteioc
ἀ2ν1αστεί ἀ2ν1αστεί ἀ2ν1αϲτεί ἀ2ν1αϲτεί
ἀ3ν2αστείβ ἀ3ν2αστείβ ἀ3ν2αϲτείβ ἀ3ν2αϲτείβ   % >ana-ste'ibw
ἀ3ν2άστειρ ἀ3ν2άστειρ ἀ3ν2άϲτειρ ἀ3ν2άϲτειρ   % >an'a-steiroc
ἀ3ν2αστείρ ἀ3ν2αστείρ ἀ3ν2αϲτείρ ἀ3ν2αϲτείρ
ἀ3ν2άστειχ ἀ3ν2άστειχ ἀ3ν2άϲτειχ ἀ3ν2άϲτειχ   % >an'a-steiqoc
ἀ3ν2αστείχ ἀ3ν2αστείχ ἀ3ν2αϲτείχ ἀ3ν2αϲτείχ
ἀ2ν1ατεὶ.   % >an-ate'i
ἀ2ν1ατεί. ἀ2ν1ατεί.
ἀ2ν1ατὶ.   % >an-at'i
ἀ2ν1ατί. ἀ2ν1ατί.
ἄ2ν1ατος. ἄ2ν1ατοϲ.   % >'an-atoc
ἄ2ν1ατοσ.
ἀ2ν1άτου. ἀ2ν1άτου.
ἀ2ν1άτω ἀ2ν1άτω
ἄ2ν1ατον.
ἄ2ν1ατε
ἄ2ν1ατοι.
ἀ2ν1άτοις. ἀ2ν1άτοις. ἀ2ν1άτοιϲ. ἀ2ν1άτοιϲ.
ἀ2ν1άτοισ. ἀ2ν1άτοισ.
ἀ2ν1άττ ἀ2ν1άττ   % >an-'attikoc
ἀ2ν1αττ
ἀ2ν1αύγ ἀ2ν1αύγ   % >an-a'ughtoc
ἀ2ν1αυγ
ἀ2ν1αύδ ἀ2ν1αύδ   % >an-a'udhtoc
ἀ2ν1αυδ
ἀ3ν2αυδί ἀ3ν2αυδί   % >a-naud'ia
ἀ3ν2αυδι
ἄ2ν1αυδ   % >'an-audoc
ἄ2ν1αυλ   % >'an-auloc
ἀ2ν1αύλ ἀ2ν1αύλ
ἀ2ν1αύξ ἀ2ν1αύξ   % >an-a'uxhtoc
ἀ2ν1αυξ
ἀ2ν1αύχ ἀ2ν1αύχ   % >an-a'uqhn
ἀ2ν1αυχ
ἀ2ν1αφαίρ ἀ2ν1αφαίρ   % >an-afa'iretoc
ἀ2ν1αφαιρ
ἀ2ν1αφή ἀ2ν1αφή   % >an-af'hc
ἀ2ν1αφὴ
ἀ2ν1αφοῦ
ἀ2ν1αφῆ
ἀ2ν1αφεῖ
ἀ2ν1αφοῖ
ἀ2ν1εφῶν.
ἀ2ν1αφέ ἀ2ν1αφέ
ἀ2ν1αφὲ
ἀ3ν2αφῆν   % >ana-f~hnai
ἀ2ν1αφρόδ ἀ2ν1αφρόδ   % >an-afr'oditoc
ἀ2ν1αφροδ
ἄ2ν1αφρ   % >'an-afroc
ἀ2ν1άφρ ἀ2ν1άφρ
ἀ2ν1αχύρ ἀ2ν1αχύρ   % >an-aq'urwtoc
ἀ2ν1αχυρ
ἀνδρό2σ1α ἀνδρό2σ1α ἀνδρό2ϲ1α ἀνδρό2ϲ1α   % >andr'os-aimon
ἀνδρο2σ1α ἀνδρο2ϲ1α
ἀ2ν1έγγ ἀ2ν1έγγ   % >an-'eggraptoc
ἀ2ν1εγγ
ἀ2ν1έγερτ ἀ2ν1έγερτ   % >an-'egertoc
ἀ2ν1εγέρτ ἀ2ν1εγέρτ
ἀ2ν1εγκ   % >an-egk'efaloc
ἀ2ν1έγκ ἀ2ν1έγκ   % >an-'egklhtoc
ἀ2ν1εγχ   % >an-egqe'irhtoc
ἀ2ν1εδά ἀ2ν1εδά   % >an-ed'afistoc
ἀ2ν1εδα
ἀ2ν1έδεσ ἀ2ν1έδεσ ἀ2ν1έδεϲ ἀ2ν1έδεϲ   % >an-'edestoc
ἀ2ν1εδέσ ἀ2ν1εδέσ ἀ2ν1εδέϲ ἀ2ν1εδέϲ
ἀ2ν1έδρασ ἀ2ν1έδρασ ἀ2ν1έδραϲ ἀ2ν1έδραϲ   % >an-'edrastoc
ἀ2ν1εδράσ ἀ2ν1εδράσ ἀ2ν1εδράϲ ἀ2ν1εδράϲ
ἀ2ν1εέρ ἀ2ν1εέρ   % >an-e'ergw
ἀ2ν1εερ
ἀ2ν1εθέλ ἀ2ν1εθέλ   % >an-ej'elhtoc
ἀ2ν1εθελ
ἀ2ν1έθι ἀ2ν1έθι   % >an-'ejistoc
ἀ2ν1εθί ἀ2ν1εθί
ἀ2ν1είδε ἀ2ν1είδε   % >an-e'ideoc
ἀ2ν1ειδέ ἀ2ν1ειδέ
ἀ2ν1είδω ἀ2ν1είδω   % >an-e'idwloc
ἀ2ν1ειδώ ἀ2ν1ειδώ
ἀ2ν1είκα ἀ2ν1είκα   % >an-e'ikastoc
ἀ2ν1εικά ἀ2ν1εικά
ἀ2ν1εικό ἀ2ν1εικό   % >an-eik'onistoc
ἀ2ν1εικο
ἀ2ν1ειλεί ἀ2ν1ειλεί   % >an-eile'ijuia
ἀ2ν1ειλει
ἀ2ν1είμα ἀ2ν1είμα   % >an-e'imartai
ἀ2ν1εί2σ1ακ ἀ2ν1εί2σ1ακ ἀ2ν1εί2ϲ1ακ ἀ2ν1εί2ϲ1ακ   % >an-e'isaktoc
ἀ2ν1ει2σ1άκ ἀ2ν1ει2σ1άκ ἀ2ν1ει2ϲ1άκ ἀ2ν1ει2ϲ1άκ
ἀ2ν1εί2σ1ο ἀ2ν1εί2σ1ο ἀ2ν1εί2ϲ1ο ἀ2ν1εί2ϲ1ο   % >an-e'isodoc
ἀ2ν1ει2σ1ό ἀ2ν1ει2σ1ό ἀ2ν1ει2ϲ1ό ἀ2ν1ει2ϲ1ό
ἀ2ν1ει2σ1φορ ἀ2ν1ει2ϲ1φορ   % >an-eisfor'ia
ἀ2ν1εί2σ1φορ ἀ2ν1εί2σ1φορ ἀ2ν1εί2ϲ1φορ ἀ2ν1εί2ϲ1φορ   % >an-e'isforoc
ἀ2ν1ει2σ1φόρ ἀ2ν1ει2σ1φόρ ἀ2ν1ει2ϲ1φόρ ἀ2ν1ει2ϲ1φόρ
ἀ2ν1έκ ἀ2ν1έκ   % >an-'ekbatoc, k.a.<'o.
ἀ2ν1εκ
ἀ3ν2έκα ἀ3ν2έκα   % >an'e-kajen
ἀ3ν2εκάς. ἀ3ν2εκάς. ἀ3ν2εκάϲ. ἀ3ν2εκάϲ.   % >ane-k'ac
ἀ3ν2εκὰς. ἀ3ν2εκὰϲ.
ἀ3ν2εκάσ. ἀ3ν2εκάσ.
ἀ3ν2εκὰσ.
ἀ3ν2εκτ   % >ane-kt'oc
ἀ4ν3έ2κ1τιτ ἀ4ν3έ2κ1τιτ   % >an-'ek-titoc
ἀ4ν3ε2κ1τίτ ἀ4ν3ε2κ1τίτ
ἀνε2κ1λιπ   % >an-ek-lip'hc
ἀνε2κ1λό ἀνε2κ1λό   % >an-ek-l'ogistoc
ἀνε2κ1λο
ἀ2ν1έλαι ἀ2ν1έλαι   % >an-'elaioc
ἀ2ν1ελαι
ἀ2ν1ελάτ ἀ2ν1ελάτ   % >an-el'atwtoc
ἀ2ν1ελατ
ἀ2ν1έλεγκ ἀ2ν1έλεγκ   % >an-'elegktoc
ἀ2ν1ελέγκ ἀ2ν1ελέγκ
ἀ2ν1ελεγξ   % >an-elegx'ia
ἀ2ν1ελέη ἀ2ν1ελέη   % >an-el'ehtoc
ἀ2ν1ελεή ἀ2ν1ελεή
ἀ2ν1έλεο ἀ2ν1έλεο   % >an-'eleoc
ἀ2ν1ελέο ἀ2ν1ελέο
ἀ2ν1ελέω ἀ2ν1ελέω
ἀ2ν1έλεε ἀ2ν1έλεε
ἀ2ν1ελκή ἀ2ν1ελκή   % >an-elk'hc
ἀ2ν1ελκὴ
ἀ2ν1ελκο
ἀ2ν1ελκῆ
ἀ2ν1ελκές. ἀ2ν1ελκές. ἀ2ν1ελκέϲ. ἀ2ν1ελκέϲ.
ἀ2ν1ελκὲς. ἀ2ν1ελκὲϲ.
ἀ2ν1ελκέσ. ἀ2ν1ελκέσ.
ἀ2ν1ελκὲσ.
ἀ2ν1ελκε
ἀ2ν1ελκῶ
ἀ2ν1ελκέσ ἀ2ν1ελκέσ ἀ2ν1ελκέϲ ἀ2ν1ελκέϲ
ἄ2ν1ελκτ   % >'an-elktoc
ἀ2ν1έλκτ ἀ2ν1έλκτ
ἀ2ν1έλκω ἀ2ν1έλκω   % >an-'elkwtoc
ἀ2ν1ελκώ ἀ2ν1ελκώ
ἀ2ν1έλλ ἀ2ν1έλλ   % >an-'ellhn
ἀ2ν1έλπι ἀ2ν1έλπι   % >an-'elpistoc
ἀ2ν1ελπί ἀ2ν1ελπί
ἀ2ν1έλυτρ ἀ2ν1έλυτρ   % >an-'elutroc
ἀ2ν1ελύτρ ἀ2ν1ελύτρ
ἀ2ν1έμβ ἀ2ν1έμβ   % >an-'embatoc
ἀ2ν1εμβ
ἀ2ν1έμετ ἀ2ν1έμετ   % >an-'emetoc
ἀ2ν1εμέτ ἀ2ν1εμέτ
ἀ2ν1έμπ ἀ2ν1έμπ   % >an-'emplhktoc
ἀ2ν1εμπ
ἀ2ν1έμφ ἀ2ν1έμφ   % >an-'emfatoc
ἀ2ν1εμφ
ἀ2ν1έν ἀ2ν1έν   % >an-'endotoc
ἀ2ν1εν
ἀ3ν2ένει ἀ3ν2ένει   % >an'e-neika
ἀ3ν2ενή ἀ3ν2ενή   % >ane-n'hnwje
ἀ3ν2έντες. ἀ3ν2έντες. ἀ3ν2έντεϲ. ἀ3ν2έντεϲ.   % >an'en-tec
ἀ3ν2έντεσ. ἀ3ν2έντεσ.
ἀ2ν1ε2ξ1   % >an-ex-omol'oghtoc k.a.<'o.
ἀ3ν2ε3ξ2ίκα ἀ3ν2ε3ξ2ίκα   % >anex'i-kakoc
ἀ3ν2ε3ξ2ικά ἀ3ν2ε3ξ2ικά
ἀ2ν1έορ ἀ2ν1έορ   % >an-'eortoc
ἀ2ν1εόρ ἀ2ν1εόρ
ἀ2ν1επ   % >an-ep'aggeltoc, k.lp.
ἀ3ν2επν   % >ane-pne'usaton
ἀ3ν2επτ   % >ane-pt'amhn
ἀ2ν1εραστ ἀ2ν1εραϲτ   % >an-erast'ia
ἀ2ν1έραστ ἀ2ν1έραστ ἀ2ν1έραϲτ ἀ2ν1έραϲτ   % >an-'erastoc
ἀ2ν1εράστ ἀ2ν1εράστ ἀ2ν1εράϲτ ἀ2ν1εράϲτ
ἀ2ν1εργ   % >an-erg'hc
ἄ2ν1εργ   % >'an-ergoc
ἀ2ν1έργ ἀ2ν1έργ
ἀ2ν1έρεικ ἀ2ν1έρεικ   % >an-'ereiktoc
ἀ2ν1ερείκ ἀ2ν1ερείκ
ἀ2ν1έρεισ ἀ2ν1έρεισ ἀ2ν1έρειϲ ἀ2ν1έρειϲ   % >an-'ereistoc
ἀ2ν1ερείσ ἀ2ν1ερείσ ἀ2ν1ερείϲ ἀ2ν1ερείϲ
ἀ2ν1ερεύνητ ἀ2ν1ερεύνητ   % >an-ere'unhtoc
ἀ2ν1ερευνήτ ἀ2ν1ερευνήτ
ἀ2ν1ερί ἀ2ν1ερί   % >an-er'ijeutoc
ἀ2ν1ερι
ἀ2ν1ερυθρίαστ ἀ2ν1ερυθρίαστ ἀ2ν1ερυθρίαϲτ ἀ2ν1ερυθρίαϲτ   % >an-erujr'iastoc
ἀ2ν1ερυθριάστ ἀ2ν1ερυθριάστ ἀ2ν1ερυθριάϲτ ἀ2ν1ερυθριάϲτ
ἀ2ν1έστι ἀ2ν1έστι ἀ2ν1έϲτι ἀ2ν1έϲτι   % >an-'estioc
ἀ2ν1εστί ἀ2ν1εστί ἀ2ν1εϲτί ἀ2ν1εϲτί
ἀ2ν1έται ἀ2ν1έται   % >an-'etairoc
ἀ2ν1εταί ἀ2ν1εταί
ἀ2ν1έτοι ἀ2ν1έτοι   % >an-'etoimoc
ἀ2ν1ετοί ἀ2ν1ετοί
ἀ2ν1ετυ   % >an-etumol'oghtoc
ἀ2ν1έτυ ἀ2ν1έτυ   % >an-'etumoc
ἀ2ν1ετύ ἀ2ν1ετύ
ἀ2ν1εύθ ἀ2ν1εύθ   % >an-e'ujetoc
ἀ2ν1ευθ
ἄ2ν1ευκ   % >'an-euktoc
ἀ2ν1εύκ ἀ2ν1εύκ
ἀ2ν1ευλ   % >an-eulab'hc
ἀ2ν1εύρετ ἀ2ν1εύρετ   % >an-e'uretoc
ἀ2ν1ευρέτ ἀ2ν1ευρέτ
ἀ2ν1ευφήμητ ἀ2ν1ευφήμητ   % >an-euf'hmhtoc
ἀ2ν1ευφημήτ ἀ2ν1ευφημήτ
ἀ2ν1εύχ ἀ2ν1εύχ   % >an-e'uqomai (some tenses may be wrong ???)
ἀ2ν1ευχ
ἀ2ν1εύξ ἀ2ν1εύξ   % >an-e'uxato
ἀ2ν1ευξ
ἀ2ν1ηυξ   % >an-hux'amhn
ἀ2ν1ηῦγ   % >an-h~ugmai
ἀ2ν1ηυγ
ἀ2ν1ευκτ   % >an-eukt'oc
ἀ2ν1έφ ἀ2ν1έφ   % >an-'efaptoc k.lp.
ἀ2ν1εφ
ἀ3ν2εφάλ ἀ3ν2εφάλ   % >ane-f'allomai
ἀ3ν2έφελ ἀ3ν2έφελ   % >a-n'efeloc
ἀ3ν2εφέλ ἀ3ν2εφέλ
ἀ2ν1εχέ ἀ2ν1εχέ   % >an-eq'egguoc
ἀ2ν1εχε
ἀ2ν1έψα ἀ2ν1έψα   % >an-'eyanoc
ἀ2ν1εψά ἀ2ν1εψά
ἀ2ν1ηγεμ   % >an-hgem'oneutoc
ἀ2ν1ήδ ἀ2ν1ήδ   % >an-'hdonoc
ἀ2ν1ηδ
ἀ2ν1ήκεσ ἀ2ν1ήκεσ ἀ2ν1ήκεϲ ἀ2ν1ήκεϲ   % >an-'hkestoc
ἀ2ν1ηκέσ ἀ2ν1ηκέσ ἀ2ν1ηκέϲ ἀ2ν1ηκέϲ
ἀ2ν1ήκο ἀ2ν1ήκο   % >an-'hkooc, >an-hkoust'ew, k.lp.
ἀ2ν1ηκό ἀ2ν1ηκό
ἀ2ν1ηκο
ἀ2ν1ηλάκ ἀ2ν1ηλάκ   % >an-hl'akatoc
ἀ2ν1ηλακ
ἀ2ν1ήλατος. ἀ2ν1ήλατος. ἀ2ν1ήλατοϲ. ἀ2ν1ήλατοϲ.   % >an-'hlatoc
ἀ2ν1ήλατοσ. ἀ2ν1ήλατοσ.
ἀ2ν1ηλάτου ἀ2ν1ηλάτου
ἀ2ν1ηλάτω ἀ2ν1ηλάτω
ἀ2ν1ήλατον. ἀ2ν1ήλατον.
ἀ2ν1ήλατε. ἀ2ν1ήλατε.
ἀ2ν1ηλάτοι ἀ2ν1ηλάτοι
ἀ2ν1ήλατοι ἀ2ν1ήλατοι
ἀ2ν1ήλατα ἀ2ν1ήλατα
ἀ2ν1ηλεγ   % >an-hleg'hc
ἀ2ν1ηλεή ἀ2ν1ηλεή   % >an-hle'hc
ἀ2ν1ηλεὴ
ἀ2ν1ηλεο
ἀ2ν1ηλεε
ἀ2ν1ηλεῶ
ἀ2ν1ηλεέ ἀ2ν1ηλεέ
ἀ2ν1ηλεὲ
ἀ2ν1ηλεῆ
ἀ2ν1ηλέη ἀ2ν1ηλέη   % >an-hl'ehtoc
ἀ2ν1ήλειπ ἀ2ν1ήλειπ   % >an-'hleiptoc
ἀ2ν1ηλείπ ἀ2ν1ηλείπ
ἀ2ν1ηλή ἀ2ν1ηλή   % >an-hl'hc
ἀ2ν1ηλὴ
ἀ2ν1ηλοῦ
ἀ2ν1ηλεῖ
ἀ2ν1ηλῆ
ἀ2ν1ηλέ ἀ2ν1ηλέ
ἀ2ν1ηλὲ
ἀ2ν1ηλοῖ
ἀ2ν1ηλῶ
ἀ2ν1ήλικ ἀ2ν1ήλικ   % >an-'hlikoc
ἀ2ν1ηλίκ ἀ2ν1ηλίκ
ἀ2ν1ήλιο ἀ2ν1ήλιο   % >an-'hlioc
ἀ2ν1ηλίο ἀ2ν1ηλίο
ἀ2ν1ηλίω ἀ2ν1ηλίω
ἀ2ν1ήλια ἀ2ν1ήλια
ἀ2ν1ήλιπ ἀ2ν1ήλιπ   % >an-'hlipoc
ἀ2ν1ηλίπ ἀ2ν1ηλίπ
ἀ2ν1ηλιφ   % >an-hlif'hc
ἀ2ν1ήμ ἀ2ν1ήμ   % >an-'hmelktoc
ἀ2ν1ημ
ἀ2ν1ήνυ ἀ2ν1ήνυ   % >an-'hnustoc
ἀ2ν1ηνύ ἀ2ν1ηνύ
ἀ2ν1ήρει ἀ2ν1ήρει   % >an-'hreiktoc
ἀ2ν1ηρεί ἀ2ν1ηρεί
ἀ2ν1ηρέμ ἀ2ν1ηρέμ   % >an-hr'emhtoc
ἀ2ν1ηρεμ
ἀ2ν1ηρεφ   % >an-href'hc
ἀ2ν1ήρι ἀ2ν1ήρι   % >an-'hrijmoc
ἀ2ν1ηρί ἀ2ν1ηρί
ἀ2ν1ήροτ ἀ2ν1ήροτ   % >an-'hrotoc
ἀ2ν1ηρότ ἀ2ν1ηρότ
ἀ2ν1ήσσ ἀ2ν1ήσσ ἀ2ν1ήϲϲ ἀ2ν1ήϲϲ   % >an-'hsshtoc
ἀ2ν1ησσ ἀ2ν1ηϲϲ
ἀ2ν1ήττ ἀ2ν1ήττ   % >an-'htthtoc
ἀ2ν1ηττ
ἀ2ν1ήφα ἀ2ν1ήφα   % >an-'hfaistoc
ἀ2ν1ηφα
ἀ2ν1ίατ ἀ2ν1ίατ   % >an-'iatoc
ἀ2ν1ιάτ ἀ2ν1ιάτ
ἀ2ν1ίδιο ἀ2ν1ίδιο   % >an-'idioc
ἀ2ν1ιδίο ἀ2ν1ιδίο
ἀ2ν1ιδίω ἀ2ν1ιδίω
ἀ2ν1ίδια ἀ2ν1ίδια
ἀ2ν1ιδιτ   % >an-idit'i
ἄ2ν1ιδρος ἄ2ν1ιδροϲ   % >'an-idroc
ἄ2ν1ιδροσ
ἀ2ν1ίδρου ἀ2ν1ίδρου
ἀ2ν1ίδρω ἀ2ν1ίδρω
ἄ2ν1ιδρον
ἄ2ν1ιδρε
ἀ2ν1ίδροι ἀ2ν1ίδροι
ἄ2ν1ιδροι
ἀ2ν1ίδρυτ ἀ2ν1ίδρυτ   % >an-'idrutoc
ἀ2ν1ιδρύτ ἀ2ν1ιδρύτ
ἀ2ν1ιδρωτ   % >an-idrwt'i
ἀ2ν1ιδρώτ ἀ2ν1ιδρώτ   % >an-idr'wtou (gen. to~u >an-'idrwtoc)
ἀ2ν1ίερ ἀ2ν1ίερ   % >an-'ieroc
ἀ2ν1ιέρ ἀ2ν1ιέρ
ἀ2ν1ιεράτ ἀ2ν1ιεράτ   % >an-ier'atou
ἀ3ν2ιέρω ἀ3ν2ιέρω   % >ani-'erwsic
ἀ2ν1ίκ ἀ2ν1ίκ   % >an-'ikanoc
ἀ2ν1ικ
ἄ2ν1ικ   % >'an-ikmoc
ἀ3ν2ίκη ἀ3ν2ίκη   % >a-n'ikhtoc
ἀ3ν2ική ἀ3ν2ική
ἀ2ν1ίλ ἀ2ν1ίλ   % >an-'ilastoc
ἀ2ν1ιλ
ἀ2ν1ίμαστ ἀ2ν1ίμαστ ἀ2ν1ίμαϲτ ἀ2ν1ίμαϲτ   % >an-'imastoc
ἀ2ν1ιμάστ ἀ2ν1ιμάστ ἀ2ν1ιμάϲτ ἀ2ν1ιμάϲτ
ἀ2ν1ίου ἀ2ν1ίου   % >an-'iouloc
ἀ2ν1ιού ἀ2ν1ιού
ἄ2ν1ιππ   % >'an-ippoc
ἀ2ν1ίππ ἀ2ν1ίππ
ἀ2ν1ισ ἀ2ν1ιϲ   % >an-is'azw
ἄ2ν1ισ ἄ2ν1ιϲ   % >'an-isoc
ἀ2ν1ίσ ἀ2ν1ίσ ἀ2ν1ίϲ ἀ2ν1ίϲ
ἀ3ν2ισᾶτ ἀ3ν2ιϲᾶτ   % >a-nis~aton
ἀ3ν2ισάτ ἀ3ν2ισάτ ἀ3ν2ιϲάτ ἀ3ν2ιϲάτ
ἀ3ν2ίστ ἀ3ν2ίστ ἀ3ν2ίϲτ ἀ3ν2ίϲτ   % >a-n'isthmi
ἀ3ν2ιστ ἀ3ν2ιϲτ
ἀ4ν3ιστορη ἀ4ν3ιϲτορη   % >an-istorhs'ia
ἀ4ν3ιστόρη ἀ4ν3ιστόρη ἀ4ν3ιϲτόρη ἀ4ν3ιϲτόρη   % >an-ist'orhtoc
ἀ4ν3ιστορή ἀ4ν3ιστορή ἀ4ν3ιϲτορή ἀ4ν3ιϲτορή
ἀ3ν2ίσχ ἀ3ν2ίσχ ἀ3ν2ίϲχ ἀ3ν2ίϲχ   % >an'i-sqw
ἀ4ν3ίσχυ ἀ4ν3ίσχυ ἀ4ν3ίϲχυ ἀ4ν3ίϲχυ   % >an-'isquroc
ἄ2ν1ιχ   % >'an-iqjuc
ἀ2ν1ίχ ἀ2ν1ίχ
ἀ2ν1ιχνεύτ ἀ2ν1ιχνεύτ   % >an-iqne'utou
ἀ2ν1ίψ ἀ2ν1ίψ   % >an-'iyaloc
ἀ2ν1ιψ
ἀ2ν1όδε ἀ2ν1όδε   % >an-'odeutoc
ἀ2ν1οδέ ἀ2ν1οδέ
ἄ2ν1οζ   % >'an-ozoc
ἀ2ν1όζ ἀ2ν1όζ
ἀ2ν1οικε   % >an-oike'iou
ἀ2ν1οικον   % >an-oikon'omhtoc
ἄ2ν1οικ   % >'an-oikoc
ἀ2ν1οίκ ἀ2ν1οίκ
ἀ2ν1οικτί ἀ2ν1οικτί   % >an-oikt'irmwn
ἄ2ν1οικτ   % >'an-oiktoc
ἀ2ν1οίκτ ἀ2ν1οίκτ
ἀ2ν1οίμωκ ἀ2ν1οίμωκ   % >an-o'imwktoc
ἀ2ν1οιμώκ ἀ2ν1οιμώκ
ἀ2ν1οιμωκ   % >an-oimwkt'i
ἀ2ν1οιν   % >an-oin'ia
ἄ2ν1οιν   % >'an-oinoc
ἀ2ν1οίν ἀ2ν1οίν
ἄ2ν1οιστρ ἄ2ν1οιϲτρ   % >'an-oistroc
ἀ2ν1οίστρ ἀ2ν1οίστρ ἀ2ν1οίϲτρ ἀ2ν1οίϲτρ
ἀ2ν1όλ ἀ2ν1όλ   % >an-'olbioc
ἀ2ν1ολ
ἄ2ν1ολ   % >'an-olboc
ἀ3ν2ολκ   % >anol-k'h
ἀ3ν2ολο   % >ano-lol'uzw
ἀ2ν1ομβρί ἀ2ν1ομβρί   % >an-ombr'ia
ἀ2ν1ομβρῖ
ἄ2ν1ομβρο   % >'an-ombroc
ἀ2ν1όμβρο ἀ2ν1όμβρο
ἀ2ν1όμβρω ἀ2ν1όμβρω
ἄ2ν1ομβρα
ἀ2ν1ομήλ ἀ2ν1ομήλ   % >an-om'hlikoc
ἀ2ν1ομηλ
ἀ2ν1ομίλ ἀ2ν1ομίλ   % >an-om'ilhtoc
ἀ2ν1ομιλ
ἀ2ν1όμιχ ἀ2ν1όμιχ   % >an-'omiqloc
ἀ2ν1ομιχ
ἀ2ν1όμο ἀ2ν1όμο   % >an-'omoioc
ἀ2ν1ομό ἀ2ν1ομό
ἀ2ν1ομο   % >an-omoz'hlou (gen. to~u >an-om'ozhloc)
ἀ3ν2ομοθ   % >a-nomo-j'ethtoc
ἀ3ν2όμου. ἀ3ν2όμου.   % >a-n'omou (gen. to~u >'a-nomoc)
ἀ3ν2όμῳ. ἀ3ν2όμῳ.
ἀ3ν2όμω. ἀ3ν2όμω.
ἀ2ν2όμοιν. ἀ2ν2όμοιν.
ἀ3ν2όμων. ἀ3ν2όμων.
ἀ3ν2όμοις. ἀ3ν2όμοις. ἀ3ν2όμοιϲ. ἀ3ν2όμοιϲ.
ἀ3ν2όμοισ. ἀ3ν2όμοισ.
ἀ3ν2όμους. ἀ3ν2όμους. ἀ3ν2όμουϲ. ἀ3ν2όμουϲ.
ἀ3ν2όμουσ. ἀ3ν2όμουσ.
ἀ2ν1όν ἀ2ν1όν   % >an-'onhtoc
ἀ2ν1ον
ἄ2ν1οπ   % >'an-oploc
ἀ2ν1όπ ἀ2ν1όπ
ἀ2ν1όρ ἀ2ν1όρ   % >an-'organoc
ἀ2ν1ορ
ἄ2ν1ορ   % >'an-orgoc
ἀ3ν2οργάζ ἀ3ν2οργάζ   % >anor-g'azw
ἄ3ν2ορθ   % >'anor-joc
ἀ3ν2όρθ ἀ3ν2όρθ
ἀ3ν2ορμά ἀ3ν2ορμά   % >anor-m'aomai
ἀ3ν2ορτ   % >anor-tal'izw
ἀ3ν2ορύ ἀ3ν2ορύ   % >ano-r'ussw
ἀ2ν1όσι ἀ2ν1όσι ἀ2ν1όϲι ἀ2ν1όϲι   % >an-'osioc
ἀ2ν1οσί ἀ2ν1οσί ἀ2ν1οϲί ἀ2ν1οϲί
ἀ2ν1οσι ἀ2ν1οϲι   % >an-osi'othc
ἄ2ν1οσμ ἄ2ν1οϲμ   % >'an-osmoc
ἀ2ν1όσμ ἀ2ν1όσμ ἀ2ν1όϲμ ἀ2ν1όϲμ
ἀ2ν1όσφρ ἀ2ν1όσφρ ἀ2ν1όϲφρ ἀ2ν1όϲφρ   % >an-'osfrantoc
ἀ2ν1οσφρ ἀ2ν1οϲφρ
ἀ2ν1ούα ἀ2ν1ούα   % >an-o'uatoc
ἀ2ν1ουά ἀ2ν1ουά
ἀ2ν1ούσι ἀ2ν1ούσι ἀ2ν1ούϲι ἀ2ν1ούϲι   % >an-o'usioc
ἀ2ν1ουσί ἀ2ν1ουσί ἀ2ν1ουϲί ἀ2ν1ουϲί
ἀ2ν1ούτ ἀ2ν1ούτ   % >an-o'utatoc
ἀ2ν1ουτ
ἀ2ν1οφθ   % >an-ofjalm'iatoc
ἀ2ν1όχευτ ἀ2ν1όχευτ   % >an-'oqeutoc
ἀ2ν1οχεύτ ἀ2ν1οχεύτ
ἄ2ν1οχλ   % >'an-oqloc
ἀ2ν1όχλ ἀ2ν1όχλ
ἀ2ν1οψ   % >an-oy'ia
ἄ2ν1οψ   % >'an-oyoc
ἀ2ν1όψ ἀ2ν1όψ
ἀντα2ν1ισ ἀντα2ν1ιϲ   % >antan-is'ow
ἀντα2ν1ίσ ἀντα2ν1ίσ ἀντα2ν1ίϲ ἀντα2ν1ίϲ   % >antan-'iswsa
ἀντει2σ1 ἀντει2ϲ1   % >anteis-'agw
ἀντε2κ1   % >antek-t'assw
ἀντε2ν1   % >anten-'edra
ἀντε2ξ1   % >antex-'agw
ἀντιδυ2σ1 ἀντιδυ2ϲ1   % >antidus-qera'inw
ἀντιπαρε2κ1   % >antiparek-te'inw
ἀντιπαρε2ξ1   % >antiparex-'agw
ἀντιπρο2σ1 ἀντιπρο2ϲ1   % >antipros-agore'uw
ἀντιπροσ3κ2υ ἀντιπροϲ3κ2υ   % >antipro-skun'ew
ἀντισύ2ν1 ἀντισύ2ν1 ἀντιϲύ2ν1 ἀντιϲύ2ν1   % >antis'un-axic
ἀντισυ2ν1 ἀντιϲυ2ν1
ἀ2ν1ύ ἀ2ν1ύ   % >an-'ubristoc
ἀ2ν1υ
ἀ3ν2υμ   % >a-numf'hc
ἀ3ν2ύσ ἀ3ν2ύσ ἀ3ν2ύϲ ἀ3ν2ύϲ   % >a-n'useie (>an'uw)
ἀ3ν2υσ ἀ3ν2υϲ   % >a-nust'oc
ἀ2ν1υπέ2ρ1 ἀ2ν1υπέ2ρ1   % >an-up'er-batoc
ἀ2ν1υπε2ρ1
%>a2n1'wd 		% >an-'wdhc %%% wrong??? comes from >'anw + <od'aw
%>a2n1~wd
ἄ2ν1ῳδ   % >'an-w|doc
ἀ2ν1ῴδ
ἀ2ν1ώδυ ἀ2ν1ώδυ   % >an-'wdunoc
ἀ2ν1ωδύ ἀ2ν1ωδύ   %%%TS%%%
ἀ2ν1ώι ἀ2ν1ώι   % >an-'wistoc
ἀ2ν1ωί ἀ2ν1ωί
ἀ2ν1ώλ ἀ2ν1ώλ   % >an-'wlejroc
ἀ2ν1ωλ
ἀ2ν1ώμ ἀ2ν1ώμ   % >an-'wmaloc
ἀ2ν1ωμ
ἀ2ν1ών ἀ2ν1ών   % >an-'wnumoc
ἀ2ν1ων
ἀ2ν1ωρ   % >an-wr'ia
ἄ2ν1ωρ   % >'an-wroc
ἀ2ν1ώρ ἀ2ν1ώρ
ἄ2ν1ωτο   % >'an-wtoc
ἀ2ν1ώτο ἀ2ν1ώτο
ἀ2ν1ωφέλ ἀ2ν1ωφέλ   % >an-wf'eleia
ἀ2ν1ωφελ   % >an-wfel'hc
ἀ2ν1ώχυ ἀ2ν1ώχυ   % >an-'wquroc
ἀ2ν1ωχύ ἀ2ν1ωχύ
ἀπα2ν1αι   % >apan-aisqunta'iw
ἀπά2ν1ου ἀπά2ν1ου   % >ap'an-ourgoc
ἀπα2ν1ούρ ἀπα2ν1ούρ
ἁπα2ξ1   % <apax-'apac
ἀπε2κ1λ   % >apek-lanj'anomai
ἁπε2ρ1   % <aper-e'i
ἀποσυ2ν1 ἀποϲυ2ν1   % >aposun-'agwgoc
ἀπρό2σ1 ἀπρό2σ1 ἀπρό2ϲ1 ἀπρό2ϲ1   % >apr'os-batoc
ἀπρο2σ1 ἀπρο2ϲ1
ἀπρό3σ2κε ἀπρό3σ2κε ἀπρό3ϲ2κε ἀπρό3ϲ2κε   % >apr'o-skeptoc
ἀπρο3σ2κέ ἀπρο3σ2κέ ἀπρο3ϲ2κέ ἀπρο3ϲ2κέ
ἀπρό3σ2κο ἀπρό3σ2κο ἀπρό3ϲ2κο ἀπρό3ϲ2κο   % >apr'o-skopoc != >apr'os-koptoc ???
ἀπρο3σ2κό ἀπρο3σ2κό ἀπρο3ϲ2κό ἀπρο3ϲ2κό
ἀπρο3σ2τ ἀπρο3ϲ2τ   % >apro-stas'iou
ἁρπα2ξ1   % >arpax-'andra (<h)
ἀρρε2ν1ω   % >arren-wp'oc
ἀρχισυ2ν1 ἀρχιϲυ2ν1   % >arqisun-agwg'oc
ἀστε2ρ1ω ἀϲτε2ρ1ω   % >aster-wp'oc
ἀσύ2ν1 ἀσύ2ν1 ἀϲύ2ν1 ἀϲύ2ν1   % >as'un-etoc
ἀσυ2ν1 ἀϲυ2ν1
ἀξύ2ν1 ἀξύ2ν1   % >ax'un-etoc
ἀξυ2ν1
αὐτέ2κ1μ αὐτέ2κ1μ   % a>ut'ek-magma
αὐτε2κ1μ
αὐτε2ξ1   % a>utex-o'usioc
ἀω2σ1φ ἀω2ϲ1φ   % >aws-f'oroc
.γερα2σ1φ .γερα2ϲ1φ   % geras-f'oroc
.δα2σ1π .δα2ϲ1π   % das-pl'hc
.διαμφι2σ1β .διαμφι2ϲ1β   % diamfis-bht'ew
.διέ2κ1ρο .διέ2κ1ρο   % di'ek-rooc
.διε2κ1ρό .διε2κ1ρό
.διέ2ξ1 .διέ2ξ1   % di'ex-eimi
.διε2ξ1   % diex-ela'unw
.δικα2σ1π .δικα2ϲ1π   % dikas-p'oloc
.διό2σ1κ .διό2σ1κ .διό2ϲ1κ .διό2ϲ1κ   % Di'os-kouroc dios-k'uamoc
.διο2σ1κ .διο2ϲ1κ
.διό2σ1π .διό2σ1π .διό2ϲ1π .διό2ϲ1π   % di'os-polic
.διο2σ1π .διο2ϲ1π
.δί2σ1α .δί2σ1α .δί2ϲ1α .δί2ϲ1α   % d'is-aboc
.δι2σ1ά .δι2σ1ά .δι2ϲ1ά .δι2ϲ1ά
.δί2σ1η .δί2σ1η .δί2ϲ1η .δί2ϲ1η   % d'is-hboc
.δι2σ1ή .δι2σ1ή .δι2ϲ1ή .δι2ϲ1ή
.δί2σ1ε .δί2σ1ε .δί2ϲ1ε .δί2ϲ1ε   % d'is-eunoc
.δι2σ1ε .δι2ϲ1ε
.δι2σ1θ .δι2ϲ1θ   % dis-jan'hc
.δύ2σ1 .δύ2σ1 .δύ2ϲ1 .δύ2ϲ1   % d'us-agnoc, k.lp.
.δυ2σ1 .δυ2ϲ1
%
δύ3σ2ω. δύ3σ2ω. δύ3ϲ2ω. δύ3ϲ2ω.   % d'uw, d'usw k.lp.
δύ3σ2εις. δύ3σ2εις. δύ3ϲ2ειϲ. δύ3ϲ2ειϲ.
δύ3σ2εισ. δύ3σ2εισ.
δύ3σ2ει. δύ3σ2ει. δύ3ϲ2ει. δύ3ϲ2ει.
.δύ3σ2ετ .δύ3σ2ετ .δύ3ϲ2ετ .δύ3ϲ2ετ
δύ3σ2ομεν. δύ3σ2ομεν. δύ3ϲ2ομεν. δύ3ϲ2ομεν.
δύ3σ2ουσιν. δύ3σ2ουσιν. δύ3ϲ2ουϲιν. δύ3ϲ2ουϲιν.
	%
δύ3σ2οιμι. δύ3σ2οιμι. δύ3ϲ2οιμι. δύ3ϲ2οιμι.
δύ3σ2οις. δύ3σ2οις. δύ3ϲ2οιϲ. δύ3ϲ2οιϲ.
δύ3σ2οισ. δύ3σ2οισ.
δύ3σ2οι. δύ3σ2οι. δύ3ϲ2οι. δύ3ϲ2οι.
δύ3σ2οιτον. δύ3σ2οιτον. δύ3ϲ2οιτον. δύ3ϲ2οιτον.
δυ3σ2οίτην. δυ3σ2οίτην. δυ3ϲ2οίτην. δυ3ϲ2οίτην.
δύ3σ2οιμεν. δύ3σ2οιμεν. δύ3ϲ2οιμεν. δύ3ϲ2οιμεν.
δύ3σ2οιτε. δύ3σ2οιτε. δύ3ϲ2οιτε. δύ3ϲ2οιτε.
δύ3σ2οιεν. δύ3σ2οιεν. δύ3ϲ2οιεν. δύ3ϲ2οιεν.
	%
δύ3σ2ειν. δύ3σ2ειν. δύ3ϲ2ειν. δύ3ϲ2ειν.
δύ3σ2ων. δύ3σ2ων. δύ3ϲ2ων. δύ3ϲ2ων. δύ3σ2ον δύ3σ2ον δύ3ϲ2ον δύ3ϲ2ον δυ3σ2όν δυ3σ2όν δυ3ϲ2όν δυ3ϲ2όν
δύ3σ2ουσ δύ3σ2ουσ δύ3ϲ2ουϲ δύ3ϲ2ουϲ δυ3σ2ούσ δυ3σ2ούσ δυ3ϲ2ούϲ δυ3ϲ2ούϲ
	%
δύ3σ2ῃ δύ3σ2ῃ δύ3ϲ2ῃ δύ3ϲ2ῃ
δύ3σ2ητον. δύ3σ2ητον. δύ3ϲ2ητον. δύ3ϲ2ητον.
δύ3σ2ωμεν. δύ3σ2ωμεν. δύ3ϲ2ωμεν. δύ3ϲ2ωμεν.
δύ3σ2ωσι. δύ3σ2ωσι. δύ3ϲ2ωϲι. δύ3ϲ2ωϲι.
	%
δύ3σ2αιμι. δύ3σ2αιμι. δύ3ϲ2αιμι. δύ3ϲ2αιμι.
δύ3σ2αις. δύ3σ2αις. δύ3ϲ2αιϲ. δύ3ϲ2αιϲ. δύ3σ2ειας. δύ3σ2ειας. δύ3ϲ2ειαϲ. δύ3ϲ2ειαϲ.
δύ3σ2αισ. δύ3σ2αισ. δύ3σ2ειασ. δύ3σ2ειασ.
δύ3σ2αι. δύ3σ2αι. δύ3ϲ2αι. δύ3ϲ2αι. δύ3σ2ειε. δύ3σ2ειε. δύ3ϲ2ειε. δύ3ϲ2ειε.
δύ3σ2αιτον. δύ3σ2αιτον. δύ3ϲ2αιτον. δύ3ϲ2αιτον.
δυ3σ2αίτην. δυ3σ2αίτην. δυ3ϲ2αίτην. δυ3ϲ2αίτην.
δύ3σ2αιμεν. δύ3σ2αιμεν. δύ3ϲ2αιμεν. δύ3ϲ2αιμεν.
δύ3σ2αιτε. δύ3σ2αιτε. δύ3ϲ2αιτε. δύ3ϲ2αιτε.
δύ3σ2αιεν δύ3σ2αιεν δύ3ϲ2αιεν δύ3ϲ2αιεν δύ3σ2ειαν. δύ3σ2ειαν. δύ3ϲ2ειαν. δύ3ϲ2ειαν.
	%
δύ3σ2ον. δύ3σ2ον. δύ3ϲ2ον. δύ3ϲ2ον.
δυ3σ2άτω. δυ3σ2άτω. δυ3ϲ2άτω. δυ3ϲ2άτω.
δύ3σ2ατον. δύ3σ2ατον. δύ3ϲ2ατον. δύ3ϲ2ατον.
δυ3σ2άτων. δυ3σ2άτων. δυ3ϲ2άτων. δυ3ϲ2άτων.
δύ3σ2ατε. δύ3σ2ατε. δύ3ϲ2ατε. δύ3ϲ2ατε.
δυ3σ2άντων. δυ3σ2άντων. δυ3ϲ2άντων. δυ3ϲ2άντων.
	%
δύ3σ2ας. δύ3σ2ας. δύ3ϲ2αϲ. δύ3ϲ2αϲ. δύ3σ2αν. δύ3σ2αν. δύ3ϲ2αν. δύ3ϲ2αν. δύ3σ2αντ δύ3σ2αντ δύ3ϲ2αντ δύ3ϲ2αντ δυ3σ2άντ δυ3σ2άντ δυ3ϲ2άντ δυ3ϲ2άντ
δύ3σ2ασ δύ3σ2ασ δύ3ϲ2αϲ δύ3ϲ2αϲ δυ3σ2άσ δυ3σ2άσ δυ3ϲ2άϲ δυ3ϲ2άϲ
	%
δύ3σ2ομαι. δύ3σ2ομαι. δύ3ϲ2ομαι. δύ3ϲ2ομαι.
.δύ3σ2εσ .δύ3σ2εσ .δύ3ϲ2εϲ .δύ3ϲ2εϲ
δυ3σ2όμεθα. δυ3σ2όμεθα. δυ3ϲ2όμεθα. δυ3ϲ2όμεθα.
δύ3σ2ονται. δύ3σ2ονται. δύ3ϲ2ονται. δύ3ϲ2ονται.
	%
δυ3σ2οίμην. δυ3σ2οίμην. δυ3ϲ2οίμην. δυ3ϲ2οίμην.
δύ3σ2οιο. δύ3σ2οιο. δύ3ϲ2οιο. δύ3ϲ2οιο.
δύ3σ2οιτο. δύ3σ2οιτο. δύ3ϲ2οιτο. δύ3ϲ2οιτο.
δύ3σ2οισθον. δύ3σ2οισθον. δύ3ϲ2οιϲθον. δύ3ϲ2οιϲθον.
δυ3σ2οίσθην. δυ3σ2οίσθην. δυ3ϲ2οίϲθην. δυ3ϲ2οίϲθην.
δυ3σ2οίμεθα. δυ3σ2οίμεθα. δυ3ϲ2οίμεθα. δυ3ϲ2οίμεθα.
δύ3σ2οισθε. δύ3σ2οισθε. δύ3ϲ2οιϲθε. δύ3ϲ2οιϲθε.
δύ3σ2οιντο. δύ3σ2οιντο. δύ3ϲ2οιντο. δύ3ϲ2οιντο.
	%
δύ3σ2εσθαι. δύ3σ2εσθαι. δύ3ϲ2εϲθαι. δύ3ϲ2εϲθαι.
.δυ3σ2όμεν .δυ3σ2όμεν .δυ3ϲ2όμεν .δυ3ϲ2όμεν   % dus'omenoc -h -on
.δυ3σ2ομέν .δυ3σ2ομέν .δυ3ϲ2ομέν .δυ3ϲ2ομέν
	%
δύ3σ2ωμαι. δύ3σ2ωμαι. δύ3ϲ2ωμαι. δύ3ϲ2ωμαι.
δύ3σ2ηται. δύ3σ2ηται. δύ3ϲ2ηται. δύ3ϲ2ηται.
δυ3σ2ώμεθα δυ3σ2ώμεθα δυ3ϲ2ώμεθα δυ3ϲ2ώμεθα
δύ3σ2ησθε. δύ3σ2ησθε. δύ3ϲ2ηϲθε. δύ3ϲ2ηϲθε.
	%
δυ3σ2αίμην. δυ3σ2αίμην. δυ3ϲ2αίμην. δυ3ϲ2αίμην.
δύ3σ2αιο. δύ3σ2αιο. δύ3ϲ2αιο. δύ3ϲ2αιο.
δύ3σ2αιτο. δύ3σ2αιτο. δύ3ϲ2αιτο. δύ3ϲ2αιτο.
δύ3σ2αισθον. δύ3σ2αισθον. δύ3ϲ2αιϲθον. δύ3ϲ2αιϲθον.
δυ3σ2αίσθην. δυ3σ2αίσθην. δυ3ϲ2αίϲθην. δυ3ϲ2αίϲθην.
δυ3σ2αίμεθα. δυ3σ2αίμεθα. δυ3ϲ2αίμεθα. δυ3ϲ2αίμεθα.
δύ3σ2αισθαι. δύ3σ2αισθαι. δύ3ϲ2αιϲθαι. δύ3ϲ2αιϲθαι.
δύ3σ2αιντο. δύ3σ2αιντο. δύ3ϲ2αιντο. δύ3ϲ2αιντο.
	%
δυ3σ2άσθω. δυ3σ2άσθω. δυ3ϲ2άϲθω. δυ3ϲ2άϲθω.
δύ3σ2ασθον. δύ3σ2ασθον. δύ3ϲ2αϲθον. δύ3ϲ2αϲθον.
δυ3σ2άσθων. δυ3σ2άσθων. δυ3ϲ2άϲθων. δυ3ϲ2άϲθων.
δύ3σ2ασθε. δύ3σ2ασθε. δύ3ϲ2αϲθε. δύ3ϲ2αϲθε.
	%
δύ3σ2ασθαι. δύ3σ2ασθαι. δύ3ϲ2αϲθαι. δύ3ϲ2αϲθαι.
δυ3σ2άμεν δυ3σ2άμεν δυ3ϲ2άμεν δυ3ϲ2άμεν   % du-s'amenoc -h -on
δυσ3σ2αμέν δυσ3σ2αμέν δυϲ3ϲ2αμέν δυϲ3ϲ2αμέν
	%
δύ3σ2ατο. δύ3σ2ατο. δύ3ϲ2ατο. δύ3ϲ2ατο.   % d'u-sato = >ed'usato
δύ3σ2ετο. δύ3σ2ετο. δύ3ϲ2ετο. δύ3ϲ2ετο.   % d'u-seto = >ed'usato
δύ3σ2αντο. δύ3σ2αντο. δύ3ϲ2αντο. δύ3ϲ2αντο.   % d'u-santo = >ed'usanto
δύ3σ2εο. δύ3σ2εο. δύ3ϲ2εο. δύ3ϲ2εο.   % d'u-seo = d~usai ??? (prost. m'esou >aor'istou)
	%
	%
.δυσεί2σ1β .δυσεί2σ1β .δυϲεί2ϲ1β .δυϲεί2ϲ1β   % duse'is-boloc
.δυσει2σ1β .δυϲει2ϲ1β
.δυσέ2κ1 .δυσέ2κ1 .δυϲέ2κ1 .δυϲέ2κ1   % dus'ek-lutoc
.δυσε2κ1 .δυϲε2κ1
.δυσέ2ξ1 .δυσέ2ξ1 .δυϲέ2ξ1 .δυϲέ2ξ1   % dus'ex-aptoc
.δυσε2ξ1 .δυϲε2ξ1
.δυ3σ2ιθ .δυ3ϲ2ιθ   % du-sij'alassoc
δύ3σ2ις. δύ3σ2ις. δύ3ϲ2ιϲ. δύ3ϲ2ιϲ.   % d'u-sic
δύ3σ2ισ. δύ3σ2ισ.
δύ3σ2εω δύ3σ2εω δύ3ϲ2εω δύ3ϲ2εω
δύ3σ2ιν. δύ3σ2ιν. δύ3ϲ2ιν. δύ3ϲ2ιν.
δύ3σ2ι. δύ3σ2ι. δύ3ϲ2ι. δύ3ϲ2ι.
δυ3σ2έοιν. δυ3σ2έοιν. δυ3ϲ2έοιν. δυ3ϲ2έοιν.
δύ3σ2εσι. δύ3σ2εσι. δύ3ϲ2εϲι. δύ3ϲ2εϲι.
δύ3σ2εσιν. δύ3σ2εσιν. δύ3ϲ2εϲιν. δύ3ϲ2εϲιν.
.δύ3σ2κε .δύ3σ2κε .δύ3ϲ2κε .δύ3ϲ2κε   % d'u-ske
.δυ3σ2μή. .δυ3σ2μή. .δυ3ϲ2μή. .δυ3ϲ2μή.   % du-sm'h
.δυ3σ2μὴ. .δυ3ϲ2μὴ.
.δυ3σ2μῆς. .δυ3ϲ2μῆϲ.
.δυ3σ2μῆσ.
.δυ3σ2μῇ .δυ3ϲ2μῇ
.δυ3σ2μῆ. .δυ3ϲ2μῆ.
.δυ3σ2μᾶ .δυ3ϲ2μᾶ
.δυ3σ2μα .δυ3ϲ2μα
.δυ3σ2μῶ .δυ3ϲ2μῶ
.δυσξύ2ν1 .δυσξύ2ν1 .δυϲξύ2ν1 .δυϲξύ2ν1   % dusx'un-etoc
.δυσξυ2ν1 .δυϲξυ2ν1
.δύ3σ2ταν .δύ3σ2ταν .δύ3ϲ2ταν .δύ3ϲ2ταν   % d'u-stanoc
.δυ3σ2τάν .δυ3σ2τάν .δυ3ϲ2τάν .δυ3ϲ2τάν
.δυ3σ2την .δυ3ϲ2την   % d'u-sthnoc
.δυ3σ2τήν .δυ3σ2τήν .δυ3ϲ2τήν .δυ3ϲ2τήν
ἐδυ2σ1τ ἐδυ2ϲ1τ   % >edus-t'uqoun
εἰ2ν1όδ εἰ2ν1όδ   % e>in-'odioc
εἰ2ν1οδ
εἰ2σ1 εἰ2ϲ1   % e>is-agwg'h, k.lp.
εἴ2σ1 εἴ2ϲ1
εἰ3σ2ί. εἰ3σ2ί. εἰ3ϲ2ί. εἰ3ϲ2ί.   % e>i-s'i(n) <-- e>im'i
εἰ3σ2ὶ. εἰ3ϲ2ὶ.
εἰ3σ2ι. εἰ3ϲ2ι.
εἰ3σ2ίν. εἰ3σ2ίν. εἰ3ϲ2ίν. εἰ3ϲ2ίν.
εἰ3σ2ὶν. εἰ3ϲ2ὶν.
εἰ3σ2ιν. εἰ3ϲ2ιν.
εἴ3σ2ομ εἴ3ϲ2ομ   % e>'i-somai <-- o<~ida
εἴ3σ2ῃ. εἴ3ϲ2ῃ. εἴσει. εἴϲει.
εἴ3σ2εται. εἴ3ϲ2εται.
εἴ3σ2εσθον. εἴ3ϲ2εϲθον.
εἰ3σ2όμ εἰ3σ2όμ εἰ3ϲ2όμ εἰ3ϲ2όμ   % e>i-s'omeja
εἴ3σ2εσθε. εἴ3ϲ2εϲθε.
εἴ3σ2ονται εἴ3ϲ2ονται
%
εἰ3σ2οίμην εἰ3σ2οίμην εἰ3ϲ2οίμην εἰ3ϲ2οίμην
εἴ3σ2οιο εἴ3ϲ2οιο
εἴ3σ2οιτο εἴ3ϲ2οιτο
εἴ3σ2οισθον εἴ3ϲ2οιϲθον
εἰ3σ2οίσθην εἰ3σ2οίσθην εἰ3ϲ2οίϲθην εἰ3ϲ2οίϲθην
εἰ3σ2οίμεθα εἰ3σ2οίμεθα εἰ3ϲ2οίμεθα εἰ3ϲ2οίμεθα
εἴ3σ2οισθε εἴ3ϲ2οιϲθε
εἴ3σ2οιντο εἴ3ϲ2οιντο
%
εἴ3σ2εσθαι εἴ3ϲ2εϲθαι
εἰ3σ2όμεν εἰ3σ2όμεν εἰ3ϲ2όμεν εἰ3ϲ2όμεν   % e>is'omenoc -h -on
εἰ3σ2ομέν εἰ3σ2ομέν εἰ3ϲ2ομέν εἰ3ϲ2ομέν
%
εἴ3σ2άμην. εἴ3σ2άμην. εἴ3ϲ2άμην. εἴ3ϲ2άμην.
εἴ3σ2ω εἴ3ϲ2ω
εἴ3σ2ατο εἴ3ϲ2ατο
εἴ3σ2ασθον εἴ3ϲ2αϲθον
εἰ3σ2άσθην εἰ3σ2άσθην εἰ3ϲ2άϲθην εἰ3ϲ2άϲθην
εἰ3σ2άμεθα εἰ3σ2άμεθα εἰ3ϲ2άμεθα εἰ3ϲ2άμεθα
εἴ3σ2ασθε εἴ3ϲ2αϲθε
εἴ3σ2αντο εἴ3ϲ2αντο
%
εἴ3σ2ωμαι εἴ3ϲ2ωμαι
εἴ3σ2ησθον εἴ3ϲ2ηϲθον
εἰ3σ2ώμεθα εἰ3σ2ώμεθα εἰ3ϲ2ώμεθα εἰ3ϲ2ώμεθα
εἴ3σ2ησθε εἴ3ϲ2ηϲθε
εἴ3σ2ωνται εἴ3ϲ2ωνται
%
εἰ3σ2αίμην εἰ3σ2αίμην εἰ3ϲ2αίμην εἰ3ϲ2αίμην
εἴ3σ2αιο εἴ3ϲ2αιο
εἴ3σ2αιτο εἴ3ϲ2αιτο
εἴ3σ2αισθον εἴ3ϲ2αιϲθον
εἴ3σ2αίσθην εἴ3σ2αίσθην εἴ3ϲ2αίϲθην εἴ3ϲ2αίϲθην
εἰ3σ2αίμεθα εἰ3σ2αίμεθα εἰ3ϲ2αίμεθα εἰ3ϲ2αίμεθα
εἴ3σ2αισθε εἴ3ϲ2αιϲθε
εἴ3σ2αιντο εἴ3ϲ2αιντο
%
εἰ3σ2άσθω εἰ3σ2άσθω εἰ3ϲ2άϲθω εἰ3ϲ2άϲθω
εἰ3σ2άσθων εἰ3σ2άσθων εἰ3ϲ2άϲθων εἰ3ϲ2άϲθων
%%	e>'i3s2asje %% duplicate pattern ????
%
εἴ3σ2ασθαι εἴ3ϲ2αϲθαι
εἰ3σ2άμεν εἰ3σ2άμεν εἰ3ϲ2άμεν εἰ3ϲ2άμεν   % e>is'amenoc -h -on
εἰ3σ2αμέν εἰ3σ2αμέν εἰ3ϲ2αμέν εἰ3ϲ2αμέν
%
ἐ2κ1λ   % >ek-lagq'anw, k.lp.
ἐ3κ2λήθη ἐ3κ2λήθη   % >e-kl'hjhn <- kal'ew
ἐ3κ2λάζ ἐ3κ2λάζ   % >e-kl'azomen <- kl'azw, >'e-klazon (???)
ἐ3κ2λάγ ἐ3κ2λάγ   % >e-kl'azomen <- kl'azw, >'e-klagon
ἐ3κ2λάο ἐ3κ2λάο   % >e-kl'aomen <- kl'aw, >'e-klaon (???)
ἐ3κ2λάσ ἐ3κ2λάσ ἐ3κ2λάϲ ἐ3κ2λάϲ   % >e-kl'asomen <- kl'aw, >'e-klasa
ἐ3κ2λαί ἐ3κ2λαί   % >e-kla'iomen <- kla'iw, >'e-klai(g)on (???)
ἐ3κ2λαύ ἐ3κ2λαύ   % >e-kla'usamen <- kla'iw, >'e-klausa
ἐ3κ2λεί ἐ3κ2λεί   % >e-kle'isamen <- kle'iw, >'e-kleisa
ἐ4κ3λείπ ἐ4κ3λείπ   % >ek-le'ipomen
ἐ4κ3λείψ ἐ4κ3λείψ   % >ek-le'iyic
ἐ3κ2λῄ   % >e-kl'h|samen <- kle'iw, >'e-klh|sa
ἐ3κ2κλέπ ἐ3κ2κλέπ   % >e-kl'eptomen <- kl'eptw, >'e-klapon (???)
ἐ3κ2κλέψ ἐ3κ2κλέψ   % >e-kl'eyamen <- kl'eptw, >'e-kleya
ἐ3κ2λάπ ἐ3κ2λάπ   % >e-kl'aphn <- kl'eptw
ἐ3κ2λαπ   % >e-klap'omeja <- kl'eptw, >ek-l'aphn
ἐ4κ3λάπτ ἐ4κ3λάπτ   % >ek-l'aptw
ἐ4κ3λαπτ
ἐ3κ2λέφ ἐ3κ2λέφ   % >e-kl'efjhn <- kl'eptw
ἐ3κ2λεφ   % >e-klefj'hthn <- kl'eptw, >e-kl'efjhn
ἐ3κ2λήρ ἐ3κ2λήρ   % >e-kl'hroun <- klhr'ow
ἐ3κ2ληρ   % >e-klhro~uton <- klhr'ow, >e-kl'hroun
ἐ3κ2λίν ἐ3κ2λίν   % >e-kl'inamen <- kl'inw, >'e-klina
ἐ3κ2λιν   % >e-klin'aton <- kl'inw, >'e-klina
ἐ3κ2λύ ἐ3κ2λύ   % >e-kl'uomen <- kl'uw, >'e-kluon
ἐ4κ3λύσεω ἐ4κ3λύσεω ἐ4κ3λύϲεω ἐ4κ3λύϲεω   % >ek-lusic
ἐ4κ3λύσει ἐ4κ3λύσει ἐ4κ3λύϲει ἐ4κ3λύϲει
ἐ4κ3λύσεοι ἐ4κ3λύσεοι ἐ4κ3λύϲεοι ἐ4κ3λύϲεοι
ἐ4κ3λύσεσι ἐ4κ3λύσεσι ἐ4κ3λύϲεϲι ἐ4κ3λύϲεϲι
ἐ3κ2λόμ ἐ3κ2λόμ   % >e-kl'omhn <- k'elomai (>'alla pr'ospwpa???)
ἐ3κ2κλώσ ἐ3κ2κλώσ ἐ3κ2κλώϲ ἐ3κ2κλώϲ   % >e-kl'wsamen <- kl'wjw (???)
ἔ2κ1λει   % >'ek-leiyic
ἔ3κ2λεισ ἔ3κ2λειϲ   % >'ek-leisa <- kle'iw
ἔ2κ1λυσ ἔ2κ1λυϲ   % >'ek-lusic
ἐ2κ1μ
ἔ2κ1μ
ἐ2κ1ν
ἔ2κ1ν
ἔ3κ2ναι   % >'e-knaisa <- kna'iw
ἐ3κ2ναί ἐ3κ2ναί   % >e-kna'isamen <- kna'iw
ἔ3κ2νησ ἔ3κ2νηϲ   % >'e-knhsa <- kn'aw
ἐ3κ2νήσ ἐ3κ2νήσ ἐ3κ2νήϲ ἐ3κ2νήϲ   % >e-kn'hsamen <- kn'aw
ἐ3κ2νυ   % >e-knuz~hto
ἐ2κ1ρ
ἔ2κ1ρ
ἐ3κ2ράδ ἐ3κ2ράδ   % >ekr'adainon <- krada'inw (???)
ἐ3κ2ραδ
ἔ3κ2ραζ   % >'e-krazon <- kr'azw (???)
ἐ3κ2ράζ ἐ3κ2ράζ
ἔ3κ2ραγ   % >'e-kragon <- kr'azw
ἐ3κ2ράγ ἐ3κ2ράγ
ἐ3κ2ράτ ἐ3κ2ράτ   % >e-kr'atoun <- krat'ew (???)
ἐ3κ2ρατ
ἐ3κ2ραύγ ἐ3κ2ραύγ   % >e-kra'ugason <- kraug'azw
ἐ3κ2ραυγ
ἔ3κ2ραι   % >'e-krainon <- kra'inw (???)
ἐ3κ2ραί ἐ3κ2ραί
ἔ3κ2ραν   % >'e-krana, >e-kr'anjhn <- kra'inw
ἐ3κ2ράν ἐ3κ2ράν
ἐ3κ2ρήη ἐ3κ2ρήη   % >e-kr'hhna, >e-kr'aanjen - >e-kra'anjhmen (???) <- kra'inw
ἐ3κ2ράα ἐ3κ2ράα
ἐ3κ2ραά ἐ3κ2ραά
ἐ3κ2ράθ ἐ3κ2ράθ   % >e-kr'ajhn
ἐ3κ2ραθ
ἔ3κ2ρεκ   % >'e-krekon <- kr'ekw (???)
ἐ3κ2ρέκ ἐ3κ2ρέκ
ἔ3κ2ρεξ   % >'e-krexa <- kr'ekw (???)
ἐ3κ2ρέξ ἐ3κ2ρέξ
ἐ3κ2ρέμ ἐ3κ2ρέμ   % >e-kr'emw, >e-krem'asjhn <- krem~w
ἐ3κ2ρεμ
ἐ3κ2ρήμ ἐ3κ2ρήμ   % >e-kr'hmnizon <- krhmn'izw
ἐ3κ2ρημ
ἔ3κ2ριν   % >'e-krina, >e-kr'ijhn <- kr'inw
ἐ3κ2ρίν ἐ3κ2ρίν
ἐ3κ2ρίθ ἐ3κ2ρίθ
ἐ3κ2ρότ ἐ3κ2ρότ   % >e-kr'othsa <- krot'ew
ἐ3κ2ροτ
ἔ3κ2ρου   % >'ekrouon, >'e-krousa <- kro'uw
ἐ3κ2ρού ἐ3κ2ρού
ἔ3κ2ρυπ   % >'e-krupton (???), >'e-kruya,
ἐ3κ2ρύπ ἐ3κ2ρύπ   % >e-kr'ubhn (???), >e-kr'ufjhn <- kr'uptw
ἔ3κ2ρυψ
ἐ3κ2ρύψ ἐ3κ2ρύψ
ἐ3κ2ρύβ ἐ3κ2ρύβ
ἐ3κ2ρύφ ἐ3κ2ρύφ
ἐ3κ2ρυσ ἐ3κ2ρυϲ   % >e-krust'allisa <- krustall'izw
ἔ3κ2ρωζ   % >'e-krwzon <- kr'wzw
ἐ3κ2ρώζ ἐ3κ2ρώζ
ἔ3κ2ρωξ   % >'e-krwxa <- kr'wzw
ἐ3κ2ρώξ ἐ3κ2ρώξ
ἐ2κ1ταθ   % >ek-taje'ic
ἔ2κ1ταμε.   % >'ek-tame
ἐ2κ1τάμν ἐ2κ1τάμν   % >ek-t'amnw
ἐ2κ1ταν   % >ek-tan'uw
ἐ2κ1ταρ   % >ek-tar'assw
ἐ2κ1τάσ ἐ2κ1τάσ ἐ2κ1τάϲ ἐ2κ1τάϲ   % >ek-t'assw
ἐ2κ1τε
ἐ2κ1τέ ἐ2κ1τέ
ἐ3κ2τείν ἐ3κ2τείν   % >e-kte'inamen <- kte'inw, >'ekteinon
ἐ2κ1τήκ ἐ2κ1τήκ   % >ek-t'hkw
ἐ2κ1τι
ἔ2κ1τι
ἐ2κ1τί ἐ2κ1τί
ἔ3κ2τιζ   % >'e-ktizon, >e-kt'izomen <- kt'izw
ἐ3κ2τίζ ἐ3κ2τίζ
ἔ3κ2τισα ἔ3κ2τιϲα   % >'e-ktisa, >e-kt'isamen <- kt'izw
ἐ3κ2τίσα ἐ3κ2τίσα ἐ3κ2τίϲα ἐ3κ2τίϲα
ἐ2κ1τό ἐ2κ1τό
ἐ2κ1το
ἔ2κ1το
ἐ3κ2τός. ἐ3κ2τός. ἐ3κ2τόϲ. ἐ3κ2τόϲ.   % >e-kt'oc
ἐ3κ2τὸς. ἐ3κ2τὸϲ.
ἐ3κ2τόσ. ἐ3κ2τόσ.
ἐ3κ2τὸσ.
ἐ2κ1τρ
ἔ2κ1τυπο   % >'ek-tupon (o>us./>epij.) != >e-kt'upoun <- ktup'ew
ἐ2κ1τύπου. ἐ2κ1τύπου.
ἐ2κ1τύπῳ. ἐ2κ1τύπῳ.
ἔ2κ1τυπε.
ἐ2κ1τύπω. ἐ2κ1τύπω.
ἐ2κτύποι. ἐ2κτύποι.
ἐ2κ1τύπων. ἐ2κ1τύπων.
ἐ2κ1τύποις. ἐ2κ1τύποις. ἐ2κ1τύποιϲ. ἐ2κ1τύποιϲ.
ἐ2κ1τύποισ. ἐ2κ1τύποισ.
ἐ2κ1τύπους. ἐ2κ1τύπους. ἐ2κ1τύπουϲ. ἐ2κ1τύπουϲ.
ἐ2κ1τύπουσ. ἐ2κ1τύπουσ.
ἔ2κ1τυπα.
ἐ2κ1τυ
ἑλλή2σ1π ἑλλή2σ1π ἑλλή2ϲ1π ἑλλή2ϲ1π   % <Ell'hs-pontoc
ἑλλη2σ1π ἑλλη2ϲ1π
ἐ2ν1
ἔ2ν1
ἐ3ν2άκις ἐ3ν2άκις ἐ3ν2άκιϲ ἐ3ν2άκιϲ   % >e-n'akic
ἐ3ν2ακισ ἐ3ν2ακιϲ   % >e-nakisq'ilioi
ἐ3ν2ακόσ ἐ3ν2ακόσ ἐ3ν2ακόϲ ἐ3ν2ακόϲ   % >e-nak'osioi
ἐ3ν2ακοσ ἐ3ν2ακοϲ
ἔ3ν2αρα.   % >'e-nara
ἐ3ν2άρων. ἐ3ν2άρων.
ἐ3ν2άροις. ἐ3ν2άροις. ἐ3ν2άροιϲ. ἐ3ν2άροιϲ.
ἐ3ν2άροισ. ἐ3ν2άροισ.
ἐ3ν2αρηφ   % >e-narhf'oroc
ἐ4ν3αραρ   % >en-arar'iskw
ἐ3ν2άρεε ἐ3ν2άρεε   % >e-n'areec
ἐ3ν2αρέω ἐ3ν2αρέω
ἐ3ν2αρέα ἐ3ν2αρέα   % >e-nar'eac
ἐ3ν2αρεά ἐ3ν2αρεά
ἐ3ν2άριε ἐ3ν2άριε   % >e-n'ariec
ἐ3ν2αρίω ἐ3ν2αρίω
ἐ3ν2αρία ἐ3ν2αρία   % >e-nar'iac
ἐ3ν2αριά ἐ3ν2αριά
ἔ3ν2ασσ ἔ3ν2αϲϲ   % >'e-nassa <- na'iw
ἐ3ν2άσσ ἐ3ν2άσσ ἐ3ν2άϲϲ ἐ3ν2άϲϲ
ἐ3ν2άσθ ἐ3ν2άσθ ἐ3ν2άϲθ ἐ3ν2άϲθ
ἐ3ν2ασθ ἐ3ν2αϲθ
ἔ3ν2ατ   % >'e-natoc
ἐ3ν2άτ ἐ3ν2άτ
ἐνδυ2σ1τ ἐνδυ2ϲ1τ   % >endus-tuq'ew
ἐ3ν2έγκ ἐ3ν2έγκ   % >e-n'egkai
ἐ3ν2εγκ   % >e-negke~in
ἔ3ν2εικ   % >'e-neika
ἐ3ν2εῖκ   % >e-ne~ikai
ἐ3ν2εικ   % >e-neik'emen
ἐ3ν2είκ ἐ3ν2είκ   % >e-ne'ikeon
ἔ3ν2ειμ   % >e-neima, >e-ne'imamen
ἐ3ν2είμ ἐ3ν2είμ
ἐ3ν2εμέσσ ἐ3ν2εμέσσ ἐ3ν2εμέϲϲ ἐ3ν2εμέϲϲ   % >e-nem'essa
ἐ3ν2εμήθ ἐ3ν2εμήθ   % >e-nem'hjhn
ἐ3ν2ενή ἐ3ν2ενή   % >e-nen'hkonta
ἐ3ν2εό ἐ3ν2εό   % >e-ne'oc -'a -'on
ἐ3ν2εὸ
ἐ3ν2εο
ἐ3ν2εῶ
ἐ3ν2εά ἐ3ν2εά
ἐ3ν2εὰ
ἐ3ν2εᾶ
ἐ3ν2έπει ἐ3ν2έπει
ἔ3ν2ερθε   % >'e-nerje
ἔ3ν2ευσ ἔ3ν2ευϲ   % >'e-neusa
ἐ3ν2εύσ ἐ3ν2εύσ ἐ3ν2εύϲ ἐ3ν2εύϲ   % >e-ne'usomai
ἐ3ν2έχθ ἐ3ν2έχθ   % >e-n'eqjhti
ἐ3ν2εχθ
ἔ3ν2ησ ἔ3ν2ηϲ   % >'e-nhsa <- na'iw
ἐ3ν2ήσ ἐ3ν2ήσ ἐ3ν2ήϲ ἐ3ν2ήϲ
ἐ3ν2ηή ἐ3ν2ηή   % >e-nh'hc, -'ec
ἐ3ν2ηὴ
ἔ3ν2ην.   % >'e-nhn
ἐ3ν2ηεί ἐ3ν2ηεί   % >e-nhe'ih
ἐ3ν2ηο
ἐ3ν2ηῶ
ἐ3νηέ ἐ3νηέ
ἐ3ν2ήνο ἐ3ν2ήνο   % >e-n'hnoje
ἐ3ν2ί ἐ3ν2ί
ἐ3ν2ι
ἔ3ν2ι
ἐ4ν3ιαύ ἐ4ν3ιαύ   % >en-ia'uw
ἐ5ν4ιαύσ ἐ5ν4ιαύσ ἐ5ν4ιαύϲ ἐ5ν4ιαύϲ   % >e-nia'usioc
ἐ5ν4ιαυσ ἐ5ν4ιαυϲ
ἐ4ν3ιδρ   % >en-idr'ow
ἐ4ν3ίδρ ἐ4ν3ίδρ   % >en-'idrwsa
ἐ4ν3ίζ ἐ4ν3ίζ   % >en-'izw
ἐ4ν3ίη ἐ4ν3ίη   % >en-'ihmi, >en-'ieton, k.lp.
ἐ4ν3ιέτον. ἐ4ν3ιέτον.
ἐ4ν3ίεμεν. ἐ4ν3ίεμεν.
ἐ4ν3ίω. ἐ4ν3ίω.
ἐ4ν3ιππ   % >en-ippe'uw
ἐ4ν3ίππ ἐ4ν3ίππ   % >en-'ippeusa
ἐ4ν3ίπτ ἐ4ν3ίπτ   % >en-'iptw, >en-'iyw
ἐ4ν3ίψ ἐ4ν3ίψ
ἐ4ν3ίσσ ἐ4ν3ίσσ ἐ4ν3ίϲϲ ἐ4ν3ίϲϲ   % >en-'issw
ἐ4ν3ίστ ἐ4ν3ίστ ἐ4ν3ίϲτ ἐ4ν3ίϲτ   % >en-'isthmi, >en-ist~h|c, k.lp.
ἐ4ν3ιστ ἐ4ν3ιϲτ
ἐ4ν3ισχ ἐ4ν3ιϲχ   % >en-isq'uw
ἐ4ν3ίσχ ἐ4ν3ίσχ ἐ4ν3ίϲχ ἐ4ν3ίϲχ   % >en-'isqw
ἔ3ν2ος. ἔ3ν2οϲ.   % >'e-noc = >'e-nhc (>'allec pt'wseic???)
ἔ3ν2οσ.
ἔ3ν2ου.
ἔ3ν2ον.
ἔ3ν2ω
ἔ3ν2οι.
ἔ3ν2οις. ἔ3ν2οιϲ.
ἔ3ν2οισ.
ἔ3ν2ης. ἔ3ν2ηϲ.
ἔ3ν2ησ.
ἔ3ν2ῃ.
ἔ3ν2η.
ἔ3ν2οσι ἔ3ν2οϲι   % >'e-nosic
ἐ3ν2όσε ἐ3ν2όσε ἐ3ν2όϲε ἐ3ν2όϲε
ἐ3ν2υάλ ἐ3ν2υάλ   % >e-nu'alioc
ἐ3ν2υαλ
ἔ3ν2υξ   % >'e-nuxa
ἐ3ν2υξ   % >e-nux'athn
ἐ3ν2ύξ ἐ3ν2ύξ   % >e-n'uxamen
ἐ3ν2ύσ ἐ3ν2ύσ ἐ3ν2ύϲ ἐ3ν2ύϲ   % >e-n'ustaxa, >e-nust'axamen
ἐ3ν2υσ ἐ3ν2υϲ
ἐ3ν2υώ ἐ3ν2υώ   % >e-nu'w
ἐ3ν2υὼ
ἐ3ν2υόο ἐ3ν2υόο
ἐ3ν2υοῦς ἐ3ν2υοῦϲ
ἐ2ξ1
ἔ2ξ1
ἐ3ξ2ήρ ἐ3ξ2ήρ   % >e-x'hrammai
ἐ3ξ2ηρ   % >e-xhr'anjhn
ἐ3ξ2υ2ν1   % >exun-~hka
ἐ3ξ2υρ   % >e-xur'amhn
ἐ3ξ2ύρ ἐ3ξ2ύρ   % >e-x'urhmai
ἔ3ξ2υσ ἔ3ξ2υϲ   % >'e-xusmai
ἔ3ξ2ω.
ἑ2ξ1ήρετμ ἑ2ξ1ήρετμ   % <ex-'hretmoc
ἑ2ξ1ηρέτμ ἑ2ξ1ηρέτμ
ἐπεί2σ1 ἐπεί2σ1 ἐπεί2ϲ1 ἐπεί2ϲ1   % >epe'is-aktoc, k.lp.
ἐπει2σ1 ἐπει2ϲ1
ἐπεί3σ2ατον. ἐπεί3σ2ατον. ἐπεί3ϲ2ατον. ἐπεί3ϲ2ατον.   % >'epe'i-saton <- pe'ijw, >'epeisa
ἐπει3σ2άτην. ἐπει3σ2άτην. ἐπει3ϲ2άτην. ἐπει3ϲ2άτην.
ἐπεί3σ2αμεν. ἐπεί3σ2αμεν. ἐπεί3ϲ2αμεν. ἐπεί3ϲ2αμεν.
ἐπεί3σ2ατε ἐπεί3σ2ατε ἐπεί3ϲ2ατε ἐπεί3ϲ2ατε
ἐπει3σ2άμην. ἐπει3σ2άμην. ἐπει3ϲ2άμην. ἐπει3ϲ2άμην.
ἐπεί3σ2ω. ἐπεί3σ2ω. ἐπεί3ϲ2ω. ἐπεί3ϲ2ω.
ἐπεί3σ2ατο ἐπεί3σ2ατο ἐπεί3ϲ2ατο ἐπεί3ϲ2ατο
ἐπεί3σ2ασθον. ἐπεί3σ2ασθον. ἐπεί3ϲ2αϲθον. ἐπεί3ϲ2αϲθον.
ἐπει3σ2άμεθα. ἐπει3σ2άμεθα. ἐπει3ϲ2άμεθα. ἐπει3ϲ2άμεθα.
ἐπεί3σ2ασθε. ἐπεί3σ2ασθε. ἐπεί3ϲ2αϲθε. ἐπεί3ϲ2αϲθε.
ἐπεί3σ2αντο. ἐπεί3σ2αντο. ἐπεί3ϲ2αντο. ἐπεί3ϲ2αντο.
ἐπεί3σ2θ ἐπεί3σ2θ ἐπεί3ϲ2θ ἐπεί3ϲ2θ   % >epe'i-sjhn, >epeisj'hthn <- pe'ijw
ἐπει3σ2θ ἐπει3ϲ2θ
ἐπε2κ1τεί ἐπε2κ1τεί   % >epek-te'inw
ἐπέ2κ1τει ἐπέ2κ1τει
ἐπε2κ1τρ   % >epek-tr'eqw
ἐπέ2κ1τρ ἐπέ2κ1τρ
ἐπε2ξ1
ἐπε2σ1β ἐπε2ϲ1β   % >epes-b'oloc
ἐπιπρό2σ1θ ἐπιπρό2σ1θ ἐπιπρό2ϲ1θ ἐπιπρό2ϲ1θ   % >epipr'os-jetoc
ἐπιπρο2σ1θ ἐπιπρο2ϲ1θ
ἐπισυ2ν1 ἐπιϲυ2ν1   % >episun-agwg'h
ἐ2σ1 ἐ2ϲ1
ἐ3σ2άω ἐ3σ2άω ἐ3ϲ2άω ἐ3ϲ2άω   % >e-s'awjen
ἐ3σ2ημ ἐ3ϲ2ημ   % >e-shm'hnanto
ἐ3σ2θ ἐ3ϲ2θ   % >e-sj'ew
ἐ4σ3θέσ ἐ4σ3θέσ ἐ4ϲ3θέϲ ἐ4ϲ3θέϲ   % >es-j'esjai
ἐ3σ2ιγ ἐ3ϲ2ιγ   % >e-sig'ajhn
ἐ3σ2κ ἐ3ϲ2κ
ἐ4σ3κά ἐ4σ3κά ἐ4ϲ3κά ἐ4ϲ3κά   % >es-k'atjeto
ἐ4σ3κα ἐ4ϲ3κα   % >es-kataba'inw
%
ἐ3σ2μὲν. ἐ3ϲ2μὲν. ἐ3σ2μέν. ἐ3σ2μέν. ἐ3ϲ2μέν. ἐ3ϲ2μέν.   % e>im'i, >esm'en, >est'i, k.lp.
ἐ3σ2τ ἐ3ϲ2τ
ἐ3σ2όμεθα ἐ3σ2όμεθα ἐ3ϲ2όμεθα ἐ3ϲ2όμεθα
ἐ3σ2οίμην ἐ3σ2οίμην ἐ3ϲ2οίμην ἐ3ϲ2οίμην
ἐ3σ2όμ ἐ3σ2όμ ἐ3ϲ2όμ ἐ3ϲ2όμ   % >e-s'omenoc, -h, -on
ἐ3σ2ομ ἐ3ϲ2ομ
ἐ3σ2οῦ ἐ3ϲ2οῦ   % >e-so~umai (dwr./ >'alla pr'oswpa???)
ἐ3σ2ού ἐ3σ2ού ἐ3ϲ2ού ἐ3ϲ2ού   %%%TS%%%
ἐ3σ2ου ἐ3ϲ2ου   %%%TS%%% ????
%
ἐ3σ2υ ἐ3ϲ2υ   % >e-s'urhn <- s'uromai
ἐ3σ2ύ ἐ3σ2ύ ἐ3ϲ2ύ ἐ3ϲ2ύ
ἐσύ2ν1 ἐσύ2ν1 ἐϲύ2ν1 ἐϲύ2ν1   % >es'un-hka
ἐσυ2ν1 ἐϲυ2ν1
ἐ3σ2χ ἐ3ϲ2χ
ἐ4σ3χέ ἐ4σ3χέ ἐ4ϲ3χέ ἐ4ϲ3χέ   % >es-q'ew
ἐ3σ2ώ ἐ3σ2ώ ἐ3ϲ2ώ ἐ3ϲ2ώ
ἐ3σ2ω ἐ3ϲ2ω
ἔ2σ1οπ ἔ2ϲ1οπ   % >'es-optroc
εὐε2ξ1   % >euex-'alepiptoc
εὐε3ξ2ί εὐε3ξ2ί   % >eue-x'ia
εὐε3ξ2ι
εὐπρό2σ1 εὐπρό2σ1 εὐπρό2ϲ1 εὐπρό2ϲ1   % e>upr'os-dektoc
εὐπρο2σ1 εὐπρο2ϲ1
εὐσύ2ν1 εὐσύ2ν1 εὐϲύ2ν1 εὐϲύ2ν1   % e>us'un-etoc
εὐσυ2ν1 εὐϲυ2ν1
εὐξύ2ν1 εὐξύ2ν1   % e>ux'un-etoc
εὐξυ2ν1
ἐω2σ1φ ἐω2ϲ1φ   % >ews-f'oroc
ἤ2ν1οψ.   % >'hn-oy
ἤ2ν1οπ
ἠ2ν1όπ ἠ2ν1όπ
.θεμι2σ1κρ .θεμι2ϲ1κρ   % jemis-kr'ewn
.θεό2σ1δ .θεό2σ1δ .θεό2ϲ1δ .θεό2ϲ1δ   % je'os-dotoc
.θεο2σ1δ .θεο2ϲ1δ
.θεοι2σ1εχθρ .θεοι2ϲ1εχθρ   % jeois-eqjr'ia
.θη2ρ1αγρ   % jhr-agr'ethc
.θυο2σ1κ .θυο2ϲ1κ   % juos-k'ew juos-k'ooc
.καθυπε2ρ1   % kajuper-akont'izw
.καλω2σ1ορ .καλω2ϲ1ορ   % kalws-or'izw kalws-'orisa
.καλω2σ1όρ .καλω2σ1όρ .καλω2ϲ1όρ .καλω2ϲ1όρ
.κα2ν1είς. .κα2ν1είς. .κα2ν1είϲ. .κα2ν1είϲ.   % kan-e'ic
.κα2ν1εὶς. .κα2ν1εὶϲ.
.κα2ν1είσ. .κα2ν1είσ.
.κα2ν1εὶσ.
.κα2ν1εν
.κα2ν1έν .κα2ν1έν
.καταδυ2σ1ωπ .καταδυ2ϲ1ωπ   % katadus-wp'ew
.κατεδυ2σ1ώπ .κατεδυ2σ1ώπ .κατεδυ2ϲ1ώπ .κατεδυ2ϲ1ώπ   % katedus-'wpesa
.κατει2σ1 .κατει2ϲ1   % kateis-'agw
.κατε2ν1αί .κατε2ν1αί   % katen-a'iromai
.κατε2ν1ή .κατε2ν1ή   % katen-'hraro
.κατε2ξ1α2ν1ί .κατε2ξ1α2ν1ί   % katex-an-'isthmi
.κατε2ξ1α2ν1έσ .κατε2ξ1α2ν1έσ .κατε2ξ1α2ν1έϲ .κατε2ξ1α2ν1έϲ   % katex-an-'esthn
.κερα2σ1φ .κερα2ϲ1φ   % keras-f'oroc
.κρά2σ1π .κρά2σ1π .κρά2ϲ1π .κρά2ϲ1π   % kr'as-pedon
.κρα2σ1π .κρα2ϲ1π
.κυνό2σ1α .κυνό2σ1α .κυνό2ϲ1α .κυνό2ϲ1α   % Kun'os-argec
.κυνό2σ1β .κυνό2σ1β .κυνό2ϲ1β .κυνό2ϲ1β   % kun'os-batoc
.κυνο2σ1β .κυνο2ϲ1β
.κυνό2σ1ο .κυνό2σ1ο .κυνό2ϲ1ο .κυνό2ϲ1ο   % kun'os-oura
.κυνο2σ1ο .κυνο2ϲ1ο
.κυνο2σ1φ .κυνο2ϲ1φ   % Kunos-fan'h (<h <Ek'ath, je`a t~hc Sel'hnhc)
.μελα2ν1άγ .μελα2ν1άγ   % melan-'agrioc
.μελα2ν1αγ
.μελα2ν1άε .μελα2ν1άε   % melan-'aetoc
.μελα2ν1αέ .μελα2ν1αέ
.μελα2ν1αθ   % melan-aj'hr
.μελα2ν1αιγ   % melan-aig'ic
.μελα2ν1αυγ   % melan-aug'hc
.μελα2ν1είμ .μελα2ν1είμ   % melan-e'imwn
.μελα2ν1εῖμ   % melan-e~imon
.μελά2ν1ιππ .μελά2ν1ιππ   % mel'an-ippoc
.μελα2ν1ίππ .μελα2ν1ίππ
.μελα2ν1όμμ .μελα2ν1όμμ   % melan-'ommatoc
.μελα2ν1ομμ
.μελά2ν1οσσ .μελά2ν1οσσ .μελά2ν1οϲϲ .μελά2ν1οϲϲ   % mel'an-ossoc
.μελα2ν1όσσ .μελα2ν1όσσ .μελα2ν1όϲϲ .μελα2ν1όϲϲ
.μελά2ν1οστ .μελά2ν1οστ .μελά2ν1οϲτ .μελά2ν1οϲτ   % mel'an-ostoc
.μελα2ν1όστ .μελα2ν1όστ .μελα2ν1όϲτ .μελα2ν1όϲτ
.μελά2ν1ουρ .μελά2ν1ουρ   % mel'an-ouroc
.μελα2ν1ούρ .μελα2ν1ούρ
.μελα2ν1ουρ   % melan-our'ic
.μελά2ν1υ .μελά2ν1υ   % mel'an-udroc
.μελα2ν1ύ .μελα2ν1ύ
.μετε2ξ1α   % metex-an'istamai
.μετε2ξ1έ .μετε2ξ1έ   % metex-'eteroi
.μετε2ξ1ε
.μογι2σ1 .μογι2ϲ1   % mogis-ayed'afa
.μογο2σ1τ .μογο2ϲ1τ   % mogos-t'okoc
.μυ2σ1π .μυ2ϲ1π   % mus-pol'ew
.μυ2σ1επ .μυ2ϲ1επ   % mus-ep'olesa
.νεώ2σ1οικ .νεώ2σ1οικ .νεώ2ϲ1οικ .νεώ2ϲ1οικ   % ne'ws-oikoc
.νεω2σ1οίκ .νεω2σ1οίκ .νεω2ϲ1οίκ .νεω2ϲ1οίκ
.νου2ν1ε   % noun-eq'hc
.ξυ2ν1αγ   % xun-age'irato = sun-age'irato <- sunage'irw
.ξυ2ν1ε
.ξυ2ν1έ .ξυ2ν1έ
.ξύ2ν1ε .ξύ2ν1ε
.ξυ3ν2εώ .ξυ3ν2εώ   % xu-ne'wn
.ξυ3ν2εῶ
.ξυ2ν1ῆκ   % xun-~hka <- xun-'ihmi
.ξύ2ν1ι .ξύ2ν1ι   % x'un-ie <- xun-'ihmi
.ξυ2ν1ί .ξυ2ν1ί   % xun-'iei <- xun-'ihmi
οἱο2ν1εί. οἱο2ν1εί.   % o<ion-e'i
οἱο2ν1εὶ.
οἱό2σ1 οἱό2σ1 οἱό2ϲ1 οἱό2ϲ1   % o<i'os-per o<i'os-te
οἰ2σ1πώτ οἰ2σ1πώτ οἰ2ϲ1πώτ οἰ2ϲ1πώτ   % o>is-p'wth
οἰ2σ1πωτ οἰ2ϲ1πωτ
ὁλο2ν1έν. ὁλο2ν1έν.
ὁλο2ν1ὲν.
ὁπω2σ1 ὁπω2ϲ1   % <'opws-o~un
ὅ2σ1γε. ὅ2ϲ1γε.   % <'os-ge
ὁσο2ν1ῶν. ὁϲο2ν1ῶν.   % <oson-~wn
ὅ2σ1περ. ὅ2ϲ1περ.   % <'os-per
ὅ2σ1τις ὅ2ϲ1τιϲ   % <'os-tic
οἷ2σ1τισι οἷ2ϲ1τιϲι   % o<~is-tisi(n)
οὕ2σ1τινας οὕ2ϲ1τιναϲ   % o<'us-tinac
ἧ2σ1τινος ἧ2ϲ1τινοϲ   % <~hs-tinoc
αἷ2σ1τισι αἷ2ϲ1τιϲι   % a<~is-tisi(n)
ἅ2σ1τινας ἅ2ϲ1τιναϲ   % <'as-tinac
ὁ2σ1τι2σ1οῦν. ὁ2ϲ1τι2ϲ1οῦν.   % <os-tis-o~un
ἡτι2σ1οῦν. ἡτι2ϲ1οῦν.   % <htis-o~un
ὁποιου2σ1τινα2σ1οῦν. ὁποιου2ϲ1τινα2ϲ1οῦν.   % <opoious-tinas-o~un
οὐδενό2σ1ω οὐδενό2σ1ω οὐδενό2ϲ1ω οὐδενό2ϲ1ω   % o>uden'os-wroc
οὐδενο2σ1ώ οὐδενο2σ1ώ οὐδενο2ϲ1ώ οὐδενο2ϲ1ώ
.παλι2ν1   % palin-'agretoc
.παλί2ν1 .παλί2ν1   % pal'in-orsoc
.πα2ν1
.πά2ν1 .πά2ν1
.πα3ν2ός. .πα3ν2ός. .πα3ν2όϲ. .πα3ν2όϲ.   % pa-n'oc <- P'an (je'oc)
.πα3ν2ὸς. .πα3ν2ὸϲ.
.πα3ν2όσ. .πα3ν2όσ.
.πα3ν2ὸσ.
.πα3ν2ί. .πα3ν2ί.
.πα3ν2ὶ.
.πάνα. .πάνα.
.πα3ν2ῶν.
.πα3ν2ικ   % pa-nik'oc
.πα3ν2ίσδ .πα3ν2ίσδ .πα3ν2ίϲδ .πα3ν2ίϲδ   % pa-n'isdomai
.πα3ν2ισδ .πα3ν2ιϲδ   % pa-nisd'omhn
.πα3ν2οῦ.   % pa-no~u, k.lp. (pan'oc = fan'oc)
.πα3ν2ῷ.
.πα3ν2ό. .πα3ν2ό.
.πα3ν2ὸ.
.πα3ν2όν. .πα3ν2όν.
.πα3ν2ὸν.
.πα3ν2έ. .πα3ν2έ.
.πα3ν2ὲ.
.πα3ν2οί. .πα3ν2οί.
.πα3ν2οὶ.
.πα3ν2οῖς. .πα3ν2οῖϲ.
.πα3ν2οῖσ.
.πα3ν2ούς. .πα3ν2ούς. .πα3ν2ούϲ. .πα3ν2ούϲ.
.πα3ν2οὺς. .πα3ν2οὺϲ.
.πα3ν2ούσ. .πα3ν2ούσ.
.πα3ν2οὺσ.
.παρα2ν1ίσχ .παρα2ν1ίσχ .παρα2ν1ίϲχ .παρα2ν1ίϲχ   % paran-'isqw
.παρεί2σ1 .παρεί2σ1 .παρεί2ϲ1 .παρεί2ϲ1   % pare'is-aktoc
.παρει2σ1 .παρει2ϲ1
.παρε2κ1λ   % parek-l'egw
.παρε2κ1τρ   % parek-tr'epw
.παρε2ν1εῖ   % paren-e~idon
.παρε2ν1ο   % paren-oql'ew
.παρε2ξ1
.παρέ2ξ1 .παρέ2ξ1
παρέ3ξ2ω. παρέ3ξ2ω.   % par'e-xw, par'e-xomai <- par'eqw
παρέ3ξ2εις. παρέ3ξ2εις. παρέ3ξ2ειϲ. παρέ3ξ2ειϲ.
παρέ3ξ2εισ. παρέ3ξ2εισ.
παρέ3ξ2ει. παρέ3ξ2ει.
παρέ3ξ2ετον. παρέ3ξ2ετον.
παρε3ξ2έτην. παρε3ξ2έτην.
παρέ3ξ2ομεν. παρέ3ξ2ομεν.
παρέ3ξ2ετε. παρέ3ξ2ετε.
παρέ3ξ2ουσι. παρέ3ξ2ουσι. παρέ3ξ2ουϲι. παρέ3ξ2ουϲι.
	%
παρέ3ξ2ομαι παρέ3ξ2ομαι
παρέ3ξ2ῃ παρέ3ξ2ῃ
παρέ3ξ2εται. παρέ3ξ2εται.
παρέ3ξ2εσθον. παρέ3ξ2εσθον. παρέ3ξ2εϲθον. παρέ3ξ2εϲθον.
παρε3ξ2όμεθα. παρε3ξ2όμεθα.
παρέ3ξ2εσθε. παρέ3ξ2εσθε. παρέ3ξ2εϲθε. παρέ3ξ2εϲθε.
παρέ3ξ2ονται. παρέ3ξ2ονται.
.πλεο2ν1έ .πλεο2ν1έ   % pleon-'ekthma
.πλεο2ν1ε
.προει2σ1 .προει2ϲ1   % proeis-'agw
.προε2κ1   % proek-l'egw
.προε2ν1   % proen-'arqomai
.προε2ξ1   % proex-agg'elw
.προέ2ξ1 .προέ2ξ1   % pro'ex-eimi
.προ2σ1 .προ2ϲ1
.προ3σ2άβ .προ3σ2άβ .προ3ϲ2άβ .προ3ϲ2άβ   % pro-s'abbatoc
.προ3σ2αβ .προ3ϲ2αβ
.προσει2σ1 .προϲει2ϲ1   % proseis-pr'assw, k.lp.
.προ3σ2εί .προ3σ2εί .προ3ϲ2εί .προ3ϲ2εί   % pro-se'iw, pro-s'eseisa, pro-sese'isjhn
.προ3σ2έσει .προ3σ2έσει .προ3ϲ2έϲει .προ3ϲ2έϲει
.προ3σ2εσεί .προ3σ2εσεί .προ3ϲ2εϲεί .προ3ϲ2εϲεί
.προσε2ν1 .προϲε2ν1   % prosen-equr'azw
.προσε2ξ1 .προϲε2ξ1   % prosex-air'eomai
.πρό3σ2θι .πρό3σ2θι .πρό3ϲ2θι .πρό3ϲ2θι   % pr'o-sjioc
.προ3σ2θί .προ3σ2θί .προ3ϲ2θί .προ3ϲ2θί
.προ4σ3θιγ .προ4ϲ3θιγ   % pro-sjigg'aw
.πρό3σ2κοπ .πρό3σ2κοπ .πρό3ϲ2κοπ .πρό3ϲ2κοπ   % pr'o-skopoc != pros-k'optw
.προ3σ2κόπ .προ3σ2κόπ .προ3ϲ2κόπ .προ3ϲ2κόπ
.προ3σ2τασ .προ3ϲ2ταϲ   % pro-stas'ia
.προ3σ2τάτ .προ3σ2τάτ .προ3ϲ2τάτ .προ3ϲ2τάτ   % pro-st'athc
.προ3σ2τατ .προ3ϲ2τατ   % pro-state'uw
.προ3σ2ταυ .προ3ϲ2ταυ   % pro-staur'ow
.προ3σ2τεί .προ3σ2τεί .προ3ϲ2τεί .προ3ϲ2τεί   % pro-ste'iqw
.προ3σ2τεν .προ3ϲ2τεν   % pro-sten'azw
.προ3σ2τέν .προ3σ2τέν .προ3ϲ2τέν .προ3ϲ2τέν   % pro-st'enw
.προ3σ2τερν .προ3ϲ2τερν   % pro-stern'idio
.πρό3σ2τερν .πρό3σ2τερν .πρό3ϲ2τερν .πρό3ϲ2τερν   % pr'o-sternon
.προ3σ2τέρν .προ3σ2τέρν .προ3ϲ2τέρν .προ3ϲ2τέρν
.προ3σ2τήσ .προ3σ2τήσ .προ3ϲ2τήϲ .προ3ϲ2τήϲ   % pro-st'hsac
.προ3σ2τόμ .προ3σ2τόμ .προ3ϲ2τόμ .προ3ϲ2τόμ   % pro-st'omion
.προ3σ2τομ .προ3ϲ2τομ
.πρό3σ2τῳ .πρό3σ2τῳ .πρό3ϲ2τῳ .πρό3ϲ2τῳ   % pr'o-stw|on
.προ3σ2τῴ .προ3ϲ2τῴ
.προ3σ2υγ .προ3ϲ2υγ   % pro-sugg'ignomai
.προ3σ2υμ .προ3ϲ2υμ   % pro-summ'isgw
.προ3σ2υ2ν1 .προ3ϲ2υ2ν1   % pro-sun-oik'ew
.πρό3σ2φαγμ .πρό3σ2φαγμ .πρό3ϲ2φαγμ .πρό3ϲ2φαγμ   % pr'o-sfagma
.προ3σ2φάγμ .προ3σ2φάγμ .προ3ϲ2φάγμ .προ3ϲ2φάγμ
.προ3σ2φάζ .προ3σ2φάζ .προ3ϲ2φάζ .προ3ϲ2φάζ   % pro-sf'azw
.προ3σ2φάττ .προ3σ2φάττ .προ3ϲ2φάττ .προ3ϲ2φάττ   % pro-sf'attw
.πρό3σ2χημ .πρό3σ2χημ .πρό3ϲ2χημ .πρό3ϲ2χημ   % pr'o-sqhma
.προ3σ2χήμ .προ3σ2χήμ .προ3ϲ2χήμ .προ3ϲ2χήμ
.πρό3σ2ω. .πρό3σ2ω. .πρό3ϲ2ω. .πρό3ϲ2ω.
.πρό3σ2ωθεν. .πρό3σ2ωθεν. .πρό3ϲ2ωθεν. .πρό3ϲ2ωθεν.
.προ3σ2ώτ .προ3σ2ώτ .προ3ϲ2ώτ .προ3ϲ2ώτ   % pro-s'wtatoc
.προ3σ2ωτ .προ3ϲ2ωτ
.προϋπε2ξ1   % pro"upex-orm'aw
.πυ2ρ1άγ .πυ2ρ1άγ   % pur-'agra
.πυ2ρ1αγ
.πυ2ρ1αίθ .πυ2ρ1αίθ   % pur-a'ijw
.πυ2ρ1αιθ   % pur-aij'onwn (gen. plhj. to~u pur-a'ijwn)
.πυ2ρ1ῆθ   % pur-~hjon (pur-a'ijw)
.πυ2ρ1ηθ   % pur-hj'ethn??? (pur-a'ijw)
.πυ2ρ1ήθ .πυ2ρ1ήθ   % pur-'hjomen??? (pur-a'ijw)
.πυ2ρ1ακ   % pur-akt'ew
.πύ2ρ1αυ .πύ2ρ1αυ   % p'ur-auloc
.πυ2ρ1αύ .πυ2ρ1αύ
.πυ2ρ1αυ   % pur-aug'hc
.πυ2ρ1ήνεμ .πυ2ρ1ήνεμ   % pur-'hnemoc
.πυ2ρ1ηνέμ .πυ2ρ1ηνέμ
.πυ2ρ1ωπ   % pur-wp'oc
.σελα2σ1φό .σελα2σ1φό .ϲελα2ϲ1φό .ϲελα2ϲ1φό   % selas-f'oroc
.σελα2σ1φο .ϲελα2ϲ1φο
.συμπαρει2σ1 .ϲυμπαρει2ϲ1   % sumpareis-'erqomai
.συ2ν1 .ϲυ2ν1
.σύ2ν1 .σύ2ν1 .ϲύ2ν1 .ϲύ2ν1   % s'un-auloc, k.>'a.<'o.
.συνδιέ2ξ1 .συνδιέ2ξ1 .ϲυνδιέ2ξ1 .ϲυνδιέ2ξ1   % sundi'ex-eimi
.συνδιε2ξ1 .ϲυνδιε2ξ1   % sundiex-i'enai
.συνδυ2σ1 .ϲυνδυ2ϲ1   % sundus-tuq'ew
.συνε2ξ1 .ϲυνε2ξ1   % sunex-'agw
.τεσσαρε2σ1κ .τεϲϲαρε2ϲ1κ   % tessares-ka'ideka
.τρει2σ1κ .τρει2ϲ1κ   % treic-ka'ideka
.τρι2σ1 .τρι2ϲ1
.τρι3σ2μό .τρι3σ2μό .τρι3ϲ2μό .τρι3ϲ2μό   % tri-sm'oc
.τρι3σ2μο .τρι3ϲ2μο
.τρι3σ2μῶ .τρι3ϲ2μῶ
.τρι3σ2π .τρι3ϲ2π   % tri-sp'ijamoc
.τρί3σ2τ .τρί3σ2τ .τρί3ϲ2τ .τρί3ϲ2τ   % tr'i-stegoc
.τρι3σ2τ .τρι3ϲ2τ
.τρι3σ2ώ .τρι3σ2ώ .τρι3ϲ2ώ .τρι3ϲ2ώ   % tri-s'wmatoc
.τρι3σ2ω .τρι3ϲ2ω
ὑο2σ1κ ὑο2ϲ1κ   % <uos-k'uamoc
ὑπεί2σ1 ὑπεί2σ1 ὑπεί2ϲ1 ὑπεί2ϲ1
ὑπει2σ1 ὑπει2ϲ1
ὑπεί3σ2ας ὑπεί3σ2ας ὑπεί3ϲ2αϲ ὑπεί3ϲ2αϲ   % <upe'i-sac = <ufe'i-sac <- <uf'ihmi
ὑπεί3σ2ασ ὑπεί3σ2ασ
ὑπεί3σ2αν ὑπεί3σ2αν ὑπεί3ϲ2αν ὑπεί3ϲ2αν
ὑπει3σ2άν ὑπει3σ2άν ὑπει3ϲ2άν ὑπει3ϲ2άν
ὑπει3σ2άσ ὑπει3σ2άσ ὑπει3ϲ2άϲ ὑπει3ϲ2άϲ
ὑπε2κ1λαμ   % <upek-lamb'anw
ὑπε2κ1λήψ ὑπε2κ1λήψ   % <upek-l'hyomai
ὑπε2κ1τ   % <upek-tan'uw <upek-t'ijhmi <upek-tr'epw
ὑπε2ν1
ὑπε2ξ1
ὑπε2ρ1
ὑπέ2ρ1 ὑπέ2ρ1
ὑπέ3ρ2α. ὑπέ3ρ2α.   % <up'e-ra
ὑπέ3ρ2ης. ὑπέ3ρ2ης. ὑπέ3ρ2ηϲ. ὑπέ3ρ2ηϲ.
ὑπέ3ρ2ησ. ὑπέ3ρ2ησ.
ὑπέ3ρ2ᾳ. ὑπέ3ρ2ᾳ.
ὑπέ3ρ2αν. ὑπέ3ρ2αν.
ὑπέ3ρ2αι. ὑπέ3ρ2αι.
ὑπε3ρ2ῶν.
ὑπέ3ρ2αις. ὑπέ3ρ2αις. ὑπέ3ρ2αιϲ. ὑπέ3ρ2αιϲ.
ὑπέ3ρ2αισ. ὑπέ3ρ2αισ.
ὑπέ3ρ2ας. ὑπέ3ρ2ας. ὑπέ3ρ2αϲ. ὑπέ3ρ2αϲ.
ὑπέ3ρ2ασ. ὑπέ3ρ2ασ.
ὑπε3ρ2εθ   % <upe-rej'izw <upe-r'ejison
ὑπε3ρ2έθ ὑπε3ρ2έθ
ὑπε3ρ2εί ὑπε3ρ2εί   % <upe-re'idw <upe-re'ipw
ὑπέ3ρ2υθ ὑπέ3ρ2υθ   % <up'e-rujroc
ὑπε3ρ2ύθ ὑπε3ρ2ύθ
ὑπε3ρ2υθ   % <upe-rujr'ew
ὑπερε2κ1τε   % <uperek-te'inw
ὑπερε2κ1τί ὑπερε2κ1τί   % <uperek-t'inw
ὑπε3ρ2έπτ ὑπε3ρ2έπτ   % <upe-r'eptw, <upe-r'eyw
ὑπε3ρ2επτ
ὑπε3ρ2έψ ὑπε3ρ2έψ
ὑπε3ρ2εψ
ὑπε3ρ2έω ὑπε3ρ2έω   % <upe-r'ew (-~w) <- <upe~ipon
ὑπε3ρ2ῶ
ὑπε3ρ2έε ὑπε3ρ2έε
ὑπε3ρ2εῖς. ὑπε3ρ2εῖϲ.
ὑπε3ρ2εῖσ.
ὑπε3ρ2εῖ.
ὑπε3ρ2έο ὑπε3ρ2έο
ὑπε3ρ2οῦ
ὑπε3ρ2εῖτ
ὑπε3ρ2ώ ὑπε3ρ2ώ   % <upe-r'w|a
ὑπε3ρ2ω   % <upe-rw'ew
ὕ2σ1τρ ὕ2ϲ1τρ   % <'us-trix
ὑ2σ1τρ ὑ2ϲ1τρ   % <us-triq'ic
.φαε2σ1φ .φαε2ϲ1φ   % faes-f'oroc
.φω2σ1φ .φω2ϲ1φ   % fws-f'oroc
.χαρι2σ1ανδρ .χαρι2ϲ1ανδρ   % qar'is-androc
.χαρι2σ1άνδρ .χαρι2σ1άνδρ .χαρι2ϲ1άνδρ .χαρι2ϲ1άνδρ
.χει2ρ1άγ .χει2ρ1άγ   % qeir-'agra
.χει2ρ1αγ   % qeir-agwg'oc
.χει2ρ1απ   % qeir-apt'azw
.χει2ρ1αψ   % qeir-ay'ia
.χει2ρ1ου   % qeir-ourg'oc
.χει2ρ1ῶν   % qeir-~wnax
.χει2ρ1άν .χει2ρ1άν
.χει2ρ1αν
.χη2ν1ναλ   % qhn-al'wphx
ὡ2σ1α2ν1εί. ὡ2σ1α2ν1εί. ὡ2ϲ1α2ν1εί. ὡ2ϲ1α2ν1εί.   % <ws-an-e'i
ὡ2σ1α2ν1εὶ. ὡ2ϲ1α2ν1εὶ.
ὡ2σ1αύτως. ὡ2σ1αύτως. ὡ2ϲ1αύτωϲ. ὡ2ϲ1αύτωϲ.   % <ws-a'utwc
ὡ2σ1αύτωσ. ὡ2σ1αύτωσ.
ὡ2σ1εί. ὡ2σ1εί. ὡ2ϲ1εί. ὡ2ϲ1εί.   % <ws-e'i
ὡ2σ1εὶ. ὡ2ϲ1εὶ.
ὥ2σ1περ. ὥ2ϲ1περ.   % <'ws-per
ὡ2σ1πε2ρ1εί. ὡ2σ1πε2ρ1εί. ὡ2ϲ1πε2ρ1εί. ὡ2ϲ1πε2ρ1εί.   % <ws-per-e'i
ὡ2σ1πε2ρ1εὶ. ὡ2ϲ1πε2ρ1εὶ.
ὥ2σ1τε ὥ2ϲ1τε   % <'ws-te
%%%%
%%%%
ι2σ1χίλιοι. ι2σ1χίλιοι. ι2ϲ1χίλιοι. ι2ϲ1χίλιοι.   % dis-q'ilioi, k.>'a.<'o.
ι2σ1χιλίων. ι2σ1χιλίων. ι2ϲ1χιλίων. ι2ϲ1χιλίων.
ι2σ1χιλίοις. ι2σ1χιλίοις. ι2ϲ1χιλίοιϲ. ι2ϲ1χιλίοιϲ.
ι2σ1χιλίοισ. ι2σ1χιλίοισ.
ι2σ1χιλίους. ι2σ1χιλίους. ι2ϲ1χιλίουϲ. ι2ϲ1χιλίουϲ.
ι2σ1χιλίουσ. ι2σ1χιλίουσ.
ι2σ1χίλιαι. ι2σ1χίλιαι. ι2ϲ1χίλιαι. ι2ϲ1χίλιαι.
ι2σ1χιλίαις. ι2σ1χιλίαις. ι2ϲ1χιλίαιϲ. ι2ϲ1χιλίαιϲ.
ι2σ1χιλίαισ. ι2σ1χιλίαισ.
ι2σ1χιλίας. ι2σ1χιλίας. ι2ϲ1χιλίαϲ. ι2ϲ1χιλίαϲ.
ι2σ1χιλίασ. ι2σ1χιλίασ.
ι2σ1χίλια. ι2σ1χίλια. ι2ϲ1χίλια. ι2ϲ1χίλια.
%
ι2σ1μύριοι. ι2σ1μύριοι. ι2ϲ1μύριοι. ι2ϲ1μύριοι.   % dis-m'urioi, k.>'a.<'o.
ι2σ1μυρίων. ι2σ1μυρίων. ι2ϲ1μυρίων. ι2ϲ1μυρίων.
ι2σ1μυρίοις. ι2σ1μυρίοις. ι2ϲ1μυρίοιϲ. ι2ϲ1μυρίοιϲ.
ι2σ1μυρίοισ. ι2σ1μυρίοισ.
ι2σ1μυρίους. ι2σ1μυρίους. ι2ϲ1μυρίουϲ. ι2ϲ1μυρίουϲ.
ι2σ1μυρίουσ. ι2σ1μυρίουσ.
ι2σ1μύριαι. ι2σ1μύριαι. ι2ϲ1μύριαι. ι2ϲ1μύριαι.
ι2σ1μυρίαις. ι2σ1μυρίαις. ι2ϲ1μυρίαιϲ. ι2ϲ1μυρίαιϲ.
ι2σ1μυρίαισ. ι2σ1μυρίαισ.
ι2σ1μυρίας. ι2σ1μυρίας. ι2ϲ1μυρίαϲ. ι2ϲ1μυρίαϲ.
ι2σ1μυρίασ. ι2σ1μυρίασ.
ι2σ1μύρια. ι2σ1μύρια. ι2ϲ1μύρια. ι2ϲ1μύρια.
%
ι2σ1χιλιοστ ι2ϲ1χιλιοϲτ   % dis-qiliost'oc, k.>'a.<'o.
%
ι2σ1μυριοστ ι2ϲ1μυριοϲτ   % dis-muriost'oc, k.>'a.<'o.
%
ι2σ1χιλιάκις. ι2σ1χιλιάκις. ι2ϲ1χιλιάκιϲ. ι2ϲ1χιλιάκιϲ.   % dis-qili'akic, k.>'a.<'o.
ι2σ1χιλιάκισ. ι2σ1χιλιάκισ.
%
ι2σ1μυριάκις. ι2σ1μυριάκις. ι2ϲ1μυριάκιϲ. ι2ϲ1μυριάκιϲ.   % dis-muri'akic, k.>'a.<'o.
ι2σ1μυριάκισ. ι2σ1μυριάκισ.
}


