## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Gl_ec 0.102;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Gl_ec::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Gl_ec> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-gl.ec.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: galician (gl)
% encoding: ec
%
% This file has been auto-generated from hyph-gl.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E1="E1
\lccode"E9="E9
\lccode"ED="ED
\lccode"EF="EF
\lccode"F1="F1
\lccode"F3="F3
\lccode"FA="FA
\patterns{
3^^ef3a
a1a
e1e
o1o
zo2o
a1^^e1
e1^^e9
o1^^f3
2ai.
2au.
2ei.
2eu.
2oi.
2ou.
a1ia
a1ie
a1io
a1i^^e1
e1ia
e1ie
e1io
e1i^^e1
o1ia
o1ie
o1io
o1i^^e1
u1ia
u1ie
u1io
u1i^^e1
2ia.
2ie.
2io.
2i^^e1.
1^^f1
1ba
1be
1bi
1bo
1bu
1b^^e1
1b^^e9
1b^^ed
1b^^f3
1b^^fa
1ca
1ce
1ci
1co
1cu
1c^^e1
1c^^e9
1c^^ed
1c^^f3
1c^^fa
1da
1de
1di
1do
1du
1d^^e1
1d^^e9
1d^^ed
1d^^f3
1d^^fa
1fa
1fe
1fi
1fo
1fu
1f^^e1
1f^^e9
1f^^ed
1f^^f3
1f^^fa
1ga
1ge
1gi
1go
1gu
1g^^e1
1g^^e9
1g^^ed
1g^^f3
1g^^fa
1ha
1he
1hi
1ho
1hu
1h^^e1
1h^^e9
1h^^ed
1h^^f3
1h^^fa
1ka
1ke
1ki
1ko
1ku
1k^^e1
1k^^e9
1k^^ed
1k^^f3
1k^^fa
1la
1le
1li
1lo
1lu
1l^^e1
1l^^e9
1l^^ed
1l^^f3
1l^^fa
1ma
1me
1mi
1mo
1mu
1m^^e1
1m^^e9
1m^^ed
1m^^f3
1m^^fa
1na
1ne
1ni
1no
1nu
1n^^e1
1n^^e9
1n^^ed
1n^^f3
1n^^fa
1pa
1pe
1pi
1po
1pu
1p^^e1
1p^^e9
1p^^ed
1p^^f3
1p^^fa
1ra
1re
1ri
1ro
1ru
1r^^e1
1r^^e9
1r^^ed
1r^^f3
1r^^fa
1sa
1se
1si
1so
1su
1s^^e1
1s^^e9
1s^^ed
1s^^f3
1s^^fa
1ta
1te
1ti
1to
1tu
1t^^e1
1t^^e9
1t^^ed
1t^^f3
1t^^fa
1va
1ve
1vi
1vo
1vu
1v^^e1
1v^^e9
1v^^ed
1v^^f3
1v^^fa
1xa
1xe
1xi
1xo
1xu
1x^^e1
1x^^e9
1x^^ed
1x^^f3
1x^^fa
1za
1ze
1zi
1zo
1zu
1z^^e1
1z^^e9
1z^^ed
1z^^f3
1z^^fa
1qu2
1c2h
2ch.
1g2h
2gh.
2k2h
1b2l
1b2r
1c2l
1c2r
1d2l
1d2r
1f2l
1f2r
1g2l
1g2r
1k2l
1k2r
1p2l
1p2r
2t2l
1t2r
1v2l
1v2r
2bl.
2br.
2cl.
2cr.
2dl.
2dr.
2fl.
2fr.
2gl.
2gr.
2kl.
2kr.
2pl.
2pr.
2tr.
2vl.
2vr.
1l4l
2ll.
1r2r
2rr.
b1p2t
c1p2t
d1p2t
l1p2t
m1p2t
n1p2t
r1p2t
s1p2t
t1p2t
x1p2t
b1c2t
c1c2t
d1c2t
l1c2t
m1c2t
n1c2t
r1c2t
s1c2t
t1c2t
x1c2t
b1c2n
c1c2n
d1c2n
l1c2n
m1c2n
n1c2n
r1c2n
s1c2n
t1c2n
x1c2n
b1p2s
c1p2s
d1p2s
l1p2s
m1p2s
n1p2s
r1p2s
s1p2s
t1p2s
x1p2s
b1m2n
c1m2n
d1m2n
l1m2n
m1m2n
n1m2n
r1m2n
s1m2n
t1m2n
x1m2n
b1g2n
c1g2n
d1g2n
l1g2n
m1g2n
n1g2n
r1g2n
s1g2n
t1g2n
x1g2n
b1f2t
c1f2t
d1f2t
l1f2t
m1f2t
n1f2t
r1f2t
s1f2t
t1f2t
x1f2t
b1p2n
c1p2n
d1p2n
l1p2n
m1p2n
n1p2n
r1p2n
s1p2n
t1p2n
x1p2n
b1c2z
c1c2z
d1c2z
l1c2z
m1c2z
n1c2z
r1c2z
s1c2z
t1c2z
x1c2z
b1t2s
c1t2s
d1t2s
l1t2s
m1t2s
n1t2s
r1t2s
s1t2s
t1t2s
x1t2s
san2c3t
plan2c3t
2pt.
2ct.
2cn.
2ps.
2mn.
2gn.
2ft.
2pn.
2cz.
2ts.
un2ha
2non.
3mente.
o2hib
alde2h
4caca4
4cago4
4caga4
4cagas.
4puta4
4puto4
4meo.
4mea.
4meable.
4meables.
4peido4
acto1a2
acto1e2
acto1i2
acto1o2
acto1u2
acto1^^e12
acto1^^e92
acto1^^ed2
acto1^^f32
acto1^^fa2
afro1a2
afro1e2
afro1i2
afro1o2
afro1u2
afro1^^e12
afro1^^e92
afro1^^ed2
afro1^^f32
afro1^^fa2
aero1a2
aero1e2
aero1i2
aero1o2
aero1u2
aero1^^e12
aero1^^e92
aero1^^ed2
aero1^^f32
aero1^^fa2
anfi1a2
anfi1e2
anfi1i2
anfi1o2
anfi1u2
anfi1^^e12
anfi1^^e92
anfi1^^ed2
anfi1^^f32
anfi1^^fa2
anglo1a2
anglo1e2
anglo1i2
anglo1o2
anglo1u2
anglo1^^e12
anglo1^^e92
anglo1^^ed2
anglo1^^f32
anglo1^^fa2
.ante1a2
.ante1e2
.ante1i2
.ante1o2
.ante1u2
.ante1^^e12
.ante1^^e92
.ante1^^ed2
.ante1^^f32
.ante1^^fa2
.anti1a2
.anti1e2
.anti1i2
.anti1o2
.anti1u2
.anti1^^e12
.anti1^^e92
.anti1^^ed2
.anti1^^f32
.anti1^^fa2
.arqui1a2
.arqui1e2
.arqui1i2
.arqui1o2
.arqui1u2
.arqui1^^e12
.arqui1^^e92
.arqui1^^ed2
.arqui1^^f32
.arqui1^^fa2
auto1a2
auto1e2
auto1i2
auto1o2
auto1u2
auto1^^e12
auto1^^e92
auto1^^ed2
auto1^^f32
auto1^^fa2
biblio1a2
biblio1e2
biblio1i2
biblio1o2
biblio1u2
biblio1^^e12
biblio1^^e92
biblio1^^ed2
biblio1^^f32
biblio1^^fa2
bio1a2
bio1e2
bio1i2
bio1o2
bio1u2
bio1^^e12
bio1^^e92
bio1^^ed2
bio1^^f32
bio1^^fa2
cardio1a2
cardio1e2
cardio1i2
cardio1o2
cardio1u2
cardio1^^e12
cardio1^^e92
cardio1^^ed2
cardio1^^f32
cardio1^^fa2
cefalo1a2
cefalo1e2
cefalo1i2
cefalo1o2
cefalo1u2
cefalo1^^e12
cefalo1^^e92
cefalo1^^ed2
cefalo1^^f32
cefalo1^^fa2
ciclo1a2
ciclo1e2
ciclo1i2
ciclo1o2
ciclo1u2
ciclo1^^e12
ciclo1^^e92
ciclo1^^ed2
ciclo1^^f32
ciclo1^^fa2
cito1a2
cito1e2
cito1i2
cito1o2
cito1u2
cito1^^e12
cito1^^e92
cito1^^ed2
cito1^^f32
cito1^^fa2
.co1a2
.co1e2
.co1i2
.co1o2
.co1u2
.co1^^e92
.co1^^ed2
.co1^^f32
.co1^^fa2
contra1a2
contra1e2
contra1i2
contra1o2
contra1u2
contra1^^e12
contra1^^e92
contra1^^ed2
contra1^^f32
contra1^^fa2
cripto1a2
cripto1e2
cripto1i2
cripto1o2
cripto1u2
cripto1^^e12
cripto1^^e92
cripto1^^ed2
cripto1^^f32
cripto1^^fa2
cromo1a2
cromo1e2
cromo1i2
cromo1o2
cromo1u2
cromo1^^e12
cromo1^^e92
cromo1^^ed2
cromo1^^f32
cromo1^^fa2
crono1a2
crono1e2
crono1i2
crono1o2
crono1u2
crono1^^e12
crono1^^e92
crono1^^ed2
crono1^^f32
crono1^^fa2
deca1a2
deca1e2
deca1i2
deca1o2
deca1u2
deca1^^e12
deca1^^e92
deca1^^ed2
deca1^^f32
deca1^^fa2
.deza1a2
.deza1e2
.deza1i2
.deza1o2
.deza1u2
.deza1^^e12
.deza1^^e92
.deza1^^ed2
.deza1^^f32
.deza1^^fa2
dinamo1a2
dinamo1e2
dinamo1i2
dinamo1o2
dinamo1u2
dinamo1^^e12
dinamo1^^e92
dinamo1^^ed2
dinamo1^^f32
dinamo1^^fa2
ecano1a2
ecano1e2
ecano1i2
ecano1o2
ecano1u2
ecano1^^e12
ecano1^^e92
ecano1^^ed2
ecano1^^f32
ecano1^^fa2
eco1a2
eco1e2
eco1i2
eco1o2
eco1u2
eco1^^e12
eco1^^e92
eco1^^ed2
eco1^^f32
eco1^^fa2
electro1a2
electro1e2
electro1i2
electro1o2
electro1u2
electro1^^e12
electro1^^e92
electro1^^ed2
electro1^^f32
electro1^^fa2
endo1a2
endo1e2
endo1i2
endo1o2
endo1u2
endo1^^e12
endo1^^e92
endo1^^ed2
endo1^^f32
endo1^^fa2
ento1a2
ento1e2
ento1i2
ento1o2
ento1u2
ento1^^e12
ento1^^e92
ento1^^ed2
ento1^^f32
ento1^^fa2
entre1a2
entre1e2
entre1i2
entre1o2
entre1u2
entre1^^e12
entre1^^e92
entre1^^ed2
entre1^^f32
entre1^^fa2
euco1a2
euco1e2
euco1i2
euco1o2
euco1u2
euco1^^e12
euco1^^e92
euco1^^ed2
euco1^^f32
euco1^^fa2
euro1a2
euro1e2
euro1i2
euro1o2
euro1u2
euro1^^e12
euro1^^e92
euro1^^ed2
euro1^^f32
euro1^^fa2
extra1a2
extra1e2
extra1i2
extra1o2
extra1u2
extra1^^e12
extra1^^e92
extra1^^ed2
extra1^^f32
extra1^^fa2
fono1a2
fono1e2
fono1i2
fono1o2
fono1u2
fono1^^e12
fono1^^e92
fono1^^ed2
fono1^^f32
fono1^^fa2
foto1a2
foto1e2
foto1i2
foto1o2
foto1u2
foto1^^e12
foto1^^e92
foto1^^ed2
foto1^^f32
foto1^^fa2
franco1a2
franco1e2
franco1i2
franco1o2
franco1u2
franco1^^e12
franco1^^e92
franco1^^ed2
franco1^^f32
franco1^^fa2
gastro1a2
gastro1e2
gastro1i2
gastro1o2
gastro1u2
gastro1^^e12
gastro1^^e92
gastro1^^ed2
gastro1^^f32
gastro1^^fa2
xeo1a2
xeo1e2
xeo1i2
xeo1o2
xeo1u2
xeo1^^e12
xeo1^^e92
xeo1^^ed2
xeo1^^f32
xeo1^^fa2
hecto1a2
hecto1e2
hecto1i2
hecto1o2
hecto1u2
hecto1^^e12
hecto1^^e92
hecto1^^ed2
hecto1^^f32
hecto1^^fa2
helio1a2
helio1e2
helio1i2
helio1o2
helio1u2
helio1^^e12
helio1^^e92
helio1^^ed2
helio1^^f32
helio1^^fa2
hemato1a2
hemato1e2
hemato1i2
hemato1o2
hemato1u2
hemato1^^e12
hemato1^^e92
hemato1^^ed2
hemato1^^f32
hemato1^^fa2
hemi1a2
hemi1e2
hemi1i2
hemi1o2
hemi1u2
hemi1^^e12
hemi1^^e92
hemi1^^ed2
hemi1^^f32
hemi1^^fa2
hexa1a2
hexa1e2
hexa1i2
hexa1o2
hexa1u2
hexa1^^e12
hexa1^^e92
hexa1^^ed2
hexa1^^f32
hexa1^^fa2
hidro1a2
hidro1e2
hidro1i2
hidro1o2
hidro1u2
hidro1^^e12
hidro1^^e92
hidro1^^ed2
hidro1^^f32
hidro1^^fa2
hipe2r1a2
hipe2r1e2
hipe2r1i2
hipe2r1o2
hipe2r1u2
hipe2r1^^e12
hipe2r1^^e92
hipe2r1^^ed2
hipe2r1^^f32
hipe2r1^^fa2
histo1a2
histo1e2
histo1i2
histo1o2
histo1u2
histo1^^e12
histo1^^e92
histo1^^ed2
histo1^^f32
histo1^^fa2
homeo1a2
homeo1e2
homeo1i2
homeo1o2
homeo1u2
homeo1^^e12
homeo1^^e92
homeo1^^ed2
homeo1^^f32
homeo1^^fa2
homo1a2
homo1e2
homo1i2
homo1o2
homo1u2
homo1^^e12
homo1^^e92
homo1^^ed2
homo1^^f32
homo1^^fa2
ibero1a2
ibero1e2
ibero1i2
ibero1o2
ibero1u2
ibero1^^e12
ibero1^^e92
ibero1^^ed2
ibero1^^f32
ibero1^^fa2
icono1a2
icono1e2
icono1i2
icono1o2
icono1u2
icono1^^e12
icono1^^e92
icono1^^ed2
icono1^^f32
icono1^^fa2
.in1a2
.in1e2
.in1i2
.in1o2
.in1u2
.in1^^e12
.in1^^e92
.in1^^ed2
.in1^^f32
.in1^^fa2
.indo1a2
.indo1e2
.indo1i2
.indo1o2
.indo1u2
.indo1^^e12
.indo1^^e92
.indo1^^ed2
.indo1^^f32
.indo1^^fa2
infra1a2
infra1e2
infra1i2
infra1o2
infra1u2
infra1^^e12
infra1^^e92
infra1^^ed2
infra1^^f32
infra1^^fa2
.inte2r1a2
.inte2r1e2
.inte2r1i2
.inte2r1o2
.inte2r1u2
.inte2r1^^e12
.inte2r1^^e92
.inte2r1^^ed2
.inte2r1^^f32
.inte2r1^^fa2
intra1a2
intra1e2
intra1i2
intra1o2
intra1u2
intra1^^e12
intra1^^e92
intra1^^ed2
intra1^^f32
intra1^^fa2
.iso1a2
.iso1e2
.iso1i2
.iso1o2
.iso1u2
.iso1^^e12
.iso1^^e92
.iso1^^ed2
.iso1^^f32
.iso1^^fa2
kilo1a2
kilo1e2
kilo1i2
kilo1o2
kilo1u2
kilo1^^e12
kilo1^^e92
kilo1^^ed2
kilo1^^f32
kilo1^^fa2
macro1a2
macro1e2
macro1i2
macro1o2
macro1u2
macro1^^e12
macro1^^e92
macro1^^ed2
macro1^^f32
macro1^^fa2
magneto1a2
magneto1e2
magneto1i2
magneto1o2
magneto1u2
magneto1^^e12
magneto1^^e92
magneto1^^ed2
magneto1^^f32
magneto1^^fa2
maxi1a2
maxi1e2
maxi1i2
maxi1o2
maxi1u2
maxi1^^e12
maxi1^^e92
maxi1^^ed2
maxi1^^f32
maxi1^^fa2
mega1a2
mega1e2
mega1i2
mega1o2
mega1u2
mega1^^e12
mega1^^e92
mega1^^ed2
mega1^^f32
mega1^^fa2
megalo1a2
megalo1e2
megalo1i2
megalo1o2
megalo1u2
megalo1^^e12
megalo1^^e92
megalo1^^ed2
megalo1^^f32
megalo1^^fa2
melano1a2
melano1e2
melano1i2
melano1o2
melano1u2
melano1^^e12
melano1^^e92
melano1^^ed2
melano1^^f32
melano1^^fa2
micro1a2
micro1e2
micro1i2
micro1o2
micro1u2
micro1^^e12
micro1^^e92
micro1^^ed2
micro1^^f32
micro1^^fa2
mili1a2
mili1e2
mili1i2
mili1o2
mili1u2
mili1^^e12
mili1^^e92
mili1^^ed2
mili1^^f32
mili1^^fa2
mini1a2
mini1e2
mini1i2
mini1o2
mini1u2
mini1^^e12
mini1^^e92
mini1^^ed2
mini1^^f32
mini1^^fa2
multi1a2
multi1e2
multi1i2
multi1o2
multi1u2
multi1^^e12
multi1^^e92
multi1^^ed2
multi1^^f32
multi1^^fa2
miria1a2
miria1e2
miria1i2
miria1o2
miria1u2
miria1^^e12
miria1^^e92
miria1^^ed2
miria1^^f32
miria1^^fa2
mono1a2
mono1e2
mono1i2
mono1o2
mono1u2
mono1^^e12
mono1^^e92
mono1^^ed2
mono1^^f32
mono1^^fa2
.nano1a2
.nano1e2
.nano1i2
.nano1o2
.nano1u2
.nano1^^e12
.nano1^^e92
.nano1^^ed2
.nano1^^f32
.nano1^^fa2
necro1a2
necro1e2
necro1i2
necro1o2
necro1u2
necro1^^e12
necro1^^e92
necro1^^ed2
necro1^^f32
necro1^^fa2
.neo1a2
.neo1e2
.neo1i2
.neo1o2
.neo1u2
.neo1^^e12
.neo1^^e92
.neo1^^ed2
.neo1^^f32
.neo1^^fa2
norte1a2
norte1e2
norte1i2
norte1o2
norte1u2
norte1^^e12
norte1^^e92
norte1^^ed2
norte1^^f32
norte1^^fa2
octo1a2
octo1e2
octo1i2
octo1o2
octo1u2
octo1^^e12
octo1^^e92
octo1^^ed2
octo1^^f32
octo1^^fa2
octa1a2
octa1e2
octa1i2
octa1o2
octa1u2
octa1^^e12
octa1^^e92
octa1^^ed2
octa1^^f32
octa1^^fa2
omni1a2
omni1e2
omni1i2
omni1o2
omni1u2
omni1^^e12
omni1^^e92
omni1^^ed2
omni1^^f32
omni1^^fa2
paleo1a2
paleo1e2
paleo1i2
paleo1o2
paleo1u2
paleo1^^e12
paleo1^^e92
paleo1^^ed2
paleo1^^f32
paleo1^^fa2
para1a2
para1e2
para1i2
para1o2
para1u2
para1^^e12
para1^^e92
para1^^ed2
para1^^f32
para1^^fa2
penta1a2
penta1e2
penta1i2
penta1o2
penta1u2
penta1^^e12
penta1^^e92
penta1^^ed2
penta1^^f32
penta1^^fa2
piezo1a2
piezo1e2
piezo1i2
piezo1o2
piezo1u2
piezo1^^e12
piezo1^^e92
piezo1^^ed2
piezo1^^f32
piezo1^^fa2
pluri1a2
pluri1e2
pluri1i2
pluri1o2
pluri1u2
pluri1^^e12
pluri1^^e92
pluri1^^ed2
pluri1^^f32
pluri1^^fa2
poli1a2
poli1e2
poli1i2
poli1o2
poli1u2
poli1^^e12
poli1^^e92
poli1^^ed2
poli1^^f32
poli1^^fa2
.pos2t1a2
.pos2t1e2
.pos2t1i2
.pos2t1o2
.pos2t1u2
.pos2t1^^e12
.pos2t1^^e92
.pos2t1^^ed2
.pos2t1^^f32
.pos2t1^^fa2
.pre1a2
.pre1e2
.pre1i2
.pre1o2
.pre1u2
.pre1^^e92
.pre1^^ed2
.pre1^^f32
.pre1^^fa2
.pro1a2
.pro1e2
.pro1i2
.pro1o2
.pro1u2
.pro1^^e12
.pro1^^e92
.pro1^^ed2
.pro1^^f32
.pro1^^fa2
proto1a2
proto1e2
proto1i2
proto1o2
proto1u2
proto1^^e12
proto1^^e92
proto1^^ed2
proto1^^f32
proto1^^fa2
pseudo1a2
pseudo1e2
pseudo1i2
pseudo1o2
pseudo1u2
pseudo1^^e12
pseudo1^^e92
pseudo1^^ed2
pseudo1^^f32
pseudo1^^fa2
radio1a2
radio1e2
radio1i2
radio1o2
radio1u2
radio1^^e12
radio1^^e92
radio1^^ed2
radio1^^f32
radio1^^fa2
.re1a2
.re1e2
.re1i2
.re1o2
.re1u2
.re1^^e12
.re1^^e92
.re1^^ed2
.re1^^f32
.re1^^fa2
retro1a2
retro1e2
retro1i2
retro1o2
retro1u2
retro1^^e12
retro1^^e92
retro1^^ed2
retro1^^f32
retro1^^fa2
sobre1a2
sobre1e2
sobre1i2
sobre1o2
sobre1u2
sobre1^^e12
sobre1^^e92
sobre1^^ed2
sobre1^^f32
sobre1^^fa2
semi1a2
semi1e2
semi1i2
semi1o2
semi1u2
semi1^^e12
semi1^^e92
semi1^^ed2
semi1^^f32
semi1^^fa2
socio1a2
socio1e2
socio1i2
socio1o2
socio1u2
socio1^^e12
socio1^^e92
socio1^^ed2
socio1^^f32
socio1^^fa2
.su2b1a2
.su2b1e2
.su2b1o2
.su2b1u2
.su2b1^^e12
.su2b1^^e92
.su2b1^^f32
.su2b1^^fa2
supe2r1a2
supe2r1e2
supe2r1i2
supe2r1o2
supe2r1u2
supe2r1^^e12
supe2r1^^e92
supe2r1^^ed2
supe2r1^^f32
supe2r1^^fa2
supra1a2
supra1e2
supra1i2
supra1o2
supra1u2
supra1^^e12
supra1^^e92
supra1^^ed2
supra1^^f32
supra1^^fa2
.tele1a2
.tele1e2
.tele1i2
.tele1o2
.tele1u2
.tele1^^e12
.tele1^^e92
.tele1^^ed2
.tele1^^f32
.tele1^^fa2
termo1a2
termo1e2
termo1i2
termo1o2
termo1u2
termo1^^e12
termo1^^e92
termo1^^ed2
termo1^^f32
termo1^^fa2
tetra1a2
tetra1e2
tetra1i2
tetra1o2
tetra1u2
tetra1^^e12
tetra1^^e92
tetra1^^ed2
tetra1^^f32
tetra1^^fa2
topo1a2
topo1e2
topo1i2
topo1o2
topo1u2
topo1^^e12
topo1^^e92
topo1^^ed2
topo1^^f32
topo1^^fa2
.tri1a2
.tri1e2
.tri1i2
.tri1o2
.tri1u2
.tri1^^e12
.tri1^^e92
.tri1^^ed2
.tri1^^f32
.tri1^^fa2
tropo1a2
tropo1e2
tropo1i2
tropo1o2
tropo1u2
tropo1^^e12
tropo1^^e92
tropo1^^ed2
tropo1^^f32
tropo1^^fa2
ultra1a2
ultra1e2
ultra1i2
ultra1o2
ultra1u2
ultra1^^e12
ultra1^^e92
ultra1^^ed2
ultra1^^f32
ultra1^^fa2
xeno1a2
xeno1e2
xeno1i2
xeno1o2
xeno1u2
xeno1^^e12
xeno1^^e92
xeno1^^ed2
xeno1^^f32
xeno1^^fa2
hiper3r
.inter3r
super3r
ti2o3qu
ti2o3co
bi1u2n^^ed
o2i3de
o2i3dal
2al.
2a2is.
pe3r2e3mia
libero2u3
atopo2u3
enaxeno2u3
2os.
2o3so.
2o3sos.
2o3sa.
2o3sas.
2o3samente.
2i3co.
2i3cos.
2i3ca.
2i3cas.
.co2ar
.co2^^e12
.co2ab^^e1
.co2acerv
.co2andro
.co2ano
.co2a^^f1ar
.co2a^^f1o
.co2art
.co2etan
.co2enci
.co2erci
.co2inci
.co2ira
.co2iro
.co2ita
co2a3gul
co2^^e13gul
co2a3la.
co2a3las.
co2a3lescen
co2a3lici^^f3n.
co2a3licions.
co2a3na.
co2a3nas.
co2antri^^f1
co2a3^^f1adeir
co2a3t^^ed.
co2a3t^^eds.
co2e3ficien
co2e3lernos.
co2e3llo.
co2e3lla.
co2e3llos.
co2e3llas.
co2e3lleir
co2enll
co2enx^^eda
co2e3sita.
co2e3sitas.
co2e3t^^e1ne
co2e3vo.
co2e3va.
co2e3vos.
co2e3vas.
co2i3dado
co2iei
co2imbra
co2imbr^^e1
co2intreau.
co2^^ed3^^f1a
co2i3^^f1a
co2i3^^f1ei
co2i3p^^fa.
co2i3p^^fas.
co2i3ra.
co2i3ras.
co2i3raza
co2i3ro.
co2i3ros.
co2i3ta.
co2i3tas.
co2i3tado.
co2i3to.
co2i3tos.
co2i3tel
co2i3t^^edo.
co2i3tus.
co2u3c
co2u3lomb
co2u3try
co2u3qui
co2u3rel
co2u3sa.
co2u3sas.
co2u3so.
co2u3sos.
co2u3selo
co2u3tad
co2u3to.
co2u3tos.
co2u3vini
co2u3z
deca2e3ment
.de2s1a2
.de2s1e2
.de2s1i2
.de2s1o2
.de2s1u2
.de2s1^^e12
.de2s1^^e92
.de2s1^^ed2
.de2s1^^f32
.de2s1^^fa2
3se.
3s2es.
3sa.
3s2as.
de3s2outr
3s2emos.
3s2edes.
3s2en.
de3s2a3crali
de3s2a3guisa
de3s2a3lini
de3s2a3ngr
de3s2a3^^f1
de3s2a3rrollis
de3s2astr
de3s2a3zo
de3s2e3c
de3s2e3que
de3s2e3guid
de3s2e3la
de3s2ensib
de3s2e3^^f1
de3s2ert
de3s2^^e9rt
de3s2esper
de4s3esperanz
de3s2e3p^^e9r
de3s2e3x
de3s2^^e93x
de3s2i3der
de3s2ign
de3s2^^edgn
de3s2i3nenc
de3s2ingr
de3s2iste
de3s2isti
de3s2o3lac
de3s2o3lad
de3s2old
de3s2o3lidari
de3s2uetud
de3s2sulf
.des2abor
.des2afia
.des2af^^eda
.des2af^^edo
.des2air
.des2emboc
.des2emb^^f3c
.des2empe^^f1
.des2emp^^e9^^f1
.des2enlac
.des2enlaz
.des2enl^^e1c
.des2enl^^e1z
.des2envol
.des2env^^f3l
.des2idia
.des2ora
.in2a3misib.
.in2a3mov
.in2a3ne.
.in2a3nic
.in2a3nid
.in2^^e13nime
.in2antes.
.in2au
.in2e3dia
.in2^^e93dit
.in2e3fab
.in2e3narr
.in2epc
.in2ept
.in2erc
.in2ert
.in2erm
.in2erv
.in2e3siv
.in2e3xora
.in2i3ci
.in2i3cu
.in2i3mig
.in2i3miza
.in2i3qui
.in2o3cen
.in2o3cui
.in2o3cuo
.in2o3cul
.in2^^f33cul
.in2o3pia.
.in2o3sili
.in2o3sit
.in2o3tr^^f3p
.in2o3trop
.in2uit
.in2u3lase
.in2u3lina
.in2unda
.in2u3sita
.in2^^fa3til
in2o4cular
.inte3r2^^e9s.
.inte3r2e3sa
.inte3r2^^e93sa
.inte3r2e3s^^e1
.inte3r2e3so
.inte3r2^^e93so
.inte3r2e3s^^f3
.inte3r2ior
.inte3r2i3no.
.inte3r2i3nos.
.inte3r2i3na.
.inte3r2i3nas.
.inte3r2i3nid
.be2n1a2
.be2ne2
.be2n1i2
.be2n1o2
.be2n1u2
.be2n1^^e12
.be2n1^^ed2
.be2n1^^f32
.be2n1^^fa2
be3n2ign
be3n2i3mer^^ed
be3n2i3n^^e9s
be3n2i3nes
be3n2i3to^^edta
.ma2l1a2
.ma2le2
.ma2l1i2
.ma2l1o2
.ma2l1u2
.ma2l1^^e12
.ma2l1^^ed2
.ma2l1^^f32
.ma2l1^^fa2
.mal2abar
.mal2ab^^e1r
.mal2aco
.mal2ac^^f3
.mal2armad
.mal2ogr
.mal2ura
.mal2axa
ma3l2a3c^^eda
ma3l2a3citan
ma3l2a3gue^^f1
ma3l2aio
ma3l2aia
ma3l2andr^^edn
ma3l2andrin
ma3l2a3quita
ma3l2ar.
ma3l2a3res.
ma3l2a3ria.
ma3l2a3to.
ma3l2a3tos.
ma3l2a3ta.
ma3l2a3tas.
ma3l2a3ti^^f3n
ma3l2aui
ma3l2eabl
ma3l2eabil
ma3l2eico
ma3l2eolar
ma3l2e3ta.
ma3l2e3tas.
ma3l2e3t^^edn
ma3l2e3teiro
ma3l2eza
ma3l2ia.
ma3l2ian
ma3l2i3cia
ma3l2i3cios
ma3l2ign
ma3l2i3kita
ma3l2inke
ma3l2^^f33fago
ma3l2^^f33nic
ma3l2o3nato
ma3l2o3nilue
ma4l3ianq
.mal1educ
.mal1encar
.mal1ensin
.mal1entend
mili2a3rio
mili2a3ria
mini2a3tur
para2u3gas
para2^^ed3so
poli2u3r
poli2o3me
poli2arq
poli2^^e1rq
poli2^^e9ste
poli2andr
poli2antea
expoli2
.pos3t2a.
.pos3t2as.
.pos3t2al.
.pos3t2ais.
.pos3t2a3llo
.pos3t2e.
.pos3t2es.
.pos3t2ear.
.pos3t2e3la.
.pos3t2e3las.
.pos3t2er.
.pos3t2erg
.pos3t2e3rid
.pos3t2e3rior
.pos3t2i3go
.pos3t2i3la
.pos3t2ill^^f3n
.pos3t2^^edn.
.pos3t2i3te.
.pos3t2i3zo.
.pos3t2i3zos.
.pos3t2i3za.
.pos3t2i3zas.
.pos3t2o.
.pos3t2os.
.pos3t2oiro
.pos3t2^^f33ni
.pos3t2u3la
.pos3t2u3lo
.pos3t2u3le
.pos3t2u3ra.
.pos3t2u3ras.
.pre2amar
.pre2ar
.pre2^^e12
.pre2ab^^e1
pre2as.
pre2a3da.
pre2a3das.
pre2^^e12
pre2ab^^e1
pre2i3t
pre2o3cup
pre2o3c^^fap
pro2e3za
pro2^^ed3do
pro2ust
.re2al
.re2a3liz
.re2a3lidade
.re2in
.re2i3no.
.re2i3nos
.re2i3nante
.re2iter
.re2i3xa
.re2os.
.re2as.
.re2u3ma
.re2^^fa3ma
.re2^^fan
.re2uni
re2u3ni^^f3n.
re2u3ni^^f3ns.
re2u3nir
re2u3n^^edrmo
re2u3n^^edren
re2u3nido.
re2u3nidos.
re2u3nida.
re2u3nidas.
re2u3nind
re2u3no.
re2u3nes.
re2u3ne.
re2u3nimos.
re2u3n^^edmo
re2u3nen.
re2u3n^^eda
re2u3ni3amos.
re2u3ni3ades.
re2u3n^^edn.
re2u3niches.
re2u3niu.
re2u3nistes.
re2u3n^^edst
re2u3niron.
re2u3na.
re2u3nas.
re2u3namos.
re2u3nades.
re2u3nan.
re2u3nise
re2u3n^^edse
re2u3nide
re2u3n^^edde
re2u3n^^e1mo
re2u3n^^e1de
re2i3nar
re2i3nado.
re2i3nados.
re2i3nand
re2i3na.
re2i3nas.
re2i3namos.
re2i3nades.
re2i3nan.
re2i3naba.
re2i3nabas.
re2i3nabamos.
re2i3n^^e1bamos.
re2i3nabades.
re2i3n^^e1bades.
re2i3nei.
re2i3naches.
re2i3nou.
re2i3nastes.
re2i3naron.
re2i3ne.
re2i3nes.
re2i3nemos.
re2i3nedes.
re2i3nen.
re2i3nase.
re2i3nases.
re2i3nasemo.
re2i3nasedes.
re2i3n^^e1se
re2i3nasen.
re2i3nade.
.su2b3l
.su2b3r
.su2b2i2
.su2b2^^ed2
.sub2eriz
.sub2orna
sub3^^edndic
sub3indic
sub3indiz
.sub4lev
.sub4lim
su3b2e3la.
su3b2e3las.
su3b2^^e93rico
su3b2e3rina.
su3b2e3rinas.
su3b2eroso
su3b2iote
su3b2ulado
su3b2orno.
su3b2ornos.
su3b2urbio
su3b4liminar
su3b4repci^^f3n
su3b4reptici
tri2a3ga.
tri2a3gas.
tri2al.
tri2a3les.
tri2angul
tri2^^e13sico.
tri2estin
tri2unf
tri2unvir
2a3do.
2i3do.
2a3da.
2i3da.
2a3dos.
2i3dos.
2a3das.
2i3das.
2ando.
2indo.
2ar.
2ir.
2a3res.
2e3res.
2i3res.
2armos.
2ermos.
2irmos.
2ardes.
2erdes.
2irdes.
2a3ren.
2e3ren.
2i3ren.
2arme.
2erme.
2irme.
2arte.
2erte.
2irte.
2arlle.
2erlle.
2irlle.
2arnos.
2ernos.
2irnos.
2arvos.
2ervos.
2irvos.
2arlles.
2erlles.
2irlles.
2a3dor.
2e3dor.
2i3dor.
2a3dora.
2e3dora.
2i3dora.
2a3dores.
2e3dores.
2i3dores.
2a3doiro.
2e3doiro.
2i3doiro.
2a3doiros.
2e3doiros.
2i3doiros.
2a3doira.
2e3doira.
2i3doira.
2a3doiras.
2e3doiras.
2i3doiras.
2a3deiro.
2e3deiro.
2i3deiro.
2a3deiros.
2e3deiros.
2i3deiros.
2a3deira.
2e3deira.
2i3deira.
2a3deiras.
2e3deiras.
2i3deiras.
2a3lo.
2e3lo.
2i3lo.
2a3los.
2e3los.
2i3los.
2a3la.
2e3la.
2i3la.
2a3las.
2e3las.
2i3las.
2a3rei.
2e3rei.
2i3rei.
2a3r^^e1s.
2e3r^^e1s.
2i3r^^e1s.
2a3r^^e1.
2e3r^^e1.
2i3r^^e1.
2a3remos.
2e3remos.
2i3remos.
2a3redes.
2e3redes.
2i3redes.
2a3r^^e1n.
2e3r^^e1n.
2i3r^^e1n.
2a3r^^eda.
2e3r^^eda.
2i3r^^eda.
2a3r^^edas.
2e3r^^edas.
2i3r^^edas.
2a3ri1amos.
2e3ri1amos.
2i3ri1amos.
2a3r^^edamos.
2e3r^^edamos.
2i3r^^edamos.
2a3ri1ades.
2e3ri1ades.
2i3ri1ades.
2a3r^^edades.
2e3r^^edades.
2i3r^^edades.
2a3r^^edan.
2e3r^^edan.
2i3r^^edan.
2a3de.
2e3de.
2i3de.
2^^e13deo.
2^^e93deo.
2^^ed3deo.
2^^e13dea.
2^^e93dea.
2^^ed3dea.
2^^e13deos.
2^^e93deos.
2^^ed3deos.
2^^e13deas.
2^^e93deas.
2^^ed3deas.
2as.
2a3mos.
2a3des.
2an.
2a3ba.
2a3bas.
2a3bamos.
2^^e13bamos.
2a3bades.
2^^e13bades.
2a3ban.
2a3ches.
2astes.
2a3ron.
2es.
2e3mos.
2e3des.
2en.
2a3se.
2a3ses.
2^^e13semos.
2^^e13sedes.
2a3sen.
o3ar.
o3ado.
o3ada.
o3ados.
o3adas.
o3ando.
o3ares.
o3armos.
o3ardes.
o3aren.
o3arme.
o3arte.
o3arlle.
o3arnos.
o3arvos.
o3arlles.
o3alo.
o3alos.
o3ala.
o3alas.
o3ade.
o3^^e1deo.
o3^^e1dea.
o3^^e1deos.
o3^^e1deas.
o3as.
o3amos.
o3ades.
o3an.
o3aba.
o3abas.
o3abamos.
o3^^e1bamos.
o3abades.
o3^^e1bades.
o3aban.
o3aches.
o3astes.
o3aron.
o3es.
o3emos.
o3edes.
o3en.
o3ase.
o3ases.
o3^^e1semos.
o3^^e1sedes.
o3asen.
e3ar.
e3ado.
e3ada.
e3ados.
e3adas.
e3ando.
e3ares.
e3armos.
e3ardes.
e3aren.
e3arme.
e3arte.
e3arlle.
e3arnos.
e3arvos.
e3arlles.
e3alo.
e3alos.
e3ala.
e3alas.
e3ade.
e3^^e1deo.
e3^^e1dea.
e3^^e1deos.
e3^^e1deas.
e3as.
e3amos.
e3ades.
e3an.
e3aba.
e3abas.
e3abamos.
e3^^e1bamos.
e3abades.
e3^^e1bades.
e3aban.
e3aches.
e3astes.
e3aron.
e3es.
e3emos.
e3edes.
e3en.
e3ase.
e3ases.
e3^^e1semos.
e3^^e1sedes.
e3asen.
2i3mos.
2i3des.
2^^eda.
2^^edas.
2^^edamos.
2^^edades.
2^^edan.
2^^edn.
2i3ches.
2iu.
2istes.
2i3ron.
2i3se.
2i3ses.
2^^ed3semos.
2^^ed3sedes.
2i3sen.
^^ed3do
^^ed3da
^^ed3dos
^^ed3das
.su3bir.
.su3bindo.
.su3bido.
.su3bida.
.su3bidos.
.su3bidas.
.su3bires.
.su3birmos.
.su3birdes.
.su3biren.
.su3bo.
.su3bes.
.su3be.
.su3bimos.
.su3bides.
.su3ben.
.su3b^^eda.
.su3b^^edas.
.su3b2i3amos.
.su3b^^edamos.
.su3b2i3ades.
.su3b^^edades.
.su3b^^edan.
.su3b^^edn.
.su3biches.
.su3biu.
.su3bistes.
.su3biron.
.su3birei.
.su3bir^^e1s.
.su3bir^^e1.
.su3biremos.
.su3biredes.
.su3bir^^e1n.
.su3bir^^eda.
.su3bir^^edas.
.su3biriamos.
.su3bir^^edamos.
.su3biriades.
.su3bir^^edades.
.su3bir^^edan.
.su3ba.
.su3bas.
.su3bamos.
.su3bades.
.su3ban.
.su3bise.
.su3bises.
.su3b^^edsemos.
.su3b^^edsedes.
.su3bisen.
.su3bide.
.su3b^^eddeo.
.su3b^^eddeos.
.su3b^^eddea.
.su3b^^eddeas.
.su3bador.
.su3badora.
.su3badores.
.su3badoras.
.supe3rar.
.supe3rando.
.supe3rado.
.supe3rada.
.supe3rados.
.supe3radas.
.supe3rares.
.supe3rarmos.
.supe3rardes.
.supe3raren.
.supe3ra.
.supe3ras.
.supe3ramos.
.supe3rades.
.supe3ran.
.supe3raba.
.supe3rabas.
.supe3rabamos.
.supe3r^^e1bamos.
.supe3rabades.
.supe3r^^e1bades.
.supe3raban.
.supe3rei.
.supe3raches.
.supe3rou.
.supe3rastes.
.supe3raron.
.supe3rarei.
.supe3rar^^e1s.
.supe3rar^^e1.
.supe3reremos.
.supe3reredes.
.supe3rar^^e1n.
.supe3rar^^eda.
.supe3rar^^edas.
.supe3rariamos.
.supe3rar^^edamos.
.supe3rariades.
.supe3rar^^edades.
.supe3rar^^edan.
.supe3re.
.supe3res.
.supe3remos.
.supe3redes.
.supe3ren.
.supe3rase.
.supe3rases.
.supe3r^^e1semos.
.supe3r^^e1sedes.
.supe3rasen.
.supe3rade.
.supe3r^^e1deo.
.supe3r^^e1deos.
.supe3r^^e1dea.
.supe3r^^e1deas.
.supe3rador.
.supe3radora.
.supe3radores.
.supe3radoras.
.supe3raci^^f3n.
supe3r2ior
supe3r2a3ble
supe3r2a3bilidade
a3er.
a3endo.
a3eres.
a3ermos.
a3erdes.
a3eren.
a3erme.
a3erte.
a3erlle.
a3ernos.
a3ervos.
a3erlles.
a3elo.
a3elos.
a3ela.
a3elas.
a3ede.
a3^^e9deo.
a3^^e9dea.
a3^^e9deos.
a3^^e9deas.
a3emos.
a3edes.
a3eron.
a3ese.
a3eses.
a3esemos.
a3^^e9semos.
a3esedes.
a3^^e9sedes.
a3esen.
}
\egroup

