use v6.c;
use Test;      # a Standard module included with Rakudo 
use lib 'lib';

use Mathx::Stat::DistributionPopulation;
use Mathx::Stat::Covariance;
use Mathx::Stat::Correlation;
use Mathx::Stat::CorrelationDimension;
use Mathx::Stat::Probability;

my $num-tests = 9;

plan $num-tests;
 
# .... tests 
#  

my $pp = 0.1;
my $pop = Mathx::Stat::DistributionPopulation.new;

my @plist;
my @indices;

loop (my $i = $pp, my $j = 0; $pp <= 1.0; $i+=0.1, $j++) {
	$pop.add($pp);
	push(@plist, $pp);
	push(@indices, $j);
}

ok $pop.Expectance, 0.55;

cmp-ok $pop.Variance, '==', $pop.Variance;

my $cov = Mathx::Stat::Covariance.new;
my $corr = Mathx::Stat::Correlation.new;

cmp-ok $cov.Covariance($pop,$pop), '==', $cov.Covariance($pop,$pop);

cmp-ok $corr.Correlation($pop,$pop), '==', $corr.Correlation($pop,$pop);

my $p = Mathx::Stat::Probability.new(xpop => @plist);

cmp-ok $p.Bayes(@indices, @plist, 1), '==', $p.Bayes(@indices, @plist, 1);

cmp-ok $p.Bayes(@indices, @plist, 0), '==', $p.Bayes(@indices, @plist, 0);

cmp-ok $p.CalculatedCondP(3,0), '==', $p.CalculatedCondP(3,0);

cmp-ok $p.CalculatedCondP(7,4), '==', $p.CalculatedCondP(7,4);

done-testing;  # optional with 'plan' 
