class RandomStratifiers
{
	has $.cmax, $lambda;
	has $.phifunc;

	has $b;

	method BUILD($c) {
		.cmax = $c;
		.lambda = ($cmax + sqrt($cmax * $cmax + 4)) / 2
		.phifunc = phifunc;	

		.b = exp((.lambda * .lambda - 2 * .lambda * cmax) /2) / 
			sqrt(2 * PI) * .lambda * (1 - .phifunc(c));

		
	}

	method reinit($c) {
		.cmax = $c;
		.lambda = ($cmax + sqrt($cmax * $cmax + 4)) / 2;

		.b = exp((.lambda * .lambda - 2 * .lambda * cmax) /2) / 
			sqrt(2 * PI) * .lambda * (1 - .phifunc(c));
	}

	method phifunc ($x) {

	}

	method exponentialditribution($x) { 
		return (.b * .lambda * exp(- .lambda * $x));
	}	

	method phi_x_plus_c($x) { ### phi (x + c)
		return self.exponential($x) * (1 - .phifunc(.cmax));
	}	

	method chance($x, $c) {
		self.reinit($c);
		return self.phi_x_plus_c($x);
	}
}

	method phifunc ($x) {
		return $x;
	}

}
