class NESAgent is NESMusicAgent is NESROMAgent 
{	
	method new( *%params ) {
		$status = $stat;
		return self.bless(|%params);
	}

	method ask(%args) {
		my $string = Agent.ask(%args) . 
				"ask about game roms\n" .
				"ask about music roms\n" .
				"get game roms\n" .
				"get music roms\n" .
				"list music roms\n" .
				"list roms\n" .
				"agent\n";
		
		return $string;
	}


	method ask_game_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {
			if (.romdb.search($key) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_game_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .romdb.search($key));
		}
		return @roms;
	}

	method ask_music_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {
			if (.musicdb.search($key) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_music_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .musicdb.search($key));
		}
		return @roms;
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process music or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask about music roms" { self.ask_music_roms(%optargs) }
		when "ask about game roms" { self.ask_game_roms(%optargs) }
		when "get game roms" { self.get_game_roms(%optargs) }
		when "get music roms" { self.get_music_roms(%optargs) }
		when "list music roms" { self.list_musicdb_keys(%optargs) } 
		when "list roms" { self.list_romdb_keys(%optargs) } 
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
