/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web;

import java.lang.reflect.Type;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.shared.Stoppable;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.DriverServlet;
import org.openqa.grid.web.servlet.Grid1HeartbeatServlet;
import org.openqa.grid.web.servlet.HubStatusServlet;
import org.openqa.grid.web.servlet.HubW3CStatusServlet;
import org.openqa.grid.web.servlet.LifecycleServlet;
import org.openqa.grid.web.servlet.NodeSessionsServlet;
import org.openqa.grid.web.servlet.ProxyStatusServlet;
import org.openqa.grid.web.servlet.RegistrationServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.servlet.TestSessionStatusServlet;
import org.openqa.grid.web.servlet.console.ConsoleServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedAttribute;
import org.openqa.selenium.remote.server.jmx.ManagedService;
import org.seleniumhq.jetty9.security.ConstraintMapping;
import org.seleniumhq.jetty9.security.ConstraintSecurityHandler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.servlet.ServletHolder;
import org.seleniumhq.jetty9.util.security.Constraint;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;

@ManagedService(objectName="org.seleniumhq.grid:type=Hub", description="Selenium Grid Hub")
public class Hub
implements Stoppable {
    private static final Logger log = Logger.getLogger(Hub.class.getName());
    private final GridHubConfiguration config;
    private final GridRegistry registry;
    private final Map<String, Class<? extends Servlet>> extraServlet = new HashMap<String, Class<? extends Servlet>>();
    private Server server;

    private void addServlet(String key, Class<? extends Servlet> s) {
        this.extraServlet.put(key, s);
    }

    public GridRegistry getRegistry() {
        return this.registry;
    }

    public Hub(GridHubConfiguration gridHubConfiguration) {
        this.config = gridHubConfiguration == null ? new GridHubConfiguration() : gridHubConfiguration;
        try {
            this.registry = (GridRegistry)Class.forName(this.config.registry).newInstance();
            this.registry.setHub(this);
            this.registry.setThrowOnCapabilityNotPresent(this.config.throwOnCapabilityNotPresent);
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error creating class with " + this.config.registry + " : " + e.getMessage(), e);
        }
        if (this.config.host == null) {
            this.config.host = "0.0.0.0";
        }
        if (this.config.port == null) {
            this.config.port = 4444;
        }
        if (this.config.servlets != null) {
            for (String s : this.config.servlets) {
                Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
                if (servletClass == null) continue;
                String path = "/grid/admin/" + servletClass.getSimpleName() + "/*";
                log.info("binding " + servletClass.getCanonicalName() + " to " + path);
                this.addServlet(path, servletClass);
            }
        }
        this.registry.start();
        new JMXHelper().register(this);
    }

    private void addDefaultServlets(ServletContextHandler handler) {
        handler.addServlet(RegistrationServlet.class.getName(), "/grid/register/*");
        handler.addServlet(DriverServlet.class.getName(), "/wd/hub/*");
        handler.addServlet(DriverServlet.class.getName(), "/selenium-server/driver/*");
        handler.addServlet(ProxyStatusServlet.class.getName(), "/grid/api/proxy/*");
        handler.addServlet(NodeSessionsServlet.class.getName(), "/grid/api/sessions/*");
        handler.addServlet(HubStatusServlet.class.getName(), "/grid/api/hub/*");
        ServletHolder statusHolder = new ServletHolder(new HubW3CStatusServlet(this.getRegistry()));
        handler.addServlet(statusHolder, "/status");
        handler.addServlet(statusHolder, "/wd/hub/status");
        handler.addServlet(TestSessionStatusServlet.class.getName(), "/grid/api/testsession/*");
        if (!this.config.isWithOutServlet(ResourceServlet.class)) {
            handler.addServlet(ResourceServlet.class.getName(), "/grid/resources/*");
        }
        if (!this.config.isWithOutServlet(DisplayHelpServlet.class)) {
            handler.addServlet(DisplayHelpServlet.class.getName(), "/*");
            handler.setInitParameter("webdriver.server.displayhelpservlet.type", this.config.role);
        }
        if (!this.config.isWithOutServlet(ConsoleServlet.class)) {
            handler.addServlet(ConsoleServlet.class.getName(), "/grid/console/*");
            handler.setInitParameter("webdriver.server.consoleservlet.path", "/grid/console");
        }
        if (!this.config.isWithOutServlet(LifecycleServlet.class)) {
            handler.addServlet(LifecycleServlet.class.getName(), "/lifecycle-manager/*");
        }
        if (!this.config.isWithOutServlet(Grid1HeartbeatServlet.class)) {
            handler.addServlet(Grid1HeartbeatServlet.class.getName(), "/heartbeat");
        }
    }

    private void initServer() {
        try {
            if (this.config.jettyMaxThreads != null && this.config.jettyMaxThreads > 0) {
                QueuedThreadPool pool = new QueuedThreadPool();
                pool.setMaxThreads(this.config.jettyMaxThreads);
                this.server = new Server(pool);
            } else {
                this.server = new Server();
            }
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.config.port);
            ServerConnector http = new ServerConnector(this.server, new HttpConnectionFactory(httpConfig));
            http.setHost(this.config.host);
            if (this.config.host.equals("0.0.0.0")) {
                this.updateHostToNonLoopBackAddressOfThisMachine();
            }
            http.setPort(this.config.port);
            this.server.addConnector(http);
            ServletContextHandler root = new ServletContextHandler(3);
            root.setContextPath("/");
            ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)root.getSecurityHandler();
            Constraint disableTrace = new Constraint();
            disableTrace.setName("Disable TRACE");
            disableTrace.setAuthenticate(true);
            ConstraintMapping disableTraceMapping = new ConstraintMapping();
            disableTraceMapping.setConstraint(disableTrace);
            disableTraceMapping.setMethod("TRACE");
            disableTraceMapping.setPathSpec("/");
            securityHandler.addConstraintMapping(disableTraceMapping);
            Constraint enableOther = new Constraint();
            enableOther.setName("Enable everything but TRACE");
            ConstraintMapping enableOtherMapping = new ConstraintMapping();
            enableOtherMapping.setConstraint(enableOther);
            enableOtherMapping.setMethodOmissions(new String[]{"TRACE"});
            enableOtherMapping.setPathSpec("/");
            securityHandler.addConstraintMapping(enableOtherMapping);
            this.server.setHandler(root);
            root.setAttribute(GridRegistry.KEY, this.registry);
            this.addDefaultServlets(root);
            for (Map.Entry<String, Class<? extends Servlet>> entry : this.extraServlet.entrySet()) {
                root.addServlet(entry.getValue().getName(), entry.getKey());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing the hub " + e.getMessage(), e);
        }
    }

    public GridHubConfiguration getConfiguration() {
        return this.config;
    }

    @ManagedAttribute(name="Configuration")
    public Map<?, ?> getConfigurationForJMX() {
        Json json = new Json();
        return (Map)json.toType(json.toJson(this.config.toJson()), (Type)((Object)Map.class));
    }

    public void start() {
        this.initServer();
        try {
            this.server.start();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof BindException) {
                log.severe(String.format("Port %s is busy, please choose a free port for the hub and specify it using -port option", this.config.port));
                return;
            }
            throw new RuntimeException(e);
        }
        log.info("Selenium Grid hub is up and running");
        log.info(String.format("Nodes should register to %s", this.getRegistrationURL()));
        log.info(String.format("Clients should connect to %s", this.getWebDriverHubRequestURL()));
    }

    @Override
    public void stop() {
        this.registry.stop();
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ManagedAttribute(name="URL")
    public URL getUrl() {
        return this.getUrl("");
    }

    public URL getUrl(String path) {
        try {
            return new URL("http://" + this.config.host + ":" + this.config.port + path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getRegistrationURL() {
        return this.getUrl("/grid/register/");
    }

    public URL getWebDriverHubRequestURL() {
        return this.getUrl("/wd/hub");
    }

    public URL getConsoleURL() {
        return this.getUrl("/grid/console");
    }

    @ManagedAttribute(name="NewSessionRequestCount")
    public int getNewSessionRequestCount() {
        return this.getRegistry().getNewSessionRequestCount();
    }

    private void updateHostToNonLoopBackAddressOfThisMachine() {
        NetworkUtils utils = new NetworkUtils();
        this.config.host = utils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
    }
}

