/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.io.FileHandler;

class SessionData {
    private final Iterable<File> sessionDataFiles;

    private SessionData(Iterable<File> sessionDataFiles) {
        this.sessionDataFiles = sessionDataFiles;
    }

    public static SessionData forCurrentPlatform() {
        Platform current = Platform.getCurrent();
        ImmutableList<File> files = ImmutableList.of();
        if (current.is(Platform.MAC)) {
            File libraryDir = new File("/Users", String.valueOf(System.getenv("USER")) + "/Library");
            files = ImmutableList.of(new File(libraryDir, "Caches/com.apple.Safari/Cache.db"), new File(libraryDir, "Cookies/Cookies.binarycookies"), new File(libraryDir, "Cookies/Cookies.plist"), new File(libraryDir, "Safari/History.plist"), new File(libraryDir, "Safari/LastSession.plist"), new File(libraryDir, "Safari/LocalStorage"), new File(libraryDir, "Safari/Databases"));
        }
        if (current.is(Platform.WINDOWS)) {
            File appDataDir = new File(System.getenv("APPDATA"), "Apple Computer/Safari");
            File localDataDir = new File(System.getenv("LOCALAPPDATA"), "Apple Computer/Safari");
            files = ImmutableList.of(new File(appDataDir, "History.plist"), new File(appDataDir, "LastSession.plist"), new File(appDataDir, "Cookies/Cookies.plist"), new File(appDataDir, "Cookies/Cookies.binarycookies"), new File(localDataDir, "Cache.db"), new File(localDataDir, "Databases"), new File(localDataDir, "LocalStorage"));
        }
        return new SessionData(files);
    }

    public void clear() throws IOException {
        for (File file : this.sessionDataFiles) {
            FileHandler.delete(file);
        }
    }
}

