/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.remote.server.KnownElements;

public class ArgumentConverter
implements Function<Object, Object> {
    private final KnownElements knownElements;

    public ArgumentConverter(KnownElements knownElements) {
        this.knownElements = knownElements;
    }

    @Override
    public Object apply(Object arg) {
        if (arg instanceof Map) {
            Map paramAsMap = (Map)arg;
            if (paramAsMap.containsKey("ELEMENT")) {
                KnownElements.ProxiedElement element = (KnownElements.ProxiedElement)((Object)this.knownElements.get((String)paramAsMap.get("ELEMENT")));
                return element.getWrappedElement();
            }
            HashMap<String, Object> converted = Maps.newHashMapWithExpectedSize(paramAsMap.size());
            for (Map.Entry entry : paramAsMap.entrySet()) {
                converted.put((String)entry.getKey(), this.apply(entry.getValue()));
            }
            return converted;
        }
        if (arg instanceof List) {
            return Lists.newArrayList(Iterables.transform((List)arg, this));
        }
        return arg;
    }
}

