/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util.jmx;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.TypeUtil;

public class ModelMBeanImpl
implements ModelMBean,
MBeanRegistration {
    private static Log log = LogFactory.getLog(ModelMBeanImpl.class);
    public static final int IMPACT_ACTION = 1;
    public static final int IMPACT_ACTION_INFO = 2;
    public static final int IMPACT_INFO = 0;
    public static final int IMPACT_UNKOWN = 3;
    public static final String STRING = "java.lang.String";
    public static final String OBJECT = "java.lang.Object";
    public static final String INT = "int";
    public static final String[] NO_PARAMS = new String[0];
    public static final boolean READ_WRITE = true;
    public static final boolean READ_ONLY = false;
    public static final boolean ON_MBEAN = true;
    public static final boolean ON_OBJECT = false;
    private static HashMap __objectId = new HashMap();
    private static String __defaultDomain = "org.openqa.jetty";
    protected ModelMBeanInfoSupport _beanInfo;
    private MBeanServer _mBeanServer;
    private Object _object;
    private ObjectName _objectName;
    private boolean _dirty = false;
    private HashMap _getter = new HashMap(4);
    private HashMap _setter = new HashMap(4);
    private HashMap _method = new HashMap(4);
    private ArrayList _attributes = new ArrayList(4);
    private ArrayList _operations = new ArrayList(4);
    private ArrayList _notifications = new ArrayList(4);
    private String _baseObjectName = null;
    private Map _components = new HashMap(4);

    public static ModelMBean mbeanFor(Object o) {
        try {
            Class<?> oClass = o.getClass();
            ClassLoader loader = oClass.getClassLoader();
            ModelMBean mbean = null;
            boolean jmx = false;
            Class<?>[] interfaces = null;
            int i = 0;
            while (mbean == null && oClass != null) {
                Class<?> focus = interfaces == null ? oClass : interfaces[i];
                String pName = focus.getPackage().getName();
                String cName = focus.getName().substring(pName.length() + 1);
                String mName = String.valueOf(pName) + (jmx ? ".jmx." : ".") + cName + "MBean";
                try {
                    Class<?> mClass = loader.loadClass(mName);
                    if (log.isTraceEnabled()) {
                        log.trace("mbeanFor " + o + " mClass=" + mClass);
                    }
                    mbean = (ModelMBean)mClass.newInstance();
                    mbean.setManagedResource(o, "objectReference");
                    if (log.isDebugEnabled()) {
                        log.debug("mbeanFor " + o + " is " + mbean);
                    }
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    if (e.toString().endsWith("MBean")) {
                        if (log.isTraceEnabled()) {
                            log.trace(e.toString());
                        }
                    } else {
                        log.warn("EXCEPTION ", e);
                    }
                }
                catch (Error e) {
                    log.warn("EXCEPTION ", e);
                    mbean = null;
                }
                catch (Exception e) {
                    log.warn("EXCEPTION ", e);
                    mbean = null;
                }
                if (jmx) {
                    if (interfaces != null) {
                        if (++i >= interfaces.length) {
                            interfaces = null;
                            oClass = oClass.getSuperclass();
                        }
                    } else {
                        interfaces = oClass.getInterfaces();
                        i = 0;
                        if (interfaces == null || interfaces.length == 0) {
                            interfaces = null;
                            oClass = oClass.getSuperclass();
                        }
                    }
                }
                boolean bl = jmx = !jmx;
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
        return null;
    }

    public ModelMBeanImpl() {
    }

    public ModelMBeanImpl(Object proxyObject) {
        try {
            this.setManagedResource(proxyObject, "objectReference");
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static String getDefaultDomain() {
        return __defaultDomain;
    }

    public static void setDefaultDomain(String d) {
        __defaultDomain = d;
    }

    public MBeanServer getMBeanServer() {
        return this._mBeanServer;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public Object getManagedResource() {
        return this._object;
    }

    @Override
    public void setManagedResource(Object proxyObject, String type) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (proxyObject == null) {
            proxyObject = null;
            return;
        }
        log.debug("setManagedResource");
        if (!"objectreference".equalsIgnoreCase(type)) {
            throw new InvalidTargetObjectTypeException(type);
        }
        if (this._object == null) {
            this._object = proxyObject;
            this.defineManagedResource();
        } else {
            this._object = proxyObject;
        }
    }

    protected void defineManagedResource() {
    }

    @Override
    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        throw new Error("setModelMBeanInfo not supported");
    }

    public synchronized void defineAttribute(String name) {
        this.defineAttribute(name, true, false);
    }

    public synchronized void defineAttribute(String name, boolean writable) {
        this.defineAttribute(name, writable, false);
    }

    public synchronized void defineAttribute(String name, boolean writable, boolean onMBean) {
        this._dirty = true;
        String uName = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        name = Introspector.decapitalize(name);
        Class<?> oClass = onMBean ? this.getClass() : this._object.getClass();
        Class<?> type = null;
        Method getter = null;
        Method setter = null;
        Method[] methods = oClass.getMethods();
        int m = 0;
        while (m < methods.length) {
            if ((methods[m].getModifiers() & 1) != 0) {
                if (methods[m].getName().equals("get" + uName) && methods[m].getParameterTypes().length == 0) {
                    if (getter != null) {
                        throw new IllegalArgumentException("Multiple getters for attr " + name);
                    }
                    getter = methods[m];
                    if (type != null && !type.equals(methods[m].getReturnType())) {
                        throw new IllegalArgumentException("Type conflict for attr " + name);
                    }
                    type = methods[m].getReturnType();
                }
                if (methods[m].getName().equals("is" + uName) && methods[m].getParameterTypes().length == 0) {
                    if (getter != null) {
                        throw new IllegalArgumentException("Multiple getters for attr " + name);
                    }
                    getter = methods[m];
                    if (type != null && !type.equals(methods[m].getReturnType())) {
                        throw new IllegalArgumentException("Type conflict for attr " + name);
                    }
                    type = methods[m].getReturnType();
                }
                if (writable && methods[m].getName().equals("set" + uName) && methods[m].getParameterTypes().length == 1) {
                    if (setter != null) {
                        throw new IllegalArgumentException("Multiple setters for attr " + name);
                    }
                    setter = methods[m];
                    if (type != null && !type.equals(methods[m].getParameterTypes()[0])) {
                        throw new IllegalArgumentException("Type conflict for attr " + name);
                    }
                    type = methods[m].getParameterTypes()[0];
                }
            }
            ++m;
        }
        if (getter == null && setter == null) {
            throw new IllegalArgumentException("No getter or setters found for " + name);
        }
        try {
            this._getter.put(name, getter);
            this._setter.put(name, setter);
            this._attributes.add(new ModelMBeanAttributeInfo(name, this.findDescription(name), getter, setter));
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void defineAttribute(ModelMBeanAttributeInfo attrInfo) {
        if (this._object == null) {
            throw new IllegalStateException("No Object");
        }
        this._dirty = true;
        String name = attrInfo.getName();
        String uName = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        Class<?> oClass = this._object.getClass();
        try {
            Class<?> type = TypeUtil.fromName(attrInfo.getType());
            if (type == null) {
                type = Thread.currentThread().getContextClassLoader().loadClass(attrInfo.getType());
            }
            Method getter = null;
            Method setter = null;
            if (attrInfo.isReadable()) {
                getter = oClass.getMethod(String.valueOf(attrInfo.isIs() ? "is" : "get") + uName, null);
            }
            if (attrInfo.isWritable()) {
                setter = oClass.getMethod("set" + uName, type);
            }
            this._getter.put(name, getter);
            this._setter.put(name, setter);
            this._attributes.add(attrInfo);
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void defineOperation(String name, int impact) {
        this.defineOperation(name, null, impact, false);
    }

    public synchronized void defineOperation(String name, String[] signature, int impact) {
        this.defineOperation(name, signature, impact, false);
    }

    public synchronized void defineOperation(String name, String[] signature, int impact, boolean onMBean) {
        Class<?> oClass;
        this._dirty = true;
        Class<?> clazz = oClass = onMBean ? this.getClass() : this._object.getClass();
        if (signature == null) {
            signature = new String[]{};
        }
        try {
            Class[] types = new Class[signature.length];
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[signature.length];
            String methodKey = String.valueOf(name) + "(";
            int i = 0;
            while (i < signature.length) {
                Class<?> type = TypeUtil.fromName(signature[i]);
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
                }
                types[i] = type;
                signature[i] = type.isPrimitive() ? TypeUtil.toName(type) : signature[i];
                methodKey = String.valueOf(methodKey) + (i > 0 ? "," : "") + signature[i];
                ++i;
            }
            methodKey = String.valueOf(methodKey) + ")";
            i = 0;
            while (i < signature.length) {
                String description = this.findDescription(String.valueOf(methodKey) + "[" + i + "]");
                int colon = description.indexOf(":");
                if (colon < 0) {
                    description = "param" + i + ":" + description;
                    colon = description.indexOf(":");
                }
                pInfo[i] = new MBeanParameterInfo(description.substring(0, colon).trim(), signature[i], description.substring(colon + 1).trim());
                ++i;
            }
            Method method = oClass.getMethod(name, types);
            Class<?> returnClass = method.getReturnType();
            this._method.put(methodKey, method);
            this._operations.add(new ModelMBeanOperationInfo(name, this.findDescription(methodKey), pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact));
        }
        catch (Exception e) {
            log.warn("operation " + name, e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void defineOperation(ModelMBeanOperationInfo opInfo) {
        this._dirty = true;
        Class<?> oClass = this._object.getClass();
        try {
            MBeanParameterInfo[] pInfo = opInfo.getSignature();
            Class[] types = new Class[pInfo.length];
            String method = String.valueOf(opInfo.getName()) + "(";
            int i = 0;
            while (i < pInfo.length) {
                Class<?> type = TypeUtil.fromName(pInfo[i].getType());
                if (type == null) {
                    type = Thread.currentThread().getContextClassLoader().loadClass(pInfo[i].getType());
                }
                types[i] = type;
                method = String.valueOf(method) + (i > 0 ? "," : "") + pInfo[i].getType();
                ++i;
            }
            method = String.valueOf(method) + ")";
            this._method.put(method, oClass.getMethod(opInfo.getName(), types));
            this._operations.add(opInfo);
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        log.debug("getMBeanInfo");
        if (this._dirty) {
            this._dirty = false;
            ModelMBeanAttributeInfo[] attributes = this._attributes.toArray(new ModelMBeanAttributeInfo[this._attributes.size()]);
            ModelMBeanOperationInfo[] operations = this._operations.toArray(new ModelMBeanOperationInfo[this._operations.size()]);
            ModelMBeanNotificationInfo[] notifications = this._notifications.toArray(new ModelMBeanNotificationInfo[this._notifications.size()]);
            this._beanInfo = new ModelMBeanInfoSupport(this._object.getClass().getName(), this.findDescription(null), attributes, null, operations, notifications);
        }
        return this._beanInfo;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter;
        if (log.isDebugEnabled()) {
            log.debug("getAttribute " + name);
        }
        if ((getter = (Method)this._getter.get(name)) == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            Object o = this._object;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            return getter.invoke(o, null);
        }
        catch (IllegalAccessException e) {
            log.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            log.warn("EXCEPTION ", e);
            throw new ReflectionException((Exception)e.getTargetException());
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        log.debug("getAttributes");
        AttributeList results = new AttributeList(names.length);
        int i = 0;
        while (i < names.length) {
            try {
                results.add(new Attribute(names[i], this.getAttribute(names[i])));
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", e);
            }
            ++i;
        }
        return results;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("setAttribute " + attr.getName() + "=" + attr.getValue());
        }
        if ((setter = (Method)this._setter.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object o = this._object;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            setter.invoke(o, attr.getValue());
        }
        catch (IllegalAccessException e) {
            log.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            log.warn("EXCEPTION ", e);
            throw new ReflectionException((Exception)e.getTargetException());
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        log.debug("setAttributes");
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", e);
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug("invoke " + name);
        }
        String methodKey = String.valueOf(name) + "(";
        if (signature != null) {
            int i = 0;
            while (i < signature.length) {
                methodKey = String.valueOf(methodKey) + (i > 0 ? "," : "") + signature[i];
                ++i;
            }
        }
        methodKey = String.valueOf(methodKey) + ")";
        try {
            Method method = (Method)this._method.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o = this._object;
            if (method.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            return method.invoke(o, params);
        }
        catch (NoSuchMethodException e) {
            log.warn("EXCEPTION ", e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            log.warn("EXCEPTION ", e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            log.warn("EXCEPTION ", e);
            throw new ReflectionException((Exception)e.getTargetException());
        }
    }

    @Override
    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        log.debug("load");
    }

    @Override
    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        log.debug("store");
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        log.debug("addNotificationListener");
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        log.debug("getNotificationInfo");
        return null;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        log.debug("removeNotificationListener");
    }

    @Override
    public void addAttributeChangeNotificationListener(NotificationListener listener, String name, Object handback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        log.debug("addAttributeChangeNotificationListener");
    }

    @Override
    public void removeAttributeChangeNotificationListener(NotificationListener listener, String name) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        log.debug("removeAttributeChangeNotificationListener");
    }

    @Override
    public void sendAttributeChangeNotification(Attribute oldAttr, Attribute newAttr) throws MBeanException, RuntimeOperationsException {
        log.debug("sendAttributeChangeNotification");
    }

    @Override
    public void sendAttributeChangeNotification(AttributeChangeNotification notify) throws MBeanException, RuntimeOperationsException {
        log.debug("sendAttributeChangeNotification");
    }

    @Override
    public void sendNotification(String notify) throws MBeanException, RuntimeOperationsException {
        log.debug("sendNotification");
    }

    @Override
    public void sendNotification(Notification notify) throws MBeanException, RuntimeOperationsException {
        log.debug("sendNotification");
    }

    private String findDescription(String key) {
        Class<?> lookIn = this.getClass();
        String[] objectNames = new String[3];
        objectNames[0] = this._object.getClass().getName();
        if (objectNames[0].indexOf(".") >= 0) {
            objectNames[1] = objectNames[0].substring(objectNames[0].lastIndexOf(".") + 1);
        }
        while (lookIn != null) {
            block17: {
                String resource;
                String pkg = lookIn.getName();
                int lastDot = pkg.lastIndexOf(".");
                if (lastDot > 0) {
                    objectNames[2] = pkg.substring(lastDot + 1);
                    pkg = pkg.substring(0, lastDot);
                } else {
                    objectNames[2] = pkg;
                    pkg = null;
                }
                String string = resource = pkg == null ? "mbean" : String.valueOf(pkg.replace('.', '/')) + "/mbean";
                if (log.isTraceEnabled()) {
                    log.trace("Look for: " + resource);
                }
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(resource, Locale.getDefault(), this._object.getClass().getClassLoader());
                    if (log.isTraceEnabled()) {
                        log.trace("Bundle " + resource);
                    }
                    int i = 0;
                    while (i < objectNames.length) {
                        block16: {
                            String name = objectNames[i];
                            if (name != null) {
                                if (name.endsWith("MBean")) {
                                    name = name.substring(0, name.length() - 5);
                                }
                                if (key != null && key.length() > 0) {
                                    name = String.valueOf(name) + "." + key;
                                }
                                try {
                                    String description = bundle.getString(name);
                                    if (description != null && description.length() > 0) {
                                        return description;
                                    }
                                }
                                catch (Exception e) {
                                    if (!log.isTraceEnabled()) break block16;
                                    log.trace(e.toString());
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block17;
                    log.trace(e.toString());
                }
            }
            lookIn = lookIn.getSuperclass();
        }
        if (key == null || key.length() == 0) {
            return objectNames[0];
        }
        return key;
    }

    protected ObjectName newObjectName(MBeanServer server) {
        if (this._baseObjectName != null) {
            if (this._baseObjectName.indexOf(58) >= 0) {
                return this.uniqueObjectName(server, this._baseObjectName);
            }
            return this.uniqueObjectName(server, String.valueOf(ModelMBeanImpl.getDefaultDomain()) + ":" + this._baseObjectName);
        }
        return this.uniqueObjectName(server, String.valueOf(ModelMBeanImpl.getDefaultDomain()) + ":");
    }

    public void setBaseObjectName(String s) {
        this._baseObjectName = s;
    }

    public String getBaseObjectName() {
        return this._baseObjectName;
    }

    @Override
    public synchronized ObjectName preRegister(MBeanServer server, ObjectName oName) {
        this._mBeanServer = server;
        this._objectName = oName;
        if (this._objectName == null) {
            try {
                oName = this.newObjectName(server);
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("preRegister " + this._objectName + " -> " + oName);
        }
        this._objectName = oName;
        return this._objectName;
    }

    @Override
    public void postRegister(Boolean ok) {
        if (ok.booleanValue()) {
            log.info("Registered " + this._objectName);
        } else {
            this._mBeanServer = null;
            this._objectName = null;
        }
    }

    @Override
    public void preDeregister() {
        log.info("Deregister " + this._objectName);
        this.getComponentMBeans(null, this._components);
        this._components.clear();
    }

    @Override
    public void postDeregister() {
        this._beanInfo = null;
        this._mBeanServer = null;
        this._object = null;
        this._objectName = null;
        if (this._getter != null) {
            this._getter.clear();
        }
        this._getter = null;
        if (this._setter != null) {
            this._setter.clear();
        }
        this._setter = null;
        if (this._method != null) {
            this._method.clear();
        }
        this._method = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._attributes = null;
        if (this._operations != null) {
            this._operations.clear();
        }
        this._operations = null;
        if (this._notifications != null) {
            this._notifications.clear();
        }
        this._notifications = null;
    }

    public synchronized ObjectName uniqueObjectName(MBeanServer server, String objectName) {
        return this.uniqueObjectName(server, this._object, objectName);
    }

    public synchronized ObjectName uniqueObjectName(MBeanServer server, Object object, String objectName) {
        if (!objectName.endsWith("=")) {
            String className = object.getClass().getName();
            if (className.indexOf(".") > 0) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            if (className.endsWith("MBean")) {
                className = className.substring(0, className.length() - 5);
            }
            if (!objectName.endsWith(":")) {
                objectName = String.valueOf(objectName) + ",";
            }
            objectName = String.valueOf(objectName) + className + "=";
        }
        ObjectName oName = null;
        try {
            do {
                Integer id;
                if ((id = (Integer)__objectId.get(objectName)) == null) {
                    id = new Integer(0);
                }
                oName = new ObjectName(String.valueOf(objectName) + id);
                id = new Integer(id + 1);
                __objectId.put(objectName, id);
            } while (server != null && server.isRegistered(oName));
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
        }
        return oName;
    }

    protected ObjectName[] getComponentMBeans(Object[] components, Map map) {
        if (map == null) {
            map = this._components;
        }
        ObjectName[] beans = null;
        if (components == null) {
            beans = new ObjectName[]{};
        } else {
            beans = new ObjectName[components == null ? 0 : components.length];
            int i = 0;
            while (i < components.length) {
                ObjectName on = (ObjectName)map.get(components[i]);
                if (on == null) {
                    ModelMBean mbean = ModelMBeanImpl.mbeanFor(components[i]);
                    if (mbean == null) {
                        log.warn("No mbean for " + components[i]);
                    } else {
                        try {
                            if (mbean instanceof ModelMBeanImpl) {
                                ((ModelMBeanImpl)mbean).setBaseObjectName(this.getObjectName().toString());
                                on = this.getMBeanServer().registerMBean(mbean, null).getObjectName();
                            } else {
                                on = this.uniqueObjectName(this.getMBeanServer(), components[i], this.getObjectName().toString());
                                on = this.getMBeanServer().registerMBean(mbean, on).getObjectName();
                            }
                            map.put(components[i], on);
                        }
                        catch (Exception e) {
                            log.warn("EXCEPTION ", e);
                        }
                    }
                }
                beans[i] = on;
                ++i;
            }
        }
        if (components == null || map.size() > components.length) {
            Object[] to_delete = new Object[map.size() - beans.length];
            int d = 0;
            block5: for (Object bean : map.keySet()) {
                if (components != null) {
                    int i = 0;
                    while (i < components.length) {
                        if (components[i] == bean) continue block5;
                        ++i;
                    }
                }
                to_delete[d++] = bean;
            }
            while (d-- > 0) {
                try {
                    this.getMBeanServer().unregisterMBean((ObjectName)map.remove(to_delete[d]));
                }
                catch (Exception e) {
                    log.warn("EXCEPTION ", e);
                }
            }
        }
        return beans;
    }

    protected void destroyComponentMBeans(Map map) {
        if (map == null) {
            map = this._components;
        }
        if (map == null) {
            return;
        }
        Iterator itor = map.values().iterator();
        while (itor.hasNext()) {
            try {
                ObjectName o = (ObjectName)itor.next();
                this.getMBeanServer().unregisterMBean(o);
                itor.remove();
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", e);
            }
        }
    }
}

