/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.webbitserver.helpers.Base64;
import org.webbitserver.netty.HybiWebSocketFrameDecoder;
import org.webbitserver.netty.HybiWebSocketFrameEncoder;
import org.webbitserver.netty.NettyWebSocketConnection;
import org.webbitserver.netty.WebSocketVersion;

public class Hybi
implements WebSocketVersion {
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    private static final Charset ASCII = Charset.forName("ASCII");
    private static final String ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final int MIN_HYBI_VERSION = 8;
    private static final MessageDigest SHA1;
    private final HttpRequest req;
    private final HttpResponse res;

    public Hybi(HttpRequest req, HttpResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public boolean matches() {
        return this.getHybiVersion() != null;
    }

    @Override
    public void prepareHandshakeResponse(NettyWebSocketConnection webSocketConnection) {
        webSocketConnection.setHybiWebSocketVersion(this.getHybiVersion());
        if (this.getHybiVersion() < 8) {
            this.res.setStatus(HttpResponseStatus.UPGRADE_REQUIRED);
            this.res.setHeader(SEC_WEBSOCKET_VERSION, String.valueOf(8));
            return;
        }
        String key = this.req.getHeader(SEC_WEBSOCKET_KEY);
        if (key == null) {
            this.res.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        String accept = Base64.encode(this.sha1(key + ACCEPT_GUID));
        this.res.setStatus(new HttpResponseStatus(101, "Switching Protocols"));
        this.res.addHeader("Upgrade", "WebSocket".toLowerCase());
        this.res.addHeader("Connection", "Upgrade");
        this.res.addHeader(SEC_WEBSOCKET_ACCEPT, accept);
    }

    @Override
    public ChannelHandler createDecoder() {
        return HybiWebSocketFrameDecoder.serverSide();
    }

    @Override
    public ChannelHandler createEncoder() {
        return new HybiWebSocketFrameEncoder();
    }

    private Integer getHybiVersion() {
        return this.req.containsHeader(SEC_WEBSOCKET_VERSION) ? Integer.valueOf(Integer.parseInt(this.req.getHeader(SEC_WEBSOCKET_VERSION).trim())) : null;
    }

    private byte[] sha1(String s) {
        return SHA1.digest(s.getBytes(ASCII));
    }

    static {
        try {
            SHA1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform");
        }
    }
}

