/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.webbitserver.netty.NettyWebSocketConnection;
import org.webbitserver.netty.WebSocketVersion;

public class Hixie76
implements WebSocketVersion {
    private static final MessageDigest MD5;
    private final HttpRequest req;
    private final HttpResponse res;

    public Hixie76(HttpRequest req, HttpResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public boolean matches() {
        return this.req.containsHeader("Sec-WebSocket-Key1") && this.req.containsHeader("Sec-WebSocket-Key2");
    }

    @Override
    public void prepareHandshakeResponse(NettyWebSocketConnection webSocketConnection) {
        webSocketConnection.setVersion("HIXIE-76");
        this.res.setStatus(new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
        this.res.addHeader("Upgrade", "WebSocket");
        this.res.addHeader("Connection", "Upgrade");
        this.res.addHeader("Sec-WebSocket-Origin", this.req.getHeader("Origin"));
        this.res.addHeader("Sec-WebSocket-Location", this.getWebSocketLocation(this.req));
        String protocol = this.req.getHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            this.res.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        String key1 = this.req.getHeader("Sec-WebSocket-Key1");
        String key2 = this.req.getHeader("Sec-WebSocket-Key2");
        int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
        int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
        long c = this.req.getContent().readLong();
        ChannelBuffer input = ChannelBuffers.buffer(16);
        input.writeInt(a);
        input.writeInt(b);
        input.writeLong(c);
        ChannelBuffer output = ChannelBuffers.wrappedBuffer(MD5.digest(input.array()));
        this.res.setContent(output);
    }

    @Override
    public ChannelHandler createDecoder() {
        return new WebSocketFrameDecoder();
    }

    @Override
    public ChannelHandler createEncoder() {
        return new WebSocketFrameEncoder();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return this.getWebSocketProtocol(req) + req.getHeader("Host") + req.getUri();
    }

    private String getWebSocketProtocol(HttpRequest req) {
        if (req.getHeader("Origin").matches("(?s)https://.*")) {
            return "wss://";
        }
        return "ws://";
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 not supported on this platform");
        }
    }
}

