/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.webbitserver.netty.NettyWebSocketConnection;
import org.webbitserver.netty.WebSocketVersion;

public class Hixie75
implements WebSocketVersion {
    private final HttpRequest req;
    private final HttpResponse res;

    public Hixie75(HttpRequest req, HttpResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public boolean matches() {
        return false;
    }

    @Override
    public void prepareHandshakeResponse(NettyWebSocketConnection webSocketConnection) {
        webSocketConnection.setVersion("HIXIE-75");
        this.res.setStatus(new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
        this.res.addHeader("Upgrade", "WebSocket");
        this.res.addHeader("Connection", "Upgrade");
        String origin = this.req.getHeader("Origin");
        if (origin != null) {
            this.res.addHeader("WebSocket-Origin", origin);
        }
        this.res.addHeader("WebSocket-Location", this.getWebSocketLocation(this.req));
        String protocol = this.req.getHeader("WebSocket-Protocol");
        if (protocol != null) {
            this.res.addHeader("WebSocket-Protocol", protocol);
        }
    }

    @Override
    public ChannelHandler createDecoder() {
        return new WebSocketFrameDecoder();
    }

    @Override
    public ChannelHandler createEncoder() {
        return new WebSocketFrameEncoder();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return this.getWebSocketProtocol(req) + req.getHeader("Host") + req.getUri();
    }

    private String getWebSocketProtocol(HttpRequest req) {
        if (req.getHeader("Origin").matches("(?s)https://.*")) {
            return "wss://";
        }
        return "ws://";
    }
}

