/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;
import org.openqa.selenium.remote.internal.CircularOutputStream;

public class Executable {
    private static final File SYSTEM_BINARY = Executable.locateFirefoxBinaryFromSystemProperty();
    private static final File PLATFORM_BINARY = Executable.locateFirefoxBinaryFromPlatform();
    private final File binary;

    public Executable(File userSpecifiedBinaryPath) {
        if (userSpecifiedBinaryPath != null) {
            if (userSpecifiedBinaryPath.exists() && userSpecifiedBinaryPath.isFile()) {
                this.binary = userSpecifiedBinaryPath;
                return;
            }
            throw new WebDriverException("Specified firefox binary location does not exist or is not a real file: " + userSpecifiedBinaryPath);
        }
        if (SYSTEM_BINARY != null && SYSTEM_BINARY.exists()) {
            this.binary = SYSTEM_BINARY;
            return;
        }
        if (PLATFORM_BINARY != null && PLATFORM_BINARY.exists()) {
            this.binary = PLATFORM_BINARY;
            return;
        }
        throw new WebDriverException("Cannot find firefox binary in PATH. Make sure firefox is installed. OS appears to be: " + (Object)((Object)Platform.getCurrent()));
    }

    public File getFile() {
        return this.binary;
    }

    public String getPath() {
        return this.binary.getAbsolutePath();
    }

    public void setLibraryPath(CommandLine command, Map<String, String> extraEnv) {
        String propertyName = CommandLine.getLibraryPathPropertyName();
        StringBuilder libraryPath = new StringBuilder();
        String env = Executable.getEnvVar(propertyName, null);
        if (env != null) {
            libraryPath.append(env).append(File.pathSeparator);
        }
        if ((env = extraEnv.get(propertyName)) != null) {
            libraryPath.append(env).append(File.pathSeparator);
        }
        String firefoxLibraryPath = System.getProperty("webdriver.firefox.library.path", this.binary.getParentFile().getAbsolutePath());
        if (Platform.getCurrent().is(Platform.MAC) && Platform.getCurrent().getMinorVersion() > 5) {
            libraryPath.append((CharSequence)libraryPath).append(File.pathSeparator);
        } else {
            libraryPath.append(firefoxLibraryPath).append(File.pathSeparator).append((CharSequence)libraryPath);
        }
        command.setEnvironmentVariable(propertyName, libraryPath.toString());
    }

    private static File locateFirefoxBinaryFromSystemProperty() {
        String binaryName = System.getProperty("webdriver.firefox.bin");
        if (binaryName == null) {
            return null;
        }
        File binary = new File(binaryName);
        if (binary.exists()) {
            return binary;
        }
        switch (Platform.getCurrent()) {
            case WINDOWS: 
            case XP: 
            case VISTA: {
                if (binaryName.endsWith(".exe")) break;
                binaryName = String.valueOf(binaryName) + ".exe";
                break;
            }
            case MAC: {
                if (!binaryName.endsWith(".app")) {
                    binaryName = String.valueOf(binaryName) + ".app";
                }
                binaryName = String.valueOf(binaryName) + "/Contents/MacOS/firefox-bin";
            }
        }
        binary = new File(binaryName);
        if (binary.exists()) {
            return binary;
        }
        throw new WebDriverException(String.format("\"webdriver.firefox.bin\" property set, but unable to locate the requested binary: %s", binaryName));
    }

    private static File locateFirefoxBinaryFromPlatform() {
        File binary = null;
        switch (Platform.getCurrent()) {
            case WINDOWS: 
            case XP: 
            case VISTA: {
                binary = Executable.findExistingBinary(WindowsUtils.getPathsInProgramFiles("Mozilla Firefox\\firefox.exe"));
                break;
            }
            case MAC: {
                binary = new File("/Applications/Firefox.app/Contents/MacOS/firefox-bin");
            }
        }
        if (binary != null && binary.exists()) {
            return binary;
        }
        String systemFirefox = CommandLine.find("firefox");
        if (systemFirefox != null) {
            return new File(systemFirefox);
        }
        return null;
    }

    private static File findExistingBinary(ImmutableList<String> paths) {
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static String getEnvVar(String name, String defaultValue) {
        String value = System.getenv(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public OutputStream getDefaultOutputStream() {
        String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
        if ("/dev/stdout".equals(firefoxLogFile)) {
            return System.out;
        }
        File logFile = firefoxLogFile == null ? null : new File(firefoxLogFile);
        return new CircularOutputStream(logFile);
    }
}

