/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.internal.HttpClientFactory;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.log.LoggingManager;

public class SelfRegisteringRemote {
    private static final Logger log = Logger.getLogger(SelfRegisteringRemote.class.getName());
    private RegistrationRequest nodeConfig;
    private final HttpClientFactory httpClientFactory;
    private SeleniumServer server;

    public SelfRegisteringRemote(RegistrationRequest config) {
        this.nodeConfig = config;
        this.httpClientFactory = new HttpClientFactory();
    }

    public URL getRemoteURL() {
        String host = (String)this.nodeConfig.getConfiguration().get("host");
        String port = (String)this.nodeConfig.getConfiguration().get("port");
        String url = "http://" + host + ":" + port;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GridConfigurationException("error building the node url " + e.getMessage(), e);
        }
    }

    public void startRemoteServer() throws Exception {
        List<String> servlets;
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        this.nodeConfig.validate();
        RemoteControlConfiguration remoteControlConfiguration = this.nodeConfig.getRemoteControlConfiguration();
        try {
            JSONObject hubParameters = this.getHubConfiguration("timeout", "browserTimeout");
            if (hubParameters.has("timeout")) {
                int timeout = hubParameters.getInt("timeout") / 1000;
                remoteControlConfiguration.setTimeoutInSeconds(timeout);
            }
            if (hubParameters.has("browserTimeout")) {
                int browserTimeout = hubParameters.getInt("browserTimeout");
                remoteControlConfiguration.setBrowserTimeoutInMs(browserTimeout);
            }
        }
        catch (Exception e) {
            log.warning("error getting the parameters from the hub. The node may end up with wrong timeouts." + e.getMessage());
        }
        this.server = new SeleniumServer(remoteControlConfiguration);
        Server jetty = this.server.getServer();
        String servletsStr = (String)this.nodeConfig.getConfiguration().get("servlets");
        if (servletsStr != null && (servlets = Arrays.asList(servletsStr.split(","))) != null) {
            HttpContext extra = new HttpContext();
            extra.setContextPath("/extra");
            ServletHandler handler = new ServletHandler();
            handler.addServlet("/resources/*", ResourceServlet.class.getName());
            for (String s : servlets) {
                Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
                if (servletClass == null) continue;
                String path = "/" + servletClass.getSimpleName() + "/*";
                String clazz = servletClass.getCanonicalName();
                handler.addServlet(path, clazz);
                log.info("started extra node servlet visible at : http://xxx:" + this.nodeConfig.getConfiguration().get("port") + "/extra" + path);
            }
            extra.addHandler(handler);
            jetty.addContext(extra);
        }
        this.server.boot();
    }

    public void stopRemoteServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void deleteAllBrowsers() {
        this.nodeConfig.getCapabilities().clear();
    }

    public void addBrowser(DesiredCapabilities cap, int instances) {
        String s = cap.getBrowserName();
        if (s == null || "".equals(s)) {
            throw new InvalidParameterException(cap + " does seems to be a valid browser.");
        }
        cap.setPlatform(Platform.getCurrent());
        cap.setCapability("maxInstances", instances);
        this.nodeConfig.getCapabilities().add(cap);
    }

    public void sendRegistrationRequest() {
        this.registerToHub(false);
    }

    public void startRegistrationProcess() {
        log.info("using the json request : " + this.nodeConfig.toJSON());
        Boolean register = (Boolean)this.nodeConfig.getConfiguration().get("register");
        if (!register.booleanValue()) {
            log.info("no registration sent ( register = false )");
        } else {
            final Integer o = (Integer)this.nodeConfig.getConfiguration().get("registerCycle");
            if (o != null && o > 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean first = true;
                        log.info("starting auto register thread. Will try to register every " + o + " ms.");
                        while (true) {
                            try {
                                boolean checkForPresence = true;
                                if (first) {
                                    first = false;
                                    checkForPresence = false;
                                }
                                SelfRegisteringRemote.this.registerToHub(checkForPresence);
                            }
                            catch (GridException e) {
                                log.info("couldn't register this node : " + e.getMessage());
                            }
                            try {
                                Thread.sleep(o.intValue());
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LoggingManager.perSessionLogHandler().clearThreadTempLogs();
                        }
                    }
                }).start();
            } else {
                this.registerToHub(false);
            }
        }
        LoggingManager.perSessionLogHandler().clearThreadTempLogs();
    }

    public void setTimeout(int timeout, int cycle) {
        this.nodeConfig.getConfiguration().put("timeout", timeout);
        this.nodeConfig.getConfiguration().put("cleanUpCycle", cycle);
    }

    public void setMaxConcurrent(int max) {
        this.nodeConfig.getConfiguration().put("maxSession", max);
    }

    public Map<String, Object> getConfiguration() {
        return this.nodeConfig.getConfiguration();
    }

    private void registerToHub(boolean checkPresenceFirst) {
        block4: {
            boolean ok;
            boolean bl = checkPresenceFirst ? !this.isAlreadyRegistered(this.nodeConfig) : (ok = true);
            if (ok) {
                String tmp = "http://" + this.nodeConfig.getConfiguration().get("hubHost") + ":" + this.nodeConfig.getConfiguration().get("hubPort") + "/grid/register";
                HttpClient client = this.httpClientFactory.getHttpClient();
                try {
                    URL registration = new URL(tmp);
                    log.info("Registering the node to hub :" + registration);
                    BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("POST", registration.toExternalForm());
                    String json = this.nodeConfig.toJSON();
                    r.setEntity(new StringEntity(json));
                    HttpHost host = new HttpHost(registration.getHost(), registration.getPort());
                    HttpResponse response = client.execute(host, r);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new RuntimeException("Error sending the registration request.");
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new GridException("Error sending the registration request.", e);
                }
            }
            log.fine("hub is already present on the hub. Skipping registration.");
        }
    }

    private JSONObject getHubConfiguration(String ... parameters) throws Exception {
        String hubApi = "http://" + this.nodeConfig.getConfiguration().get("hubHost") + ":" + this.nodeConfig.getConfiguration().get("hubPort") + "/grid/api/hub";
        HttpClient client = this.httpClientFactory.getHttpClient();
        URL api = new URL(hubApi);
        HttpHost host = new HttpHost(api.getHost(), api.getPort());
        String url = api.toExternalForm();
        BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("GET", url);
        JSONObject j = new JSONObject();
        JSONArray keys = new JSONArray();
        j.put("configuration", keys);
        r.setEntity(new StringEntity(j.toString()));
        HttpResponse response = client.execute(host, r);
        JSONObject o = SelfRegisteringRemote.extractObject(response);
        return o;
    }

    private boolean isAlreadyRegistered(RegistrationRequest node) {
        HttpClient client = this.httpClientFactory.getHttpClient();
        try {
            String tmp = "http://" + node.getConfiguration().get("hubHost") + ":" + node.getConfiguration().get("hubPort") + "/grid/api/proxy";
            URL api = new URL(tmp);
            HttpHost host = new HttpHost(api.getHost(), api.getPort());
            BasicHttpRequest r = new BasicHttpRequest("GET", String.valueOf(api.toExternalForm()) + "?id=" + node.getConfiguration().get("remoteHost"));
            HttpResponse response = client.execute(host, r);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new GridException("hub down or not responding.");
            }
            JSONObject o = SelfRegisteringRemote.extractObject(response);
            return (Boolean)o.get("success");
        }
        catch (Exception exception) {
            throw new GridException("hub down or not responding.");
        }
    }

    private static JSONObject extractObject(HttpResponse resp) throws IOException, JSONException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
        StringBuilder s = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            s.append(line);
        }
        rd.close();
        return new JSONObject(s.toString());
    }
}

