/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.desktop;

import com.opera.core.systems.internal.WatirUtils;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import java.awt.Point;
import java.util.logging.Logger;

class ClickDelayer {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected long lastClickTime = 0L;
    protected Point lastClickLocation = null;
    protected SystemInputProtos.MouseInfo.MouseButton lastClickMouseButton = null;

    ClickDelayer() {
    }

    public final void delayClickIfNeeded(Point location, SystemInputProtos.MouseInfo.MouseButton button, int numClicks) {
        if (this.lastClickTime > 0L && numClicks == 1 && button.equals(this.lastClickMouseButton) && location.equals(this.lastClickLocation)) {
            long timeSinceLastClick;
            long currentTime = System.currentTimeMillis();
            long doubleClickTime = WatirUtils.getSystemDoubleClickTimeMs().intValue();
            long remainingTime = doubleClickTime - (timeSinceLastClick = currentTime - this.lastClickTime);
            if (remainingTime > 0L) {
                this.logger.fine(String.format("Delaying click in order to avoid double-click - check your test (last click was %d ms ago, OS double click timeout is %d ms)", timeSinceLastClick, doubleClickTime));
                try {
                    Thread.sleep(remainingTime + 100L);
                }
                catch (InterruptedException e) {
                    this.logger.warning("*** Delay was interrupted ***");
                }
            }
        }
        this.lastClickMouseButton = button;
        this.lastClickLocation = location;
        this.lastClickTime = System.currentTimeMillis();
    }
}

