/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.model.RuntimeNode;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.scope.AbstractEcmascriptService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.Ecmascript;
import com.opera.core.systems.scope.stp.services.messages.EcmascriptMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.apache.commons.jxpath.Pointer;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebElement;

public class ScopeEcmascriptService
extends AbstractEcmascriptService
implements Ecmascript {
    private final AtomicStampedReference<EcmascriptProtos.Runtime> runtime = new AtomicStampedReference<Object>(null, 0);
    private final ConcurrentMap<Integer, EcmascriptProtos.Runtime> runtimesList = new ConcurrentHashMap<Integer, EcmascriptProtos.Runtime>();
    private final Queue<Integer> runtimesQueue = Lists.newLinkedList();
    private final Queue<Integer> garbageQueue = Lists.newLinkedList();

    public ScopeEcmascriptService(ScopeServices services) {
        super(services, "ecmascript");
    }

    @Override
    public int getRuntimeId() {
        return this.runtime.getStamp();
    }

    public void setRuntime(EcmascriptProtos.Runtime runtime) {
        if (runtime != null) {
            this.runtime.set(runtime, runtime.getRuntimeID());
            this.activeWindowId = runtime.getWindowID();
        }
    }

    @Override
    public void setRuntime(EsdbgProtos.RuntimeInfo runtime) {
        throw new UnsupportedOperationException("Not supported without ecmascript-debugger");
    }

    @Override
    public void addRuntime(EsdbgProtos.RuntimeInfo info) {
        EcmascriptProtos.Runtime.Builder runtime = EcmascriptProtos.Runtime.newBuilder();
        runtime.setRuntimeID(info.getRuntimeID());
        runtime.setHtmlFramePath(info.getHtmlFramePath());
        runtime.setWindowID(info.getWindowID());
        runtime.setObjectID(info.getObjectID());
        runtime.setUri(info.getUri());
        this.runtimesList.put(info.getRuntimeID(), runtime.build());
    }

    @Override
    public void removeRuntime(int runtimeId) {
        this.runtimesList.remove(runtimeId);
    }

    private List<EcmascriptProtos.Runtime> getRuntimesList() {
        int windowId = this.services.getWindowManager().getActiveWindowId();
        Iterator<?> iterator = this.xpathIterator(this.runtimesList.values(), "/.[windowID='" + windowId + "']");
        ArrayList<EcmascriptProtos.Runtime> runtimes = Lists.newArrayList();
        while (iterator.hasNext()) {
            runtimes.add((EcmascriptProtos.Runtime)((Pointer)iterator.next()).getNode());
        }
        return runtimes;
    }

    @Override
    public void init() {
        this.updateRuntime();
    }

    @Override
    public boolean updateRuntime() {
        EcmascriptProtos.Runtime activeRuntime = this.findRuntime();
        if (activeRuntime != null) {
            this.setRuntime(activeRuntime);
            return true;
        }
        return false;
    }

    protected void createAllRuntimes() {
        EcmascriptProtos.ListRuntimesArg.Builder selection = EcmascriptProtos.ListRuntimesArg.newBuilder();
        selection.setCreate(true);
        UmsProtos.Response response = this.executeMessage(EcmascriptMessage.LIST_RUNTIMES, selection);
        this.runtimesList.clear();
        EcmascriptProtos.RuntimeList.Builder builder = EcmascriptProtos.RuntimeList.newBuilder();
        ScopeEcmascriptService.buildPayload(response, builder);
        List<EcmascriptProtos.Runtime> allRuntimes = builder.build().getRuntimeListList();
        for (EcmascriptProtos.Runtime info : allRuntimes) {
            this.runtimesList.put(info.getRuntimeID(), info);
        }
    }

    @Override
    public Object scriptExecutor(String script, Object ... params) {
        this.processQueues();
        ArrayList<WebElement> elements = Lists.newArrayList();
        String toSend = this.buildEvalString(elements, script, params);
        EcmascriptProtos.EvalArg.Builder evalBuilder = this.buildEval(toSend, this.getRuntimeId());
        for (WebElement webElement : elements) {
            EcmascriptProtos.EvalArg.Variable variable = this.buildVariable(webElement.toString(), ((OperaWebElement)webElement).getObjectId());
            evalBuilder.addVariableList(variable);
        }
        UmsProtos.Response response = this.executeMessage(EcmascriptMessage.EVAL, evalBuilder);
        if (response == null) {
            throw new ScopeException("Internal error while executing script");
        }
        EcmascriptProtos.EvalResult result = this.parseEvalData(response);
        Object parsed = this.parseEvalReply(result);
        if (parsed instanceof EcmascriptProtos.Object) {
            EcmascriptProtos.Object data = (EcmascriptProtos.Object)parsed;
            return new ScriptResult(data.getObjectID(), data.getClassName());
        }
        return parsed;
    }

    private EcmascriptProtos.EvalResult parseEvalData(UmsProtos.Response response) {
        EcmascriptProtos.EvalResult.Builder builder = EcmascriptProtos.EvalResult.newBuilder();
        ScopeEcmascriptService.buildPayload(response, builder);
        return builder.build();
    }

    private EcmascriptProtos.EvalArg.Builder buildEval(String toSend, int runtimeId) {
        EcmascriptProtos.EvalArg.Builder builder = EcmascriptProtos.EvalArg.newBuilder();
        builder.setRuntimeID(runtimeId);
        builder.setScriptData(toSend);
        return builder;
    }

    private EcmascriptProtos.EvalArg.Variable buildVariable(String name, int objectId) {
        EcmascriptProtos.EvalArg.Variable.Builder variable = EcmascriptProtos.EvalArg.Variable.newBuilder();
        variable.setName(name);
        variable.setObjectID(objectId);
        return variable.build();
    }

    private EcmascriptProtos.EvalResult eval(String using, EcmascriptProtos.EvalArg.Variable ... variables) {
        return this.eval(using, this.getRuntimeId(), variables);
    }

    private EcmascriptProtos.EvalResult eval(String using, int runtimeId, EcmascriptProtos.EvalArg.Variable ... variables) {
        EcmascriptProtos.EvalArg.Builder builder = this.buildEval(using, runtimeId);
        builder.addAllVariableList(Arrays.asList(variables));
        UmsProtos.Response response = this.executeMessage(EcmascriptMessage.EVAL, builder, OperaIntervals.SCRIPT_TIMEOUT.getMs());
        if (response == null && this.retries < 5) {
            ++this.retries;
            this.sleepDuration += OperaIntervals.SCRIPT_RETRY_INTERVAL.getMs();
            ScopeEcmascriptService.sleep(this.sleepDuration);
            this.recover();
            return this.eval(using, variables);
        }
        if (this.retries >= 5) {
            this.resetCounters();
            throw new CommunicationException("No response on ECMAScript evaluation command");
        }
        this.resetCounters();
        return this.parseEvalData(response);
    }

    @Override
    public Object executeScript(String using, boolean responseExpected) {
        return this.executeScript(using, responseExpected, this.getRuntimeId());
    }

    private Object executeScript(String using, boolean responseExpected, int runtimeId) {
        EcmascriptProtos.EvalResult reply = this.eval(using, runtimeId, new EcmascriptProtos.EvalArg.Variable[0]);
        return responseExpected ? this.parseEvalReply(reply) : null;
    }

    @Override
    public Integer getObject(String using) {
        EcmascriptProtos.EvalResult reply = this.eval(using, new EcmascriptProtos.EvalArg.Variable[0]);
        return reply.getValue().getType().equals(EcmascriptProtos.Value.Type.OBJECT) ? Integer.valueOf(reply.getValue().getObject().getObjectID()) : null;
    }

    @Override
    public String callFunctionOnObject(String using, int objectId) {
        Object result = this.callFunctionOnObject(using, objectId, true);
        return result == null ? null : String.valueOf(result);
    }

    @Override
    public Object callFunctionOnObject(String using, int objectId, boolean responseExpected) {
        EcmascriptProtos.EvalArg.Variable variable = this.buildVariable("locator", objectId);
        EcmascriptProtos.EvalResult reply = this.eval(using, variable);
        return responseExpected ? this.parseEvalReply(reply) : null;
    }

    @Override
    public Integer executeScriptOnObject(String using, int objectId) {
        EcmascriptProtos.EvalArg.Variable variable = this.buildVariable("locator", objectId);
        EcmascriptProtos.EvalResult reply = this.eval(using, variable);
        Object object = this.parseEvalReply(reply);
        if (object == null || !(object instanceof EcmascriptProtos.Object)) {
            return null;
        }
        return ((EcmascriptProtos.Object)object).getObjectID();
    }

    @Override
    public void setFormElementValue(int objectId, String value) {
        EcmascriptProtos.SetFormElementValueArg.Builder args = EcmascriptProtos.SetFormElementValueArg.newBuilder();
        args.setObjectID(objectId);
        args.setValue(value);
        this.executeMessage(EcmascriptMessage.SET_FORM_ELEMENT_VALUE, args);
    }

    private Object parseEvalReply(EcmascriptProtos.EvalResult result) {
        EcmascriptProtos.EvalResult.Status status = result.getStatus();
        switch (status) {
            case CANCELLED: {
                return null;
            }
            case EXCEPTION: {
                throw new ScopeException("EcmaScript exception");
            }
            case NO_MEMORY: {
                throw new ScopeException("Out of memory");
            }
            case FAILURE: {
                throw new ScopeException("Could not execute script");
            }
        }
        EcmascriptProtos.Value value = result.getValue();
        EcmascriptProtos.Value.Type type = value.getType();
        switch (type) {
            case STRING: {
                return value.getStr();
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case OBJECT: {
                return value.getObject();
            }
            case NUMBER: {
                return this.parseNumber(String.valueOf(value.getNumber()));
            }
            case NAN: {
                return Float.valueOf(Float.NaN);
            }
            case MINUS_INFINITY: {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            case PLUS_INFINITY: {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
        }
        return null;
    }

    protected EcmascriptProtos.Runtime findRuntime() {
        return this.findRuntime(this.windowManager.getActiveWindowId());
    }

    protected EcmascriptProtos.Runtime findRuntime(int windowId) {
        this.createAllRuntimes();
        Pointer pointer = this.xpathPointer(this.runtimesList.values(), String.format("/.[htmlFramePath='%s' and windowID='%d']", this.currentFramePath, windowId));
        if (pointer != null) {
            return (EcmascriptProtos.Runtime)pointer.getValue();
        }
        return null;
    }

    private void buildRuntimeTree() {
        this.updateRuntime();
        EcmascriptProtos.Runtime rootInfo = this.findRuntime();
        this.root = new RuntimeNode();
        this.root.setFrameName("_top");
        this.root.setRuntimeID(rootInfo.getRuntimeID());
        ArrayList<EcmascriptProtos.Runtime> runtimeInfos = Lists.newArrayList(this.runtimesList.values());
        runtimeInfos.remove(rootInfo);
        for (EcmascriptProtos.Runtime runtimeInfo : runtimeInfos) {
            this.addNode(runtimeInfo, this.root);
        }
    }

    @Override
    public void changeRuntime(int index) {
        this.buildRuntimeTree();
        RuntimeNode node = this.root.getNodes().get(index + 1);
        if (node == null) {
            throw new NoSuchFrameException("Invalid frame index " + index);
        }
        EcmascriptProtos.Runtime info = (EcmascriptProtos.Runtime)this.runtimesList.get(node.getRuntimeID());
        this.currentFramePath = info.getHtmlFramePath();
        this.setRuntime(info);
    }

    @Override
    public void changeRuntime(String frameName) {
        String value;
        Preconditions.checkNotNull(frameName);
        this.buildRuntimeTree();
        String[] values = frameName.split("\\.");
        RuntimeNode curr = this.root;
        String[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (curr = this.findNodeByName(value = arr$[i$], curr)) != null; ++i$) {
        }
        if (curr == null) {
            throw new NoSuchFrameException("Invalid frame name " + frameName);
        }
        EcmascriptProtos.Runtime info = (EcmascriptProtos.Runtime)this.runtimesList.get(curr.getRuntimeID());
        if (!info.getHtmlFramePath().startsWith(this.currentFramePath)) {
            throw new NoSuchFrameException("No such frame " + frameName + " in " + this.currentFramePath);
        }
        this.currentFramePath = info.getHtmlFramePath();
        this.setRuntime(info);
    }

    private RuntimeNode findNodeByName(String name, RuntimeNode rootNode) {
        for (Map.Entry<Integer, RuntimeNode> entry : rootNode.getNodes().entrySet()) {
            if (this.isNumber(name) && entry.getKey().equals(Integer.valueOf(name) + 1)) {
                return entry.getValue();
            }
            if (entry.getValue().getFrameName().equals(name)) {
                return entry.getValue();
            }
            try {
                if (!this.executeScript("frameElement ? frameElement.id : ''", true, entry.getValue().getRuntimeID()).equals(name)) continue;
                return entry.getValue();
            }
            catch (CommunicationException e) {
            }
        }
        return null;
    }

    private void addNode(EcmascriptProtos.Runtime info, RuntimeNode root) {
        String[] values = info.getHtmlFramePath().split("/");
        RuntimeNode curr = root;
        for (int i = 1; i < values.length; ++i) {
            int index = this.framePathToIndex(values[i]);
            if (curr.getNodes().get(index) == null) {
                RuntimeNode node = new RuntimeNode();
                int end = values[i].indexOf(91);
                node.setFrameName(values[i].substring(0, end));
                curr.getNodes().put(index, node);
                curr = node;
                continue;
            }
            curr = curr.getNodes().get(index);
        }
        curr.setRuntimeID(info.getRuntimeID());
    }

    private int framePathToIndex(String framePath) {
        int begin = framePath.indexOf(91);
        int end = framePath.indexOf(93);
        return Integer.valueOf(framePath.substring(begin + 1, end));
    }

    @Override
    public void cleanUpRuntimes(int windowId) {
        for (EcmascriptProtos.Runtime runtime : this.runtimesList.values()) {
            if (runtime.getWindowID() != windowId) continue;
            this.runtimesList.remove(runtime.getRuntimeID());
        }
    }

    @Override
    public List<Integer> examineObjects(Integer id) {
        ImmutableList.Builder objects = ImmutableList.builder();
        for (EcmascriptProtos.Object.Property obj : this.getObjectList(id).getPrototypeListList().get(0).getObjectListList().get(0).getPropertyListList()) {
            if (!obj.getValue().getType().equals(EcmascriptProtos.Value.Type.OBJECT)) continue;
            objects.add((Object)obj.getValue().getObject().getObjectID());
        }
        return objects.build();
    }

    @Override
    public List<String> listFramePaths() {
        ImmutableList.Builder frameNames = ImmutableList.builder();
        for (EcmascriptProtos.Runtime runtime : this.getRuntimesList()) {
            frameNames.add(runtime.getHtmlFramePath());
        }
        return frameNames.build();
    }

    @Override
    public void releaseObjects() {
        EcmascriptProtos.ReleaseObjectsArg.Builder builder = EcmascriptProtos.ReleaseObjectsArg.newBuilder();
        this.executeMessage(EcmascriptMessage.RELEASE_OBJECTS, builder);
    }

    @Override
    public void resetRuntimesList() {
        this.runtimesList.clear();
    }

    @Override
    public void readyStateChanged(EcmascriptProtos.ReadyStateChange change) {
        if (!this.runtimesList.containsKey(change.getRuntimeID())) {
            this.runtimesQueue.add(change.getRuntimeID());
        }
    }

    @Override
    public void releaseObject(int objectId) {
        this.garbageQueue.add(objectId);
    }

    @Override
    public void resetFramePath() {
        this.currentFramePath = "_top";
        this.setRuntime(this.findRuntime());
    }

    @Override
    public String executeJavascript(String using, Integer windowId) {
        String tmp = this.currentFramePath;
        this.currentFramePath = "_top";
        EcmascriptProtos.Runtime runtime = this.findRuntime(windowId);
        this.currentFramePath = tmp;
        if (runtime == null) {
            return "";
        }
        return (String)this.executeScript(using, true, runtime.getRuntimeID());
    }

    @Override
    public Object examineScriptResult(Integer id) {
        return this.examineScriptResult(id, new HashSet<Integer>());
    }

    private Object examineScriptResult(Integer id, Set<Integer> visitedIDs) {
        if (visitedIDs.contains(id)) {
            return null;
        }
        visitedIDs.add(id);
        EcmascriptProtos.ObjectList list = this.getObjectList(id);
        EcmascriptProtos.Object obj = list.getPrototypeList(0).getObjectList(0);
        String className = obj.getClassName();
        List<EcmascriptProtos.Object.Property> properties = obj.getPropertyListList();
        if (className.endsWith("Element")) {
            return new OperaWebElement(this.driver, id);
        }
        if (className.equals("Array")) {
            ArrayList<Object> result = Lists.newArrayList();
            for (EcmascriptProtos.Object.Property property : properties) {
                EcmascriptProtos.Value.Type type = property.getValue().getType();
                if (type == EcmascriptProtos.Value.Type.NUMBER && property.getName().equals("length")) continue;
                result.add(this.parseValue(type, property.getValue(), visitedIDs));
            }
            return result;
        }
        HashMap<String, Object> result = Maps.newHashMap();
        for (EcmascriptProtos.Object.Property property : properties) {
            EcmascriptProtos.Value.Type type = property.getValue().getType();
            if (type == EcmascriptProtos.Value.Type.NUMBER && property.getName().equals("length")) continue;
            result.put(property.getName(), this.parseValue(type, property.getValue(), visitedIDs));
        }
        return result;
    }

    private Object parseValue(EcmascriptProtos.Value.Type type, EcmascriptProtos.Value value, Set<Integer> visitedIDs) {
        switch (type) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case PLUS_INFINITY: {
                return Double.POSITIVE_INFINITY;
            }
            case MINUS_INFINITY: {
                return Double.NEGATIVE_INFINITY;
            }
            case NUMBER: {
                return value.getNumber();
            }
            case STRING: {
                return value.getStr();
            }
            case OBJECT: {
                return this.examineScriptResult(value.getObject().getObjectID(), visitedIDs);
            }
        }
        return null;
    }

    private void processQueues() {
        if (!this.garbageQueue.isEmpty()) {
            this.processGcObjects();
        }
        if (!this.runtimesQueue.isEmpty()) {
            this.processNewRuntimes();
        }
        if (this.runtimesList.isEmpty()) {
            this.updateRuntime();
        }
    }

    private void processNewRuntimes() {
        while (!this.runtimesQueue.isEmpty()) {
            EcmascriptProtos.Runtime runtime = this.getRuntime(this.runtimesQueue.poll());
            if (runtime == null) continue;
            if (runtime.getHtmlFramePath().equals("_top") && this.windowManager.getActiveWindowId() == runtime.getWindowID()) {
                this.setRuntime(runtime);
            }
            this.runtimesList.putIfAbsent(runtime.getRuntimeID(), runtime);
        }
    }

    private void processGcObjects() {
        EcmascriptProtos.ReleaseObjectsArg.Builder builder = EcmascriptProtos.ReleaseObjectsArg.newBuilder();
        builder.addAllObjectIDList(this.garbageQueue);
        this.executeMessage(EcmascriptMessage.RELEASE_OBJECTS, builder);
        this.garbageQueue.clear();
    }

    private EcmascriptProtos.Runtime getRuntime(int runtimeID) {
        EcmascriptProtos.ListRuntimesArg.Builder builder = EcmascriptProtos.ListRuntimesArg.newBuilder();
        builder.addRuntimeIDList(runtimeID);
        builder.setCreate(true);
        UmsProtos.Response response = this.executeMessage(EcmascriptMessage.LIST_RUNTIMES, builder);
        EcmascriptProtos.RuntimeList.Builder runtimeListBuilder = EcmascriptProtos.RuntimeList.newBuilder();
        ScopeEcmascriptService.buildPayload(response, runtimeListBuilder);
        List<EcmascriptProtos.Runtime> runtimes = runtimeListBuilder.build().getRuntimeListList();
        return runtimes.isEmpty() ? null : runtimes.get(0);
    }

    private EcmascriptProtos.ObjectList getObjectList(Integer id) {
        EcmascriptProtos.ExamineObjectsArg.Builder builder = EcmascriptProtos.ExamineObjectsArg.newBuilder();
        builder.setExaminePrototypes(false);
        builder.setRuntimeID(this.getRuntimeId());
        builder.addObjectIDList(id);
        UmsProtos.Response response = this.executeMessage(EcmascriptMessage.EXAMINE_OBJECTS, builder);
        EcmascriptProtos.ObjectList.Builder objListBuilder = EcmascriptProtos.ObjectList.newBuilder();
        ScopeEcmascriptService.buildPayload(response, objListBuilder);
        return objListBuilder.build();
    }
}

