/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.google.common.base.Preconditions;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.internal.VersionUtil;
import com.opera.core.systems.scope.Message;
import com.opera.core.systems.scope.ScopeService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.Service;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.UmsProtos;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.Pointer;

public abstract class AbstractService
implements Service {
    protected final ScopeServices services;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ScopeService service;
    private final String version;

    public AbstractService(ScopeServices services, String name) {
        this(services, name, null);
    }

    public AbstractService(ScopeServices services, String name, String requiredVersion) {
        this.services = services;
        this.service = ScopeService.get(name);
        this.version = services.getAvailableServices().get((Object)ScopeService.get(name));
        this.checkRequiredVersion(requiredVersion);
    }

    private void checkRequiredVersion(String requiredVersion) {
        if (requiredVersion == null) {
            return;
        }
        if (!this.isVersionInRange(requiredVersion)) {
            throw new ScopeException(String.format("Unmet version dependency for Scope service %s: Requested version %s, but only has version %s", this.getServiceName(), requiredVersion, this.getServiceVersion()));
        }
    }

    public boolean isVersionInRange(String requiredVersion) {
        Preconditions.checkNotNull(requiredVersion);
        return VersionUtil.compare(this.getServiceVersion(), requiredVersion) >= 0;
    }

    @Override
    public String getServiceName() {
        return this.service.toOpera();
    }

    @Override
    public String getServiceVersion() {
        return this.version;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public UmsProtos.Response executeMessage(Message message) {
        return this.executeMessage(message, null);
    }

    public UmsProtos.Response executeMessage(Message message, AbstractMessage.Builder<?> builder) {
        if (this.services.getConnection() == null) {
            return UmsProtos.Response.getDefaultInstance();
        }
        return this.executeMessage(message, builder, OperaIntervals.DEFAULT_RESPONSE_TIMEOUT.getMs());
    }

    public UmsProtos.Response executeMessage(Message message, AbstractMessage.Builder<?> builder, long timeout) {
        if (this.services.getConnection() == null) {
            return UmsProtos.Response.getDefaultInstance();
        }
        return this.services.executeMessage(message, builder, timeout);
    }

    public Pointer xpathPointer(Collection<?> collection, String query) {
        JXPathContext pathContext = JXPathContext.newContext(collection);
        Pointer result = null;
        try {
            result = pathContext.getPointer(query);
        }
        catch (JXPathNotFoundException e) {
            this.logger.warning(String.format("JXPath exception: %s", e.getMessage()));
        }
        return result;
    }

    public Iterator<?> xpathIterator(Collection<?> collection, String query) {
        JXPathContext pathContext = JXPathContext.newContext(collection);
        Iterator result = null;
        try {
            result = pathContext.iteratePointers(query);
        }
        catch (JXPathNotFoundException e) {
            this.logger.log(Level.WARNING, "JXPath exception: {0}", e.getMessage());
        }
        return result;
    }

    public static GeneratedMessage.Builder<?> buildPayload(UmsProtos.Response response, GeneratedMessage.Builder<?> builder) {
        return AbstractService.buildMessage(builder, response.getPayload().toByteArray());
    }

    private static GeneratedMessage.Builder<?> buildMessage(GeneratedMessage.Builder<?> builder, byte[] message) {
        try {
            return (GeneratedMessage.Builder)builder.mergeFrom(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ScopeException(String.format("Could not build %s: %s", builder.getDescriptorForType().getFullName(), e.getMessage()));
        }
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

