/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.common.lang;

import com.google.common.base.Preconditions;

public final class OperaBoolean {
    public static boolean parseBoolean(String string) {
        Preconditions.checkNotNull(string);
        OperaBoolean.assertBoolesque(string);
        return OperaBoolean.isTruthy(string);
    }

    public static boolean isBoolesque(String string) {
        Preconditions.checkNotNull(string);
        OperaBoolean.assertBoolesque(string);
        return OperaBoolean.isFalsy(string) || OperaBoolean.isTruthy(string);
    }

    private static boolean isTruthy(String string) {
        return string.equals("1") || string.equals("true");
    }

    private static boolean isFalsy(String string) {
        return string.equals("0") || string.equals("false");
    }

    private static void assertBoolesque(String string) {
        Preconditions.checkArgument(OperaBoolean.isTruthy(string) || OperaBoolean.isFalsy(string), "Not a boolesque value: " + string);
    }
}

