/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.collect.ImmutableSortedSet;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.QuickMenu;
import com.opera.core.systems.QuickMenuItem;
import com.opera.core.systems.QuickWidget;
import com.opera.core.systems.QuickWindow;
import com.opera.core.systems.internal.ProfileUtils;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import com.opera.core.systems.scope.ScopeService;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.services.desktop.DesktopWindowManager;
import com.opera.core.systems.scope.services.desktop.SystemInput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public class OperaDesktopDriver
extends OperaDriver {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private DesktopWindowManager desktopWindowManager;
    private SystemInput systemInputManager;
    private DesktopUtils desktopUtils;
    private ProfileUtils profileUtils;
    private boolean firstTestRun = true;
    private String largePreferencesPath;
    private String smallPreferencesPath;
    private String cachePreferencesPath;

    public OperaDesktopDriver() {
        this(new OperaSettings());
    }

    public OperaDesktopDriver(Capabilities capabilities) {
        this(new OperaSettings().merge(capabilities));
    }

    public OperaDesktopDriver(OperaSettings settings) {
        super(settings);
        this.initDesktopDriver();
    }

    private void setPrefsPaths() {
        this.largePreferencesPath = this.getLargePreferencesPath();
        this.smallPreferencesPath = this.getSmallPreferencesPath();
        this.cachePreferencesPath = this.getCachePreferencesPath();
        this.profileUtils = new ProfileUtils(this.largePreferencesPath, this.smallPreferencesPath, this.cachePreferencesPath, this.settings);
    }

    private void setServices() {
        this.desktopWindowManager = this.getScopeServices().getDesktopWindowManager();
        this.systemInputManager = this.getScopeServices().getSystemInputManager();
        this.desktopUtils = this.getScopeServices().getDesktopUtils();
    }

    private void startOpera() {
        super.init();
        this.setServices();
        this.setPrefsPaths();
    }

    private void initDesktopDriver() {
        this.setServices();
        this.setPrefsPaths();
        if (this.settings.getBinary() == null && !this.settings.noRestart()) {
            String operaPath = this.getOperaPath();
            this.logger.fine("OperaBinaryLocation retrieved from Opera: " + operaPath);
            if (operaPath.length() > 0) {
                this.settings.setBinary(new File(operaPath));
                this.runner = new OperaLauncherRunner(this.settings);
                try {
                    this.getScopeServices().quit(this.runner);
                }
                catch (IOException e) {
                    throw new WebDriverException(e);
                }
                if (!this.profileUtils.deleteProfile()) {
                    this.logger.severe("Could not delete profile");
                }
                this.startOpera();
            }
        }
    }

    @Override
    protected SortedSet<ScopeService> getRequiredServices() {
        ImmutableSortedSet.Builder services = ImmutableSortedSet.naturalOrder();
        services.addAll(super.getRequiredServices());
        services.add((Object[])new ScopeService[]{ScopeService.DESKTOP_WINDOW_MANAGER, ScopeService.SYSTEM_INPUT, ScopeService.DESKTOP_UTILS});
        return services.build();
    }

    public void quitDriver() {
        this.logger.fine("OperaDesktopDriver shutting down");
        this.getScopeServices().shutdown();
        if (this.runner != null) {
            this.runner.shutdown();
        }
    }

    public void quitOpera() {
        if (this.runner != null) {
            if (this.runner.isOperaRunning() || this.runner.hasOperaCrashed()) {
                this.getScopeServices().shutdown();
                this.runner.stopOpera();
            }
        } else {
            String operaPath = this.desktopUtils.getOperaPath();
            this.logger.info("OperaBinaryLocation retrieved from Opera: " + operaPath);
            if (operaPath.length() > 0) {
                this.settings.setBinary(new File(operaPath));
            }
            this.runner = new OperaLauncherRunner(this.settings);
            try {
                this.getScopeServices().quit(this.runner);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }

    public int getActiveQuickWindowID() {
        return this.desktopWindowManager.getActiveQuickWindowId();
    }

    public List<QuickWidget> getQuickWidgetList(String windowName) {
        int id = this.getQuickWindowID(windowName);
        if (id >= 0 || windowName.isEmpty()) {
            return this.getQuickWidgetList(id);
        }
        return Collections.emptyList();
    }

    public List<QuickWidget> getQuickWidgetList(int windowId) {
        return this.desktopWindowManager.getQuickWidgetList(windowId);
    }

    public List<QuickWindow> getQuickWindowList() {
        return this.desktopWindowManager.getQuickWindowList();
    }

    public QuickMenu getQuickMenu(String menuName) {
        return this.desktopWindowManager.getQuickMenu(menuName);
    }

    public QuickMenu getQuickMenu(String menuName, int windowId) {
        return this.desktopWindowManager.getQuickMenu(menuName, windowId);
    }

    public List<QuickMenu> getQuickMenuList() {
        return this.desktopWindowManager.getQuickMenuList();
    }

    public List<QuickMenuItem> getQuickMenuItemList() {
        return this.desktopWindowManager.getQuickMenuItemList();
    }

    public int getQuickWindowID(String windowName) {
        return this.desktopWindowManager.getQuickWindowID(windowName);
    }

    public QuickWindow getQuickWindow(String windowName) {
        return this.desktopWindowManager.getQuickWindowByName(windowName);
    }

    public QuickWidget findWidgetByName(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String widgetName) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME, widgetName);
    }

    public QuickWidget findWidgetByName(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String widgetName, String parentName) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME, widgetName, parentName);
    }

    public QuickWidget findWidgetByText(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String text) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.TEXT, text);
    }

    public QuickWidget findWidgetByText(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String text, String parentName) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.TEXT, text, parentName);
    }

    public QuickWidget findWidgetByStringId(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String stringId) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.findWidgetByText(type, windowId, text);
    }

    public QuickWidget findWidgetByStringId(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String stringId, String parentName) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.findWidgetByText(type, windowId, text, parentName);
    }

    public QuickWidget findWidgetByPosition(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, int row, int column) {
        return this.desktopWindowManager.getQuickWidgetByPos(type, windowId, row, column);
    }

    public QuickWidget findWidgetByPosition(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, int row, int column, String parentName) {
        return this.desktopWindowManager.getQuickWidgetByPos(type, windowId, row, column, parentName);
    }

    public void pressQuickMenuItem(String menuItemText, boolean popMenu) {
        this.desktopWindowManager.pressQuickMenuItem(menuItemText, popMenu);
    }

    public QuickMenuItem getQuickMenuItemByAction(String action) {
        return this.desktopWindowManager.getQuickMenuItemByAction(action);
    }

    public QuickMenuItem getQuickMenuItemBySubmenu(String submenu) {
        return this.desktopWindowManager.getQuickMenuItemBySubmenu(submenu);
    }

    public QuickMenuItem getQuickMenuItemByName(String name) {
        return this.desktopWindowManager.getQuickMenuItemByName(name);
    }

    public QuickMenuItem getQuickMenuItemByName(String name, int window_id) {
        return this.desktopWindowManager.getQuickMenuItemByName(name, window_id);
    }

    public QuickMenuItem getQuickMenuItemByText(String text) {
        return this.desktopWindowManager.getQuickMenuItemByText(text);
    }

    public QuickMenuItem getQuickMenuItemByPosition(int row, String menuName) {
        return this.desktopWindowManager.getQuickMenuItemByPosition(row, menuName);
    }

    public QuickMenuItem getQuickMenuItemByAccKey(String key, String menuName) {
        return this.desktopWindowManager.getQuickMenuItemByAccKey(key, menuName);
    }

    public QuickMenuItem getQuickMenuItemByShortcut(String shortcut) {
        return this.desktopWindowManager.getQuickMenuItemByShortcut(shortcut);
    }

    public QuickMenuItem getQuickMenuItemByStringId(String stringId) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.desktopWindowManager.getQuickMenuItemByText(text);
    }

    public QuickWindow findWindowByName(String windowName) {
        return this.desktopWindowManager.getQuickWindow(DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME, windowName);
    }

    public QuickWindow findWindowById(int windowId) {
        return this.desktopWindowManager.getQuickWindowById(windowId);
    }

    public String getQuickWindowName(int windowId) {
        return this.desktopWindowManager.getQuickWindowName(windowId);
    }

    public String getString(String enumText, boolean stripAmpersand) {
        return this.desktopUtils.getString(enumText, stripAmpersand);
    }

    public String getSubstitutedString(String[] arg, boolean stripAmpersand) {
        return this.desktopUtils.getSubstitutedString(arg, stripAmpersand);
    }

    public String getOperaPath() {
        return this.desktopUtils.getOperaPath();
    }

    public String getLargePreferencesPath() {
        return this.desktopUtils.getLargePreferencesPath();
    }

    public String getSmallPreferencesPath() {
        return this.desktopUtils.getSmallPreferencesPath();
    }

    public String getCachePreferencesPath() {
        return this.desktopUtils.getCachePreferencesPath();
    }

    public void keyPress(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.keyPress(key, modifiers);
    }

    public void keyUp(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.keyUp(key, modifiers);
    }

    public void keyDown(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.keyDown(key, modifiers);
    }

    public int getQuickWindowCount() {
        return this.desktopWindowManager.getOpenQuickWindowCount();
    }

    public void operaDesktopAction(String using, int data, String dataString, String dataStringParam) {
        this.getScopeServices().getExec().action(using, data, dataString, dataStringParam);
    }

    public void waitStart() {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        this.getScopeServices().waitStart();
    }

    public void waitForWindowUpdated() {
        this.waitForWindowUpdated("");
    }

    public void waitForWindowActivated() {
        this.waitForWindowActivated("");
    }

    public void waitForWindowClose() {
        this.waitForWindowClose("");
    }

    public int waitForWindowShown(String windowName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForDesktopWindowShown(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getMs());
    }

    public int waitForWindowUpdated(String windowName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForDesktopWindowUpdated(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getMs());
    }

    public int waitForWindowActivated(String windowName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForDesktopWindowActivated(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getMs());
    }

    public int waitForWindowClose(String windowName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForDesktopWindowClosed(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getMs());
    }

    public int waitForWindowPageChanged(String windowName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForDesktopWindowPageChanged(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getMs());
    }

    public int waitForWindowLoaded(String windowName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForDesktopWindowLoaded(windowName, OperaIntervals.PAGE_LOAD_TIMEOUT.getMs());
    }

    public String waitForMenuShown(String menuName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForMenuShown(menuName, OperaIntervals.MENU_EVENT_TIMEOUT.getMs());
    }

    public String waitForMenuClosed(String menuName) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForMenuClosed(menuName, OperaIntervals.MENU_EVENT_TIMEOUT.getMs());
    }

    public String waitForMenuItemPressed(String menuItemText) {
        if (this.getScopeServices().getConnection() == null) {
            throw new CommunicationException("waiting for a menu item to be pressed failed because Opera is not connected.");
        }
        return this.getScopeServices().waitForMenuItemPressed(menuItemText, OperaIntervals.MENU_EVENT_TIMEOUT.getMs());
    }

    public void resetOperaPrefs(String newPrefs) {
        if (!this.firstTestRun || new File(newPrefs).exists()) {
            if (!(this.profileUtils.isMainProfile(this.smallPreferencesPath) || this.profileUtils.isMainProfile(this.largePreferencesPath) || this.profileUtils.isMainProfile(this.cachePreferencesPath))) {
                this.quitOpera();
                if (Platform.getCurrent().is(Platform.WINDOWS)) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.profileUtils.deleteProfile()) {
                    this.logger.severe("Could not delete profile");
                }
                if (!new File(newPrefs).exists()) {
                    this.logger.finer("The '" + newPrefs + "' directory doesn't exist, omitting profile copying.");
                } else if (!this.profileUtils.copyProfile(newPrefs)) {
                    this.logger.severe("Failed to copy profile from '" + newPrefs);
                } else {
                    this.logger.finer("Profile from '" + newPrefs + "' copied OK");
                }
                this.startOpera();
            } else {
                this.logger.warning("Running tests in main user profile");
            }
        }
        this.firstTestRun = false;
    }

    public void deleteOperaPrefs() {
        if (this.runner != null && !this.runner.isOperaRunning()) {
            if (!this.profileUtils.deleteProfile()) {
                this.logger.severe("Could not delete profile");
            }
        } else {
            this.logger.warning("Cannot delete profile while Opera is running");
        }
    }

    public int getPid() {
        return this.desktopUtils.getOperaPid();
    }

    public boolean isOperaRunning() {
        return !this.settings.autostart() || this.runner != null && this.runner.isOperaRunning();
    }
}

