/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.regex.Pattern;

@JsxClass
public class CSSFontFaceRule
extends CSSRule {
    private static final Pattern REPLACEMENT_1 = Pattern.compile("font-family: ([^;]*);");
    private static final Pattern REPLACEMENT_2 = Pattern.compile("src: ([^;]*);");

    @Deprecated
    public CSSFontFaceRule() {
    }

    protected CSSFontFaceRule(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSRule rule) {
        super(stylesheet, rule);
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public short getType() {
        return 5;
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getCssText() {
        String cssText = super.getCssText();
        cssText = cssText.replace("{ ", "{\n  ");
        cssText = cssText.replace("; }", ";\n}");
        cssText = cssText.replace("; ", ";\n  ");
        cssText = REPLACEMENT_1.matcher(cssText).replaceFirst("font-family: \"$1\";");
        cssText = REPLACEMENT_2.matcher(cssText).replaceFirst("src: url(\"$1\");");
        return cssText;
    }
}

