/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public final class InputElementFactory
implements ElementFactory {
    private static final Log LOG = LogFactory.getLog(InputElementFactory.class);
    public static final InputElementFactory instance = new InputElementFactory();

    private InputElementFactory() {
    }

    @Override
    public HtmlElement createElement(SgmlPage page, String tagName, Attributes attributes) {
        return this.createElementNS(page, null, tagName, attributes);
    }

    @Override
    public HtmlElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedName, Attributes attributes) {
        return this.createElementNS(page, namespaceURI, qualifiedName, attributes, false);
    }

    @Override
    public HtmlElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedName, Attributes attributes, boolean asdf) {
        HtmlInput result;
        Map<String, DomAttr> attributeMap = DefaultElementFactory.setAttributes(page, attributes);
        if (attributeMap == null) {
            attributeMap = new HashMap<String, DomAttr>();
        }
        String type = null;
        if (attributes != null) {
            type = attributes.getValue("type");
        }
        if (type == null) {
            type = "";
        } else {
            type = type.toLowerCase();
            attributeMap.get("type").setValue(type);
        }
        if (type.isEmpty()) {
            DomAttr newAttr = new DomAttr(page, null, "type", "text", true);
            attributeMap.put("type", newAttr);
            result = new HtmlTextInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("submit".equals(type)) {
            result = new HtmlSubmitInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("checkbox".equals(type)) {
            result = new HtmlCheckBoxInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("radio".equals(type)) {
            result = new HtmlRadioButtonInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("text".equals(type)) {
            result = new HtmlTextInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("hidden".equals(type)) {
            result = new HtmlHiddenInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("password".equals(type)) {
            result = new HtmlPasswordInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("image".equals(type)) {
            result = new HtmlImageInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("reset".equals(type)) {
            result = new HtmlResetInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("button".equals(type)) {
            result = new HtmlButtonInput(namespaceURI, qualifiedName, page, attributeMap);
        } else if ("file".equals(type)) {
            result = new HtmlFileInput(namespaceURI, qualifiedName, page, attributeMap);
        } else {
            LOG.info("Bad input type: \"" + type + "\", creating a text input");
            result = new HtmlTextInput(namespaceURI, qualifiedName, page, attributeMap);
        }
        return result;
    }
}

