#ifndef PQCLEAN_NTRULPR857_CLEAN_API_H
#define PQCLEAN_NTRULPR857_CLEAN_API_H

#include <stdint.h>


#define PQCLEAN_NTRULPR857_CLEAN_CRYPTO_ALGNAME "ntrulpr857"

#define PQCLEAN_NTRULPR857_CLEAN_CRYPTO_SECRETKEYBYTES 1463
#define PQCLEAN_NTRULPR857_CLEAN_CRYPTO_PUBLICKEYBYTES 1184
#define PQCLEAN_NTRULPR857_CLEAN_CRYPTO_CIPHERTEXTBYTES 1312
#define PQCLEAN_NTRULPR857_CLEAN_CRYPTO_BYTES 32

int PQCLEAN_NTRULPR857_CLEAN_crypto_kem_keypair(uint8_t *pk, uint8_t *sk);
int PQCLEAN_NTRULPR857_CLEAN_crypto_kem_enc(uint8_t *c, uint8_t *k, const uint8_t *pk);
int PQCLEAN_NTRULPR857_CLEAN_crypto_kem_dec(uint8_t *k, const uint8_t *c, const uint8_t *sk);
#endif
