package Psh::Locale::Portuguese;

use strict;
use locale;

$VERSION = do { my @r = (q$Revision: 1.3 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; # must be all one line, for MakeMaker

BEGIN {
	my %sig_description = (
						   'TTOU' => 'sada do TTY',
						   'TTIN' => 'entrada do TTY',
						   'KILL' => 'matado',
						   'FPE'  => 'exceo do ponto flutuando',
						   'SEGV' => 'falha da segmentao',
						   'PIPE' => 'tubulao quebrada',

                                      # TODO: This is probably not correct. It probably means
                                      # bus as in schoolbus or city bus.
						   'BUS'  => 'erro de barra-nibus',

						   'ABRT' => 'abortado',
						   'ILL'  => 'instruo ilegal',
						   'TSTP' => 'pare datilografado no TTY',
						   'INT'  => 'o carter de interrupo datilografou'
						   );

	$Psh::text{sig_description}=\%sig_description;

	$Psh::text{done}='feito';
	$Psh::text{terminated}='terminado';
	$Psh::text{stopped}='parado';
	$Psh::text{restart}='reincio';
	$Psh::text{foreground}='primeiro plano';
	$Psh::text{exec_failed}="Erro (exec %1) falhou.\n";
    $Psh::text{simulate_perl_w}="Simulando a opo -w e strict\n";
	$Psh::text{perm_denied}="%2: %1: Permisso negada.\n";
	$Psh::text{no_such_dir}="%2: %1: Nenhum tal diretrio.\n";
	$Psh::text{no_such_builtin}="%2: %1: Nenhum tal builtin.\n";
	$Psh::text{readline_interrupted}="\nInterrompido!\n";
	$Psh::text{readline_error}="Readline no comeou acima corretamente:\n%1\n";
	$Psh::text{no_readline}="Nenhum mdulo de Readline disponvel. Instale por favor Term::ReadLine::Perl\n";
	$Psh::text{unalias_noalias}="unalias: `%1' no  alis\n";
	$Psh::text{builtin_readline_header}="Usando Readline: %1, com caractersticas:\n";
	$Psh::text{no_jobcontrol}="Seu sistema no suporta o controle de trabalho\n";
	$Psh::text{help_header}="psh suporta os seguintes comandos internos\n";
	$Psh::text{no_help}="Pesarosa, a ajuda para o builtin %1 no est disponve\n";


	$Psh::text{prompt_expansion_error}=<<EOT;
%3: Aviso: A expanso de '\\%1' na mensagem de alerta
rendeu o texto que contem '\\%2'. Removendo a seqncia
de escape da substituio.
EOT

	$Psh::text{prompt_unknown_escape}="%2: Aviso: \$Psh::prompt contem seqncia de escape desconhecida `\\%1'.\n";
	$Psh::text{no_libwin32}="libwin32 requerido (disponvel como o pacote de CPAN ou com distribuio de ActivePerl).\n";
}


1;
