# NOTE: Derived from blib/lib/IPC/Shareable.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package IPC::Shareable;

#line 1663 "blib/lib/IPC/Shareable.pm (autosplit into blib/lib/auto/IPC/Shareable/NEXTKEY.al)"
sub NEXTKEY {
    my($shm_hash) = @_;
    my($key);
    # --- Called during the middle of an iteration via each() or keys().
    debug "called on $shm_hash" if ($Debug);

    # --- Get the next key from our local cache
    $key = each %{$Shm_Info{$$shm_hash}{'DATA'}{'user'}};

    # --- Check to see if we're at the end of the iteration; if so,
    # --- we save our cached copy for the world to see.
    if (not defined $key) {
	debug "$Package\:\:NEXTKEY: end of iteration detected" if ($Debug);
	delete $Shm_Info{$$shm_hash}{'hash_iterating'};
	STORE($shm_hash);
    }

    # --- Now we return the key
    $key;
}

# end of IPC::Shareable::NEXTKEY
1;
