package Sim::OPT::Report;
# Copyright (C) 2008-2015 by Gian Luca Brunetti and Politecnico di Milano.
# This is the module Sim::OPT::Retrieve of Sim::OPT, a program for detailed metadesign managing parametric explorations through the ESP-r building performance simulation platform and performing optimization by block coordinate descent.
# This is free software.  You can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 
use v5.14;
# use v5.20;
use Exporter;
use vars qw( $VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS );
use Math::Trig;
use Math::Round;
use List::Util qw[ min max reduce shuffle];
use List::MoreUtils qw(uniq);
use List::AllUtils qw(sum);
use Statistics::Basic qw(:all);
use Set::Intersection;
use List::Compare;
use IO::Tee;
use Sim::OPT;
use Sim::OPT::Morph;
use Sim::OPT::Sim;
use Sim::OPT::Descend;
use Sim::OPT::Takechance;
use Data::Dumper;
#$Data::Dumper::Indent = 0;
#$Data::Dumper::Useqq  = 1;
#$Data::Dumper::Terse  = 1;
use Data::Dump qw(dump);
use feature 'say';
no strict; 
no warnings;
use warnings::unused;
@ISA = qw(Exporter); # our @adamkISA = qw(Exporter);
#%EXPORT_TAGS = ( DEFAULT => [qw( &opt &prepare )]); # our %EXPORT_TAGS = ( 'all' => [ qw( ) ] );
#@EXPORT   = qw(); # our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( retrieve report get_files );

$VERSION = '0.47'; # our $VERSION = '';


#########################################################################################
# HERE FOLLOWS THE CONTENT OF "Retrieve.pm", Sim::OPT::Retrieve
##############################################################################


sub retrieve
{	
	my $swap = shift; #say TOSHELL "swapINRETRIEVE: " . dump($swap);
	my %dat = %$swap;
	my @instances = @{ $dat{instances} }; #say "scalar(\@instances): " . scalar(@instances);
	my $countcase = $dat{countcase}; #say TOSHELL "dump(\$countcase): " . dump($countcase); # IT WILL BE SHADOWED. CUT ZZZ
	my $countblock = $dat{countblock}; #say TOSHELL "dump(\$countblock): " . dump($countblock); # IT WILL BE SHADOWED. CUT ZZZ		
	my %dirfiles = %{ $dat{dirfiles} }; #say "dump(\%dirfiles): " . dump(%dirfiles); 
		
	$configfile = $main::configfile; #say "dump(\$configfile): " . dump($configfile);
	@sweeps = @main::sweeps; #say TOSHELL "dump(\@sweeps): " . dump(@sweeps);
	@varinumbers = @main::varinumbers; #say "dump(\@varinumbers): " . dump(@varinumbers);
	@mediumiters = @main::mediumiters;
	@rootnames = @main::rootnames; #say "dump(\@rootnames): " . dump(@rootnames);
	%vals = %main::vals; #say "dump(\%vals): " . dump(%vals);
	
	$mypath = $main::mypath;  #say TOSHELL "dumpINRETRIEVE(\$mypath): " . dump($mypath);
	$exeonfiles = $main::exeonfiles; #say TOSHELL "dumpINRETRIEVE(\$exeonfiles): " . dump($exeonfiles);
	$generatechance = $main::generatechance; 
	$file = $main::file;
	$preventsim = $main::preventsim;
	$fileconfig = $main::fileconfig; #say TOSHELL "dumpINRETRIEVE(\$fileconfig): " . dump($fileconfig); # NOW GLOBAL. TO MAKE IT PRIVATE, FIX PASSING OF PARAMETERS IN CONTRAINTS PROPAGATION SECONDARY SUBROUTINES
	$outfile = $main::outfile;
	$toshell = $main::toshell;
	$report = $main::report;
	$simnetwork = $main::simnetwork;
	
	$tee = new IO::Tee(\*STDOUT, ">>$toshell"); # GLOBAL ZZZ
	
	#open( OUTFILE, ">>$outfile" ) or die "Can't open $outfile: $!"; 
	open( TOSHELL, ">>$toshell" ) or die "Can't open $toshell: $!"; 
	say "\nNow in Sim::OPT::Report::retrieve.\n";
	say $tee "\n#Now in Sim::OPT::Report_retrieve.\n";
	
	%dowhat = %main::dowhat;

	%simtitles = %main::simtitles; #say $tee "dumpINRETRIEVE(\%simtitles): " . dump(%simtitles);
	%retrievedata = %main::retrievedata;
	@keepcolumns = @main::keepcolumns;
	@weights = @main::weights;
	@weightsaim = @main::weightsaim;
	@varthemes_report = @main::varthemes_report;
	@varthemes_variations = @vmain::arthemes_variations;
	@varthemes_steps = @main::varthemes_steps;
	@rankdata = @main::rankdata; # CUT ZZZ
	@rankcolumn = @main::rankcolumn;
	%reportdata = %main::reportdata; #say $tee "dump(\%reportdata): " . dump(%reportdata);
	@files_to_filter = @main::files_to_filter;
	@filter_reports = @main::filter_reports;
	@base_columns = @main::base_columns;
	@maketabledata = @main::maketabledata;
	@filter_columns = @main::filter_columns;
	%vals = %main::vals;
	
	my @simcases = @{ $dirfiles{simcases} }; #say $tee "dump(\@simcases): " . dump(@simcases);
	my @simstruct = @{ $dirfiles{simstruct} }; #say $tee "dump(\@simstruct): " . dump(@simstruct);
	my @morphcases = @{ $dirfiles{morphcases} };
	my @morphstruct = @{ $dirfiles{morphstruct} };
	my @retcases = @{ $dirfiles{retcases} };
	my @retstruct = @{ $dirfiles{retstruct} };
	my @repcases = @{ $dirfiles{repcases} };
	my @repstruct = @{ $dirfiles{repstruct} };
	my @mergecases = @{ $dirfiles{mergecases} };
	my @mergestruct = @{ $dirfiles{mergestruct} };
	my @descendcases = @{ $dirfiles{descendcases} };
	my @descendstruct = @{ $dirfiles{descendstruct} };
	
	my $morphlist = $dirfiles{morphlist}; #say $tee "dump(\$morphlist): " . dump($morphlist);
	my $morphblock = $dirfiles{morphblock};
	my $simlist = $dirfiles{simlist}; #say $tee "dump(\$simlist): " . dump($simlist);
	my $simblock = $dirfiles{simblock};
	my $retlist = $dirfiles{retlist};
	my $retblock = $dirfiles{retblock};
	my $replist = $dirfiles{replist};
	my $repblock = $dirfiles{repblock};
	my $descendlist = $dirfiles{descendlist};
	my $descendblock = $dirfiles{descendblock};
	
	my $skipfile = $vals{skipfile}; #say $tee "dump(\$skipfile): " . dump($skipfile);
	my $skipsim = $vals{skipsim}; #say $tee "dump(\$skipsim): " . dump($skipsim);
	my $skipreport = $vals{skipreport}; #say $tee "dump(\$skipreport): " . dump($skipreport);	
	my %notecases;
	
	#my $getpars = shift;
	#eval( $getpars );

	#if ( fileno (MORPHLIST)
	
	my $countinstance = 0;
	foreach my $instance (@instances)
	{
		say TOSHELL "\nNow in Sim::OPT::Retrieve. INSTANCES\n";
		my %d = %{$instance};
		my $countcase = $d{countcase}; #say TOSHELL "dump(\$countcase): " . dump($countcase);
		my $countblock = $d{countblock}; #say TOSHELL "dump(\$countblock): " . dump($countblock);
		my @miditers = @{ $d{miditers} }; #say $tee "dump(\@miditers): " . dump(@miditers);
		my @winneritems = @{ $d{winneritems} }; #say TOSHELL "dumpIN( \@winneritems) " . dump(@winneritems);
		my $countvar = $d{countvar}; #say TOSHELL "dump(\$countvar): " . dump($countvar);
		my $countstep = $d{countstep}; #say TOSHELL "dump(\$countstep): " . dump($countstep);						
		my $to = $d{to}; #say TOSHELL "dump(\$to): " . dump($to);
		my $origin = $d{origin}; #say TOSHELL "dump(\$origin): " . dump($origin);
		my @uplift = @{ $d{uplift} }; #say TOSHELL "dump(\@uplift): " . dump(@uplift);
		#eval($getparshere);
		
		my $skip = $vals{$countvar}{skip}; #say $tee "dumpinreport(\$skip): " . dump($skip);
		
		my $rootname = Sim::OPT::getrootname(\@rootnames, $countcase); #say TOSHELL "dump(\$rootname): " . dump($rootname);
		my @blockelts = Sim::OPT::getblockelts(\@sweeps, $countcase, $countblock); #say TOSHELL "dumpIN( \@blockelts) " . dump(@blockelts);
		my @blocks = Sim::OPT::getblocks(\@sweeps, $countcase);  #say TOSHELL "dumpIN( \@blocks) " . dump(@blocks);
		my $toitem = Sim::OPT::getitem(\@winneritems, $countcase, $countblock); #say TOSHELL "dump(\$toitem): " . dump($toitem);
		my $from = Sim::OPT::getline($toitem); #say $tee "dumpIN(\$from): " . dump($from);
		my %varnums = Sim::OPT::getcase(\@varinumbers, $countcase); #say TOSHELL "dumpIN---(\%varnums): " . dump(%varnums); 
		my %mids = Sim::OPT::getcase(\@miditers, $countcase); #say TOSHELL "dumpIN---(\%mids): " . dump(%mids); 
		#eval($getfly);
		
		my $stepsvar = Sim::OPT::getstepsvar($countvar, $countcase, \@varinumbers); #say TOSHELL "dump(\$stepsvar): " . dump($stepsvar); 
		my $varnumber = $countvar; #say TOSHELL "dump---(\$varnumber): " . dump($varnumber) . "\n\n";  # LEGACY VARIABLE
		
		my $numberof_simtools = scalar ( keys %{ $dowhat{simtools} } ); #say $tee "\$numberof_simtools " . dump( $numberof_simtools );
		
		my $counttool = 1;
		while ( $counttool <= $numberof_simtools )
		{	
			my $skip = $vals{$countvar}{$counttool}{skip}; #say $tee "dumpinsim(\$skip): " . dump($skip);
			if ( not ( eval ( $skipsim{$counttool} )))
			{
				my $tooltype = $dowhat{simtools}{$counttool}; #say $tee "\$tooltype " . dump( $tooltype );

				sub retrieve_temperatures_results 
				{
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $themereport, $counttheme, $countreport, $retfile ) = @_;
					my @retrdata = @$retrdata_ref;
					
					say "INRETRIEVE0\$countcase : " . dump($countcase);
					say "INRETRIEVE1\@rootnames : " . dump(@rootnames);
					say "INRETRIEVE1\$countblock : " . dump($countblock);
					say "INRETRIEVE1\@sweeps : " . dump(@sweeps);
					say "INRETRIEVE1\@varinumbers : " . dump(@varinumbers);
					say "INRETRIEVE1\@miditers : " . dump(@miditers);
					say "INRETRIEVE1\@winneritems : " . dump(@winneritems);
					say "INRETRIEVE1\@morphcases : " . dump(@morphcases);
					say "INRETRIEVE1\@morphstruct : " . dump(@morphstruct);

					unless (-e "$retfile-")
					{
						my $printthis = 
"res -file $resfile -mode script<<YYY

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
a
a
b
a
b
e
b
f
>
a
$retfile
!
-
-
-
-
-
-
-
-
YYY
";
						if ($exeonfiles eq "y")
						{ 	
							say "Retrieving temperature results.";
							say $tee "#Retrieving temperature results.";
							print `$printthis`;
						}
						print $tee "
			#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
			$printthis";

					}
				}

				sub retrieve_comfort_results
				{
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $stripcheck, $themereport, $counttheme, $countreport, $retfile ) = @_;
					
					my @retrdata = @$retrdata_ref;

					unless (-e "$retfile-")
					{
						my $printthis =
"res -file $resfile -mode script<<ZZZ

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
c
g
c
a

b


a
>
a
$retfile
!
-
-
-
-
-
-
-
-
ZZZ
";
						if ($exeonfiles eq "y") 
						{ 
							say "Retrieving comfort results.";
							say TOSHELL "#Retrieving comfort results.";
							print `$printthis`;
						}
						print TOSHELL "
		#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
		$printthis";
					}
				}

				sub retrieve_stats_results
				{	
					my ( $result, $resfile, $retrdata_ref, $reporttitle, $themereport, $counttheme, $countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines ) = @_;
					print $tee " IN RETRIEVE STATS: \$sim: $sim, \$resfile: $resfile, \$result: $result, \$reporttitle: $reporttitle, \$themereport: $themereport, \$counttheme: $counttheme, \$countreport, $countreport, \$retfile : $retfile \n";
					print $tee "\%retrievedata: " . dump( %retrievedata ); 
					my @retrdata = @$retrdata_ref; say $tee "\@retrdata " . dump(@retrdata);
					my $printthis;
					
					if ( $themereport eq "loads" )
					{
						$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
d
>
a
$retfile
$retfile
l
a
-
-
-
-
-
TTT
";
			
					}
					elsif ( $themereport eq "tempsstats" )
					{
						$printthis =
"res -file $resfile -mode script<<TTT

3
$retrdata[0]
$retrdata[1]
$retrdata[2]
d
>
a
$retfile
$retfile
m
-
-
-
-
TTT
";
					}
					if ($exeonfiles eq "y") 
					{
						#say "Retrieving $themereport results.";
						say $tee "#Retrieving $themereport results.";
						print `$printthis`;
					}
					print $tee " 
		#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", simulation period $counttheme, retrieve period $countreport\n
		$printthis
		";

				}
				
				say $tee "\nNow in Sim::OPT::Retrieve. INSIDE";
				my @resfiles = @{ $simstruct[$countcase][$countblock][$countinstance][$counttool] }; say $tee "SAY\@resfiles " . dump(@resfiles); 
				#say $tee "SAY\@simcases " . dump( @simcases ); say $tee "SAY\@simstruct " . dump(@simstruct); 
				
				#say $tee "\%retrievedata " . dump( %retrievedata );
				#say $tee "\$retrievedata{\$counttool} " . dump( $retrievedata{$counttool} );
				
				if ( $retrievedata{$counttool} )
				{
					if ( $tooltype eq "esp-r" )
					{
						my $counttheme = 0;
						foreach my $retrievedatum ( @{ $retrievedata{$counttool} } )
						{	
							#say $tee "\$retrievedatum " . dump($retrievedatum);
							my $reportdata_ref_ref = $reportdata{$counttool}->[$counttheme]; #say $tee "\$reportdata_ref_ref " . dump($reportdata_ref_ref);
							my @retrievedatarefs = @{$retrievedatum}; #say $tee "\@retrievedatarefs " . dump(@retrievedatarefs);
							my $simtitle = $simtitles{$counttool}->[ $counttheme ][0]; #say $tee "\$simtitle " . dump($simtitle);
							my @sims = @{ $simtitles{$counttool}->[ $counttheme ] }[1..4]; #say $tee "\@sims " . dump(@sims);
							
							my $resfile = $resfiles[ $counttheme ]; #say $tee "\HERE\$resfile " . dump($resfile);
							
							#if ( not ( eval ( $skipreport ) ) )
							if ( -e $resfile ) 
							{
								
								my $countreport = 0;
								foreach my $retrievedataref (@retrievedatarefs)
								{
									#say $tee "\$retrievedataref " . dump($retrievedataref);
									my @retrdata = @$retrievedataref; #say $tee "\@retrdata " . dump(@retrdata);
									my $sim = $sims[$countreport]; #say $tee "\$sim-RESFILE" . dump($sim); 
									my $targetprov = $sim;
									$targetprov =~ s/$mypath\///;
									my $result = "$mypath" . "/$targetprov"; #say $tee "\$result " . dump($result); 
									
									#if ( fileno (RETLIST) )
									#if (not (-e $retlist ) )
									#{
									#	if ( $countblock == 0 )
									#	{
											open( RETLIST, ">>$retlist"); # or die;
									#	}
									#	else 
									#	{
									#		open( RETLIST, ">>$retlist"); # or die;
									#	}
									#}
									
									#if ( fileno (RETLIST) ) # SAME LEVEL OF RETLIST. JUST ANOTHER CONTAINER.
									#if (not (-e $retblock ) )
									#{
									#	if ( $countblock == 0 )
									#	{
											open( RETBLOCK, ">>$retblock"); # or die;
									#	}
									#	else 
									#	{
									#		open( RETBLOCK, ">>$retblock"); # or die;
									#	}
									#}
													
									my $reportdata_ref = $reportdata_ref_ref->[$countreport]; say $tee "\$reportdata_ref" . dump($reportdata_ref); 
									my @reportdata = @$reportdata_ref;  say $tee "\@reportdata" . dump(@reportdata); 
									
									my $countitem = 0;
									foreach my $item ( @reportdata )
									{
										my %datarep = %$item; say $tee "\%datarep" . dump(%datarep); 
										my $reporttitle = $datarep{reporttitle}; say $tee "\$reporttitle! " . dump($reporttitle); ###DDD HERE
										my $themereport = $datarep{themereport}; say $tee "\$themereport " . dump($themereport); 
										my $semaphorego1 = $datarep{semaphorego1}; say $tee "\$semaphorego1 " . dump($semaphorego1); 
										my $semaphorego2 = $datarep{semaphorego2}; say $tee "\$semaphorego2 " . dump($semaphorego2); 
										my $semaphorestop1 = $datarep{semaphorestop1}; say $tee "\$semaphorestop1 " . dump($semaphorestop1); 
										my $semaphorestop2 = $datarep{semaphorestop2}; say $tee "\$semaphorestop2 " . dump($semaphorestop2); 
										my $textpattern = $datarep{textpattern}; say $tee "\$textpattern " . dump($textpattern); 
										my $afterlines = $datarep{afterlines}; say $tee "\$afterlines " . dump($afterlines); 
										my $retfile = "$resfile-$reporttitle-$themereport.grt"; #say $tee "\$retfile " . dump($retfile); say TOSHELL "\$retfile " . dump($retfile); say TOSHELL "\$retfile " . dump($retfile);
										
										$retstruct[$countcase][$countblock][ $countinstance ][$counttheme][$countreport][$countitem][$counttool] = $retfile;
										print RETBLOCK "$retfile\n";
										
										if ( not ($retfile ~~ @retcases ) )
										{
											push ( @retcases, $retfile );
											say RETLIST "$retfile";
										}
										
										if ( not ( $retfile ~~ @{ $notecases[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] } ) )
										{
											
											push ( @{ $notecases[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] } , 
																				{
																					retfile => $retfile,
																					reporttitle => $reporttitle,
																					themereport => $themereport,
																					semaphorego1 => $semaphorego1,
																					semaphorego2 => $semaphorego2,
																					semaphorestop1 => $semaphorestop1,
																					semaphorestop2 => $semaphorestop2,
																					textpattern => $textpattern,
																					afterlines => $afterlines
																				} );
										}
										
										say "#Retrieving results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep for tool $tooltype. Instance $countinstance: going to write $retfile.\ ";
											
										if ( $themereport eq "temps" ) 
										{
											 retrieve_temperatures_results( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, $countreport, $retfile ); 
										}
										elsif ( $themereport eq "comfort"  ) 
										{ 
											retrieve_comfort_results( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, $countreport, $retfile ); 
										}
										elsif ( ( ( $themereport eq "loads" ) or ( $themereport eq "tempsstats"  ) ) )
										{ 
											retrieve_stats_results( $result, $resfile, \@retrdata, $reporttitle, $themereport, $counttheme, 
														$countreport, $retfile, $semaphorego1, $semaphorego2, $semaphorestop1, $semaphorestop2, $textpattern, $afterlines ); 
										}
										$countitem++;
									}
									$countreport++;
								}
							}
							$counttheme++;
						}
						$counttool++;
					}
					elsif ( ( $tooltype eq "generic" ) or ( $tooltype eq "energyplus" ) )
					{	#use warnings; use strict;
						my @retfiles = @{ $simstruct[$countcase][$countblock][$countinstance][$counttool] }; say $tee "SAY\@retfiles " . dump(@retfiles); 
						$retstruct[$countcase][$countblock][$countinstance][$counttool]  = $simstruct[$countcase][$countblock][$countinstance][$counttool] ; 
						my $counttheme = 0;
						foreach my $retrievedatum ( @{ $retrievedata{$counttool} } )
						{
							my $reportdata_ref_ref = $reportdata{$counttool}->[$counttheme]; #say $tee "\$reportdata_ref_ref " . dump($reportdata_ref_ref);
							my @retrievedatarefs = @{$retrievedatum}; #say $tee "\@retrievedatarefs " . dump(@retrievedatarefs);
							my $simtitle = $simtitles{$counttool}->[ $counttheme ][0]; #say $tee "\$simtitle " . dump($simtitle);
							my @sims = @{ $simtitles{$counttool}->[ $counttheme ] }[1..4]; #say $tee "\@sims " . dump(@sims);
							
							my $resfile = $resfiles[ $counttheme ]; #say $tee "\HERE\$resfile " . dump($resfile);
							
							if ( -e $resfile ) 
							{
								

								my @retrdata = @$retrievedataref; #say $tee "\@retrdata " . dump(@retrdata);
				
								open( RETLIST, ">>$retlist"); # or die;
								open( RETBLOCK, ">>$retblock"); # or die;
																				
								my $reportdata_ref = $reportdata_ref_ref->[$countreport]; say $tee "\$reportdata_ref" . dump($reportdata_ref); 
								my @reportdata = @$reportdata_ref;  say $tee "\@reportdata" . dump(@reportdata); 
								
								my $retfile = "$resfile"; #say $tee "\$retfile " . dump($retfile); 
								if ( not ($retfile ~~ @retcases ) )
								{
									push ( @retcases, $retfile );
									say RETLIST "$retfile";
								}
								my @provbag;
								
								push ( @provbag, $retfile );
									
								my $countitem = 0;
								foreach my $item ( @reportdata )
								{
									my %datarep = %$item; say $tee "\%datarep" . dump(%datarep); 
									my $reporttitle = $datarep{reporttitle}; say $tee "\$reporttitle! " . dump($reporttitle); ###DDD HERE
									my $themereport = $datarep{themereport}; say $tee "\$themereport " . dump($themereport); 
									my $semaphorego1 = $datarep{semaphorego1}; say $tee "\$semaphorego1 " . dump($semaphorego1); 
									my $semaphorego2 = $datarep{semaphorego2}; say $tee "\$semaphorego2 " . dump($semaphorego2); 
									my $semaphorestop1 = $datarep{semaphorestop1}; say $tee "\$semaphorestop1 " . dump($semaphorestop1); 
									my $semaphorestop2 = $datarep{semaphorestop2}; say $tee "\$semaphorestop2 " . dump($semaphorestop2); 
									my $textpattern = $datarep{textpattern}; say $tee "\$textpattern " . dump($textpattern); 
									my $afterlines = $datarep{afterlines}; say $tee "\$afterlines " . dump($afterlines);  
									say TOSHELL "\$retfile " . dump($retfile); say TOSHELL "\$retfile " . dump($retfile);
									
									print RETBLOCK "$retfile\n";
	
									
									#if ( not ( $retfile ~~ @provbag ) ) 
									#{
										
										push ( @{ $notecases[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] } , 
																			{
																				retfile => $retfile,
																				reporttitle => $reporttitle,
																				themereport => $themereport,
																				semaphorego1 => $semaphorego1,
																				semaphorego2 => $semaphorego2,
																				semaphorestop1 => $semaphorestop1,
																				semaphorestop2 => $semaphorestop2,
																				textpattern => $textpattern,
																				afterlines => $afterlines
																			} );
									#}
									$countitem++;
								}


							}
							else  
							{ 
								say "A RESULT FILE NAMED $resfile DOES NOT EXIST. EXITING.";
							}
							$counttheme++;
						}
						$counttool++;
					}
				}	
			}
		}
		$countinstance++;
	}
	print `rm -f $mypath/*.par`;
	print TOSHELL "rm -f $mypath/*.par\n";
	close OUTFILE;
	close TOSHELL;
	close RETLIST;
	close RETBLOCK;
	say $tee "INEXIT \@retcases " . dump( @retcases ); 
	say $tee "\@retstruct " . dump( @retstruct ); 
	say $tee "\@notecases " . dump( @notecases ); 
	return ( \@retcases, \@retstruct, \@notecases );
}	# END SUB RETRIEVE


sub report # This function retrieves the results of interest from the texts files created by the "retrieve" function
{
	my $swap = shift; #say TOSHELL "swapINDESCEND: " . dump($swap);
	my %dat = %$swap;
	my @instances = @{ $dat{instances} }; #say "scalar(\@instances): " . scalar(@instances);
	my $countcase = $dat{countcase}; #say "dump(\$countcase): " . dump($countcase); # IT WILL BE SHADOWED. CUT ZZZ
	my $countblock = $dat{countblock}; #say "dump(\$countblock): " . dump($countblock); # IT WILL BE SHADOWED. CUT ZZZ		
	my %dirfiles = %{ $dat{dirfiles} }; #say "dump(\%dirfiles): " . dump(%dirfiles); 
		
	$configfile = $main::configfile; #say "dump(\$configfile): " . dump($configfile);
	@sweeps = @main::sweeps; #say "dump(\@sweeps): " . dump(@sweeps);
	@varinumbers = @main::varinumbers; #say "dump(\@varinumbers): " . dump(@varinumbers);
	@mediumiters = @main::mediumiters;
	@rootnames = @main::rootnames; #say "dump(\@rootnames): " . dump(@rootnames);
	%vals = %main::vals; #say "dump(\%vals): " . dump(%vals);
	
	$mypath = $main::mypath;  #say TOSHELL "dumpINDESCEND(\$mypath): " . dump($mypath);
	$exeonfiles = $main::exeonfiles; #say TOSHELL "dumpINDESCEND(\$exeonfiles): " . dump($exeonfiles);
	$generatechance = $main::generatechance; 
	$file = $main::file;
	$preventsim = $main::preventsim;
	$fileconfig = $main::fileconfig; #say TOSHELL "dumpINDESCEND(\$fileconfig): " . dump($fileconfig); # NOW GLOBAL. TO MAKE IT PRIVATE, FIX PASSING OF PARAMETERS IN CONTRAINTS PROPAGATION SECONDARY SUBROUTINES
	$outfile = $main::outfile;
	$toshell = $main::toshell;
	$report = $main::report;
	$simnetwork = $main::simnetwork;
	
	$tee = new IO::Tee(\*STDOUT, ">>$toshell"); # GLOBAL ZZZ
	
	#open( OUTFILE, ">>$outfile" ) or die "Can't open $outfile: $!"; 
	open( TOSHELL, ">>$toshell" ) or die "Can't open $toshell: $!";  
	say "\nNow in Sim::OPT::Report::report.\n";
	say TOSHELL "\n#Now in Sim::OPT::Report::report.\n";
	
	%dowhat = %main::dowhat;

	%simtitles = %main::simtitles; say $tee "dumpINRETRIEVE(\%simtitles): " . dump(%simtitles);
	%retrievedata = %main::retrievedata;
	@keepcolumns = @main::keepcolumns;
	@weights = @main::weights;
	@weightsaim = @main::weightsaim;
	@varthemes_report = @main::varthemes_report;
	@varthemes_variations = @vmain::arthemes_variations;
	@varthemes_steps = @main::varthemes_steps;
	@rankdata = @main::rankdata; # CUT ZZZ
	@rankcolumn = @main::rankcolumn;
	%reportdata = %main::reportdata; say $tee "dump(\%reportdata): " . dump(%reportdata);
	@files_to_filter = @main::files_to_filter;
	@filter_reports = @main::filter_reports;
	@base_columns = @main::base_columns;
	@maketabledata = @main::maketabledata;
	@filter_columns = @main::filter_columns;
	%notecases = %main::notecases;
	
	my @simcases = @{ $dirfiles{simcases} }; #say "dump(\@simcases): " . dump(@simcases);
	my @simstruct = @{ $dirfiles{simstruct} }; #say "dump(\@simstruct): " . dump(@simstruct);
	my @INREPORT = @{ $dirfiles{morphcases} };
	my @morphstruct = @{ $dirfiles{morphstruct} };
	my @retcases = @{ $dirfiles{retcases} }; say TOSHELL "dumpINREPORT::report(\@retcases): " . dump(@retcases); 
	my @retstruct = @{ $dirfiles{retstruct} }; say TOSHELL "dumpINREPORT::report(\@retstruct): " . dump(@retstruct);
	my @repcases = @{ $dirfiles{repcases} };
	my @repstruct = @{ $dirfiles{repstruct} };
	my @mergecases = @{ $dirfiles{mergecases} };
	my @mergestruct = @{ $dirfiles{mergestruct} };
	my @descendcases = @{ $dirfiles{descendcases} };
	my @descendstruct = @{ $dirfiles{descendstruct} };
	my @notecases = @{ $dirfiles{notecases} }; say TOSHELL "dumpINREPORT::report(\@notecases): " . dump(@notecases);
	
	my $morphlist = $dirfiles{morphlist}; #say "dump(\$dat{morphlist}): " . dump($dat{morphlist});
	my $morphblock = $dirfiles{morphblock};
	my $simlist = $dirfiles{simlist}; #say "dump(\$simlist): " . dump($simlist);
	my $simblock = $dirfiles{simblock};
	my $retlist = $dirfiles{retlist}; say TOSHELL "dumpINREPORT::report(\$retlist): " . dump($retlist); 
	my $retblock = $dirfiles{retblock};
	my $replist = $dirfiles{replist};
	my $repblock = $dirfiles{repblock};
	my $descendlist = $dirfiles{descendlist};
	my $descendblock = $dirfiles{descendblock};
	
	my @repfilemem;
	my @linecontent;
	$" = " ";
	my $repfile;
	$" = " ";
	my $countinstance = 0;
	foreach my $instance (@instances)
	{
		my %d = %{$instance};
		my $countcase = $d{countcase}; #say TOSHELL "dump(\$countcase): " . dump($countcase);
		my $countblock = $d{countblock}; #say TOSHELL "dump(\$countblock): " . dump($countblock);
		my @miditers = @{ $d{miditers} }; #say TOSHELL "dump(\@miditers): " . dump(@miditers);
		my @winneritems = @{ $d{winneritems} }; #say TOSHELL "dumpIN( \@winneritems) " . dump(@winneritems);
		my $countvar = $d{countvar}; #say TOSHELL "dump(\$countvar): " . dump($countvar);
		my $countstep = $d{countstep}; #say TOSHELL "dump(\$countstep): " . dump($countstep);						
		my $to = $d{to}; #say TOSHELL "dump(\$to): " . dump($to);
		my $origin = $d{origin}; #say TOSHELL "dump(\$origin): " . dump($origin);
		my @uplift = @{ $d{uplift} }; #say TOSHELL "dump(\@uplift): " . dump(@uplift);
		
		my $rootname = Sim::OPT::getrootname(\@rootnames, $countcase); #say TOSHELL "dump(\$rootname): " . dump($rootname);
		my @blockelts = Sim::OPT::getblockelts(\@sweeps, $countcase, $countblock); #say TOSHELL "dumpIN( \@blockelts) " . dump(@blockelts);
		my @blocks = Sim::OPT::getblocks(\@sweeps, $countcase);  #say TOSHELL "dumpIN( \@blocks) " . dump(@blocks);
		my $toitem = Sim::OPT::getitem(\@winneritems, $countcase, $countblock); #say TOSHELL "dump(\$toitem): " . dump($toitem);
		my $from = Sim::OPT::getline($toitem); #say TOSHELL "dumpIN(\$from): " . dump($from);
		my %varnums = Sim::OPT::getcase(\@varinumbers, $countcase); #say TOSHELL "dumpIN---(\%varnums): " . dump(%varnums); 
		my %mids = Sim::OPT::getcase(\@miditers, $countcase); #say TOSHELL "dumpIN---(\%mids): " . dump(%mids); 
		
		my $stepsvar = Sim::OPT::getstepsvar($countvar, $countcase, \@varinumbers); #say TOSHELL "dump(\$stepsvar): " . dump($stepsvar); 
		my $varnumber = $countvar; #say TOSHELL "dump---(\$varnumber): " . dump($varnumber) . "\n\n";  # LEGACY VARIABLE

		say TOSHELL "#Processing reports for case " . ($countcase + 1) . ", block " . ($countblock + 1);
		
		open( REPLIST, ">>$replist" ) or die( "$!" ); say TOSHELL "dump---(\$replist): " . dump($replist) . "\n\n";  
		open( REPBLOCK, ">>$repblock" ) or die( "$!" ); say TOSHELL "dump---(\$repblock): " . dump($repblock) . "\n\n";
		
		$repfile = "$mypath/$file-report-$countcase-$countblock.txt";  say TOSHELL "dump---(\$repfile): " . dump($repfile) . "\n\n";
		open( REPFILE, ">>$repfile") or die "Can't open $repfile $!";
		
		push ( @{ $repstruct[$countcase][$countblock] }, $repfile );
		say REPBLOCK "$repfile";
		if ( not ( $repfile ~~ @repcases ) )
		{
			push ( @repcases, $repfile );
			say REPLIST "$repfile";
		}

		#open( REPFILE, ">>$repfile") or die "Can't open $repfile $!";
		
		say TOSHELL "dump---(\%notecases): " . dump( %notecases ) . "\n\n";  
		
		my $numberof_simtools = scalar ( keys %{ $dowhat{simtools} } ); say $tee "\$numberof_simtools " . dump( $numberof_simtools );
		
		my $counttool = 1;
		while ( $counttool <= $numberof_simtools )
		{	
			my $skip = $vals{$countvar}{$counttool}{skip}; say $tee "dumpinsim(\$skip): " . dump($skip);
			if ( not ( eval ( $skipsim{$counttool} )))
			{
				my $tooltype = $dowhat{simtools}{$counttool}; say $tee "\$tooltype " . dump( $tooltype );
				say $tee "\$notecases[ \$countcase ][ \$countblock ][ \$countinstance ][ \$counttool ] } : " . dump( $notecases[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] );
				foreach $ret_ref ( @{ $notecases[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] } )
				{
					say $tee "\$ret_ref " . dump( $ret_ref );
					%retitem = %$ret_ref; say TOSHELL "dump---(\@retitem): " . dump(@retitem) . "\n\n";  
					my $retfile = $retitem{retfile}; say TOSHELL "dump---(\$retfile): " . dump($retfile) . "\n\n";  
					my $reporttitle = $retitem{reporttitle}; say TOSHELL "dump---(\$reporttitle): " . dump($reporttitle) . "\n\n";  
					my $themereport = $retitem{themereport}; say TOSHELL "dump---(\$themereport): " . dump($themereport) . "\n\n";  
					my $semaphorego1 = $retitem{semaphorego1}; say TOSHELL "dump---(\$semaphorego1): " . dump($semaphorego1) . "\n\n";  
					my $semaphorego2 = $retitem{semaphorego2}; say TOSHELL "dump---(\$semaphorego2): " . dump($semaphorego2) . "\n\n";  
					my $semaphorestop1 = $retitem{semaphorestop1}; say TOSHELL "dump---(\$semaphorestop1): " . dump($semaphorestop1) . "\n\n";
					my $semaphorestop2 = $retitem{semaphorestop2}; say TOSHELL "dump---(\$semaphorestop2): " . dump($semaphorestop2) . "\n\n";  
					my $textpattern = $retitem{textpattern}; say TOSHELL "dump---(\$textpattern): " . dump($textpattern) . "\n\n";  
					my $afterlines = $retitem{afterlines}; say TOSHELL "dump---(\$afterlines): " . dump($afterlines) . "\n\n";  
					my ( $semaphore1, $semaphore2 );
					
					
					if ( -e $retfile )
					#if ( not ( eval ( $skipreport ) ) )
					{
						open( RETFILE, "$retfile" ) or die( "$!" );
						my @lines = <RETFILE>;
						close RETFILE;
						say TOSHELL "RETFILE! " ;
						my $countline = 0;
						foreach my $line ( @lines )
						{
							$line =~ s/^\s+//;
							chomp $line;
							$line = $line . " ";
							#say TOSHELL "\$line: $line";
							
							if ( ( not defined( $semaphorego1 ) ) or ( $line =~ m/$semaphorego1/ ) )
							{
								$semaphore1 = "on";  say TOSHELL "ON1: ";
							}
							
							if ( $semaphore1 eq "on" )
							{
								if ( ( not defined( $semaphorego2 ) ) or ( $line =~ m/$semaphorego2/ ) )
								{
									$semaphore2 = "on"; say TOSHELL "ON2: ";
								}
							}
														
							if ( ( $line =~ m/$semaphorestop1/ ) and ( $semaphorestop1 ne "" ) )
							{
								$semaphore1 = "off"; say TOSHELL "OFF1: ";
							}
							
							if ( ( $line =~ m/$semaphorestop2/ ) and ( $semaphorestop2 ne "" ) )
							{
								$semaphore2 = "off"; say TOSHELL "OFF2: ";
							}
							
							if ( ( $textpattern ne "" ) and ( $line =~ m/^$textpattern/ ) and ( $semaphore1 eq "on" ) and ( $semaphore2 eq "on" ) )
							{
								print TOSHELL "HIT REPORT1! "; say TOSHELL $line;
								push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, "$retfile $semaphorego1 $semaphorego2 $line " );
								$semaphore1 = "off";
								$semaphore2 = "off";
							}
							
							if ( ( $afterlines ne "" ) and ( $semaphore1 eq "on" ) and ( $semaphore2 eq "on" ) and ( $countline == $afterlines ) )
							{
								print TOSHELL "HIT REPORT2! "; say TOSHELL $line;
								push ( @{ $mergestruct[$countcase][$countblock][ $countinstance ] }, "$retfile $semaphorestop1 $semaphorestop2 $line " );
								$countlines = 0;
								$semaphore1 = "off";
								$semaphore2 = "off";
							}
							
							if ( ( $semaphore1 eq "on" ) and ( $semaphore2 eq "on" ) )
							{
								$countline++; say TOSHELL "ON3 COUNTLINE: $countline";
							}
						}
					}
					
				}
			}
			$counttool++;
		}
		say TOSHELL "\@mergestruct: " . dump(@mergestruct); 
		$countinstance++;
	}
	
	#if ( @repfilemem ~~ @mergecases ) 
	#{ 
	#	push ( @mergecases,  @repfilemem );
	#}
	#say TOSHELL "\@repfilemem ~~ \@mergecases.";
	
	say "#Reporting results for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep. Instance $countinstance: writing $repfile. ";
		
	foreach my $instref ( @{ $mergestruct[$countcase][$countblock] } )
	{
		foreach my $inst ( @$instref )
		{
			print REPFILE "$inst"; #say TOSHELL " INSTANCE " . dump($_);
		}
		print REPFILE "\n";
	}
	close REPFILE;
		
	say TOSHELL "HEREIS \@repcases " . dump(@repcases); say TOSHELL "\@repstruct " . dump(@repstruct); say TOSHELL "\@mergestruct " . dump(@mergestruct);
	say TOSHELL "\@mergecases " . dump(@mergecases); say TOSHELL "\$repfile: " . dump($repfile);
	close TOSHELL;
	close OUTFILE;
	return ( \@repcases, \@repstruct, \@mergestruct, \@mergecases, $repfile ); 
} # END SUB report;

sub get_files # UNUSED. LEGACY. CUT.
{
	say "Extracting statistics for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", instance: " . ( $countinstance + 1);
	say TOSHELL "
	#Extracting statistics for case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", instance: " . ( $countinstance + 1);
	my ( $themereport, $countcase, $countblock, $counttheme, $countreport, $retfile, $repfile, 
		$simtitle, $reporttitle, $simdatum, $retrievsref, $countinstance, $swap, $loadsortemps ) = @_;
		
	say TOSHELL "#CALLED-REPSTRUCT " . dump(@repstruct); # ZZZ	
	say TOSHELL "CALLED-\$themereport: " . dump($themereport);
	say TOSHELL "CALLED-\$countcase: " . dump($countcase);
	say TOSHELL "CALLED-\$countblock: " . dump($countblock);
	say TOSHELL "CALLED-\$themereport " . dump($themereport);
	say TOSHELL "CALLED-\$counttheme " . dump($counttheme);
	say TOSHELL "CALLED-\$countreport " . dump($countreport);
	say TOSHELL "CALLED-\$retfile: " . dump($retfile);
	say TOSHELL "CALLED-\$repfile: " . dump($repfile);
	say TOSHELL "CALLED-\$loadsortemps " . dump($loadsortemps);
	say TOSHELL "repfilemem CALLED " . dump( @repfilemem );
				
	my @repfilemem = @$swap; #say TOSHELL "CALLED-\@repfilemem " . dump(@repfilemem);
	my @retrievs = @$retrievsref;
	
	my @measurements_to_report = $retrievs[0]; #say TOSHELL "CALLED-\@measurements_to_report " . dump(@measurements_to_report);
	my $dates_to_report = $simtitle; #say TOSHELL "CALLED-\$dates_to_report " . dump($dates_to_report);
	
	say TOSHELL "CALLED\$loadsortemps: " . $loadsortemps; say TOSHELL "\$retfile! " . $retfile;
	open( RETFILE,  "$retfile" ) or die "Can't open $retfile $!";
	my @lines_to_inspect = <RETFILE>; say TOSHELL "CALLED-\@lines_to_inspect " . dump(@lines_to_inspect);

	my @countcolumns;
	my $countzones = 0;
	my $countlines = 0;
	foreach my $line_to_inspect (@lines_to_inspect) 
	{
		if ( $line_to_inspect )
		{
			
			$line_to_inspect =~ s/^\s+//g;### DO THIS? ZZZ
			$line_to_inspect =~ s/\s*$//;      #remove trailing whitespace
			#$line_to_inspect =~ s/\ {2,}/ /g;  #remove multiple literal spaces
			$line_to_inspect =~ s/\t{2,}/\t/g; say TOSHELL "line_to_inspect: $line_to_inspect";		 
			
			if ( $themereport eq "temps" ) # NEVER CHECKED IF IT STILL WORKS AFTER SOME USES
			{
				my @roww = split( /\s+/, $line_to_inspect );
				if ( $countlines == 1 )
				{
					$file_and_period = $roww[5];
				} 
				elsif ( $countlines == 3 )
				{
					my $countcolumn = 0;
					foreach $elt_of_row (@roww)
					{    #
						foreach $column (@columns_to_report)
						{
							if ( $elt_of_row eq $column )
							{
								push @countcolumns, $countcolumn;
								if ( $elt_of_row eq $columns_to_report[0] )
								{
									$title_of_column = "$elt_of_row";
								} else
								{
									$title_of_column =  "$elt_of_row-" . "$file_and_period";
								}
								push ( @{ $repfilemem[$countinstance] }, "$title_of_column\t" );
							}
						}
						$countcolumn = $countcolumn + 1;
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				} 
				elsif ( $countlines > 3 )
				{
					foreach $columnumber (@countcolumns)
					{
						if ( $columnumber =~ /\d/ )
						{
							push ( @{ $repfilemem[$countinstance] }, "$roww[$columnumber]\t" );
						}
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				}
				$countlines++;
			}
			
			if ( $themereport eq "comfort" ) # NEVER CHECKED IF IT STILL WORKS AFTER SOME USES
			{				
				my @roww = split( /\s+/, $line_to_inspect );

				if ( $countlines == 1 )
				{
					$file_and_period = $roww[5];
				} 
				elsif ( $countlines == 3 )
				{
					my $countcolumn = 0;
					foreach $elt_of_row (@roww)
					{    #
						foreach $column (@columns_to_report)
						{
							if ( $elt_of_row eq $column )
							{
								push @countcolumns, $countcolumn;
								if ( $elt_of_row eq $columns_to_report[0] )
								{
									$title_of_column = "$elt_of_row";
								} else
								{
									$title_of_column =
									  "$elt_of_row-" . "$file_and_period";
								}
								push ( @{ $repfilemem[$countinstance] }, "$title_of_column\t" );
							}
						}
						$countcolumn = $countcolumn + 1;
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				} 
				elsif ( $countlines > 3 )
				{
					foreach $columnumber (@countcolumns)
					{
						if ( $columnumber =~ /\d/ )
						{
							push ( @{ $repfilemem[$countinstance] }, "$roww[$columnumber]\t" );
						}
					}
					#push ( @{ $repfilemem[$countlines] }, "\n" );
				}
				$countlines++;
			}
			
			my $line_to_report;
			say TOSHELL "\$loadsortemps: $loadsortemps";
			if ( ( $themereport eq "loads" ) or ( $themereport eq "tempsstats" ) ) 
			{	
				if ( $line_to_inspect =~ /^$loadsortemps/ )
				{
					$line_to_report = "$retfile " . " $themereport $reporttitle " . $line_to_inspect . " " ;
					$line_to_report =~ s/--//g;
					$line_to_report =~ s/\s+/ /g;  #remove multiple literal spaces
					$line_to_report =~ s/ /,/g;  #remove multiple literal spaces
					push ( @{ $repfilemem[$countinstance] }, $line_to_report );
				}
				$countlines++;
			}
		}
	}
	say TOSHELL "LEAVING \@repfilemem " . dump(@repfilemem);
	return (@repfilemem); 
} # END SUB get_files

1;
