use strict;
use warnings;
use inc::Module::Install;
use Module::Install::XSUtil 0.21;

all_from 'lib/Text/Xslate.pm';

use_ppport 3.19;
cc_warnings;

requires 'Mouse'                => '0.55';
requires 'MouseX::NativeTraits' => '0.002';
requires 'MouseX::Getopt'       => '0.2601';
requires 'parent'               => '0.221';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
test_requires 'Test::LeakTrace';

install_script 'xslate';

tests_recursive 't';

cc_src_paths qw(xs);

auto_set_repository() if -d '.git';

postamble <<'M';
# xslate_ops.h is automatically generated by xs/Text-Xslate.xs
xslate_ops.h :: xs/Text-Xslate.xs tool/opcode.pl
	$(PERLRUNINST) tool/opcode.pl xs/Text-Xslate.xs >xslate_ops.h

lib/Text/Xslate/PP/Const.pm :: xs/Text-Xslate.xs tool/opcode_for_pp.pl
	$(PERLRUNINST) tool/opcode_for_pp.pl xs/Text-Xslate.xs > lib/Text/Xslate/PP/Const.pm
M

if(author_context()) {
        # repeat testing for pure Perl mode
        # see also ExtUtils::MM_Any::test_via_harness()
        my $t_pp =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
                   .q{ "do 'tool/force-pp.pl'; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
                   .q{ $(TEST_FILES)} . "\n";

        postamble qq{test_dynamic :: test_pp\n\n}
                . qq{test_pp :: pure_all\n}
                . qq{\t} . $t_pp;
}

clean_files qw(
    Text-Xslate-*
    nytprof *.out
    cover_db
);

WriteAll(check_nmake => 0);

