package TestCompat::apache_table;

# Apache::Table compat layer tests

# these tests are all run and validated on the server side.

use strict;
use warnings FATAL => 'all';

use Apache::TestUtil;
use Apache::Test;

use Apache::compat ();
use Apache::Constants qw(OK);

sub handler {
    my $r = shift;

    plan $r, tests => 2;

    $r->send_http_header('text/plain');

    my $t = Apache::Table->new($r);
    my $t_class = ref $t;

    ok t_cmp('APR::Table', $t_class, "Apache::Table->new");

    ok t_cmp(!$r->main, $r->is_main,
             '$r->is_main');

    OK;
}

1;

