package Math::Partition::Rand;
our $AUTHORITY = 'cpan:GENE';

# ABSTRACT: Partition a number into addition sequences

our $VERSION = '0.01';

use strict;
use warnings;



sub new {
    my $class = shift;
    my %args = @_;
    my $self = {
        top => $args{top} || 1,
        n   => $args{n}   || 2,
    };
    bless $self, $class;
    return $self;
}


sub choose {
    my $self = shift;

    my %distribution;

    my $label = 0;
    my $top   = $self->{top};
    my $n     = $self->{n};

    for my $i ( 1 .. $n ) {
        my $curr = rand($top);
        my $next = abs( $top - $curr );

        $distribution{$label} = $i == $n ? $top : $next;

        $top = $curr;
        $label++;
    }

    return %distribution;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Math::Partition::Rand - Partition a number into addition sequences

=head1 VERSION

version 0.01

=head1 SYNOPSIS

  use Math::Partition::Rand;
  my $p = Math::Partition::Rand->new( top => 1, n => 3 );
  my %d = $p->choose();

=head1 DESCRIPTION

A C<Math::Partition::Rand> partitions a number (B<top>) into a given number of addition sequences (B<n>).

=head1 NAME

Math::Partition::Rand - Partition a number into addition sequences

=head1 METHODS

=head2 new()

  $x = Math::Partition::Rand->new(%arguments);

Create a new C<Math::Partition::Rand> object.

Arguments and defaults:

  top => 1,
  n   => 2,

=head2 choose()

  my %hash = $self->choose();

Partition the given number, B<top> into addition B<n> parts.

Example: For top = 1, n = 3

  { 0 => 0.228102577310889,
    1 => 0.0880906485615138,
    2 => 0.683806774127597 }

=head1 AUTHOR

Gene Boggs <gene@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gene Boggs.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
