use Test::More tests => 6;
use Gnuplot::Simple qw(:all);
use File::Slurp;
use Test::Exception;
use Cwd;
use File::Basename;

{
    #this dataset contains some whitespace to test that case too
    my $D = [ [ 1, "3 " ], [ 2, 4 ] ];
    write_data( "./t/temp/gnuplot_test.csv", $D );
    is(
        read_file( "./t/temp/gnuplot_test.csv", { binmode => ":utf8" } ),
        "1\t\"3 \"\n2\t4",
        'Writes gnuplot file correctly'
    );

    #test exception
    my $d = [ ['"a'] ];
    my $df = "./t/temp/gnuplot_test.csv";
    dies_ok { write_data( $df, $d ) } 'Does not accept "';
    throws_ok { write_data( $df, [] ) } qr/Non-empty/, 'Must contain data';
    throws_ok { write_data( $df, [ [] ] ) } qr/more than one/, 'Must contain labels';

}

#exec_commands
{
    my $d = [ [ 1, 1 ], [ 2, 2 ], [ 3, 3 ] ];
    my $f = dirname(__FILE__) . "/test.png";
    exec_commands(
        qq{
        set terminal png
        set output "$f"
        plot __DATA__ u 1:2 
        }, $d
    );
    ok( -e $f, 'Creates an image file' );
    `rm -f $f`;

    #test error handling
    throws_ok { exec_commands( "asdf\n", $d ) } qr/invalid command/,
      'Captures gnuplot stderr.';
}

