#
# (c) Jan Gehring <jan.gehring@gmail.com>
#
# vim: set ts=2 sw=2 tw=0:
# vim: set expandtab:

package Rex::Interface::Shell::Ash;

use strict;
use warnings;

our $VERSION = '1.3.1_2'; # TRIAL VERSION

use Rex::Interface::Shell::Bash;

use base qw(Rex::Interface::Shell::Bash);

sub new {
  my $class = shift;
  my $proto = ref($class) || $class;
  my $self  = $proto->SUPER::new(@_);

  bless( $self, $class );

  return $self;
}

sub detect {
  my ( $self, $con ) = @_;

  my ($shell_path) = $con->_exec("echo \$SHELL");
  if ( $shell_path =~ m/\/ash$/ ) {
    return 1;
  }

  return 0;
}

1;
