#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorBalance4',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'about' => { 204 => 'about' },
	'abspeakaudiofilepath' => { 209 => 'absPeakAudioFilePath' },
	'accessorytype' => { 158 => 0x53 },
	'actionadvised' => { 62 => 0x2a },
	'activearea' => { 56 => 0xc68d },
	'actived-lighting' => { 117 => 0x22, 135 => 0x24 },
	'actived-lightingmode' => { 135 => 0x25 },
	'addaspectratioinfo' => { 33 => 0x80e },
	'additionalmodelinformation' => { 197 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 33 => 0x80f, 34 => 0x11, 35 => 0x13, 38 => 0x14 },
	'address' => { 84 => 'Address' },
	'adjustmentmode' => { 183 => [0x15,0x22] },
	'adultcontentwarning' => { 200 => 'AdultContentWarning', 203 => 'adultContentWarning' },
	'advancedraw' => { 137 => 0x76a43203 },
	'advisory' => { 207 => 'Advisory' },
	'ae_iso' => { 160 => 0x2 },
	'aeaperture' => { 160 => 0x1 },
	'aebautocancel' => { 33 => 0x104 },
	'aebbracketvalue' => { 30 => 0x11 },
	'aebsequence' => { 31 => 0x9, 32 => 0x9, 33 => 0x105, 34 => 0x8, 35 => 0x9, 38 => 0x9, 39 => 0x7 },
	'aebshotcount' => { 33 => 0x106 },
	'aebxv' => { 160 => 0x4 },
	'aeexposuretime' => { 160 => 0x0 },
	'aeextra' => { 160 => 0x7 },
	'aelock' => { 125 => '733.3', 126 => '752.2', 144 => 0x201, 171 => 0x48 },
	'aelockbutton' => { 125 => '733.2', 126 => '752.1' },
	'aemaxaperture' => { 160 => 0x9 },
	'aemaxaperture2' => { 160 => 0xa },
	'aemeteringmode' => { 160 => 0xc },
	'aemeteringsegments' => { 171 => 0x209 },
	'aeminaperture' => { 160 => 0xb },
	'aeminexposuretime' => { 160 => 0x5 },
	'aeprogrammode' => { 160 => 0x6 },
	'aesetting' => { 11 => 0x21 },
	'aexv' => { 160 => 0x3 },
	'af-cpriorityselection' => { 124 => '791.1' },
	'af-onformb-d10' => { 124 => '793.1' },
	'af-spriorityselection' => { 124 => '791.2' },
	'afactivation' => { 124 => '792.1' },
	'afadjustment' => { 171 => 0x72 },
	'afaperture' => { 115 => 0x5, 116 => 0x5 },
	'afareaillumination' => { 126 => '763.3' },
	'afareamode' => { 101 => 0x0, 102 => 0x5, 126 => 0x2fc },
	'afareamodesetting' => { 125 => 0x2e4 },
	'afareas' => { 144 => 0x304 },
	'afassist' => { 31 => 0x5, 39 => 0x5, 125 => '729.2', 126 => '748.2' },
	'afassistbeam' => { 33 => 0x50e, 34 => 0x4, 35 => 0x5, 36 => 0x4, 37 => 0x4, 38 => 0x5 },
	'afassistilluminator' => { 124 => '792.4' },
	'afdefocus' => { 161 => 0x6 },
	'afduringliveview' => { 33 => 0x511 },
	'afexpansionwithselectedpoint' => { 33 => 0x508 },
	'affinetuneadj' => { 124 => 0x2d1 },
	'afintegrationtime' => { 161 => 0x7 },
	'afmicroadjustment' => { 33 => 0x507 },
	'afmode' => { 158 => 0xf, 183 => 0x5 },
	'afonaelockbuttonswitch' => { 33 => 0x702 },
	'afpoint' => { 11 => 0x13, 52 => 0x18, 101 => 0x1, 147 => 0x308 },
	'afpointactivationarea' => { 32 => 0x11, 38 => 0x11 },
	'afpointautoselection' => { 33 => 0x50b },
	'afpointbrightness' => { 33 => 0x50d },
	'afpointdisplayduringfocus' => { 33 => 0x50c },
	'afpointillumination' => { 32 => 0xa, 124 => '792.3' },
	'afpointmode' => { 164 => 0x3 },
	'afpointposition' => { 53 => 0x2021 },
	'afpointregistration' => { 31 => 0x7 },
	'afpoints' => { 95 => 0x10 },
	'afpointselected' => { 171 => 0xe },
	'afpointselected2' => { 164 => 0x4 },
	'afpointselection' => { 32 => 0xb, 124 => '791.3' },
	'afpointselectionmethod' => { 33 => 0x50f, 34 => 0xc, 35 => 0xd, 38 => 0xd },
	'afpointsinfocus' => { 30 => 0xe, 101 => 0x2, 161 => 0xb, 171 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 9 => 0x38 },
	'afpointspotmetering' => { 32 => 0xd },
	'afpointsunknown1' => { 161 => 0x0 },
	'afpointsunknown2' => { 161 => 0x2 },
	'afpointsused' => { 102 => 0x8 },
	'afpredictor' => { 161 => 0x4 },
	'afresponse' => { 117 => 0xad },
	'afresult' => { 149 => 0x1038 },
	'afsearch' => { 144 => 0x303 },
	'aggregationtype' => { 201 => 'aggregationType' },
	'agreement' => { 203 => 'agreement' },
	'aiservoimagepriority' => { 33 => 0x503 },
	'aiservotrackingmethod' => { 33 => 0x504 },
	'aiservotrackingsensitivity' => { 32 => 0x14, 33 => 0x502 },
	'album' => { 209 => 'album' },
	'alreadyapplied' => { 192 => 'AlreadyApplied' },
	'alternatetitle' => { 201 => 'alternateTitle' },
	'alttapename' => { 209 => 'altTapeName' },
	'alttimecodetimeformat' => { 209 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 209 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 209 => 'altTimecodeValue' },
	'anti-blur' => { 184 => 0xb04b },
	'antialiasstrength' => { 56 => 0xc632 },
	'aperturerange' => { 33 => 0x10d },
	'apertureringuse' => { 164 => '1.4' },
	'aperturevalue' => { 42 => 0x2, 56 => 0x9202, 149 => 0x1002, 195 => 'ApertureValue' },
	'applekeywords' => { 153 => 'AAPL:Keywords' },
	'applicationnotes' => { 56 => 0x2bc },
	'applicationrecordversion' => { 62 => 0x0 },
	'applyshootingmeteringmode' => { 33 => 0x10e },
	'approximatefnumber' => { 156 => 0x313 },
	'armidentifier' => { 63 => 0x78 },
	'armversion' => { 63 => 0x7a },
	'artist' => { 56 => 0x13b, 155 => 'Artist', 205 => 'Artist', 209 => 'artist' },
	'artworkcopyrightnotice' => { 197 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 197 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 197 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 197 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 197 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 197 => 'ArtworkOrObjectAOTitle' },
	'asshoticcprofile' => { 56 => 0xc68f },
	'asshotneutral' => { 56 => 0xc628 },
	'asshotpreprofilematrix' => { 56 => 0xc690 },
	'asshotprofilename' => { 56 => 0xc6f6 },
	'asshotwhitexy' => { 56 => 0xc629 },
	'assignfuncbutton' => { 33 => 0x70b },
	'assistbuttonfunction' => { 31 => 0xd },
	'audio' => { 158 => 0x20 },
	'audiochanneltype' => { 209 => 'audioChannelType' },
	'audiocompression' => { 78 => 'Compression' },
	'audiocompressor' => { 209 => 'audioCompressor' },
	'audioduration' => { 62 => 0x99 },
	'audiomoddate' => { 209 => 'audioModDate' },
	'audiooutcue' => { 62 => 0x9a },
	'audiosamplerate' => { 209 => 'audioSampleRate' },
	'audiosampletype' => { 209 => 'audioSampleType' },
	'audiosamplingrate' => { 62 => 0x97 },
	'audiosamplingresolution' => { 62 => 0x98 },
	'audiotype' => { 62 => 0x96 },
	'author' => { 80 => 'Author', 153 => 'Author', 155 => 'Author', 179 => 'Author', 198 => 'Author' },
	'authorsposition' => { 199 => 'AuthorsPosition' },
	'autoaperture' => { 168 => '0.1' },
	'autobracket' => { 183 => 0x19 },
	'autobracketing' => { 60 => 0x1100, 171 => 0x18 },
	'autobracketmodem' => { 124 => '811.2' },
	'autobracketorder' => { 124 => '811.3', 126 => '750.2' },
	'autobracketrelease' => { 117 => 0x8a },
	'autobracketset' => { 124 => '811.1', 126 => '750.1' },
	'autobrightness' => { 192 => 'AutoBrightness' },
	'autocontrast' => { 192 => 'AutoContrast' },
	'autoexposure' => { 192 => 'AutoExposure' },
	'autoexposurebracketing' => { 30 => 0x10 },
	'autofocus' => { 102 => 0x6, 147 => 0x209 },
	'autofp' => { 126 => '755.2' },
	'autoiso' => { 30 => 0x1, 53 => 0x3008, 125 => '730.1', 126 => '749.1' },
	'autoisomax' => { 125 => '730.2', 126 => '749.2' },
	'autoisominshutterspeed' => { 125 => '730.3', 126 => '749.3' },
	'autolightingoptimizer' => { 33 => 0x204 },
	'autoredeye' => { 137 => 0xfe28a44f },
	'autorotate' => { 30 => 0x1b },
	'autoshadows' => { 192 => 'AutoShadows' },
	'auxiliarylens' => { 117 => 0x82 },
	'avaperturesetting' => { 164 => 0x13 },
	'avsettingwithoutlens' => { 33 => 0x707 },
	'azimuth' => { 88 => 'Azimuth' },
	'babyage' => { 158 => [0x8010,0x33] },
	'baseexposurecompensation' => { 164 => 0x15 },
	'baseiso' => { 30 => 0x2, 46 => 0x101c },
	'baselineexposure' => { 56 => 0xc62a },
	'baselinenoise' => { 56 => 0xc62b },
	'baselinesharpness' => { 56 => 0xc62c },
	'baseurl' => { 207 => 'BaseURL' },
	'batteryadbodyload' => { 162 => 0x3 },
	'batteryadbodynoload' => { 162 => 0x2 },
	'batteryadgripload' => { 162 => 0x5 },
	'batteryadgripnoload' => { 162 => 0x4 },
	'batteryorder' => { 124 => '802.3' },
	'batterystates' => { 162 => 0x1 },
	'bayergreensplit' => { 56 => 0xc62d },
	'bayerpattern' => { 66 => 0xf902, 98 => 0x17 },
	'beatspliceparamsriseindecibel' => { 209 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 209 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 209 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 209 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 124 => '803.1', 125 => '729.1', 126 => '748.1' },
	'bestqualityscale' => { 56 => 0xc65c },
	'bestshotmode' => { 53 => 0x3007 },
	'bitdepth' => { 85 => 'BitDepth', 98 => 0x11, 122 => 0x41 },
	'bitspercomponent' => { 64 => 0x87 },
	'bitspersample' => { 56 => 0x102, 205 => 'BitsPerSample' },
	'blacklevel' => { 56 => 0xc61a, 149 => 0x1012 },
	'blacklevel2' => { 148 => 0x600, 152 => 0x600 },
	'blackpoint' => { 171 => 0x200 },
	'bluebalance' => { 149 => 0x1018, 159 => 0x12, 171 => 0x1b },
	'bluecurvelimits' => { 50 => 0x1fe },
	'bluecurvepoints' => { 50 => 0x1d4 },
	'bluehue' => { 192 => 'BlueHue' },
	'bluesaturation' => { 192 => 'BlueSaturation' },
	'blurwarning' => { 60 => 0x1300 },
	'bodyfirmwareversion' => { 145 => 0x104, 146 => 0x100, 149 => 0x104 },
	'bracketmode' => { 20 => 0x3 },
	'bracketsequence' => { 53 => 0x301d },
	'bracketshotnumber' => { 20 => 0x5, 164 => 0x9 },
	'bracketstep' => { 93 => 0xe },
	'bracketvalue' => { 20 => 0x4 },
	'brightness' => { 56 => 0xfe53, 79 => 'Brightness', 93 => 0x2c, 119 => 0x34, 192 => 'Brightness' },
	'brightnessadj' => { 50 => 0x114, 130 => 0x0, 140 => 0x2d },
	'brightnessvalue' => { 56 => 0x9203, 149 => 0x1003, 195 => 'BrightnessValue' },
	'bulbduration' => { 30 => 0x18 },
	'burstmode' => { 68 => 0xa, 158 => 0x2a },
	'burstmode2' => { 68 => 0x18 },
	'buttonfunctioncontroloff' => { 33 => 0x70a },
	'bwfilter' => { 93 => 0x2a, 99 => 0x39 },
	'bwmode' => { 149 => 0x203 },
	'by-line' => { 62 => 0x50 },
	'by-linetitle' => { 62 => 0x55 },
	'bytecount' => { 201 => 'byteCount' },
	'calibrationilluminant1' => { 56 => 0xc65a },
	'calibrationilluminant2' => { 56 => 0xc65b },
	'cameracalibrationsig' => { 56 => 0xc6f3 },
	'cameraid' => { 149 => 0x209, 182 => 0x209 },
	'cameraiso' => { 11 => 0x10 },
	'cameraparameters' => { 149 => 0x2050 },
	'cameraprofile' => { 192 => 'CameraProfile' },
	'cameraprofiledigest' => { 192 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 56 => 0xc62f, 189 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 144 => 0x0 },
	'cameratemperature' => { 156 => 0x320, 171 => 0x47 },
	'cameratype' => { 30 => 0x1a, 149 => 0x207 },
	'cameratype2' => { 145 => 0x100 },
	'canonexposuremode' => { 11 => 0x14 },
	'canonfiledescription' => { 46 => 0x805 },
	'canonfilelength' => { 23 => 0xe },
	'canonfirmwareversion' => { 23 => 0x7, 46 => 0x80b },
	'canonflashinfo' => { 46 => 0x1028 },
	'canonflashmode' => { 11 => 0x4 },
	'canonimagesize' => { 3 => 0x39, 11 => 0xa },
	'canonimagetype' => { 23 => 0x6, 46 => 0x815 },
	'canonmodelid' => { 23 => 0x10, 46 => 0x1834 },
	'canonvrd' => { 57 => 'CanonVRD' },
	'caption-abstract' => { 62 => 0x78 },
	'captionwriter' => { 199 => 'CaptionWriter' },
	'casioimagesize' => { 53 => 0x9 },
	'catalogsets' => { 188 => 'CatalogSets' },
	'categories' => { 23 => 0x23 },
	'category' => { 62 => 0xf, 199 => 'Category' },
	'ccdboardversion' => { 156 => 0x331 },
	'ccdscanmode' => { 149 => 0x1039 },
	'ccdsensitivity' => { 127 => 0x6 },
	'ccdversion' => { 156 => 0x330 },
	'celllength' => { 56 => 0x109 },
	'cellwidth' => { 56 => 0x108 },
	'centerafarea' => { 126 => '763.1' },
	'centerweightedareasize' => { 124 => '797.1', 126 => '754.3' },
	'certificate' => { 213 => 'Certificate' },
	'cfapattern' => { 56 => 0xa302 },
	'cfapatterncolumns' => { 195 => 'CFAPatternColumns' },
	'cfapatternrows' => { 195 => 'CFAPatternRows' },
	'cfapatternvalues' => { 195 => 'CFAPatternValues' },
	'channel' => { 201 => 'channel' },
	'channels' => { 78 => 'Channels' },
	'checkmark' => { 50 => 0x26a },
	'childfontfiles' => { 214 => 'FontsChildFontFiles' },
	'chromablurradius' => { 56 => 0xc631 },
	'chromaticaberrationb' => { 192 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 192 => 'ChromaticAberrationR' },
	'chrominancenoisereduction' => { 51 => 0xbc },
	'chrominancenr_tiff_jpeg' => { 51 => 0xc0 },
	'city' => { 62 => 0x5a, 84 => 'City', 199 => 'City' },
	'clarity' => { 192 => 'Clarity' },
	'classifystate' => { 62 => 0xe1 },
	'clmodeshootingspeed' => { 124 => '800.2' },
	'cmcontrast' => { 152 => 0x2022 },
	'cmexposurecompensation' => { 152 => 0x2000 },
	'cmhue' => { 152 => 0x2021 },
	'cmsaturation' => { 152 => 0x2020 },
	'cmsharpness' => { 152 => 0x2023 },
	'cmwhitebalance' => { 152 => 0x2001 },
	'cmwhitebalancecomp' => { 152 => 0x2002 },
	'cmwhitebalancegraypoint' => { 152 => 0x2010 },
	'codec' => { 92 => 'Codec' },
	'codedcharacterset' => { 63 => 0x5a },
	'coloraberrationcontrol' => { 137 => 0xc89224b },
	'coloradjustment' => { 183 => 0x14 },
	'coloradjustmentmode' => { 182 => 0x210 },
	'coloranta' => { 214 => 'ColorantsA' },
	'colorantb' => { 214 => 'ColorantsB' },
	'colorantblack' => { 214 => 'ColorantsBlack' },
	'colorantblue' => { 214 => 'ColorantsBlue' },
	'colorantcyan' => { 214 => 'ColorantsCyan' },
	'colorantgreen' => { 214 => 'ColorantsGreen' },
	'colorantl' => { 214 => 'ColorantsL' },
	'colorantmagenta' => { 214 => 'ColorantsMagenta' },
	'colorantmode' => { 214 => 'ColorantsMode' },
	'colorantred' => { 214 => 'ColorantsRed' },
	'colorantswatchname' => { 214 => 'ColorantsSwatchName' },
	'coloranttype' => { 214 => 'ColorantsType' },
	'colorantyellow' => { 214 => 'ColorantsYellow' },
	'colorbalance' => { 79 => 'ColorBalance' },
	'colorbalance1' => { 117 => 0xc },
	'colorbalanceadj' => { 137 => 0x76a43202 },
	'colorbalanceblue' => { 93 => 0x1e },
	'colorbalancegreen' => { 93 => 0x1d },
	'colorbalancered' => { 93 => 0x1c },
	'colorbooster' => { 137 => 0x5f0e7d23 },
	'colorboostlevel' => { 131 => 0x1 },
	'colorboosttype' => { 131 => 0x0 },
	'colorclass' => { 174 => 0xde },
	'colorcontrol' => { 149 => 0x102b },
	'coloreffect' => { 158 => 0x28 },
	'colorfilter' => { 52 => 0x17, 93 => 0x29, 99 => 0x38, 173 => 0x17 },
	'colorgain' => { 122 => 0x51 },
	'colorhue' => { 117 => 0x8d },
	'colorimetricreference' => { 56 => 0xc6bf },
	'colormatrix' => { 148 => 0x200, 149 => 0x1011 },
	'colormatrix2' => { 152 => 0x200 },
	'colormatrixa' => { 171 => 0x203 },
	'colormatrixb' => { 171 => 0x204 },
	'colormatrixnumber' => { 149 => 0x1019 },
	'colormode' => { 53 => 0x3015, 60 => 0x1210, 68 => 0x66, 93 => 0x28, 96 => 0x16, 97 => 0x101, 99 => 0x7, 117 => 0x3, 127 => 0x4, 149 => 0x101, 158 => 0x32, 184 => 0xb029, 199 => 'ColorMode' },
	'colormoirereduction' => { 138 => 0x15 },
	'colormoirereductionmode' => { 138 => 0x5 },
	'colornoisereduction' => { 192 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 138 => 0x18 },
	'colornoisereductionsharpness' => { 138 => 0x1c },
	'colorplanes' => { 59 => 0x2 },
	'colorprofile' => { 93 => 0x33 },
	'colorrepresentation' => { 64 => 0x3c },
	'colorreproduction' => { 184 => 0xb020 },
	'colorsequence' => { 64 => 0x41 },
	'colorspace' => { 17 => 0x3, 23 => 0xb4, 46 => 0x10b4, 56 => 0xa001, 85 => 'ColorSpace', 94 => 0x2f, 95 => 0x25, 117 => 0x1e, 144 => 0x507, 171 => 0x37, 183 => 0xb, 195 => 'ColorSpace' },
	'colortempasshot' => { 13 => 0x1d, 14 => 0x1c, 15 => 0x43, 16 => 0x43 },
	'colortempauto' => { 13 => 0x22, 14 => 0x26, 15 => 0x48, 16 => 0x48 },
	'colortempcloudy' => { 13 => 0x31, 14 => 0x35, 15 => 0x5c, 16 => 0x61 },
	'colortempcustom' => { 15 => 0x84 },
	'colortempcustom1' => { 13 => 0x45 },
	'colortempcustom2' => { 13 => 0x4a },
	'colortempdaylight' => { 13 => 0x27, 14 => 0x2b, 15 => 0x52, 16 => 0x57 },
	'colortemperature' => { 1 => 0x73, 2 => [0x48,0x4e], 3 => 0x37, 4 => 0x62, 5 => 0x37, 6 => 0x73, 7 => 0x73, 8 => 0x73, 9 => 0x58, 23 => 0xae, 28 => 0x9, 46 => 0x10ae, 60 => 0x1005, 67 => 0x846, 79 => 'ColorTemperature', 94 => [0x6e,0x49], 95 => 0x3f, 96 => 0x5e, 97 => 0x10b, 99 => 0x3c, 156 => 0x321, 171 => 0x50, 184 => 0xb021 },
	'colortemperaturebg' => { 149 => 0x1013 },
	'colortemperaturerg' => { 149 => 0x1014 },
	'colortempflash' => { 13 => 0x40, 14 => 0x49, 15 => 0x70, 16 => 0x75 },
	'colortempfluorescent' => { 13 => 0x3b, 14 => 0x3f, 15 => 0x66, 16 => 0x6b },
	'colortempkelvin' => { 14 => 0x44, 15 => 0x6b, 16 => 0x70 },
	'colortempmeasured' => { 15 => 0x4d, 16 => 0x4d },
	'colortemppc1' => { 14 => 0x94, 15 => 0x75 },
	'colortemppc2' => { 14 => 0x99, 15 => 0x7a },
	'colortemppc3' => { 14 => 0x9e, 15 => 0x7f },
	'colortempshade' => { 13 => 0x2c, 14 => 0x30, 15 => 0x57, 16 => 0x5c },
	'colortemptungsten' => { 13 => 0x36, 14 => 0x3a, 15 => 0x61, 16 => 0x66 },
	'colortempunknown' => { 14 => 0x21 },
	'colortempunknown10' => { 14 => 0x76, 16 => 0xa2 },
	'colortempunknown11' => { 14 => 0x7b, 16 => 0xa7 },
	'colortempunknown12' => { 14 => 0x80 },
	'colortempunknown13' => { 14 => 0x85 },
	'colortempunknown14' => { 14 => 0x8a },
	'colortempunknown15' => { 14 => 0x8f },
	'colortempunknown16' => { 14 => 0xa3 },
	'colortempunknown2' => { 14 => 0x4e, 16 => 0x7a },
	'colortempunknown3' => { 14 => 0x53, 16 => 0x7f },
	'colortempunknown4' => { 14 => 0x58, 16 => 0x84 },
	'colortempunknown5' => { 14 => 0x5d, 16 => 0x89 },
	'colortempunknown6' => { 14 => 0x62, 16 => 0x8e },
	'colortempunknown7' => { 14 => 0x67, 16 => 0x93 },
	'colortempunknown8' => { 14 => 0x6c, 16 => 0x98 },
	'colortempunknown9' => { 14 => 0x71, 16 => 0x9d },
	'colortone' => { 3 => 0x6f, 5 => 0x77, 11 => 0x2a, 17 => 0x2 },
	'colortoneadj' => { 50 => 0x11e },
	'colortonefaithful' => { 9 => 0x107 },
	'colortonelandscape' => { 9 => 0x105 },
	'colortoneneutral' => { 9 => 0x106 },
	'colortoneportrait' => { 9 => 0x104 },
	'colortonestandard' => { 9 => 0x103 },
	'colortoneuserdef1' => { 9 => 0x109 },
	'colortoneuserdef2' => { 9 => 0x10a },
	'colortoneuserdef3' => { 9 => 0x10b },
	'commanddials' => { 126 => '753.1' },
	'commanddialsaperturesetting' => { 124 => '807.3' },
	'commanddialschangemainsub' => { 124 => '807.2' },
	'commanddialsmenuandplayback' => { 124 => '807.4' },
	'commanddialsreverserotation' => { 124 => '807.1' },
	'commanderchannel' => { 126 => '758.2' },
	'commandergroupa_manualoutput' => { 126 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 126 => '761.1' },
	'commandergroupamode' => { 126 => '759.2' },
	'commandergroupb_manualoutput' => { 126 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 126 => '762.1' },
	'commandergroupbmode' => { 126 => '759.3' },
	'commanderinternalflash' => { 126 => '759.1' },
	'commanderinternalmanualoutput' => { 126 => '760.2' },
	'commanderinternalttlcomp' => { 126 => '760.1' },
	'comment' => { 0 => 0x2, 57 => 'Comment', 80 => 'Comment', 155 => 'Comment' },
	'complianceprofile' => { 201 => 'complianceProfile' },
	'componentsconfiguration' => { 56 => 0x9101, 85 => 'Components', 195 => 'ComponentsConfiguration' },
	'componentversion' => { 46 => 0x80c },
	'composer' => { 209 => 'composer' },
	'compressedbitsperpixel' => { 56 => 0x9102, 195 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 97 => 0x40, 149 => 0x40 },
	'compression' => { 56 => 0x103, 205 => 'Compression' },
	'compressionfactor' => { 144 => 0x50d },
	'compressionratio' => { 85 => 'Compression', 149 => 0x1034 },
	'constrainedcropheight' => { 50 => 0x266, 174 => 0xd6 },
	'constrainedcropwidth' => { 50 => 0x262, 174 => 0xd5 },
	'contact' => { 62 => 0x76 },
	'contentlocationcode' => { 62 => 0x1a },
	'contentlocationname' => { 62 => 0x1b },
	'continuousdrive' => { 11 => 0x5 },
	'continuousshootingspeed' => { 33 => 0x610 },
	'continuousshotlimit' => { 33 => 0x611 },
	'contrast' => { 3 => 0x73, 5 => 0x75, 11 => 0xd, 52 => 0xc, 53 => [0x3012,0x20], 56 => [0xa408,0xfe54], 60 => [0x1004,0x1006], 79 => 'Contrast', 93 => 0x20, 94 => 0x31, 95 => 0x27, 96 => 0x19, 99 => 0x2, 119 => 0x33, 149 => 0x1029, 158 => [0x2c,0x39], 171 => 0x20, 173 => 0xc, 183 => 0xd, 192 => 'Contrast', 195 => 'Contrast' },
	'contrastadj' => { 50 => 0x115, 140 => 0x2c },
	'contrastfaithful' => { 9 => 0xec },
	'contrastlandscape' => { 9 => 0xea },
	'contrastmonochrome' => { 9 => 0xed },
	'contrastneutral' => { 9 => 0xeb },
	'contrastportrait' => { 9 => 0xe9 },
	'contrastsetting' => { 144 => 0x505, 152 => 0x1012 },
	'contraststandard' => { 9 => 0xe8 },
	'contrastuserdef1' => { 9 => 0xee },
	'contrastuserdef2' => { 9 => 0xef },
	'contrastuserdef3' => { 9 => 0xf0 },
	'contributedmediadurationscale' => { 209 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 209 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 209 => 'contributedMediaManaged' },
	'contributedmediapath' => { 209 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 209 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 209 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 209 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 209 => 'contributedMediaWebStatement' },
	'contributor' => { 193 => 'contributor' },
	'contributors' => { 80 => 'Contributors' },
	'controlledvocabularyterm' => { 197 => 'CVterm' },
	'controllerboardversion' => { 156 => 0x332 },
	'controlmode' => { 30 => 0x12 },
	'conversionlens' => { 158 => 0x35 },
	'converter' => { 56 => 0xfe4d, 127 => 0xb },
	'converttograyscale' => { 192 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 56 => 0x8298, 80 => 'Copyright', 155 => 'Copyright', 179 => 'Copyright', 198 => 'Copyright', 201 => 'copyright', 203 => 'copyright', 205 => 'Copyright', 209 => 'copyright' },
	'copyrightflag' => { 177 => 0x40a },
	'copyrightnotice' => { 62 => 0x74 },
	'copyrightownerid' => { 200 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 200 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 200 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 200 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 200 => 'CopyrightStatus' },
	'coringfilter' => { 148 => 0x310, 149 => 0x102d, 152 => 0x310 },
	'coringvalues' => { 148 => 0x311, 152 => 0x311 },
	'corporateentity' => { 201 => 'corporateEntity' },
	'country' => { 84 => 'Country', 199 => 'Country' },
	'country-primarylocationcode' => { 62 => 0x64 },
	'country-primarylocationname' => { 62 => 0x65 },
	'countrycode' => { 175 => 'CountryCode', 196 => 'CountryCode' },
	'coverage' => { 193 => 'coverage' },
	'coverdate' => { 201 => 'coverDate' },
	'coverdisplaydate' => { 201 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 171 => 0x28 },
	'crc32' => { 194 => 'crc32' },
	'createdate' => { 56 => 0x9004, 80 => 'CreateDate', 153 => 'CreationDate', 179 => 'CreationDate', 207 => 'CreateDate' },
	'creationdate' => { 198 => 'CreationDate', 201 => 'creationDate' },
	'creationtime' => { 155 => 'Creation Time' },
	'creator' => { 153 => 'Creator', 179 => 'Creator', 193 => 'creator', 198 => 'Creator' },
	'creatoraddress' => { 196 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 196 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 196 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 196 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 196 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 207 => 'CreatorTool' },
	'creatorworkemail' => { 196 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 196 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 196 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 62 => 0x6e, 199 => 'Credit' },
	'creditline' => { 203 => 'creditLine' },
	'creditlinereq' => { 212 => 'CreditLineReq' },
	'creditlinerequired' => { 200 => 'CreditLineRequired' },
	'cropactive' => { 50 => 0x244 },
	'cropangle' => { 192 => 'CropAngle' },
	'cropaspectratio' => { 50 => 0x260 },
	'cropbottom' => { 59 => 0x9, 132 => 0x36, 174 => 0xdc, 192 => 'CropBottom' },
	'cropheight' => { 50 => 0x24c, 148 => 0x615, 152 => 0x615, 192 => 'CropHeight' },
	'crophispeed' => { 117 => 0x1b },
	'cropleft' => { 50 => 0x246, 59 => 0x6, 132 => 0x1e, 148 => 0x612, 152 => 0x612, 174 => 0xd9, 192 => 'CropLeft' },
	'cropoutputheight' => { 132 => 0xce },
	'cropoutputheightinches' => { 132 => 0x96 },
	'cropoutputpixels' => { 132 => 0xd6 },
	'cropoutputresolution' => { 132 => 0xb6 },
	'cropoutputscale' => { 132 => 0xbe },
	'cropoutputwidth' => { 132 => 0xc6 },
	'cropoutputwidthinches' => { 132 => 0x8e },
	'cropright' => { 59 => 0x8, 132 => 0x2e, 174 => 0xdb, 192 => 'CropRight' },
	'croprotation' => { 59 => 0xb },
	'cropscaledresolution' => { 132 => 0x9e },
	'cropsourceresolution' => { 132 => 0xae },
	'croptop' => { 50 => 0x248, 59 => 0x7, 132 => 0x26, 148 => 0x613, 152 => 0x613, 174 => 0xda, 192 => 'CropTop' },
	'cropunit' => { 192 => 'CropUnit' },
	'cropunits' => { 192 => 'CropUnits' },
	'cropwidth' => { 50 => 0x24a, 148 => 0x614, 152 => 0x614, 192 => 'CropWidth' },
	'currenticcprofile' => { 56 => 0xc691 },
	'currentpreprofilematrix' => { 56 => 0xc692 },
	'curves' => { 137 => 0x76a43201 },
	'custom1' => { 200 => 'Custom1' },
	'custom10' => { 200 => 'Custom10' },
	'custom2' => { 200 => 'Custom2' },
	'custom3' => { 200 => 'Custom3' },
	'custom4' => { 200 => 'Custom4' },
	'custom5' => { 200 => 'Custom5' },
	'custom6' => { 200 => 'Custom6' },
	'custom7' => { 200 => 'Custom7' },
	'custom8' => { 200 => 'Custom8' },
	'custom9' => { 200 => 'Custom9' },
	'customrendered' => { 56 => 0xa401, 195 => 'CustomRendered' },
	'customsaturation' => { 144 => 0x503 },
	'd-lightinghq' => { 137 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 133 => 0x2 },
	'd-lightinghqhighlight' => { 133 => 0x1 },
	'd-lightinghqselected' => { 137 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 133 => 0x0 },
	'd-lightinghs' => { 137 => 0xce5554aa },
	'd-lightinghsadjustment' => { 134 => 0x0 },
	'd-lightinghscolorboost' => { 134 => 0x1 },
	'datacompressionmethod' => { 64 => 0x6e },
	'dataimprint' => { 93 => 0x34 },
	'date' => { 171 => 0x6, 193 => 'date' },
	'dateacquired' => { 189 => 'DateAcquired' },
	'datecreated' => { 62 => 0x37, 199 => 'DateCreated' },
	'dateformat' => { 129 => 0x3 },
	'daterecieved' => { 201 => 'dateRecieved' },
	'datesent' => { 63 => 0x46 },
	'datestampmode' => { 23 => 0x1c },
	'datetime' => { 205 => 'DateTime' },
	'datetimedigitized' => { 195 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 49 => 0x0, 56 => 0x9003, 80 => 'OriginalDate', 195 => 'DateTimeOriginal' },
	'datetimestamp' => { 68 => 0x64 },
	'daylightsavings' => { 129 => 0x2 },
	'declination' => { 88 => 'Declination' },
	'decposition' => { 93 => 0x32 },
	'defaultcroporigin' => { 56 => 0xc61f },
	'defaultcropsize' => { 56 => 0xc620 },
	'defaultscale' => { 56 => 0xc61e },
	'defringe' => { 192 => 'Defringe' },
	'deletedimagecount' => { 117 => 0xa6, 123 => 0x6e },
	'derivedfromalternatepaths' => { 210 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 210 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 210 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 210 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 210 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 210 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 210 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 210 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 210 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 210 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 210 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 210 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 210 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 210 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 210 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 210 => 'DerivedFromVersionID' },
	'description' => { 155 => 'Description', 193 => 'description' },
	'destination' => { 63 => 0x5 },
	'destinationcity' => { 171 => 0x24 },
	'destinationcitycode' => { 173 => 0x1001 },
	'destinationdst' => { 171 => 0x26 },
	'developmentdynamicrange' => { 60 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 195 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 195 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 195 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 33 => 0x706 },
	'digitalcreationdate' => { 62 => 0x3e },
	'digitalcreationtime' => { 62 => 0x3f },
	'digitalgain' => { 28 => 0xb },
	'digitalgem' => { 112 => 0x0 },
	'digitalice' => { 122 => 0x100 },
	'digitalimageguid' => { 197 => 'DigImageGUID' },
	'digitalroc' => { 121 => 0x0 },
	'digitalsourcefiletype' => { 197 => 'DigitalSourcefileType' },
	'digitalzoom' => { 11 => 0xc, 52 => 0xa, 68 => 0x68, 79 => 'DigitalZoom', 93 => 0xc, 117 => 0x86, 127 => 0xa, 149 => 0x204, 171 => 0x1e, 173 => 0xa, 182 => 0x204 },
	'digitalzoomon' => { 182 => 0x21b },
	'digitalzoomratio' => { 56 => 0xa404, 195 => 'DigitalZoomRatio' },
	'directory' => { 57 => 'Directory' },
	'directoryindex' => { 1 => 0x137, 4 => 0x17e, 6 => 0x13f, 7 => 0x133 },
	'directorynumber' => { 108 => 0x6 },
	'disclaimer' => { 155 => 'Disclaimer' },
	'displayaperture' => { 11 => 0x23 },
	'displayedunitsx' => { 178 => 0x2 },
	'displayedunitsy' => { 178 => 0x6 },
	'distance1' => { 68 => 0x28 },
	'distance2' => { 68 => 0x2c },
	'distance3' => { 68 => 0x30 },
	'distance4' => { 68 => 0x34 },
	'distortioncorrection' => { 144 => 0x50b },
	'distortioncorrection2' => { 148 => 0x1011 },
	'distributor' => { 201 => 'distributor' },
	'dngbackwardversion' => { 56 => 0xc613 },
	'dnglensinfo' => { 56 => 0xc630 },
	'dngversion' => { 56 => 0xc612 },
	'document' => { 155 => 'Document' },
	'documenthistory' => { 62 => 0xe7 },
	'documentid' => { 210 => 'DocumentID' },
	'documentname' => { 56 => 0x10d },
	'documentnotes' => { 62 => 0xe6 },
	'doi' => { 201 => 'doi' },
	'dotrange' => { 56 => 0x150 },
	'drivemode' => { 93 => 0x6, 96 => 0x1e, 144 => 0x600, 171 => 0x34, 183 => 0x3 },
	'drivemode2' => { 164 => 0x7 },
	'dspfirmwareversion' => { 171 => 0x27 },
	'duration' => { 78 => 'Duration', 92 => 'Duration' },
	'durationscale' => { 209 => 'durationScale' },
	'durationvalue' => { 209 => 'durationValue' },
	'dynamicafarea' => { 124 => '791.4' },
	'dynamicrange' => { 60 => 0x1400 },
	'dynamicrangeexpansion' => { 171 => 0x69 },
	'dynamicrangemax' => { 50 => 0x7c },
	'dynamicrangemin' => { 50 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0xb025 },
	'dynamicrangesetting' => { 60 => 0x1402 },
	'e-dialinprogram' => { 164 => '1.3' },
	'easyexposurecompensation' => { 124 => '796.4' },
	'easymode' => { 11 => 0xb },
	'edgenoisereduction' => { 138 => 0x4 },
	'edition' => { 201 => 'edition' },
	'editorialupdate' => { 62 => 0x8 },
	'editstatus' => { 62 => 0x7, 175 => 'EditStatus' },
	'effectivelv' => { 171 => 0x2d },
	'effectivemaxaperture' => { 115 => 0x12, 116 => 0x13 },
	'eissn' => { 201 => 'eIssn' },
	'elevation' => { 88 => 'Elevation' },
	'email' => { 80 => 'EMail' },
	'embargodate' => { 201 => 'embargoDate', 203 => 'embargoDate' },
	'endingpage' => { 201 => 'endingPage' },
	'enduserid' => { 200 => 'EndUserEndUserID' },
	'endusername' => { 200 => 'EndUserEndUserName' },
	'engineer' => { 209 => 'engineer' },
	'enhancedarktones' => { 130 => 0x8 },
	'enhancement' => { 52 => 0x16, 53 => 0x3016 },
	'enhancer' => { 148 => 0x300 },
	'enhancervalues' => { 148 => 0x301 },
	'envelopenumber' => { 63 => 0x28 },
	'envelopepriority' => { 63 => 0x3c },
	'enveloperecordversion' => { 63 => 0x0 },
	'epsonimageheight' => { 149 => 0x20c },
	'epsonimagewidth' => { 149 => 0x20b },
	'epsonsoftware' => { 149 => 0x20d },
	'equipmentinstitution' => { 186 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 186 => 'EquipmentManufacturer' },
	'equipmentversion' => { 145 => 0x0 },
	'ettlii' => { 33 => 0x304, 34 => 0xd, 35 => 0xe, 36 => 0x7, 37 => 0x7, 38 => 0xe },
	'event' => { 188 => 'Event', 197 => 'Event', 201 => 'event' },
	'evsteps' => { 164 => '1.2', 166 => 0x0 },
	'evstepsize' => { 126 => '748.7' },
	'exclusivityenddate' => { 203 => 'exclusivityEndDate' },
	'excursiontolerance' => { 64 => 0x82 },
	'exifbyteorder' => { 57 => 'ExifByteOrder' },
	'exifcamerainfo' => { 62 => 0xe8 },
	'exifimageheight' => { 56 => 0xa003, 195 => 'PixelYDimension' },
	'exifimagewidth' => { 56 => 0xa002, 195 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 57 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 56 => 0x9000, 195 => 'ExifVersion' },
	'exitpupilposition' => { 115 => 0x4, 116 => 0x4 },
	'expirationdate' => { 62 => 0x25, 201 => 'expirationDate', 203 => 'expirationDate' },
	'expirationtime' => { 62 => 0x26 },
	'exposure' => { 56 => 0xfe51, 192 => 'Exposure' },
	'exposureadj' => { 135 => 0x0 },
	'exposureadj2' => { 135 => 0x12 },
	'exposurebracketstepsize' => { 164 => 0x8 },
	'exposurebracketvalue' => { 117 => 0x19 },
	'exposurecompensation' => { 30 => 0x6, 42 => 0x0, 56 => 0x9204, 68 => 0x24, 79 => 'ExposureComp', 93 => 0xd, 94 => 0x53, 95 => 0x1e, 96 => 0x1, 149 => 0x1006, 171 => 0x16, 183 => [0xc,0x35], 195 => 'ExposureBiasValue' },
	'exposurecontrolstepsize' => { 124 => '796.2' },
	'exposuredelaymode' => { 124 => '800.1', 126 => '754.4' },
	'exposuredifference' => { 117 => 0xe },
	'exposureindex' => { 56 => 0xa215, 195 => 'ExposureIndex' },
	'exposurelevelincrements' => { 31 => 0x6, 32 => 0x6, 33 => 0x101, 34 => 0x5, 35 => 0x6, 36 => 0x5, 37 => 0x5, 38 => 0x6, 39 => 0x4 },
	'exposuremode' => { 56 => 0xa402, 79 => 'ExposureMode', 93 => 0x1, 94 => 0xa, 95 => 0x0, 96 => 0x0, 144 => 0x200, 183 => 0x8, 184 => 0xb041, 195 => 'ExposureMode' },
	'exposuremodeinmanual' => { 33 => 0x10b },
	'exposureprogram' => { 56 => 0x8822, 195 => 'ExposureProgram' },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 9 => 0x4, 10 => 0x6, 30 => 0x16, 56 => 0x829a, 66 => 0xfd05, 68 => 0x20, 69 => 0xfa24, 71 => 0xf104, 75 => 0x38, 79 => 'ExposureTime', 93 => 0x9, 94 => 0x35, 95 => 0x48, 171 => 0x12, 183 => 0x32, 195 => 'ExposureTime' },
	'exposuretime2' => { 183 => 0x33 },
	'exposurevalue' => { 67 => 0x3 },
	'exposurewarning' => { 60 => 0x1302 },
	'extendedwbdetect' => { 144 => 0x902 },
	'extender' => { 145 => 0x301 },
	'extenderfirmwareversion' => { 145 => 0x304 },
	'extendermagnification' => { 81 => 'Magnification' },
	'extendermake' => { 81 => 'Make' },
	'extendermodel' => { 81 => 'Model', 145 => 0x303 },
	'extenderserialnumber' => { 81 => 'SerialNumber', 145 => 0x302 },
	'externalflash' => { 147 => 0x1201 },
	'externalflashae1' => { 149 => 0x101f },
	'externalflashae1_0' => { 149 => 0x101b },
	'externalflashae2' => { 149 => 0x1020 },
	'externalflashae2_0' => { 149 => 0x101c },
	'externalflashbounce' => { 147 => 0x1204, 149 => 0x1026, 167 => 0x1a },
	'externalflashexposurecomp' => { 167 => 0x19 },
	'externalflashflags' => { 109 => 0x8, 110 => 0x8, 111 => 0x8 },
	'externalflashguidenumber' => { 147 => 0x1203, 167 => '24.1' },
	'externalflashgvalue' => { 149 => 0x1025 },
	'externalflashmode' => { 149 => 0x1028, 167 => 0x2 },
	'externalflashzoom' => { 147 => 0x1205, 149 => 0x1027 },
	'externalsensorbrightnessvalue' => { 156 => 0x311 },
	'face0position' => { 18 => 0x8 },
	'face1position' => { 18 => 0xa },
	'face2position' => { 18 => 0xc },
	'face3position' => { 18 => 0xe },
	'face4position' => { 18 => 0x10 },
	'face5position' => { 18 => 0x12 },
	'face6position' => { 18 => 0x14 },
	'face7position' => { 18 => 0x16 },
	'face8position' => { 18 => 0x18 },
	'facedetect' => { 148 => 0x1200 },
	'facedetectarea' => { 148 => 0x1201 },
	'facedetectframeheight' => { 18 => 0x4 },
	'facedetectframewidth' => { 18 => 0x3 },
	'facesdetected' => { 18 => 0x2, 19 => 0x2 },
	'ffid' => { 194 => 'ffid' },
	'fieldcount' => { 149 => 0x103f },
	'filedatarate' => { 209 => 'fileDataRate' },
	'fileformat' => { 44 => 0x0, 63 => 0x14 },
	'fileindex' => { 1 => 0x143, 4 => 0x172, 6 => 0x133, 7 => 0x13f },
	'filemodifydate' => { 57 => 'FileModifyDate' },
	'filename' => { 57 => 'FileName' },
	'filenameasdelivered' => { 200 => 'FileNameAsDelivered' },
	'filenumber' => { 20 => 0x1, 23 => 0x8, 46 => 0x1817, 108 => 0x8 },
	'filenumbermemory' => { 93 => 0x1a },
	'filenumbersequence' => { 124 => '802.2' },
	'filesource' => { 56 => 0xa300, 60 => 0x8000, 195 => 'FileSource' },
	'fileversion' => { 63 => 0x16 },
	'fillflashautoreduction' => { 31 => 0xe, 32 => 0xe, 39 => 0xa },
	'filllight' => { 192 => 'FillLight' },
	'fillorder' => { 56 => 0x10a },
	'filmmode' => { 60 => 0x1401, 158 => 0x42 },
	'filmtype' => { 122 => 0x2 },
	'filter' => { 53 => 0x3017 },
	'filtereffect' => { 20 => 0xe, 119 => 0x37 },
	'filtereffectmonochrome' => { 9 => 0xff },
	'finderdisplayduringexposure' => { 32 => 0x1 },
	'finetuneoptcenterweighted' => { 124 => '797.2' },
	'finetuneoptmatrixmetering' => { 124 => '798.1' },
	'finetuneoptspotmetering' => { 124 => '798.2' },
	'finetunestepsize' => { 124 => '796.3' },
	'firmware' => { 149 => 0x405, 183 => [0x17,0x3b], 190 => 'Firmware' },
	'firmwaredate' => { 52 => 0x15, 53 => 0x2001 },
	'firmwareid' => { 98 => 0x0 },
	'firmwarerevision' => { 9 => 0xa4, 23 => 0x1e },
	'firmwareversion' => { 1 => 0x10b, 4 => 0x136, 6 => 0xff, 7 => 0x107, 67 => 0xce5, 79 => 'FirmwareVersion', 158 => 0x2 },
	'firstpublicationdate' => { 200 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 62 => 0x16 },
	'flash' => { 56 => 0x9209, 94 => 0x1f, 95 => 0x15 },
	'flashactivity' => { 11 => 0x1c },
	'flashbias' => { 158 => 0x24 },
	'flashbits' => { 11 => 0x1d },
	'flashchargelevel' => { 149 => 0x1010 },
	'flashcommandermode' => { 109 => '9.1', 110 => '9.1', 111 => '9.1' },
	'flashcompensation' => { 190 => 'FlashCompensation' },
	'flashcontrolmode' => { 109 => '9.2', 110 => '9.2', 111 => '9.2' },
	'flashdevice' => { 149 => 0x1005 },
	'flashdistance' => { 53 => 0x2034 },
	'flashenergy' => { 56 => 0xa20b, 195 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 117 => 0x18 },
	'flashexposurecomp' => { 30 => 0xf, 60 => 0x1011, 82 => 'ExposureComp', 93 => 0x23, 97 => 0x104, 109 => 0xa, 110 => 0xa, 111 => 0xa, 117 => 0x12, 144 => 0x401, 149 => 0x1023, 171 => 0x4d, 183 => 0x3a, 184 => 0x104 },
	'flashexposurecompset' => { 160 => 0xe },
	'flashfired' => { 68 => 0x5d, 82 => 'Fired', 93 => 0x14, 126 => '590.3', 195 => 'FlashFired' },
	'flashfiring' => { 33 => 0x306, 34 => 0x6, 35 => 0x7, 38 => 0x7 },
	'flashfirmwareversion' => { 145 => 0x1002 },
	'flashfocallength' => { 109 => 0xb, 110 => 0xc },
	'flashfunction' => { 195 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 109 => 0xf, 110 => '16.1', 111 => '17.1' },
	'flashgroupaexposurecomp' => { 109 => 0x11, 110 => 0x12, 111 => 0x13 },
	'flashgroupaoutput' => { 109 => 0x11, 110 => 0x12, 111 => 0x13 },
	'flashgroupbcontrolmode' => { 109 => 0x10, 110 => '17.1', 111 => '18.1' },
	'flashgroupbexposurecomp' => { 109 => 0x12, 110 => 0x13, 111 => 0x14 },
	'flashgroupboutput' => { 109 => 0x12, 110 => 0x13, 111 => 0x14 },
	'flashgroupccontrolmode' => { 110 => '17.2', 111 => '18.2' },
	'flashgroupcexposurecomp' => { 110 => 0x14, 111 => 0x15 },
	'flashgroupcoutput' => { 110 => 0x14, 111 => 0x15 },
	'flashguidenumber' => { 30 => 0xd, 43 => 0x0, 82 => 'GuideNumber' },
	'flashintensity' => { 52 => [0x19,0x5] },
	'flashlevel' => { 125 => 0x2e2 },
	'flashmake' => { 82 => 'Make' },
	'flashmanufacturer' => { 189 => 'FlashManufacturer' },
	'flashmetering' => { 93 => 0x3f },
	'flashmeteringsegments' => { 171 => 0x20a },
	'flashmode' => { 52 => 0x4, 68 => 0x5c, 82 => 'Mode', 93 => 0x2, 94 => 0x20, 95 => 0x16, 117 => 0x87, 144 => 0x400, 149 => 0x1004, 171 => 0xc, 173 => 0x4, 180 => 0x20, 182 => 0x225, 195 => 'FlashMode' },
	'flashmodel' => { 82 => 'Model', 109 => 0x4, 110 => 0x4, 111 => 0x4, 145 => 0x1001, 189 => 'FlashModel' },
	'flashoptions' => { 164 => 0x2 },
	'flashoptions2' => { 164 => 0x10 },
	'flashoutput' => { 30 => 0x21, 109 => 0xa, 110 => 0xa, 111 => 0xa },
	'flashpixversion' => { 56 => 0xa000, 195 => 'FlashpixVersion' },
	'flashredeyemode' => { 195 => 'FlashRedEyeMode' },
	'flashreturn' => { 195 => 'FlashReturn' },
	'flashserialnumber' => { 82 => 'SerialNumber', 145 => 0x1003 },
	'flashsetting' => { 117 => 0x8 },
	'flashshutterspeed' => { 124 => '810.2', 126 => '755.1' },
	'flashstatus' => { 167 => 0x0 },
	'flashsyncspeed' => { 124 => '810.1' },
	'flashsyncspeedav' => { 31 => 0x3, 33 => 0x10f, 34 => 0x2, 35 => 0x3, 36 => 0x2, 37 => 0x2, 38 => 0x3, 39 => 0x6 },
	'flashthreshold' => { 43 => 0x1 },
	'flashtype' => { 82 => 'Type', 117 => 0x9, 145 => 0x1000 },
	'flickerreduce' => { 182 => 0x218 },
	'fliphorizontal' => { 137 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 9 => 0x3, 10 => 0x5, 30 => 0x15, 56 => 0x829d, 66 => 0xfd04, 68 => 0x1e, 69 => 0xfa23, 71 => 0xf103, 75 => 0x3c, 86 => 'FNumber', 93 => 0xa, 94 => 0x36, 95 => 0x47, 171 => 0x13, 183 => 0x31, 195 => 'FNumber' },
	'focallength' => { 1 => 0x1d, 2 => 0xa, 3 => 0x9, 4 => 0x1d, 5 => 0x9, 6 => 0x1d, 7 => 0x1d, 9 => 0x28, 22 => 0x1, 53 => 0x1d, 56 => 0x920a, 86 => 'FocalLength', 93 => 0x12, 115 => 0xa, 116 => 0xb, 168 => 0x9, 171 => 0x1d, 195 => 'FocalLength' },
	'focallengthin35mmformat' => { 56 => 0xa405, 195 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 145 => 0x103, 149 => 0x205 },
	'focalplaneresolutionunit' => { 56 => 0xa210, 195 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 56 => 0xa20e, 195 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 22 => 0x2 },
	'focalplanexunknown' => { 22 => 0x2 },
	'focalplaneyresolution' => { 56 => 0xa20f, 195 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 22 => 0x3 },
	'focalplaneyunknown' => { 22 => 0x3 },
	'focaltype' => { 3 => 0x2d, 22 => 0x0 },
	'focalunits' => { 11 => 0x19 },
	'focus' => { 127 => 0x8 },
	'focusarea' => { 93 => 0x31 },
	'focusareaselection' => { 126 => '763.2' },
	'focuscontinuous' => { 11 => 0x20 },
	'focusdistance' => { 86 => 'FocusDistance', 93 => 0x13, 115 => 0x9, 116 => 0xa, 147 => 0x305 },
	'focusdistancelower' => { 1 => 0x45, 4 => 0x45, 6 => 0x45, 7 => 0x45, 8 => 0x52, 30 => 0x14 },
	'focusdistanceupper' => { 1 => 0x43, 4 => 0x43, 6 => 0x43, 7 => 0x43, 8 => 0x50, 30 => 0x13 },
	'focusinfoversion' => { 147 => 0x0 },
	'focusingscreen' => { 32 => 0x0, 33 => 0x80b, 38 => 0x0 },
	'focusmode' => { 11 => 0x7, 52 => 0x3, 53 => [0x3003,0xd], 60 => 0x1021, 68 => 0x38, 79 => 'FocusMode', 93 => 0x30, 95 => 0xe, 117 => 0x7, 144 => 0x301, 149 => 0x100b, 158 => 0x7, 171 => 0xd, 173 => 0x3 },
	'focusmode2' => { 164 => '3.1' },
	'focusmodesetting' => { 125 => 0x2e3 },
	'focuspixel' => { 60 => 0x1023 },
	'focuspointwrap' => { 124 => '792.2' },
	'focusposition' => { 115 => 0x8, 116 => 0x8, 171 => 0x10 },
	'focusprocess' => { 144 => 0x302 },
	'focusrange' => { 11 => 0x12, 149 => 0x100a },
	'focussetting' => { 183 => 0x6 },
	'focusstepcount' => { 147 => 0x301, 149 => 0x100e },
	'focusstepinfinity' => { 147 => 0x303 },
	'focusstepnear' => { 147 => 0x304 },
	'focustrackinglockon' => { 124 => '791.5' },
	'focuswarning' => { 60 => 0x1301 },
	'foldername' => { 93 => 0x27 },
	'fontcomposite' => { 214 => 'FontsComposite' },
	'fontface' => { 214 => 'FontsFontFace' },
	'fontfamily' => { 214 => 'FontsFontFamily' },
	'fontfilename' => { 214 => 'FontsFontFileName' },
	'fontname' => { 214 => 'FontsFontName' },
	'fonttype' => { 214 => 'FontsFontType' },
	'fontversion' => { 214 => 'FontsVersionString' },
	'for' => { 179 => 'For' },
	'format' => { 193 => 'format' },
	'forwardmatrix1' => { 56 => 0xc714 },
	'forwardmatrix2' => { 56 => 0xc715 },
	'framenum' => { 174 => 0xd7 },
	'framenumber' => { 60 => 0x8003, 171 => 0x29 },
	'freebytes' => { 46 => 0x1 },
	'freememorycardimages' => { 94 => [0x37,0x54], 95 => [0x2d,0x4a] },
	'fujiflashmode' => { 60 => 0x1010 },
	'fullsizeimage' => { 85 => 'data' },
	'fullsizeimagename' => { 85 => '1Name' },
	'fullsizeimagetype' => { 85 => '0Type' },
	'functionbutton' => { 126 => '753.2' },
	'gainbase' => { 148 => 0x610 },
	'gaincontrol' => { 56 => 0xa407, 195 => 'GainControl' },
	'gamma' => { 56 => 0xa500 },
	'gammacompensatedvalue' => { 64 => 0x91 },
	'genre' => { 201 => 'genre', 209 => 'genre' },
	'geography' => { 202 => 'geography' },
	'globalaltitude' => { 177 => 0x419 },
	'globalangle' => { 177 => 0x40d },
	'gpsaltitude' => { 61 => 0x6, 83 => 'Altitude', 195 => 'GPSAltitude' },
	'gpsaltituderef' => { 61 => 0x5, 195 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 61 => 0x1c, 195 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 61 => 0x1d },
	'gpsdatetime' => { 83 => 'DateTime', 195 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 61 => 0x18, 83 => 'Bearing', 195 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 61 => 0x17, 195 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 61 => 0x1a, 83 => 'Distance', 195 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 61 => 0x19, 195 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 61 => 0x14, 195 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 61 => 0x13 },
	'gpsdestlongitude' => { 61 => 0x16, 195 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 61 => 0x15 },
	'gpsdifferential' => { 61 => 0x1e, 83 => 'Differential', 195 => 'GPSDifferential' },
	'gpsdop' => { 61 => 0xb, 195 => 'GPSDOP' },
	'gpsimgdirection' => { 61 => 0x11, 195 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 61 => 0x10, 195 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 61 => 0x2, 83 => 'Latitude', 195 => 'GPSLatitude' },
	'gpslatituderef' => { 61 => 0x1 },
	'gpslongitude' => { 61 => 0x4, 83 => 'Longitude', 195 => 'GPSLongitude' },
	'gpslongituderef' => { 61 => 0x3 },
	'gpsmapdatum' => { 61 => 0x12, 83 => 'Datum', 195 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 61 => 0xa, 83 => 'MeasureMode', 195 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 61 => 0x1b, 195 => 'GPSProcessingMethod' },
	'gpssatellites' => { 61 => 0x8, 83 => 'Satellites', 195 => 'GPSSatellites' },
	'gpsspeed' => { 61 => 0xd, 83 => 'Speed', 195 => 'GPSSpeed' },
	'gpsspeedref' => { 61 => 0xc, 195 => 'GPSSpeedRef' },
	'gpsstatus' => { 61 => 0x9, 195 => 'GPSStatus' },
	'gpstimestamp' => { 61 => 0x7 },
	'gpstrack' => { 61 => 0xf, 83 => 'Heading', 195 => 'GPSTrack' },
	'gpstrackref' => { 61 => 0xe, 195 => 'GPSTrackRef' },
	'gpsversionid' => { 61 => 0x0, 195 => 'GPSVersionID' },
	'gradation' => { 144 => 0x50f },
	'graymixeraqua' => { 192 => 'GrayMixerAqua' },
	'graymixerblue' => { 192 => 'GrayMixerBlue' },
	'graymixergreen' => { 192 => 'GrayMixerGreen' },
	'graymixermagenta' => { 192 => 'GrayMixerMagenta' },
	'graymixerorange' => { 192 => 'GrayMixerOrange' },
	'graymixerpurple' => { 192 => 'GrayMixerPurple' },
	'graymixerred' => { 192 => 'GrayMixerRed' },
	'graymixeryellow' => { 192 => 'GrayMixerYellow' },
	'grayresponseunit' => { 56 => 0x122 },
	'greencurvelimits' => { 50 => 0x1c4 },
	'greencurvepoints' => { 50 => 0x19a },
	'greenhue' => { 192 => 'GreenHue' },
	'greensaturation' => { 192 => 'GreenSaturation' },
	'griddisplay' => { 124 => '803.3', 126 => '754.1' },
	'halftonehints' => { 56 => 0x141 },
	'hasalternative' => { 201 => 'hasAlternative' },
	'hascorrection' => { 201 => 'hasCorrection' },
	'hascrop' => { 192 => 'HasCrop' },
	'hasextendedxmp' => { 211 => 'HasExtendedXMP' },
	'haspreviousversion' => { 201 => 'hasPreviousVersion' },
	'hassettings' => { 192 => 'HasSettings' },
	'hastranslation' => { 201 => 'hasTranslation' },
	'headline' => { 62 => 0x69, 199 => 'Headline' },
	'hierarchicalsubject' => { 187 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 33 => 0x202, 117 => 0xb1, 171 => 0x71 },
	'highlight' => { 183 => 0xf },
	'highlightprotection' => { 136 => 0x6 },
	'highlightrecovery' => { 192 => 'HighlightRecovery' },
	'highlighttonepriority' => { 33 => 0x203 },
	'history' => { 199 => 'History' },
	'historyaction' => { 210 => 'HistoryAction' },
	'historychanged' => { 210 => 'HistoryChanged' },
	'historyinstanceid' => { 210 => 'HistoryInstanceID' },
	'historyparameters' => { 210 => 'HistoryParameters' },
	'historysoftwareagent' => { 210 => 'HistorySoftwareAgent' },
	'historywhen' => { 210 => 'HistoryWhen' },
	'hometowncity' => { 53 => 0x3006, 171 => 0x23 },
	'hometowncitycode' => { 173 => 0x1000 },
	'hometowndst' => { 171 => 0x25 },
	'hostcomputer' => { 56 => 0x13c },
	'hue' => { 99 => 0x3b },
	'hueadj' => { 140 => 0x2f },
	'hueadjustment' => { 94 => 0x4a, 95 => 0x40, 117 => 0x92, 119 => 0x36 },
	'hueadjustmentaqua' => { 192 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 192 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 192 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 192 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 192 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 192 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 192 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 192 => 'HueAdjustmentYellow' },
	'huesetting' => { 152 => 0x1011 },
	'icc_profile' => { 57 => 'ICC_Profile' },
	'iccprofilename' => { 199 => 'ICCProfile' },
	'identifier' => { 193 => 'identifier', 207 => 'Identifier' },
	'illumination' => { 126 => '748.5' },
	'imageadjustment' => { 117 => 0x80, 127 => 0x5 },
	'imagealterationconstraints' => { 200 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 171 => 0x38 },
	'imageauthentication' => { 117 => 0x20 },
	'imageboundary' => { 117 => 0x16 },
	'imagecount' => { 117 => 0xa5 },
	'imagecreatorid' => { 200 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 200 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 200 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 117 => 0xa2 },
	'imagedescription' => { 56 => 0x10e, 205 => 'ImageDescription' },
	'imageduplicationconstraints' => { 200 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 137 => 0xfe443a45 },
	'imagefileconstraints' => { 200 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 200 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 200 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 56 => 0x101, 98 => 0xc, 205 => 'ImageLength' },
	'imagehistory' => { 56 => 0x9213 },
	'imageidnumber' => { 156 => 0x340 },
	'imagenumber' => { 9 => 0xd0, 56 => 0x9211, 79 => 'ImageNumber', 94 => 0xae, 95 => 0x5e, 190 => 'ImageNumber' },
	'imagenumber2' => { 95 => 0x62 },
	'imageoptimization' => { 117 => 0xa9 },
	'imageorientation' => { 62 => 0x83 },
	'imageprocessing' => { 117 => 0x1a, 171 => 0x32 },
	'imageprocessingcount' => { 171 => 0x41 },
	'imageprocessingversion' => { 148 => 0x0 },
	'imagequality' => { 79 => 'ImageQuality', 158 => 0x1 },
	'imagequality2' => { 144 => 0x603 },
	'imagereview' => { 125 => '729.4', 126 => '748.4' },
	'imagereviewtime' => { 125 => 0x2db },
	'imagesize' => { 85 => 'ImageSize' },
	'imagesizerestriction' => { 203 => 'imageSizeRestriction' },
	'imagesourcedata' => { 56 => 0x935c },
	'imagestabilization' => { 11 => 0x22, 53 => 0x3020, 79 => 'ImageStabilization', 94 => 0xbd, 95 => 0x71, 96 => 0x57, 97 => [0x18,0x107,0x113], 117 => 0xac, 147 => 0x1600, 158 => 0x1a, 184 => 0xb026 },
	'imagesupplierid' => { 200 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 200 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 200 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 171 => 0x4f },
	'imagetype' => { 62 => 0x82, 200 => 'ImageType' },
	'imageuniqueid' => { 56 => 0xa420, 195 => 'ImageUniqueID' },
	'imagewidth' => { 56 => 0x100, 98 => 0xe, 205 => 'ImageWidth' },
	'incrementaltemperature' => { 192 => 'IncrementalTemperature' },
	'incrementaltint' => { 192 => 'IncrementalTint' },
	'industry' => { 201 => 'industry', 202 => 'industry' },
	'infinitylensstep' => { 149 => 0x103b },
	'infobuttonwhenshooting' => { 33 => 0x409 },
	'ingredientsalternatepaths' => { 210 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 210 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 210 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 210 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 210 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 210 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 210 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 210 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 210 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 210 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 210 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 210 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 210 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 210 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 210 => 'IngredientsToPart' },
	'ingredientsversionid' => { 210 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 124 => '799.3' },
	'inkset' => { 56 => 0x14c },
	'instanceid' => { 210 => 'InstanceID' },
	'instructions' => { 199 => 'Instructions' },
	'instrument' => { 209 => 'instrument' },
	'intellectualgenre' => { 196 => 'IntellectualGenre' },
	'interchangecolorspace' => { 64 => 0x40 },
	'internalflash' => { 93 => 0x2b, 124 => '813.1', 125 => '737.1', 126 => '756.1', 147 => 0x1208 },
	'internalflashae1' => { 149 => 0x1021 },
	'internalflashae1_0' => { 149 => 0x101d },
	'internalflashae2' => { 149 => 0x1022 },
	'internalflashae2_0' => { 149 => 0x101e },
	'internalflashmode' => { 167 => 0x1 },
	'internalflashstrength' => { 167 => 0x3 },
	'internalflashtable' => { 149 => 0x1024 },
	'internalserialnumber' => { 23 => 0x96, 29 => 0x9, 60 => 0x10, 145 => 0x102, 158 => 0x25, 163 => 0x4 },
	'interopindex' => { 56 => 0x1 },
	'interopversion' => { 56 => 0x2 },
	'intervallength' => { 93 => 0x10 },
	'intervalmode' => { 93 => 0x26 },
	'intervalnumber' => { 93 => 0x11 },
	'introtimescale' => { 209 => 'introTimeScale' },
	'introtimevalue' => { 209 => 'introTimeValue' },
	'iptc-naa' => { 56 => 0x83bb },
	'iptcbitspersample' => { 64 => 0x56 },
	'iptcdigest' => { 177 => 0x425 },
	'iptcimageheight' => { 64 => 0x1e },
	'iptcimagerotation' => { 64 => 0x66 },
	'iptcimagewidth' => { 64 => 0x14 },
	'iptclastedited' => { 197 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 64 => 0xa },
	'iptcpixelheight' => { 64 => 0x32 },
	'iptcpixelwidth' => { 64 => 0x28 },
	'isbn' => { 201 => 'isbn' },
	'iscorrectionof' => { 201 => 'isCorrectionOf' },
	'iso' => { 3 => 0x75, 4 => 0x6, 5 => 0x79, 9 => 0x6, 10 => 0x0, 52 => 0x14, 53 => [0x3014,0x14], 56 => 0x8827, 66 => 0xfd06, 67 => 0x1784, 68 => 0x60, 69 => [0xfa2e,0xfa46], 70 => [0x27,0x28], 71 => 0xf105, 75 => 0x4e, 79 => 'ISO', 93 => 0x8, 113 => 0x0, 117 => 0x2, 159 => 0x17, 171 => 0x14, 173 => 0x14, 195 => 'ISOSpeedRatings' },
	'iso2' => { 113 => 0x6, 123 => 0x256, 124 => 0x25c },
	'isoexpansion' => { 33 => 0x103, 34 => 0x7, 35 => 0x8, 38 => 0x8, 113 => 0x4 },
	'isoexpansion2' => { 113 => 0xa },
	'isofloor' => { 164 => 0x6 },
	'isoselection' => { 117 => 0xf },
	'isosetting' => { 68 => 0x5e, 79 => 'ISOSetting', 93 => 0x24, 94 => 0x26, 95 => 0x1c, 99 => 0x6, 117 => 0x13, 164 => '17.3', 180 => 0x27 },
	'isospeedexpansion' => { 32 => 0x3 },
	'isospeedincrements' => { 33 => 0x102 },
	'isospeedrange' => { 33 => 0x103 },
	'isostepsize' => { 124 => '796.1' },
	'isovalue' => { 149 => 0x1001 },
	'issn' => { 201 => 'issn' },
	'issueidentifier' => { 201 => 'issueIdentifier' },
	'issuename' => { 201 => 'issueName' },
	'istranslationof' => { 201 => 'isTranslationOf' },
	'jobid' => { 62 => 0xb8 },
	'jobrefid' => { 208 => 'JobRefId' },
	'jobrefname' => { 208 => 'JobRefName' },
	'jobrefurl' => { 208 => 'JobRefUrl' },
	'jpegquality' => { 3 => 0x66 },
	'jpgfromraw' => { 46 => 0x2007, 54 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 56 => [0x117,0x202] },
	'jpgfromrawstart' => { 56 => [0x111,0x201] },
	'jpgrecordedpixels' => { 164 => 0xe },
	'key' => { 209 => 'key' },
	'keyword' => { 201 => 'keyword' },
	'keywords' => { 62 => 0x19, 80 => 'Keywords', 153 => 'Keywords', 179 => 'Keywords', 198 => 'Keywords' },
	'killdate' => { 201 => 'killDate' },
	'kodakimageheight' => { 66 => 0xf908, 68 => 0xe, 69 => [0xfa1e,0xfa52], 74 => 0x70 },
	'kodakimagewidth' => { 66 => 0xf907, 68 => 0xc, 69 => [0xfa1d,0xfa51], 74 => 0x6c },
	'kodakinfotype' => { 66 => 0xfa00 },
	'kodakmaker' => { 74 => 0x8 },
	'kodakmodel' => { 68 => 0x0, 74 => 0x28 },
	'label' => { 155 => 'Label', 207 => 'Label' },
	'language' => { 193 => 'language' },
	'languageidentifier' => { 62 => 0x87 },
	'lastfilenumber' => { 93 => 0x1b },
	'lastkeywordiptc' => { 189 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 189 => 'LastKeywordXMP' },
	'lasturl' => { 210 => 'LastURL' },
	'lc1' => { 168 => 0x2 },
	'lc10' => { 168 => 0xb },
	'lc11' => { 168 => 0xc },
	'lc12' => { 168 => 0xd },
	'lc14' => { 168 => 0xf },
	'lc15' => { 168 => 0x10 },
	'lc2' => { 168 => 0x3 },
	'lc3' => { 168 => 0x4 },
	'lc4' => { 168 => 0x5 },
	'lc5' => { 168 => 0x6 },
	'lc6' => { 168 => 0x7 },
	'lc7' => { 168 => 0x8 },
	'lcddisplayatpoweron' => { 33 => 0x811, 37 => 0xa },
	'lcddisplayreturntoshoot' => { 38 => 0x12 },
	'lcdillumination' => { 124 => '807.5' },
	'lcdilluminationduringbulb' => { 33 => 0x408 },
	'lcdpanels' => { 32 => 0x8 },
	'lcheditor' => { 137 => 0x8ae85e },
	'legacyiptcdigest' => { 199 => 'LegacyIPTCDigest' },
	'lens' => { 56 => 0xfdea, 117 => 0x84, 183 => 0xa, 190 => 'Lens' },
	'lensafstopbutton' => { 31 => 0x11, 32 => 0x13, 33 => 0x506, 34 => 0x10, 35 => 0x12, 38 => 0x13, 39 => 0x9 },
	'lensaperturerange' => { 183 => 0x30 },
	'lensdistortionparams' => { 149 => 0x206 },
	'lensdrivenoaf' => { 33 => 0x505 },
	'lensfirmwareversion' => { 145 => 0x204 },
	'lensfstops' => { 114 => 0x7, 115 => 0xc, 116 => 0xd, 117 => 0x8b, 168 => '0.3' },
	'lensid' => { 190 => 'LensID' },
	'lensidnumber' => { 114 => 0x6, 115 => 0xb, 116 => 0xc },
	'lensinfo' => { 190 => 'LensInfo' },
	'lenskind' => { 168 => 0x1 },
	'lensmake' => { 86 => 'Make' },
	'lensmanufacturer' => { 189 => 'LensManufacturer' },
	'lensmodel' => { 1 => 0x937, 6 => 0x92b, 7 => 0x933, 23 => 0x95, 86 => 'Model', 189 => 'LensModel' },
	'lensproperties' => { 145 => 0x20b },
	'lensserialnumber' => { 86 => 'SerialNumber', 145 => 0x202, 158 => 0x52 },
	'lenstemperature' => { 149 => 0x1008 },
	'lenstype' => { 1 => 0xe3, 2 => 0xd, 3 => 0xd, 4 => 0x112, 5 => 0xd, 6 => 0xd7, 7 => 0xdf, 8 => 0xeb, 9 => [0xd,0x98], 11 => 0x16, 97 => 0x10c, 117 => 0x83, 145 => 0x201, 156 => 0x310, 158 => 0x51, 169 => 0x0, 170 => 0x0, 171 => 0x3f, 184 => 0xb027 },
	'license' => { 191 => 'license' },
	'licenseeid' => { 200 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 200 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 200 => 'LicenseeImageNotes' },
	'licenseename' => { 200 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 200 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 200 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 200 => 'LicenseeTransactionID' },
	'licenseid' => { 200 => 'LicenseID' },
	'licensestartdate' => { 200 => 'LicenseStartDate' },
	'licensetransactiondate' => { 200 => 'LicenseTransactionDate' },
	'licensetype' => { 194 => 'licensetype' },
	'licensorcity' => { 200 => 'LicensorLicensorCity' },
	'licensorcountry' => { 200 => 'LicensorLicensorCountry' },
	'licensoremail' => { 200 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 200 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 200 => 'LicensorLicensorID' },
	'licensorimageid' => { 200 => 'LicensorImageID' },
	'licensorname' => { 200 => 'LicensorLicensorName' },
	'licensornotes' => { 200 => 'LicensorNotes' },
	'licensorpostalcode' => { 200 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 200 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 200 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 200 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 200 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 200 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 200 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 200 => 'LicensorTransactionID' },
	'licensorurl' => { 200 => 'LicensorLicensorURL' },
	'lightcondition' => { 149 => 0x1009 },
	'lightreading' => { 171 => 0x15 },
	'lightsource' => { 56 => 0x9208, 117 => 0x90, 152 => 0x1000, 195 => 'LightSource' },
	'lightsourcespecial' => { 182 => 0x21d },
	'lightvaluecenter' => { 149 => 0x103d },
	'lightvalueperiphery' => { 149 => 0x103e },
	'linearresponselimit' => { 56 => 0xc62e },
	'liveviewexposuresimulation' => { 33 => 0x810 },
	'localcaption' => { 62 => 0x79 },
	'localizedcameramodel' => { 56 => 0xc615 },
	'location' => { 188 => 'Location', 196 => 'Location', 201 => 'location' },
	'locationcreatedcity' => { 197 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 197 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 197 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 197 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 197 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 197 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 197 => 'LocationShownCity' },
	'locationshowncountrycode' => { 197 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 197 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 197 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 197 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 197 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 33 => 0x709 },
	'logcomment' => { 209 => 'logComment' },
	'longexposurenoisereduction' => { 33 => 0x201, 34 => 0x1, 35 => 0x2, 36 => 0x1, 37 => 0x1, 38 => 0x2, 39 => 0x1, 184 => 0xb04e },
	'longfocal' => { 2 => 0x10, 3 => 0x13, 4 => 0x115, 5 => 0x13, 6 => 0xda, 9 => 0x95, 11 => 0x17 },
	'loop' => { 209 => 'loop' },
	'luminanceadjustmentaqua' => { 192 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 192 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 192 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 192 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 192 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 192 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 192 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 192 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 51 => 0xbe },
	'luminancenr_tiff_jpeg' => { 51 => 0xda },
	'luminancesmoothing' => { 192 => 'LuminanceSmoothing' },
	'm16cversion' => { 156 => 0x333 },
	'macro' => { 60 => 0x1020, 149 => 0x202, 180 => 0x21, 182 => 0x202, 184 => 0xb040 },
	'macromode' => { 11 => 0x1, 93 => 0xb, 144 => 0x300, 158 => 0x1c },
	'magnifiedview' => { 35 => 0x11, 37 => 0x9 },
	'maindialexposurecomp' => { 126 => '748.6' },
	'make' => { 47 => 0x0, 56 => 0x10f, 79 => 'Make', 155 => 'Make', 159 => 0x10f, 205 => 'Make' },
	'makernote' => { 195 => 'MakerNote' },
	'makernotecanon' => { 55 => 'MakN', 56 => 0x927c },
	'makernotecasio' => { 55 => 'MakN', 56 => 0x927c },
	'makernotecasio2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotefujifilm' => { 55 => 'MakN', 56 => 0x927c },
	'makernotehp' => { 55 => 'MakN', 56 => 0x927c },
	'makernotehp2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotehp4' => { 55 => 'MakN', 56 => 0x927c },
	'makernotehp6' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteisl' => { 55 => 'MakN', 56 => 0x927c },
	'makernotejvc' => { 55 => 'MakN', 56 => 0x927c },
	'makernotejvctext' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak1a' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak1b' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak3' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak4' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak5' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak6a' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak6b' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak7' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak8a' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodak8b' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekodakunknown' => { 55 => 'MakN', 56 => 0x927c },
	'makernotekyocera' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteleica' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteleica2' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteleica3' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteminolta' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteminolta2' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteminolta3' => { 55 => 'MakN', 56 => 0x927c },
	'makernotenikon' => { 55 => 'MakN', 56 => 0x927c },
	'makernotenikon2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotenikon3' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteoffset' => { 182 => 0xff },
	'makernoteolympus' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteolympus2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotepanasonic' => { 55 => 'MakN', 56 => 0x927c },
	'makernotepanasonic2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotepentax' => { 55 => 'MakN', 56 => 0x927c },
	'makernotepentax2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotepentax3' => { 55 => 'MakN', 56 => 0x927c },
	'makernotepentax4' => { 55 => 'MakN', 56 => 0x927c },
	'makernotericoh' => { 55 => 'MakN', 56 => 0x927c },
	'makernotericohtext' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesafety' => { 56 => 0xc635 },
	'makernotesanyo' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesanyoc4' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesanyopatch' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesigma' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesony' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesony2' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesony3' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesony4' => { 55 => 'MakN', 56 => 0x927c },
	'makernotesonysrf' => { 55 => 'MakN', 56 => 0x927c },
	'makernotetype' => { 181 => 0x1 },
	'makernoteunknown' => { 55 => 'MakN', 56 => 0x927c },
	'makernoteversion' => { 97 => 0x0, 117 => 0x1, 149 => 0x0, 158 => 0x8000, 181 => 0x2, 183 => 0x1d },
	'managedfromalternatepaths' => { 210 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 210 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 210 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 210 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 210 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 210 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 210 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 210 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 210 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 210 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 210 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 210 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 210 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 210 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 210 => 'ManagedFromToPart' },
	'managedfromversionid' => { 210 => 'ManagedFromVersionID' },
	'manager' => { 210 => 'Manager' },
	'managervariant' => { 210 => 'ManagerVariant' },
	'manageto' => { 210 => 'ManageTo' },
	'manageui' => { 210 => 'ManageUI' },
	'manometerpressure' => { 144 => 0x900 },
	'manometerreading' => { 144 => 0x901 },
	'manualflash' => { 147 => 0x1209 },
	'manualflashoutput' => { 11 => 0x29, 125 => '737.2', 126 => '756.2' },
	'manualfocusdistance' => { 117 => 0x85, 149 => 0x100c, 182 => 0x223 },
	'manualtv' => { 32 => 0x5, 33 => 0x705 },
	'manufacturedate' => { 163 => 0x1 },
	'marked' => { 198 => 'Marked', 213 => 'Marked' },
	'markerscomment' => { 209 => 'markersComment' },
	'markerscuepointparamskey' => { 209 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 209 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 209 => 'markersCuePointType' },
	'markersduration' => { 209 => 'markersDuration' },
	'markerslocation' => { 209 => 'markersLocation' },
	'markersname' => { 209 => 'markersName' },
	'markersprobability' => { 209 => 'markersProbability' },
	'markersspeaker' => { 209 => 'markersSpeaker' },
	'markersstarttime' => { 209 => 'markersStartTime' },
	'markerstarget' => { 209 => 'markersTarget' },
	'markerstype' => { 209 => 'markersType' },
	'maskedareas' => { 56 => 0xc68e },
	'masterdocumentid' => { 62 => 0xb9 },
	'mastergain' => { 122 => 0x50 },
	'maxaperture' => { 11 => 0x1a, 71 => 0x6103, 86 => 'MaxAperture', 93 => 0x17, 168 => '14.1' },
	'maxapertureatcurrentfocal' => { 145 => 0x20a },
	'maxapertureatmaxfocal' => { 60 => 0x1407, 86 => 'MaxApertureAtMaxFocal', 114 => 0xb, 115 => 0x10, 116 => 0x11, 145 => 0x206 },
	'maxapertureatminfocal' => { 60 => 0x1406, 114 => 0xa, 115 => 0xf, 116 => 0x10, 145 => 0x205 },
	'maxaperturevalue' => { 56 => 0x9205, 195 => 'MaxApertureValue' },
	'maxavailheight' => { 197 => 'MaxAvailHeight' },
	'maxavailwidth' => { 197 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 124 => '801.1' },
	'maxfocallength' => { 60 => 0x1405, 86 => 'MaxFocalLength', 114 => 0x9, 115 => 0xe, 116 => 0xf, 145 => 0x208 },
	'maximumdensityrange' => { 64 => 0x8c },
	'maxpagesizeh' => { 214 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 214 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 214 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 56 => 0x119 },
	'mb-d10batteries' => { 124 => '802.4' },
	'mb-d80batteries' => { 126 => '754.5' },
	'mcuversion' => { 114 => 0xc, 115 => 0x11, 116 => 0x12 },
	'md5digest' => { 87 => 'zmd5' },
	'measuredev' => { 30 => 0x3, 46 => 0x1814, 79 => 'MeasuredEV' },
	'measuredlv' => { 156 => 0x312 },
	'mediaconstraints' => { 200 => 'MediaConstraints' },
	'mediasummarycode' => { 200 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 31 => 0xb, 34 => 0xa, 35 => 0xb, 38 => 0xb },
	'menubuttonreturn' => { 39 => 0xb },
	'metadatadate' => { 207 => 'MetadataDate' },
	'metadatamoddate' => { 209 => 'metadataModDate' },
	'metering' => { 125 => 0x2df },
	'meteringmode' => { 11 => 0x11, 56 => 0x9207, 68 => 0x1c, 93 => 0x7, 94 => 0x25, 144 => 0x202, 171 => 0x17, 183 => 0x9, 195 => 'MeteringMode' },
	'meteringmode2' => { 164 => '2.1' },
	'meteringmode3' => { 164 => '16.1' },
	'meteringtime' => { 124 => '812.2', 125 => '732.2', 126 => '751.2' },
	'mieversion' => { 87 => '0Vers' },
	'minaperture' => { 11 => 0x1b, 86 => 'MinAperture', 168 => '0.2' },
	'minfocallength' => { 60 => 0x1404, 86 => 'MinFocalLength', 114 => 0x8, 115 => 0xd, 116 => 0xe, 145 => 0x207 },
	'minoltadate' => { 93 => 0x15 },
	'minoltaimagesize' => { 93 => 0x4, 94 => 0xc, 95 => 0x2, 97 => 0x103 },
	'minoltamodelid' => { 93 => 0x25 },
	'minoltaquality' => { 93 => 0x5, 94 => 0xd, 95 => 0x3, 97 => [0x102,0x103], 149 => [0x102,0x103] },
	'minoltatime' => { 93 => 0x16 },
	'minormodelagedisclosure' => { 200 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 56 => 0x118 },
	'mirrorlockup' => { 31 => 0xc, 32 => 0xc, 33 => 0x60f, 34 => 0xb, 35 => 0xc, 36 => 0x6, 37 => 0x6, 38 => 0xc, 39 => 0x3 },
	'moddate' => { 198 => 'ModDate' },
	'model' => { 47 => 0x6, 56 => 0x110, 79 => 'Model', 155 => 'Model', 159 => 0x110, 205 => 'Model' },
	'modelage' => { 197 => 'ModelAge' },
	'modelingflash' => { 124 => '811.4', 126 => '755.3' },
	'modelreleaseid' => { 200 => 'ModelReleaseID' },
	'modelreleasestatus' => { 200 => 'ModelReleaseStatus' },
	'modificationdate' => { 201 => 'modificationDate' },
	'modifiedcolortemp' => { 24 => 0x9 },
	'modifieddigitalgain' => { 24 => 0xb },
	'modifiedparamflag' => { 21 => 0x1 },
	'modifiedpicturestyle' => { 24 => 0xa },
	'modifiedsaturation' => { 144 => 0x504 },
	'modifiedsensorbluelevel' => { 24 => 0x5 },
	'modifiedsensorredlevel' => { 24 => 0x4 },
	'modifiedsharpness' => { 24 => 0x2 },
	'modifiedsharpnessfreq' => { 24 => 0x3 },
	'modifiedtonecurve' => { 24 => 0x1 },
	'modifiedwhitebalance' => { 24 => 0x8 },
	'modifiedwhitebalanceblue' => { 24 => 0x7 },
	'modifiedwhitebalancered' => { 24 => 0x6 },
	'modifydate' => { 56 => 0x132, 80 => 'ModifyDate', 153 => 'ModDate', 154 => 'tIME', 179 => 'ModDate', 207 => 'ModifyDate' },
	'moirefilter' => { 56 => 0xfe58 },
	'monitorofftime' => { 124 => '808.2', 125 => '732.1', 126 => '751.1' },
	'monochromecontrast' => { 51 => 0x78 },
	'monochromefiltereffect' => { 51 => 0x74 },
	'monochromelinear' => { 51 => 0x7a },
	'monochromesharpness' => { 51 => 0x7c },
	'monochrometoningeffect' => { 51 => 0x76 },
	'monthdaycreated' => { 68 => 0x12, 75 => 0xe },
	'multiexposureautogain' => { 118 => 0x3 },
	'multiexposuremode' => { 118 => 0x1 },
	'multiexposureshots' => { 118 => 0x2 },
	'multipleexposureset' => { 164 => '10.1' },
	'multisample' => { 122 => 0x40 },
	'multiselector' => { 124 => '799.4' },
	'multiselectorplaybackmode' => { 124 => '799.2' },
	'multiselectorshootmode' => { 124 => '799.1' },
	'mycolormode' => { 25 => 0x2 },
	'nativedigest' => { 195 => 'NativeDigest', 205 => 'NativeDigest' },
	'ncdfileinfo' => { 67 => 0x414 },
	'ndfilter' => { 30 => 0x1c },
	'nearlensstep' => { 149 => 0x103c },
	'nefcompression' => { 117 => 0x93 },
	'newsphotoversion' => { 64 => 0x0 },
	'nickname' => { 207 => 'Nickname' },
	'nikon_0x00b9' => { 117 => 0xb9 },
	'nikoncaptureversion' => { 117 => 0xe09 },
	'nikoniccprofile' => { 117 => 0xe1d },
	'noisefilter' => { 144 => 0x527 },
	'noisereduction' => { 20 => 0x8, 60 => 0x100b, 94 => 0xb0, 95 => 0x60, 96 => 0x3f, 117 => 0x95, 137 => 0x753dcbc0, 138 => 0x17, 144 => 0x50a, 149 => 0x103a, 158 => 0x2d, 171 => 0x49 },
	'noisereduction2' => { 148 => 0x1010 },
	'noisereductionapplied' => { 56 => 0xc6f7 },
	'noisereductionintensity' => { 138 => 0x9 },
	'noisereductionmethod' => { 138 => 0x11 },
	'noisereductionsharpness' => { 138 => 0xd },
	'nomemorycard' => { 124 => '812.1', 125 => '729.3', 126 => '748.3' },
	'nominalmaxaperture' => { 168 => 0xa },
	'nominalminaperture' => { 168 => '10.1' },
	'notes' => { 185 => 'Notes' },
	'npages' => { 214 => 'NPages' },
	'nullrecord' => { 46 => 0x0 },
	'number' => { 201 => 'number' },
	'numberofbeats' => { 209 => 'numberOfBeats' },
	'numindexentries' => { 64 => 0x54 },
	'object' => { 201 => 'object' },
	'objectattributereference' => { 62 => 0x4 },
	'objectcycle' => { 62 => 0x4b },
	'objectdistance' => { 52 => 0x6, 53 => 0x2022 },
	'objectname' => { 62 => 0x5 },
	'objectpreviewdata' => { 62 => 0xca },
	'objectpreviewfileformat' => { 62 => 0xc8 },
	'objectpreviewfileversion' => { 62 => 0xc9 },
	'objecttypereference' => { 62 => 0x3 },
	'oecfcolumns' => { 195 => 'OECFColumns' },
	'oecfnames' => { 195 => 'OECFNames' },
	'oecfrows' => { 195 => 'OECFRows' },
	'oecfvalues' => { 195 => 'OECFValues' },
	'offsetschema' => { 56 => 0xea1d },
	'oldsubfiletype' => { 56 => 0xff },
	'olympusimageheight' => { 149 => 0x102f },
	'olympusimagewidth' => { 149 => 0x102e },
	'onetouchwb' => { 149 => 0x302 },
	'opticalzoom' => { 69 => 0xfa3d, 71 => [0x6006,0xf006], 72 => 0x1000, 73 => 0xf, 75 => 0x1e, 86 => 'OpticalZoom' },
	'opticalzoomcode' => { 30 => 0xa },
	'opticalzoommode' => { 158 => 0x34 },
	'opticalzoomon' => { 182 => 0x219 },
	'optionenddate' => { 203 => 'optionEndDate' },
	'ordernumber' => { 60 => 0x8002 },
	'organisationinimagecode' => { 197 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 197 => 'OrganisationInImageName' },
	'organization' => { 201 => 'organization' },
	'orientation' => { 56 => 0x112, 159 => 0x112, 205 => 'Orientation' },
	'originaldecisiondata' => { 54 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 23 => 0x83 },
	'originaldocumentid' => { 210 => 'OriginalDocumentID' },
	'originalfilename' => { 46 => 0x816, 67 => 0x3e9, 76 => 0x20 },
	'originalimageheight' => { 59 => 0x1 },
	'originalimagewidth' => { 59 => 0x0 },
	'originalrawfiledata' => { 56 => 0xc68c },
	'originalrawfiledigest' => { 56 => 0xc71d },
	'originalrawfilename' => { 56 => 0xc68b },
	'originaltransmissionreference' => { 62 => 0x67 },
	'originatingprogram' => { 62 => 0x41 },
	'originplatform' => { 201 => 'originPlatform' },
	'os' => { 194 => 'os' },
	'otherconditions' => { 200 => 'OtherConditions' },
	'otherconstraints' => { 200 => 'OtherConstraints' },
	'otherimageinfo' => { 200 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 200 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 200 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 200 => 'OtherLicenseRequirements' },
	'outcuescale' => { 209 => 'outCueScale' },
	'outcuevalue' => { 209 => 'outCueValue' },
	'outputimageheight' => { 103 => 0x3 },
	'outputimagewidth' => { 103 => 0x2 },
	'outputresolution' => { 103 => 0x4 },
	'owner' => { 213 => 'Owner' },
	'ownerid' => { 62 => 0xbc },
	'ownername' => { 23 => 0x9, 46 => 0x810, 56 => 0xfde8, 79 => 'OwnerName', 190 => 'OwnerName' },
	'padding' => { 56 => 0xea1c },
	'pagename' => { 56 => 0x11d },
	'pagenumber' => { 56 => 0x129 },
	'pagerange' => { 201 => 'pageRange' },
	'panasonicexifversion' => { 158 => 0x26 },
	'panasonicrawversion' => { 159 => 0x1 },
	'panoramadirection' => { 26 => 0x5 },
	'panoramaframe' => { 26 => 0x2 },
	'panoramamode' => { 68 => 0x3c, 144 => 0x601 },
	'parametricdarks' => { 192 => 'ParametricDarks' },
	'parametrichighlights' => { 192 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 192 => 'ParametricHighlightSplit' },
	'parametriclights' => { 192 => 'ParametricLights' },
	'parametricmidtonesplit' => { 192 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 192 => 'ParametricShadows' },
	'parametricshadowsplit' => { 192 => 'ParametricShadowSplit' },
	'patientid' => { 186 => 'PatientID' },
	'patientsbirthdate' => { 186 => 'PatientDOB' },
	'patientsname' => { 186 => 'PatientName' },
	'patientssex' => { 186 => 'PatientSex' },
	'pdfversion' => { 198 => 'PDFVersion' },
	'pentaximagesize' => { 171 => 0x9 },
	'pentaxmodelid' => { 163 => 0x0, 171 => 0x5 },
	'pentaxmodeltype' => { 171 => 0x1 },
	'pentaxversion' => { 171 => 0x0 },
	'people' => { 188 => 'People' },
	'permissions' => { 203 => 'permissions' },
	'person' => { 201 => 'person' },
	'personinimage' => { 197 => 'PersonInImage' },
	'pf0customfuncregistration' => { 41 => 0x1 },
	'pf10retainprogramshift' => { 41 => 0xb },
	'pf13drivepriority' => { 41 => 0xe },
	'pf14disablefocussearch' => { 41 => 0xf },
	'pf15disableafassistbeam' => { 41 => 0x10 },
	'pf16autofocuspointshoot' => { 41 => 0x11 },
	'pf17disableafpointsel' => { 41 => 0x12 },
	'pf18enableautoafpointsel' => { 41 => 0x13 },
	'pf19continuousshootspeed' => { 41 => 0x14 },
	'pf19shootingspeedhigh' => { 40 => 0xa },
	'pf19shootingspeedlow' => { 40 => 0x9 },
	'pf1disableshootingmodes' => { 41 => 0x2 },
	'pf1value' => { 40 => 0x1 },
	'pf20limitcontinousshots' => { 41 => 0x15 },
	'pf20maxcontinousshots' => { 40 => 0xb },
	'pf21enablequietoperation' => { 41 => 0x16 },
	'pf23felocktime' => { 40 => 0xd },
	'pf23postreleasetime' => { 40 => 0xe },
	'pf23settimerlengths' => { 41 => 0x18 },
	'pf23shutterbuttontime' => { 40 => 0xc },
	'pf24lightlcdduringbulb' => { 41 => 0x19 },
	'pf25aemode' => { 40 => 0xf },
	'pf25afmode' => { 40 => 0x12 },
	'pf25afpointsel' => { 40 => 0x13 },
	'pf25colormatrix' => { 40 => 0x17 },
	'pf25defaultclearsettings' => { 41 => 0x1a },
	'pf25drivemode' => { 40 => 0x11 },
	'pf25imagesize' => { 40 => 0x14 },
	'pf25meteringmode' => { 40 => 0x10 },
	'pf25parameters' => { 40 => 0x16 },
	'pf25wbmode' => { 40 => 0x15 },
	'pf26shortenreleaselag' => { 41 => 0x1b },
	'pf27reversedialrotation' => { 41 => 0x1c },
	'pf27value' => { 40 => 0x18 },
	'pf28noquickdialexpcomp' => { 41 => 0x1d },
	'pf29quickdialswitchoff' => { 41 => 0x1e },
	'pf2disablemeteringmodes' => { 41 => 0x3 },
	'pf2value' => { 40 => 0x2 },
	'pf30enlargementmode' => { 41 => 0x1f },
	'pf31originaldecisiondata' => { 41 => 0x20 },
	'pf3manualexposuremetering' => { 41 => 0x4 },
	'pf3value' => { 40 => 0x3 },
	'pf4exposuretimelimits' => { 41 => 0x5 },
	'pf4exposuretimemax' => { 40 => 0x5 },
	'pf4exposuretimemin' => { 40 => 0x4 },
	'pf5aperturelimits' => { 41 => 0x6 },
	'pf5aperturemax' => { 40 => 0x7 },
	'pf5aperturemin' => { 40 => 0x6 },
	'pf6presetshootingmodes' => { 41 => 0x7 },
	'pf7bracketcontinuousshoot' => { 41 => 0x8 },
	'pf8bracketshots' => { 40 => 0x8 },
	'pf8setbracketshots' => { 41 => 0x9 },
	'pf9changebracketsequence' => { 41 => 0xa },
	'phonenumber' => { 80 => 'Phone' },
	'photoeffect' => { 11 => 0x28 },
	'photoeffects' => { 137 => 0xab5eca5e },
	'photoeffectsblue' => { 139 => 0x8 },
	'photoeffectsgreen' => { 139 => 0x6 },
	'photoeffectsred' => { 139 => 0x4 },
	'photoeffectstype' => { 139 => 0x0 },
	'photoinfoplayback' => { 124 => '807.6' },
	'photometricinterpretation' => { 56 => 0x106, 205 => 'PhotometricInterpretation' },
	'photoshopquality' => { 176 => 0x0 },
	'pictinfo' => { 182 => 0x208 },
	'picturecontrol' => { 137 => 0xe2173c47 },
	'picturecontrolactive' => { 140 => 0x0 },
	'picturecontroladjust' => { 119 => 0x30 },
	'picturecontrolbase' => { 119 => 0x18 },
	'picturecontrolmode' => { 140 => 0x13 },
	'picturecontrolname' => { 119 => 0x4 },
	'picturecontrolquickadjust' => { 119 => 0x31 },
	'picturefinish' => { 94 => 0x71 },
	'picturemode' => { 60 => 0x1031, 144 => 0x520, 171 => [0xb,0x33] },
	'picturemode2' => { 164 => 0x0 },
	'picturemodebwfilter' => { 144 => 0x525 },
	'picturemodecontrast' => { 144 => 0x523 },
	'picturemodehue' => { 144 => 0x522 },
	'picturemodesaturation' => { 144 => 0x521 },
	'picturemodesharpness' => { 144 => 0x524 },
	'picturemodetone' => { 144 => 0x526 },
	'picturestyle' => { 2 => [0x4b,0x51], 3 => 0x6c, 4 => 0x86, 5 => 0x73, 9 => 0x6c, 28 => 0xa, 51 => 0x4 },
	'planarconfiguration' => { 56 => 0x11c, 205 => 'PlanarConfiguration' },
	'platenames' => { 214 => 'PlateNames' },
	'plusversion' => { 200 => 'Version' },
	'pngwarning' => { 155 => 'Warning' },
	'postalcode' => { 84 => 'PostalCode' },
	'postcropvignetteamount' => { 192 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 192 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 192 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 192 => 'PostCropVignetteRoundness' },
	'powersource' => { 162 => 0x0 },
	'precaptureframes' => { 149 => 0x300 },
	'predictor' => { 56 => 0x13d },
	'prefs' => { 62 => 0xdd, 175 => 'Prefs' },
	'preservedfilename' => { 210 => 'PreservedFileName' },
	'previewapplicationname' => { 56 => 0xc716 },
	'previewapplicationversion' => { 56 => 0xc717 },
	'previewcolorspace' => { 56 => 0xc71a },
	'previewdatetime' => { 56 => 0xc71b },
	'previewheight' => { 69 => 0xfa58 },
	'previewimage' => { 53 => 0x2000, 54 => 'PreviewImage', 55 => 'MakN', 56 => 0x927c, 58 => 0x4, 89 => 'data', 97 => 0x81, 149 => 0x280, 159 => 0x2e, 184 => 0x2001 },
	'previewimageborders' => { 171 => 0x3e },
	'previewimageheight' => { 27 => 0x4 },
	'previewimagelength' => { 27 => 0x2, 53 => 0x3, 56 => [0x117,0x202], 97 => 0x89, 120 => 0x202, 144 => 0x102, 149 => 0x1037, 171 => 0x3, 180 => 0x1e, 183 => 0x1b },
	'previewimagename' => { 89 => '1Name' },
	'previewimagesize' => { 53 => 0x2, 89 => 'ImageSize', 171 => 0x2, 183 => 0x1c },
	'previewimagestart' => { 27 => 0x5, 53 => 0x4, 56 => [0x111,0x201], 97 => 0x88, 120 => 0x201, 144 => 0x101, 149 => 0x1036, 171 => 0x4, 180 => 0x1c, 183 => 0x1a },
	'previewimagetype' => { 89 => '0Type' },
	'previewimagevalid' => { 144 => 0x100, 149 => 0x1035 },
	'previewimagewidth' => { 27 => 0x3 },
	'previewquality' => { 27 => 0x1 },
	'previewsettingsdigest' => { 56 => 0xc719 },
	'previewsettingsname' => { 56 => 0xc718 },
	'previewwidth' => { 69 => 0xfa57 },
	'primarychromaticities' => { 56 => 0x13f, 205 => 'PrimaryChromaticities' },
	'printim' => { 56 => 0xc4a5 },
	'privatertkinfo' => { 187 => 'privateRTKInfo' },
	'processingsoftware' => { 56 => 0xb },
	'producer' => { 153 => 'Producer', 198 => 'Producer' },
	'productid' => { 63 => 0x32 },
	'productioncode' => { 163 => 0x2 },
	'productorserviceconstraints' => { 200 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 56 => 0xc6f4 },
	'profilecopyright' => { 56 => 0xc6fe },
	'profileembedpolicy' => { 56 => 0xc6fd },
	'profilehuesatmapdata1' => { 56 => 0xc6fa },
	'profilehuesatmapdata2' => { 56 => 0xc6fb },
	'profilehuesatmapdims' => { 56 => 0xc6f9 },
	'profilelooktabledata' => { 56 => 0xc726 },
	'profilelooktabledims' => { 56 => 0xc725 },
	'profilename' => { 56 => 0xc6f8 },
	'profiletonecurve' => { 56 => 0xc6fc },
	'programiso' => { 158 => 0x3c },
	'programline' => { 164 => '1.1' },
	'programmode' => { 99 => 0x5 },
	'programshift' => { 117 => 0xd },
	'programversion' => { 62 => 0x46 },
	'projectrefpath' => { 209 => 'projectRefPath' },
	'projectreftype' => { 209 => 'projectRefType' },
	'propertyreleaseid' => { 200 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 200 => 'PropertyReleaseStatus' },
	'province-state' => { 62 => 0x5f },
	'publicationdate' => { 201 => 'publicationDate' },
	'publicationname' => { 201 => 'publicationName' },
	'publisher' => { 193 => 'publisher' },
	'pulldown' => { 209 => 'pullDown' },
	'quality' => { 0 => 0x1, 11 => 0x3, 52 => 0x2, 53 => 0x3002, 60 => 0x1000, 68 => 0x9, 117 => 0x4, 127 => 0x3, 149 => 0x201, 156 => 0x300, 171 => 0x8, 173 => 0x2, 183 => 0x16, 184 => [0x102,0xb047] },
	'qualitymode' => { 53 => 0x8 },
	'quantizationmethod' => { 64 => 0x78 },
	'quickadjust' => { 140 => 0x2a },
	'quickcontroldialinmeter' => { 33 => 0x703 },
	'quickshot' => { 182 => 0x213 },
	'rasterizedcaption' => { 62 => 0x7d },
	'rating' => { 56 => 0x4746, 174 => 0xdf, 194 => 'rating', 207 => 'Rating' },
	'ratingpercent' => { 56 => 0x4749, 189 => 'Rating' },
	'rawandjpgrecording' => { 31 => 0x8, 164 => 0xd },
	'rawbrightnessadj' => { 50 => 0x38 },
	'rawcoloradj' => { 50 => 0x2e },
	'rawcolortoneadj' => { 51 => 0x1a },
	'rawcontrastadj' => { 51 => 0x1e },
	'rawcropbottom' => { 174 => 0xd4 },
	'rawcropleft' => { 174 => 0xd1 },
	'rawcropright' => { 174 => 0xd3 },
	'rawcroptop' => { 174 => 0xd2 },
	'rawcustomsaturation' => { 50 => 0x30 },
	'rawcustomtone' => { 50 => 0x34 },
	'rawdatauniqueid' => { 56 => 0xc65d },
	'rawdepth' => { 98 => 0x10 },
	'rawdevautogradation' => { 151 => 0x119 },
	'rawdevcolorspace' => { 150 => 0x108, 151 => 0x109 },
	'rawdevcontrastvalue' => { 150 => 0x106, 151 => 0x105 },
	'rawdeveditstatus' => { 150 => 0x10b },
	'rawdevengine' => { 150 => 0x109, 151 => 0x10b },
	'rawdevexposurebiasvalue' => { 150 => 0x100, 151 => 0x100 },
	'rawdevgradation' => { 151 => 0x112 },
	'rawdevgraypoint' => { 150 => 0x103, 151 => 0x104 },
	'rawdevmemorycoloremphasis' => { 150 => 0x105, 151 => 0x108 },
	'rawdevnoisereduction' => { 150 => 0x10a, 151 => 0x10a },
	'rawdevpicturemode' => { 151 => 0x10c },
	'rawdevpm_bwfilter' => { 151 => 0x110 },
	'rawdevpmcontrast' => { 151 => 0x10e },
	'rawdevpmnoisefilter' => { 151 => 0x120 },
	'rawdevpmpicturetone' => { 151 => 0x111 },
	'rawdevpmsaturation' => { 151 => 0x10d },
	'rawdevpmsharpness' => { 151 => 0x10f },
	'rawdevsaturation3' => { 151 => 0x113 },
	'rawdevsaturationemphasis' => { 150 => 0x104, 151 => 0x107 },
	'rawdevsettings' => { 150 => 0x10c },
	'rawdevsharpnessvalue' => { 150 => 0x107, 151 => 0x106 },
	'rawdevversion' => { 150 => 0x0, 151 => 0x0 },
	'rawdevwbfineadjustment' => { 150 => 0x102, 151 => 0x103 },
	'rawdevwhitebalance' => { 151 => 0x101 },
	'rawdevwhitebalancevalue' => { 150 => 0x101, 151 => 0x102 },
	'rawfile' => { 56 => 0xfe4c },
	'rawfilename' => { 192 => 'RawFileName' },
	'rawhighlightpoint' => { 51 => 0x24 },
	'rawimagecenter' => { 117 => 0x99 },
	'rawimagedigest' => { 56 => 0xc71c },
	'rawimagesize' => { 171 => 0x39 },
	'rawinfoversion' => { 152 => 0x0 },
	'rawjpgheight' => { 48 => 0x4 },
	'rawjpgquality' => { 20 => 0x6, 48 => 0x1 },
	'rawjpgsize' => { 20 => 0x7, 48 => 0x2 },
	'rawjpgwidth' => { 48 => 0x3 },
	'rawlinear' => { 51 => 0x20 },
	'rawsaturationadj' => { 51 => 0x1c },
	'rawshadowpoint' => { 51 => 0x26 },
	'rawsharpnessadj' => { 51 => 0x22 },
	'recordid' => { 46 => 0x1804 },
	'recordingmode' => { 52 => 0x1, 173 => 0x1 },
	'recordmode' => { 11 => 0x9, 53 => 0x3000 },
	'recordshutterrelease' => { 182 => 0x217 },
	'redbalance' => { 149 => 0x1017, 159 => 0x11, 171 => 0x1c },
	'redcurvelimits' => { 50 => 0x18a },
	'redcurvepoints' => { 50 => 0x160 },
	'redeyecorrection' => { 141 => 0x0 },
	'redeyeinfo' => { 192 => 'RedEyeInfo' },
	'redhue' => { 192 => 'RedHue' },
	'redsaturation' => { 192 => 'RedSaturation' },
	'referenceblackwhite' => { 56 => 0x214, 205 => 'ReferenceBlackWhite' },
	'referencedate' => { 62 => 0x2f },
	'referencenumber' => { 62 => 0x32 },
	'references' => { 80 => 'References' },
	'referenceservice' => { 62 => 0x2d },
	'regionconstraints' => { 200 => 'RegionConstraints' },
	'registryitemid' => { 197 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 197 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 78 => 'data' },
	'relatedaudiofilename' => { 78 => '1Name' },
	'relatedaudiofiletype' => { 78 => '0Type' },
	'relatedimagefileformat' => { 56 => 0x1000 },
	'relatedimageheight' => { 56 => 0x1002 },
	'relatedimagewidth' => { 56 => 0x1001 },
	'relatedsoundfile' => { 56 => 0xa004, 195 => 'RelatedSoundFile' },
	'relatedvideofile' => { 92 => 'data' },
	'relatedvideofilename' => { 92 => '1Name' },
	'relatedvideofiletype' => { 92 => '0Type' },
	'relation' => { 193 => 'relation' },
	'relativepeakaudiofilepath' => { 209 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 209 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 209 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 124 => '807.8' },
	'releasedate' => { 62 => 0x1e, 209 => 'releaseDate' },
	'releasesetting' => { 46 => 0x1016 },
	'releasetime' => { 62 => 0x23 },
	'remoteonduration' => { 125 => '733.1', 126 => '752.3' },
	'renditionclass' => { 210 => 'RenditionClass' },
	'renditionofalternatepaths' => { 210 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 210 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 210 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 210 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 210 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 210 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 210 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 210 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 210 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 210 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 210 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 210 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 210 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 210 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 210 => 'RenditionOfToPart' },
	'renditionofversionid' => { 210 => 'RenditionOfVersionID' },
	'renditionparams' => { 210 => 'RenditionParams' },
	'repeatingflashcount' => { 109 => 0xd, 110 => 0xe, 126 => '757.2' },
	'repeatingflashoutput' => { 126 => '757.1' },
	'repeatingflashrate' => { 109 => 0xc, 110 => 0xd, 126 => '758.1' },
	'resampleparamsquality' => { 209 => 'resampleParamsQuality' },
	'resaved' => { 182 => 0x21e },
	'resolution' => { 85 => 'Resolution' },
	'resolutionmode' => { 183 => 0x4 },
	'resolutionunit' => { 56 => 0x128, 65 => 0x2, 205 => 'ResolutionUnit' },
	'restrictions' => { 203 => 'restrictions' },
	'retouchhistory' => { 117 => 0x9e },
	'retouchinfo' => { 192 => 'RetouchInfo' },
	'reuse' => { 200 => 'Reuse' },
	'reuseallowed' => { 212 => 'ReuseAllowed' },
	'reuseprohibited' => { 203 => 'reuseProhibited' },
	'reverseindicators' => { 124 => '802.1' },
	'revision' => { 194 => 'revision' },
	'rgbcurvelimits' => { 50 => 0x238 },
	'rgbcurvepoints' => { 50 => 0x20e },
	'ricohdate' => { 180 => 0x6 },
	'ricohimageheight' => { 180 => 0x2 },
	'ricohimagewidth' => { 180 => 0x0 },
	'rightascension' => { 88 => 'RightAscension' },
	'rights' => { 193 => 'rights' },
	'rightsagent' => { 201 => 'rightsAgent', 203 => 'rightsAgent' },
	'rightsowner' => { 203 => 'rightsOwner' },
	'romoperationmode' => { 46 => 0x80d },
	'rotation' => { 10 => 0x17, 45 => 0x3, 50 => 0x26e, 59 => 0x4, 88 => 'Rotation', 94 => [0x65,0x50], 95 => 0x46, 96 => 0x5a, 126 => '590.1', 137 => 0x76a43207, 158 => 0x30, 164 => '17.2', 174 => 0xd8 },
	'routing' => { 179 => 'Routing' },
	'rowsperstrip' => { 56 => 0x116 },
	'safetyshift' => { 33 => 0x108 },
	'safetyshiftinavortv' => { 31 => 0x10, 32 => 0x10, 34 => 0xf, 35 => 0x10, 38 => 0x10 },
	'samplebits' => { 78 => 'SampleBits' },
	'samplerate' => { 78 => 'SampleRate' },
	'samplesperpixel' => { 56 => 0x115, 205 => 'SamplesPerPixel' },
	'samplestructure' => { 64 => 0x5a },
	'sanyoquality' => { 182 => 0x201 },
	'sanyothumbnail' => { 182 => 0x100 },
	'saturation' => { 3 => 0x6e, 5 => 0x76, 11 => 0xe, 17 => 0x1, 52 => 0xd, 53 => [0x3013,0x1f], 56 => [0xa409,0xfe55], 60 => 0x1003, 79 => 'Saturation', 93 => 0x1f, 94 => 0x32, 95 => 0x28, 96 => 0x1a, 99 => 0x1, 117 => [0x94,0xaa], 119 => 0x35, 158 => 0x40, 171 => 0x1f, 173 => 0xd, 180 => 0x28, 183 => 0x10, 192 => 'Saturation', 195 => 'Saturation' },
	'saturationadj' => { 50 => 0x116, 136 => 0x1, 140 => 0x2e },
	'saturationadjustmentaqua' => { 192 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 192 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 192 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 192 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 192 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 192 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 192 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 192 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 9 => 0xfe },
	'saturationinfo' => { 171 => 0x21b },
	'saturationlandscape' => { 9 => 0xfc },
	'saturationneutral' => { 9 => 0xfd },
	'saturationportrait' => { 9 => 0xfb },
	'saturationsetting' => { 152 => 0x1010 },
	'saturationstandard' => { 9 => 0xfa },
	'saturationuserdef1' => { 9 => 0x100 },
	'saturationuserdef2' => { 9 => 0x101 },
	'saturationuserdef3' => { 9 => 0x102 },
	'saveid' => { 210 => 'SaveID' },
	'scaletype' => { 209 => 'scaleType' },
	'scanningdirection' => { 64 => 0x64 },
	'scene' => { 196 => 'Scene', 209 => 'scene' },
	'scenearea' => { 147 => 0x211, 149 => 0x1031 },
	'sceneassist' => { 117 => 0x9c },
	'scenecapturetype' => { 56 => 0xa406, 195 => 'SceneCaptureType' },
	'scenedetect' => { 147 => 0x210, 149 => 0x1030 },
	'scenedetectdata' => { 147 => 0x212, 149 => 0x1033 },
	'scenemode' => { 69 => 0xfa02, 97 => 0x100, 117 => 0x8f, 144 => 0x509, 149 => 0x403, 158 => 0x8001, 184 => 0xb023 },
	'scenemodeused' => { 71 => [0x6002,0xf002] },
	'sceneselect' => { 182 => 0x21f },
	'scenetype' => { 56 => 0xa301, 195 => 'SceneType' },
	'section' => { 201 => 'section' },
	'securityclassification' => { 56 => 0x9212 },
	'selectableafpoint' => { 33 => 0x509 },
	'selftimer' => { 11 => 0x2, 53 => 0x3001, 158 => 0x2e, 182 => 0x214 },
	'selftimer2' => { 30 => 0x1d },
	'selftimermode' => { 56 => 0x882b },
	'selftimertime' => { 46 => 0x1806, 124 => '808.1', 125 => '732.3', 126 => '751.3' },
	'seminfo' => { 56 => 0x8546 },
	'sensingmethod' => { 56 => 0xa217, 195 => 'SensingMethod' },
	'sensitivityadjust' => { 171 => 0x40 },
	'sensitivitysteps' => { 164 => '17.4', 166 => 0x1 },
	'sensorbluelevel' => { 28 => 0x5 },
	'sensorcleaning' => { 39 => 0xd },
	'sensorfullheight' => { 66 => 0xf904 },
	'sensorfullwidth' => { 66 => 0xf903 },
	'sensorheight' => { 66 => 0xf901, 69 => 0xfa21, 98 => 0x8 },
	'sensorpixelsize' => { 117 => 0x9a },
	'sensorredlevel' => { 28 => 0x4 },
	'sensorsize' => { 79 => 'SensorSize' },
	'sensortemperature' => { 147 => 0x1500, 149 => 0x1007 },
	'sensorwidth' => { 66 => 0xf900, 69 => 0xfa20, 98 => 0xa },
	'sequencenumber' => { 30 => 0x9, 53 => 0x301c, 60 => 0x1101, 68 => 0x1d, 158 => 0x2b },
	'sequenceshotinterval' => { 182 => 0x224 },
	'sequentialshot' => { 182 => 0x20e },
	'serialnumber' => { 23 => 0xc, 46 => 0x180b, 56 => 0xfde9, 66 => 0xfa04, 69 => 0xfa19, 77 => 0x0, 79 => 'SerialNumber', 117 => 0xa0, 145 => 0x101, 149 => [0x404,0x101a], 156 => 0x303, 183 => 0x2, 190 => 'SerialNumber' },
	'serialnumberformat' => { 23 => 0x15, 46 => 0x183b },
	'seriesdatetime' => { 186 => 'SeriesDateTime' },
	'seriesdescription' => { 186 => 'SeriesDescription' },
	'seriesmodality' => { 186 => 'SeriesModality' },
	'seriesnumber' => { 186 => 'SeriesNumber' },
	'serviceidentifier' => { 63 => 0x1e },
	'setbuttoncrosskeysfunc' => { 36 => 0x0, 37 => 0x0 },
	'setbuttonfunction' => { 31 => 0x1, 39 => 0xc },
	'setbuttonwhenshooting' => { 33 => 0x704 },
	'setfunctionwhenshooting' => { 34 => 0x0, 35 => 0x1, 38 => 0x1 },
	'shadingcompensation' => { 144 => 0x50c },
	'shadingcompensation2' => { 148 => 0x1012 },
	'shadow' => { 183 => 0xe },
	'shadowprotection' => { 136 => 0x0 },
	'shadows' => { 56 => 0xfe52, 192 => 'Shadows' },
	'shadowscale' => { 56 => 0xc633 },
	'shadowtint' => { 192 => 'ShadowTint' },
	'shakereduction' => { 172 => 0x1 },
	'sharpendetail' => { 192 => 'SharpenDetail' },
	'sharpenedgemasking' => { 192 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 140 => 0x2b },
	'sharpenradius' => { 192 => 'SharpenRadius' },
	'sharpness' => { 2 => [0x42,0x48], 3 => 0x72, 5 => 0x74, 11 => 0xf, 28 => 0x2, 52 => 0xb, 53 => [0x3011,0x21], 56 => [0xa40a,0xfe56], 60 => 0x1001, 68 => 0x6b, 75 => 0x37, 79 => 'Sharpness', 93 => 0x21, 94 => 0x30, 95 => 0x26, 96 => 0x18, 99 => 0x3, 117 => 0x6, 119 => 0x32, 149 => 0x100f, 158 => 0x41, 171 => 0x21, 173 => 0xb, 180 => 0x22, 181 => 0x1003, 183 => 0x11, 192 => 'Sharpness', 195 => 'Sharpness' },
	'sharpnessfactor' => { 149 => 0x102a },
	'sharpnessfaithful' => { 9 => 0xf5 },
	'sharpnessfrequency' => { 2 => [0x41,0x47], 28 => 0x3 },
	'sharpnesslandscape' => { 9 => 0xf3 },
	'sharpnessmonochrome' => { 9 => 0xf6 },
	'sharpnessneutral' => { 9 => 0xf4 },
	'sharpnessportrait' => { 9 => 0xf2 },
	'sharpnesssetting' => { 144 => 0x506, 152 => 0x1013 },
	'sharpnessstandard' => { 9 => 0xf1 },
	'sharpnessuserdef1' => { 9 => 0xf7 },
	'sharpnessuserdef2' => { 9 => 0xf8 },
	'sharpnessuserdef3' => { 9 => 0xf9 },
	'shootinginfodisplay' => { 124 => '803.2' },
	'shootingmode' => { 79 => 'ShootingMode', 117 => 0x89, 158 => 0x1f },
	'shootingmodesetting' => { 125 => '734.1' },
	'shortdescription' => { 194 => 'shortdescription' },
	'shortdocumentid' => { 62 => 0xba },
	'shortfocal' => { 2 => 0xe, 3 => 0x11, 4 => 0x113, 5 => 0x11, 6 => 0xd8, 9 => 0x93, 11 => 0x18 },
	'shortownername' => { 9 => 0xac },
	'shortreleasetimelag' => { 33 => 0x80d },
	'shotdate' => { 209 => 'shotDate' },
	'shotlocation' => { 209 => 'shotLocation' },
	'shotname' => { 209 => 'shotName' },
	'shutter-aelock' => { 31 => 0x4, 33 => 0x701, 34 => 0x3, 35 => 0x4, 36 => 0x3, 37 => 0x3, 38 => 0x4, 39 => 0x2 },
	'shutteraelbutton' => { 32 => 0x4 },
	'shutterbuttonafonbutton' => { 33 => 0x701 },
	'shuttercount' => { 4 => 0x176, 20 => 0x1, 123 => [0x6a,0x157,0x276], 124 => 0x279, 125 => 0x246, 126 => 0x24a, 171 => 0x5d },
	'shuttercurtainsync' => { 31 => 0xf, 32 => 0xf, 33 => 0x305, 34 => 0xe, 35 => 0xf, 36 => 0x8, 37 => 0x8, 38 => 0xf, 39 => 0x8 },
	'shuttermode' => { 68 => 0x1b },
	'shutterreleasebuttonae-l' => { 124 => '807.7' },
	'shutterreleasemethod' => { 46 => 0x1010 },
	'shutterreleasenocfcard' => { 31 => 0x2, 32 => 0x2, 39 => 0xf },
	'shutterreleasetiming' => { 46 => 0x1011 },
	'shutterspeedrange' => { 33 => 0x10c },
	'shutterspeedvalue' => { 42 => 0x1, 56 => 0x9201, 149 => 0x1000, 195 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 199 => 'SidecarForExtension' },
	'similarityindex' => { 62 => 0xe4 },
	'slaveflashmeteringsegments' => { 171 => 0x20b },
	'slowshutter' => { 30 => 0x8 },
	'slowsync' => { 60 => 0x1030 },
	'smoothness' => { 56 => 0xfe57 },
	'software' => { 56 => 0x131, 80 => 'Software', 155 => 'Software', 183 => 0x18, 205 => 'Software' },
	'softwareversion' => { 182 => 0x207 },
	'source' => { 62 => 0x73, 155 => 'Source', 193 => 'source', 194 => 'source', 199 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 195 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 195 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 195 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 195 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 209 => 'speakerPlacement' },
	'specialinstructions' => { 62 => 0x28 },
	'specialmode' => { 149 => 0x200, 182 => 0x200 },
	'spectralsensitivity' => { 56 => 0x8824, 195 => 'SpectralSensitivity' },
	'splittoningbalance' => { 192 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 192 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 192 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 192 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 192 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 93 => 0x2d },
	'spotfocuspointy' => { 93 => 0x2e },
	'spotmeteringmode' => { 11 => 0x27 },
	'spotmeterlinktoafpoint' => { 33 => 0x107 },
	'sractive' => { 164 => '17.1' },
	'srfocallength' => { 172 => 0x3 },
	'srhalfpresstime' => { 172 => 0x2 },
	'srresult' => { 172 => 0x0 },
	'startingpage' => { 201 => 'startingPage' },
	'starttimecodetimeformat' => { 209 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 209 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 209 => 'startTimecodeValue' },
	'state' => { 84 => 'State', 199 => 'State' },
	'status' => { 188 => 'Status' },
	'storagemethod' => { 98 => 0x12 },
	'straightenangle' => { 137 => 0x2fc08431 },
	'stretchmode' => { 209 => 'stretchMode' },
	'studydatetime' => { 186 => 'StudyDateTime' },
	'studydescription' => { 186 => 'StudyDescription' },
	'studyid' => { 186 => 'StudyID' },
	'studyphysician' => { 186 => 'StudyPhysician' },
	'sub-location' => { 62 => 0x5c },
	'subfiledata' => { 87 => 'data' },
	'subfiledirectory' => { 87 => '1Directory' },
	'subfilemimetype' => { 87 => '2MIME' },
	'subfilename' => { 87 => '1Name' },
	'subfileresource' => { 87 => 'rsrc' },
	'subfiletype' => { 56 => 0xfe, 87 => '0Type' },
	'subject' => { 153 => 'Subject', 179 => 'Subject', 193 => 'subject', 198 => 'Subject' },
	'subjectarea' => { 195 => 'SubjectArea' },
	'subjectcode' => { 196 => 'SubjectCode' },
	'subjectdistance' => { 56 => 0x9206, 68 => 0x3e, 195 => 'SubjectDistance' },
	'subjectdistancerange' => { 56 => 0xa40c, 195 => 'SubjectDistanceRange' },
	'subjectlocation' => { 56 => [0x9214,0xa214], 195 => 'SubjectLocation' },
	'subjectprogram' => { 93 => 0x22 },
	'subjectreference' => { 62 => 0xc },
	'subsectime' => { 56 => 0x9290, 67 => 0x401 },
	'subsectimedigitized' => { 56 => 0x9292 },
	'subsectimeoriginal' => { 56 => 0x9291 },
	'subsection1' => { 201 => 'subsection1' },
	'subsection2' => { 201 => 'subsection2' },
	'subsection3' => { 201 => 'subsection3' },
	'subsection4' => { 201 => 'subsection4' },
	'superimposeddisplay' => { 31 => 0xa, 33 => 0x510, 34 => 0x9, 35 => 0xa, 38 => 0xa, 39 => 0xe },
	'supplementalcategories' => { 62 => 0x14, 199 => 'SupplementalCategories' },
	'supplementaltype' => { 64 => 0x37 },
	'svisosetting' => { 164 => 0x14 },
	'switchtoregisteredafpoint' => { 32 => 0x12, 33 => 0x50a },
	'tagged' => { 174 => 0xdd },
	'tapename' => { 209 => 'tapeName' },
	'targetaperture' => { 30 => 0x4 },
	'targetcompressionratio' => { 44 => 0x1 },
	'targetdistancesetting' => { 46 => 0x1807 },
	'targetexposuretime' => { 30 => 0x5 },
	'targetimagetype' => { 46 => 0x100a },
	'teaser' => { 201 => 'teaser' },
	'teleconverter' => { 97 => 0x105, 184 => 0x105 },
	'temperature' => { 192 => 'Temperature' },
	'tempo' => { 209 => 'tempo' },
	'termsandconditionstext' => { 200 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 200 => 'TermsAndConditionsURL' },
	'thresholding' => { 56 => 0x107 },
	'thumbnailfilename' => { 46 => 0x817 },
	'thumbnailformat' => { 207 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 69 => 0xfa55, 207 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 46 => 0x2008, 54 => 'ThumbnailImage', 58 => 0x3, 90 => 'data', 149 => 0x100, 207 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 90 => '1Name' },
	'thumbnailimagesize' => { 90 => 'ImageSize' },
	'thumbnailimagetype' => { 90 => '0Type' },
	'thumbnailimagevalidarea' => { 23 => 0x13 },
	'thumbnaillength' => { 56 => 0x202 },
	'thumbnailoffset' => { 56 => 0x201 },
	'thumbnailwidth' => { 69 => 0xfa54, 207 => 'ThumbnailsWidth' },
	'ticker' => { 201 => 'ticker' },
	'tilelength' => { 56 => 0x143 },
	'tilewidth' => { 56 => 0x142 },
	'time' => { 171 => 0x7 },
	'timecreated' => { 62 => 0x3c, 68 => 0x14, 75 => 0x10, 175 => 'TimeCreated' },
	'timeperiod' => { 201 => 'timePeriod' },
	'timerfunctionbutton' => { 125 => '734.2' },
	'timerlength' => { 33 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 209 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 209 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 209 => 'timeScaleParamsQuality' },
	'timesent' => { 63 => 0x50 },
	'timesignature' => { 209 => 'timeSignature' },
	'timesincepoweron' => { 158 => 0x29 },
	'timestamp' => { 4 => 0x45e, 9 => 0x11c, 155 => 'TimeStamp' },
	'timestamp1' => { 4 => 0x45a },
	'timezone' => { 129 => 0x0 },
	'timezonecode' => { 49 => 0x1 },
	'timezoneinfo' => { 49 => 0x2 },
	'timezoneoffset' => { 56 => 0x882a },
	'tint' => { 192 => 'Tint' },
	'title' => { 56 => 0xc6d2, 80 => 'Title', 153 => 'Title', 155 => 'Title', 179 => 'Title', 193 => 'title', 198 => 'Title' },
	'tonecomp' => { 117 => 0x81 },
	'tonecurve' => { 28 => 0x1, 171 => 0x402, 192 => 'ToneCurve' },
	'tonecurveactive' => { 50 => 0x110 },
	'tonecurvefilename' => { 67 => 0x1391 },
	'tonecurvename' => { 192 => 'ToneCurveName' },
	'tonecurveproperty' => { 50 => 0x3c },
	'tonecurves' => { 171 => 0x403 },
	'toningeffect' => { 20 => 0xf, 117 => 0xb3, 119 => 0x38 },
	'toningeffectmonochrome' => { 9 => 0x108 },
	'toningsaturation' => { 119 => 0x39 },
	'totalzoom' => { 68 => 0x62 },
	'tracknumber' => { 209 => 'trackNumber' },
	'tracksframerate' => { 209 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 209 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 209 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 209 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 209 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 209 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 209 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 209 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 209 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 209 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 209 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 209 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 209 => 'TracksMarkersType' },
	'trackstrackname' => { 209 => 'TracksTrackName' },
	'trackstracktype' => { 209 => 'TracksTrackType' },
	'trailersignature' => { 87 => 'zmie' },
	'transferfunction' => { 205 => 'TransferFunction' },
	'transmissionreference' => { 199 => 'TransmissionReference' },
	'trapped' => { 153 => 'Trapped', 198 => 'Trapped' },
	'travelday' => { 158 => 0x36 },
	'ttl_da_adown' => { 167 => 0x5 },
	'ttl_da_aup' => { 167 => 0x4 },
	'ttl_da_bdown' => { 167 => 0x7 },
	'ttl_da_bup' => { 167 => 0x6 },
	'tvexposuretimesetting' => { 164 => 0x12 },
	'type' => { 193 => 'type' },
	'uniquecameramodel' => { 56 => 0xc614 },
	'uniquedocumentid' => { 62 => 0xbb },
	'uniqueobjectname' => { 63 => 0x64 },
	'unknownblock' => { 148 => 0x1103 },
	'unknowncompensation' => { 183 => 0xc },
	'unknownev' => { 67 => 0x1 },
	'unknownnumber' => { 46 => 0x180b },
	'unsharp1color' => { 142 => 0x13 },
	'unsharp1halowidth' => { 142 => 0x19 },
	'unsharp1intensity' => { 142 => 0x17 },
	'unsharp1threshold' => { 142 => 0x1b },
	'unsharp2color' => { 142 => 0x2e },
	'unsharp2halowidth' => { 142 => 0x34 },
	'unsharp2intensity' => { 142 => 0x32 },
	'unsharp2threshold' => { 142 => 0x36 },
	'unsharp3color' => { 142 => 0x49 },
	'unsharp3halowidth' => { 142 => 0x4f },
	'unsharp3intensity' => { 142 => 0x4d },
	'unsharp3threshold' => { 142 => 0x51 },
	'unsharp4color' => { 142 => 0x64 },
	'unsharp4halowidth' => { 142 => 0x6a },
	'unsharp4intensity' => { 142 => 0x68 },
	'unsharp4threshold' => { 142 => 0x6c },
	'unsharpcount' => { 142 => 0x0 },
	'unsharpmask' => { 137 => 0x76a43200 },
	'urgency' => { 62 => 0xa, 199 => 'Urgency' },
	'url' => { 80 => 'URL', 155 => 'URL', 177 => 0x40b, 201 => 'url' },
	'usablemeteringmodes' => { 33 => 0x10a },
	'usableshootingmodes' => { 33 => 0x109 },
	'usage' => { 202 => 'usage' },
	'usagefee' => { 203 => 'usageFee' },
	'usageterms' => { 213 => 'UsageTerms' },
	'usercomment' => { 46 => 0x805, 56 => 0x9286, 195 => 'UserComment' },
	'userdef1picturestyle' => { 9 => 0x10c },
	'userdef2picturestyle' => { 9 => 0x10e },
	'userdef3picturestyle' => { 9 => 0x110 },
	'userfields' => { 188 => 'UserFields' },
	'userprofile' => { 156 => 0x302 },
	'usmlenselectronicmf' => { 32 => 0x7, 33 => 0x501 },
	'utmeasting' => { 91 => 'Easting' },
	'utmmapdatum' => { 91 => 'Datum' },
	'utmnorthing' => { 91 => 'Northing' },
	'utmzone' => { 91 => 'Zone' },
	'uv-irfiltercorrection' => { 156 => 0x325 },
	'validbits' => { 148 => 0x611, 149 => 0x102c },
	'validpixeldepth' => { 152 => 0x611 },
	'variousmodes' => { 68 => 0x26 },
	'variousmodes2' => { 68 => 0x3a },
	'variprogram' => { 117 => 0xab },
	'version' => { 60 => 0x0, 179 => 'Version', 192 => 'Version' },
	'versionid' => { 210 => 'VersionID' },
	'versionidentifier' => { 201 => 'versionIdentifier' },
	'versionscomments' => { 210 => 'VersionsComments' },
	'versionseventaction' => { 210 => 'VersionsEventAction' },
	'versionseventchanged' => { 210 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 210 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 210 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 210 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 210 => 'VersionsEventWhen' },
	'versionsmodifier' => { 210 => 'VersionsModifier' },
	'versionsmodifydate' => { 210 => 'VersionsModifyDate' },
	'versionsversion' => { 210 => 'VersionsVersion' },
	'vibrance' => { 192 => 'Vibrance' },
	'vibrationreduction' => { 123 => [0x75,0x82,0x1ae], 125 => '586.1', 126 => '590.2', 128 => 0x4 },
	'videoalphamode' => { 209 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 209 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 209 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 209 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 209 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 209 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 209 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 209 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 209 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 209 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 209 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 209 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 209 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 209 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 209 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 209 => 'videoColorSpace' },
	'videocompressor' => { 209 => 'videoCompressor' },
	'videofieldorder' => { 209 => 'videoFieldOrder' },
	'videoframerate' => { 209 => 'videoFrameRate' },
	'videoframesizeh' => { 209 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 209 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 209 => 'videoFrameSizeW' },
	'videomoddate' => { 209 => 'videoModDate' },
	'videopixelaspectratio' => { 209 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 209 => 'videoPixelDepth' },
	'viewfinderwarning' => { 124 => '803.4', 126 => '754.2' },
	'viewinfoduringexposure' => { 33 => 0x407 },
	'vignetteamount' => { 192 => 'VignetteAmount' },
	'vignettecontrol' => { 117 => 0x2a, 137 => 0x76a43205 },
	'vignettecontrolintensity' => { 137 => 0xac6bd5c0 },
	'vignettemidpoint' => { 192 => 'VignetteMidpoint' },
	'voicememo' => { 182 => 0x216 },
	'volume' => { 201 => 'volume' },
	'vr_0x66' => { 123 => 0x66 },
	'vrdoffset' => { 23 => 0xd0 },
	'wb_glevel' => { 148 => 0x11f },
	'wb_glevel3000k' => { 148 => 0x113 },
	'wb_glevel3300k' => { 148 => 0x114 },
	'wb_glevel3600k' => { 148 => 0x115 },
	'wb_glevel3900k' => { 148 => 0x116 },
	'wb_glevel4000k' => { 148 => 0x117 },
	'wb_glevel4300k' => { 148 => 0x118 },
	'wb_glevel4500k' => { 148 => 0x119 },
	'wb_glevel4800k' => { 148 => 0x11a },
	'wb_glevel5300k' => { 148 => 0x11b },
	'wb_glevel6000k' => { 148 => 0x11c },
	'wb_glevel6600k' => { 148 => 0x11d },
	'wb_glevel7500k' => { 148 => 0x11e },
	'wb_grbglevels' => { 107 => 0x0 },
	'wb_rbgglevels' => { 104 => 0x0 },
	'wb_rblevels' => { 148 => 0x100 },
	'wb_rblevels3000k' => { 148 => 0x102 },
	'wb_rblevels3300k' => { 148 => 0x103 },
	'wb_rblevels3600k' => { 148 => 0x104 },
	'wb_rblevels3900k' => { 148 => 0x105 },
	'wb_rblevels4000k' => { 148 => 0x106 },
	'wb_rblevels4300k' => { 148 => 0x107 },
	'wb_rblevels4500k' => { 148 => 0x108 },
	'wb_rblevels4800k' => { 148 => 0x109 },
	'wb_rblevels5300k' => { 148 => 0x10a },
	'wb_rblevels6000k' => { 148 => 0x10b },
	'wb_rblevels6600k' => { 148 => 0x10c },
	'wb_rblevels7500k' => { 148 => 0x10d },
	'wb_rblevelsauto' => { 152 => 0x110 },
	'wb_rblevelscloudy' => { 152 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 152 => 0x132 },
	'wb_rblevelscwb1' => { 148 => 0x10e },
	'wb_rblevelscwb2' => { 148 => 0x10f },
	'wb_rblevelscwb3' => { 148 => 0x110 },
	'wb_rblevelscwb4' => { 148 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 152 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 152 => 0x131 },
	'wb_rblevelseveningsunlight' => { 152 => 0x124 },
	'wb_rblevelsfineweather' => { 152 => 0x122 },
	'wb_rblevelsshade' => { 152 => 0x120 },
	'wb_rblevelstungsten' => { 152 => 0x123 },
	'wb_rblevelsused' => { 152 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 152 => 0x133 },
	'wb_rgbglevels' => { 106 => 0x0 },
	'wb_rgblevels' => { 157 => 0xd },
	'wb_rggblevels' => { 105 => 0x0 },
	'wb_rggblevelsasshot' => { 13 => 0x19, 14 => 0x18, 15 => 0x3f, 16 => 0x3f },
	'wb_rggblevelsauto' => { 12 => 0x0, 13 => 0x1e, 14 => 0x22, 15 => 0x44, 16 => 0x44 },
	'wb_rggblevelscloudy' => { 12 => 0xc, 13 => 0x2d, 14 => 0x31, 15 => 0x58, 16 => 0x5d, 171 => 0x20f },
	'wb_rggblevelscustom' => { 12 => 0x1c, 15 => 0x80 },
	'wb_rggblevelscustom1' => { 13 => 0x41 },
	'wb_rggblevelscustom2' => { 13 => 0x46 },
	'wb_rggblevelsdaylight' => { 12 => 0x4, 13 => 0x23, 14 => 0x27, 15 => 0x4e, 16 => 0x53, 171 => 0x20d },
	'wb_rggblevelsflash' => { 12 => 0x18, 13 => 0x3c, 14 => 0x45, 15 => 0x6c, 16 => 0x71, 171 => 0x214 },
	'wb_rggblevelsfluorescent' => { 12 => 0x14, 13 => 0x37, 14 => 0x3b, 15 => 0x62, 16 => 0x67 },
	'wb_rggblevelsfluorescentd' => { 171 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 171 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 171 => 0x213 },
	'wb_rggblevelskelvin' => { 12 => 0x20, 14 => 0x40, 15 => 0x67, 16 => 0x6c },
	'wb_rggblevelsmeasured' => { 15 => 0x49, 16 => 0x49 },
	'wb_rggblevelspc1' => { 14 => 0x90, 15 => 0x71 },
	'wb_rggblevelspc2' => { 14 => 0x95, 15 => 0x76 },
	'wb_rggblevelspc3' => { 14 => 0x9a, 15 => 0x7b },
	'wb_rggblevelsshade' => { 12 => 0x8, 13 => 0x28, 14 => 0x2c, 15 => 0x53, 16 => 0x58, 171 => 0x20e },
	'wb_rggblevelstungsten' => { 12 => 0x10, 13 => 0x32, 14 => 0x36, 15 => 0x5d, 16 => 0x62, 171 => 0x210 },
	'wb_rggblevelsunknown' => { 14 => 0x1d },
	'wb_rggblevelsunknown10' => { 14 => 0x72, 16 => 0x9e },
	'wb_rggblevelsunknown11' => { 14 => 0x77, 16 => 0xa3 },
	'wb_rggblevelsunknown12' => { 14 => 0x7c },
	'wb_rggblevelsunknown13' => { 14 => 0x81 },
	'wb_rggblevelsunknown14' => { 14 => 0x86 },
	'wb_rggblevelsunknown15' => { 14 => 0x8b },
	'wb_rggblevelsunknown16' => { 14 => 0x9f },
	'wb_rggblevelsunknown2' => { 14 => 0x4a, 16 => 0x76 },
	'wb_rggblevelsunknown3' => { 14 => 0x4f, 16 => 0x7b },
	'wb_rggblevelsunknown4' => { 14 => 0x54, 16 => 0x80 },
	'wb_rggblevelsunknown5' => { 14 => 0x59, 16 => 0x85 },
	'wb_rggblevelsunknown6' => { 14 => 0x5e, 16 => 0x8a },
	'wb_rggblevelsunknown7' => { 14 => 0x63, 16 => 0x8f },
	'wb_rggblevelsunknown8' => { 14 => 0x68, 16 => 0x94 },
	'wb_rggblevelsunknown9' => { 14 => 0x6d, 16 => 0x99 },
	'wbadjbluebalance' => { 143 => 0x8 },
	'wbadjcolortemp' => { 50 => 0x1a },
	'wbadjlighting' => { 143 => 0x15 },
	'wbadjlightingsubtype' => { 143 => 0x14 },
	'wbadjmode' => { 143 => 0x10 },
	'wbadjredbalance' => { 143 => 0x0 },
	'wbadjrgblevels' => { 50 => 0x8 },
	'wbadjtemperature' => { 143 => 0x18 },
	'wbadjtint' => { 143 => 0x25 },
	'wbadjustab' => { 158 => 0x46 },
	'wbadjustgm' => { 158 => 0x47 },
	'wbbluelevel' => { 156 => 0x324, 158 => 0x8006, 159 => 0x26 },
	'wbbracketmode' => { 20 => 0x9 },
	'wbbracketvalueab' => { 20 => 0xc },
	'wbbracketvaluegm' => { 20 => 0xd },
	'wbfinetuneactive' => { 50 => 0x24 },
	'wbfinetunesaturation' => { 50 => 0x28 },
	'wbfinetunetone' => { 50 => 0x2c },
	'wbgreenlevel' => { 156 => 0x323, 158 => 0x8005, 159 => 0x25 },
	'wblevels' => { 100 => 0x4 },
	'wbmediaimagesizesetting' => { 33 => 0x708 },
	'wbmode' => { 99 => 0x4, 149 => 0x1015 },
	'wbredlevel' => { 156 => 0x322, 158 => 0x8004, 159 => 0x24 },
	'wbscale' => { 100 => 0x0 },
	'wbshiftab' => { 28 => 0xc, 165 => 0x10 },
	'wbshiftgm' => { 28 => 0xd },
	'wbshiftmg' => { 165 => 0x11 },
	'webstatement' => { 213 => 'WebStatement' },
	'whitebalance' => { 1 => 0x6f, 2 => [0x44,0x4a], 3 => 0x36, 4 => 0x5e, 5 => 0x36, 6 => 0x6f, 7 => 0x6f, 9 => 0x54, 28 => 0x8, 30 => 0x7, 52 => 0x7, 53 => [0x19,0x2012], 56 => [0xa403,0xfe4e], 60 => 0x1002, 68 => 0x40, 93 => 0x3, 94 => 0xe, 95 => 0x4, 96 => 0xb, 117 => 0x5, 127 => 0x7, 156 => 0x304, 158 => 0x3, 171 => 0x19, 173 => 0x7, 180 => 0x26, 183 => [0x3c,0x7], 192 => 'WhiteBalance', 195 => 'WhiteBalance' },
	'whitebalance2' => { 144 => 0x500 },
	'whitebalanceadj' => { 50 => 0x18, 137 => 0x76a43204 },
	'whitebalancebias' => { 53 => 0x2011, 149 => 0x304, 158 => 0x23 },
	'whitebalanceblue' => { 28 => 0x7 },
	'whitebalancebracket' => { 144 => 0x502, 149 => 0x303 },
	'whitebalancecomp' => { 152 => 0x1001 },
	'whitebalancefinetune' => { 60 => 0x100a, 117 => 0xb },
	'whitebalancemode' => { 171 => 0x1a },
	'whitebalancered' => { 28 => 0x6 },
	'whitebalanceset' => { 164 => 0xa },
	'whitebalancetemperature' => { 144 => 0x501 },
	'whiteboard' => { 149 => 0x301 },
	'whitelevel' => { 56 => 0xc61d },
	'whitepoint' => { 56 => 0x13e, 171 => 0x201, 205 => 'WhitePoint' },
	'widefocuszone' => { 93 => 0x2f },
	'widerange' => { 182 => 0x20f },
	'wordcount' => { 201 => 'wordCount' },
	'workcolorspace' => { 50 => 0x270 },
	'worldtimelocation' => { 158 => 0x3a, 171 => 0x22 },
	'writer-editor' => { 62 => 0x7a },
	'x3filllight' => { 183 => 0x12 },
	'xmp' => { 57 => 'XMP' },
	'xmptoolkit' => { 206 => 'xmptk' },
	'xpauthor' => { 56 => 0x9c9d },
	'xpcomment' => { 56 => 0x9c9c },
	'xpkeywords' => { 56 => 0x9c9e },
	'xposition' => { 56 => 0x11e },
	'xpsubject' => { 56 => 0x9c9f },
	'xptitle' => { 56 => 0x9c9b },
	'xresolution' => { 56 => 0x11a, 65 => 0x3, 178 => 0x0, 205 => 'XResolution' },
	'xyresolution' => { 59 => 0x3 },
	'ycbcrcoefficients' => { 56 => 0x211, 205 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 56 => 0x213, 205 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 56 => 0x212, 205 => 'YCbCrSubSampling' },
	'yearcreated' => { 68 => 0x10, 75 => 0xc },
	'yposition' => { 56 => 0x11f },
	'yresolution' => { 56 => 0x11b, 65 => 0x5, 178 => 0x4, 205 => 'YResolution' },
	'zonematching' => { 97 => 0x10a, 99 => 0x3a, 184 => 0xb024 },
	'zonematchingon' => { 95 => 0x75 },
	'zoomsourcewidth' => { 11 => 0x24 },
	'zoomstepcount' => { 147 => 0x300, 149 => 0x100d },
	'zoomtargetwidth' => { 11 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitflag' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'characterset' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalance4' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'entrypoint' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrafieldlength' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filenamelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'rowinterleavefactor' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'supermacro' => 1,
	'svgversion' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transform' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipversion' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2008, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
