#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorBalance4',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::FlashInfo',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 176 => 'absPeakAudioFilePath' },
	'accessorytype' => { 136 => 0x53 },
	'actionadvised' => { 59 => 0x2a },
	'activearea' => { 53 => 0xc68d },
	'actived-lighting' => { 105 => 0x22 },
	'addaspectratioinfo' => { 30 => 0x80e },
	'addoriginaldecisiondata' => { 30 => 0x80f, 31 => 0x11, 32 => 0x13, 35 => 0x14 },
	'address' => { 80 => 'Address' },
	'adjustmentmode' => { 158 => [0x15,0x22] },
	'advancedraw' => { 118 => 0x76a43203 },
	'advisory' => { 174 => 'Advisory' },
	'ae_iso' => { 138 => 0x2 },
	'aeaperture' => { 138 => 0x1 },
	'aebautocancel' => { 30 => 0x104 },
	'aebbracketvalue' => { 27 => 0x11 },
	'aebsequence' => { 28 => 0x9, 29 => 0x9, 30 => 0x105, 31 => 0x8, 32 => 0x9, 35 => 0x9, 36 => 0x7 },
	'aebshotcount' => { 30 => 0x106 },
	'aebxv' => { 138 => 0x4 },
	'aeexposuretime' => { 138 => 0x0 },
	'aeextra' => { 138 => 0x7 },
	'aeflashtv' => { 138 => 0x5 },
	'aelock' => { 124 => 0x201, 145 => 0x48 },
	'aemeteringsegments' => { 145 => 0x209 },
	'aeprogrammode' => { 138 => 0x6 },
	'aesetting' => { 8 => 0x21 },
	'aexv' => { 138 => 0x3 },
	'afareamode' => { 97 => 0x0 },
	'afareas' => { 124 => 0x304 },
	'afassist' => { 28 => 0x5, 36 => 0x5 },
	'afassistbeam' => { 30 => 0x50e, 31 => 0x4, 32 => 0x5, 33 => 0x4, 34 => 0x4, 35 => 0x5 },
	'afdefocus' => { 139 => 0x6 },
	'afduringliveview' => { 30 => 0x511 },
	'afexpansionwithselectedpoint' => { 30 => 0x508 },
	'afintegrationtime' => { 139 => 0x7 },
	'afmicroadjustment' => { 30 => 0x507 },
	'afmode' => { 136 => 0xf, 158 => 0x5 },
	'afonaelockbuttonswitch' => { 30 => 0x702 },
	'afpoint' => { 8 => 0x13, 49 => 0x18, 97 => 0x1, 127 => 0x308 },
	'afpointactivationarea' => { 29 => 0x11, 35 => 0x11 },
	'afpointautoselection' => { 30 => 0x50b },
	'afpointbrightness' => { 30 => 0x50d },
	'afpointdisplayduringfocus' => { 30 => 0x50c },
	'afpointillumination' => { 29 => 0xa },
	'afpointregistration' => { 28 => 0x7 },
	'afpoints' => { 91 => 0x10 },
	'afpointselected' => { 145 => 0xe },
	'afpointselection' => { 29 => 0xb },
	'afpointselectionmethod' => { 30 => 0x50f, 31 => 0xc, 32 => 0xd, 35 => 0xd },
	'afpointsinfocus' => { 27 => 0xe, 97 => 0x2, 139 => 0xb, 145 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 6 => 0x38 },
	'afpointspotmetering' => { 29 => 0xd },
	'afpointsunknown1' => { 139 => 0x0 },
	'afpointsunknown2' => { 139 => 0x2 },
	'afpredictor' => { 139 => 0x4 },
	'afresponse' => { 105 => 0xad },
	'afresult' => { 129 => 0x1038 },
	'afsearch' => { 124 => 0x303 },
	'aiservoimagepriority' => { 30 => 0x503 },
	'aiservotrackingmethod' => { 30 => 0x504 },
	'aiservotrackingsensitivity' => { 29 => 0x14, 30 => 0x502 },
	'album' => { 176 => 'album' },
	'alreadyapplied' => { 166 => 'AlreadyApplied' },
	'alttapename' => { 176 => 'altTapeName' },
	'alttimecodetimeformat' => { 176 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 176 => 'altTimecodeTimeValue' },
	'anti-blur' => { 159 => 0xb04b },
	'antialiasstrength' => { 53 => 0xc632 },
	'aperturerange' => { 30 => 0x10d },
	'aperturevalue' => { 53 => 0x9202, 129 => 0x1002, 169 => 'ApertureValue' },
	'applekeywords' => { 133 => 'AAPL:Keywords' },
	'applicationrecordversion' => { 59 => 0x0 },
	'applyshootingmeteringmode' => { 30 => 0x10e },
	'armidentifier' => { 60 => 0x78 },
	'armversion' => { 60 => 0x7a },
	'artist' => { 53 => 0x13b, 135 => 'Artist', 173 => 'Artist', 176 => 'artist' },
	'asshoticcprofile' => { 53 => 0xc68f },
	'asshotpreprofilematrix' => { 53 => 0xc690 },
	'asshotwhitexy' => { 53 => 0xc629 },
	'assistbuttonfunction' => { 28 => 0xd },
	'audio' => { 136 => 0x20 },
	'audiochanneltype' => { 176 => 'audioChannelType' },
	'audiocompression' => { 74 => 'Compression' },
	'audiocompressor' => { 176 => 'audioCompressor' },
	'audioduration' => { 59 => 0x99 },
	'audiomoddate' => { 176 => 'audioModDate' },
	'audiooutcue' => { 59 => 0x9a },
	'audiosamplerate' => { 176 => 'audioSampleRate' },
	'audiosampletype' => { 176 => 'audioSampleType' },
	'audiosamplingrate' => { 59 => 0x97 },
	'audiosamplingresolution' => { 59 => 0x98 },
	'audiotype' => { 59 => 0x96 },
	'author' => { 76 => 'Author', 133 => 'Author', 135 => 'Author', 154 => 'Author', 171 => 'Author' },
	'authorsposition' => { 172 => 'AuthorsPosition' },
	'autobracket' => { 158 => 0x19 },
	'autobracketing' => { 57 => 0x1100, 145 => 0x18 },
	'autobracketrelease' => { 105 => 0x8a },
	'autobrightness' => { 166 => 'AutoBrightness' },
	'autocontrast' => { 166 => 'AutoContrast' },
	'autoexposure' => { 166 => 'AutoExposure' },
	'autoexposurebracketing' => { 27 => 0x10 },
	'autofocus' => { 127 => 0x209 },
	'autoiso' => { 27 => 0x1, 50 => 0x3008 },
	'autolightingoptimizer' => { 30 => 0x204 },
	'autorotate' => { 27 => 0x1b },
	'autoshadows' => { 166 => 'AutoShadows' },
	'auxiliarylens' => { 105 => 0x82 },
	'avsettingwithoutlens' => { 30 => 0x707 },
	'avvalue' => { 39 => 0x2 },
	'azimuth' => { 84 => 'Azimuth' },
	'babyage' => { 136 => [0x8010,0x33] },
	'baseexposurecompensation' => { 147 => 0x15 },
	'baseiso' => { 27 => 0x2, 43 => 0x101c },
	'baselineexposure' => { 53 => 0xc62a },
	'baselinenoise' => { 53 => 0xc62b },
	'baselinesharpness' => { 53 => 0xc62c },
	'baseurl' => { 174 => 'BaseURL' },
	'batteryadbodyload' => { 140 => 0x3 },
	'batteryadbodynoload' => { 140 => 0x2 },
	'batteryadgripload' => { 140 => 0x5 },
	'batteryadgripnoload' => { 140 => 0x4 },
	'batterystates' => { 140 => 0x1 },
	'bayergreensplit' => { 53 => 0xc62d },
	'bayerpattern' => { 63 => 0xf902, 94 => 0x17 },
	'beatspliceparamsriseindecibel' => { 176 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 176 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 176 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 53 => 0xc65c },
	'bestshotmode' => { 50 => 0x3007 },
	'bitdepth' => { 81 => 'BitDepth', 94 => 0x11, 110 => 0x41 },
	'bitspercomponent' => { 61 => 0x87 },
	'bitspersample' => { 53 => 0x102, 173 => 'BitsPerSample' },
	'blacklevel' => { 129 => 0x1012 },
	'blacklevel2' => { 128 => 0x600, 132 => 0x600 },
	'blackpoint' => { 145 => 0x200 },
	'bluebalance' => { 129 => 0x1018, 137 => 0x12, 145 => 0x1b },
	'bluecurvelimits' => { 47 => 0x1fe },
	'bluecurvepoints' => { 47 => 0x1d4 },
	'bluehue' => { 166 => 'BlueHue' },
	'bluesaturation' => { 166 => 'BlueSaturation' },
	'blurwarning' => { 57 => 0x1300 },
	'bodyfirmwareversion' => { 125 => 0x104, 126 => 0x100, 129 => 0x104 },
	'bracketmode' => { 18 => 0x3 },
	'bracketsequence' => { 50 => 0x301d },
	'bracketshotnumber' => { 18 => 0x5, 147 => 0x9 },
	'bracketstep' => { 89 => 0xe },
	'bracketvalue' => { 18 => 0x4 },
	'brightness' => { 53 => 0xfe53, 75 => 'Brightness', 89 => 0x2c, 107 => 0x34, 166 => 'Brightness' },
	'brightnessadj' => { 47 => 0x114, 113 => 0x0 },
	'brightnessvalue' => { 53 => 0x9203, 129 => 0x1003, 169 => 'BrightnessValue' },
	'bulbduration' => { 27 => 0x18 },
	'burstmode' => { 64 => 0xa, 136 => 0x2a },
	'burstmode2' => { 64 => 0x18 },
	'buttonfunctioncontroloff' => { 30 => 0x70a },
	'bwfilter' => { 89 => 0x2a, 95 => 0x39 },
	'bwmode' => { 129 => 0x203 },
	'by-line' => { 59 => 0x50 },
	'by-linetitle' => { 59 => 0x55 },
	'calibrationilluminant1' => { 53 => 0xc65a },
	'calibrationilluminant2' => { 53 => 0xc65b },
	'cameraid' => { 129 => 0x209, 157 => 0x209 },
	'cameraiso' => { 8 => 0x10 },
	'cameraparameters' => { 129 => 0x2050 },
	'cameraprofile' => { 166 => 'CameraProfile' },
	'cameraprofiledigest' => { 166 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 53 => 0xc62f, 163 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 124 => 0x0 },
	'cameratemperature' => { 145 => 0x47 },
	'cameratype' => { 27 => 0x1a, 129 => 0x207 },
	'cameratype2' => { 125 => 0x100 },
	'canonexposuremode' => { 8 => 0x14 },
	'canonfiledescription' => { 43 => 0x805 },
	'canonfilelength' => { 21 => 0xe },
	'canonfirmwareversion' => { 21 => 0x7, 43 => 0x80b },
	'canonflashinfo' => { 43 => 0x1028 },
	'canonflashmode' => { 8 => 0x4 },
	'canonimagesize' => { 2 => 0x39, 8 => 0xa },
	'canonimagetype' => { 21 => 0x6, 43 => 0x815 },
	'canonmodelid' => { 21 => 0x10, 43 => 0x1834 },
	'canonvrd' => { 54 => 'CanonVRD' },
	'caption-abstract' => { 59 => 0x78 },
	'captionwriter' => { 172 => 'CaptionWriter' },
	'casioimagesize' => { 50 => 0x9 },
	'catalogsets' => { 162 => 'CatalogSets' },
	'category' => { 59 => 0xf, 172 => 'Category' },
	'ccdscanmode' => { 129 => 0x1039 },
	'ccdsensitivity' => { 111 => 0x6 },
	'celllength' => { 53 => 0x109 },
	'cellwidth' => { 53 => 0x108 },
	'certificate' => { 179 => 'Certificate' },
	'cfapattern' => { 53 => 0xa302 },
	'cfapatterncolumns' => { 169 => 'CFAPatternColumns' },
	'cfapatternrows' => { 169 => 'CFAPatternRows' },
	'cfapatternvalues' => { 169 => 'CFAPatternValues' },
	'channels' => { 74 => 'Channels' },
	'checkmark' => { 47 => 0x26a },
	'chromablurradius' => { 53 => 0xc631 },
	'chromaticaberrationb' => { 166 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 166 => 'ChromaticAberrationR' },
	'chrominancenoisereduction' => { 48 => 0xbc },
	'chrominancenr_tiff_jpeg' => { 48 => 0xc0 },
	'city' => { 59 => 0x5a, 80 => 'City', 172 => 'City' },
	'clarity' => { 166 => 'Clarity' },
	'classifystate' => { 59 => 0xe1 },
	'cmcontrast' => { 132 => 0x2022 },
	'cmexposurecompensation' => { 132 => 0x2000 },
	'cmhue' => { 132 => 0x2021 },
	'cmsaturation' => { 132 => 0x2020 },
	'cmsharpness' => { 132 => 0x2023 },
	'cmwhitebalance' => { 132 => 0x2001 },
	'cmwhitebalancecomp' => { 132 => 0x2002 },
	'cmwhitebalancegraypoint' => { 132 => 0x2010 },
	'codec' => { 88 => 'Codec' },
	'codedcharacterset' => { 60 => 0x5a },
	'coloraberrationcontrol' => { 118 => 0xc89224b },
	'coloradjustment' => { 158 => 0x14 },
	'coloradjustmentmode' => { 157 => 0x210 },
	'colorantsa' => { 180 => 'ColorantsA' },
	'colorantsb' => { 180 => 'ColorantsB' },
	'colorantsblack' => { 180 => 'ColorantsBlack' },
	'colorantsblue' => { 180 => 'ColorantsBlue' },
	'colorantscyan' => { 180 => 'ColorantsCyan' },
	'colorantsgreen' => { 180 => 'ColorantsGreen' },
	'colorantsl' => { 180 => 'ColorantsL' },
	'colorantsmagenta' => { 180 => 'ColorantsMagenta' },
	'colorantsmode' => { 180 => 'ColorantsMode' },
	'colorantsred' => { 180 => 'ColorantsRed' },
	'colorantsswatchname' => { 180 => 'ColorantsSwatchName' },
	'colorantstype' => { 180 => 'ColorantsType' },
	'colorantsyellow' => { 180 => 'ColorantsYellow' },
	'colorbalance' => { 75 => 'ColorBalance' },
	'colorbalance1' => { 105 => 0xc },
	'colorbalanceadj' => { 118 => 0x76a43202 },
	'colorbalanceblue' => { 89 => 0x1e },
	'colorbalancegreen' => { 89 => 0x1d },
	'colorbalancered' => { 89 => 0x1c },
	'colorbooster' => { 118 => 0x5f0e7d23 },
	'colorboostlevel' => { 114 => 0x1 },
	'colorboosttype' => { 114 => 0x0 },
	'colorclass' => { 149 => 0xde },
	'colorcontrol' => { 129 => 0x102b },
	'coloreffect' => { 136 => 0x28 },
	'colorfilter' => { 49 => 0x17, 89 => 0x29, 95 => 0x38, 148 => 0x17 },
	'colorgain' => { 110 => 0x51 },
	'colorhue' => { 105 => 0x8d },
	'colormatrix' => { 15 => 0xa, 128 => 0x200, 129 => 0x1011 },
	'colormatrix2' => { 132 => 0x200 },
	'colormatrixnumber' => { 129 => 0x1019 },
	'colormode' => { 50 => 0x3015, 57 => 0x1210, 64 => 0x66, 89 => 0x28, 92 => 0x16, 93 => 0x101, 95 => 0x7, 105 => 0x3, 111 => 0x4, 129 => 0x101, 136 => 0x32, 159 => 0xb029, 172 => 'ColorMode' },
	'colormoirereduction' => { 119 => 0x5 },
	'colornoisereduction' => { 166 => 'ColorNoiseReduction' },
	'colorplanes' => { 56 => 0x2 },
	'colorprofile' => { 89 => 0x33 },
	'colorrepresentation' => { 61 => 0x3c },
	'colorreproduction' => { 159 => 0xb020 },
	'colorsequence' => { 61 => 0x41 },
	'colorspace' => { 14 => 0x3, 21 => 0xb4, 43 => 0x10b4, 53 => 0xa001, 81 => 'ColorSpace', 90 => 0x2f, 91 => 0x25, 105 => 0x1e, 124 => 0x507, 145 => 0x37, 158 => 0xb, 169 => 'ColorSpace' },
	'colortempasshot' => { 10 => 0x1d, 11 => 0x1c, 12 => 0x43, 13 => 0x43 },
	'colortempauto' => { 10 => 0x22, 11 => 0x26, 12 => 0x48, 13 => 0x48 },
	'colortempcloudy' => { 10 => 0x31, 11 => 0x35, 12 => 0x5c, 13 => 0x61 },
	'colortempcustom' => { 12 => 0x84 },
	'colortempcustom1' => { 10 => 0x45 },
	'colortempcustom2' => { 10 => 0x4a },
	'colortempdaylight' => { 10 => 0x27, 11 => 0x2b, 12 => 0x52, 13 => 0x57 },
	'colortemperature' => { 1 => [0x48,0x4e], 2 => 0x37, 3 => 0x62, 4 => 0x37, 5 => 0x73, 6 => 0x58, 15 => 0x9, 21 => 0xae, 26 => 0x9, 43 => 0x10ae, 57 => 0x1005, 75 => 'ColorTemperature', 90 => [0x6e,0x49], 91 => 0x3f, 92 => 0x5e, 93 => 0x10b, 95 => 0x3c, 145 => 0x50, 159 => 0xb021 },
	'colortemperaturebg' => { 129 => 0x1013 },
	'colortemperaturerg' => { 129 => 0x1014 },
	'colortempflash' => { 10 => 0x40, 11 => 0x49, 12 => 0x70, 13 => 0x75 },
	'colortempfluorescent' => { 10 => 0x3b, 11 => 0x3f, 12 => 0x66, 13 => 0x6b },
	'colortempkelvin' => { 11 => 0x44, 12 => 0x6b, 13 => 0x70 },
	'colortempmeasured' => { 12 => 0x4d, 13 => 0x4d },
	'colortemppc1' => { 11 => 0x94, 12 => 0x75 },
	'colortemppc2' => { 11 => 0x99, 12 => 0x7a },
	'colortemppc3' => { 11 => 0x9e, 12 => 0x7f },
	'colortempshade' => { 10 => 0x2c, 11 => 0x30, 12 => 0x57, 13 => 0x5c },
	'colortemptungsten' => { 10 => 0x36, 11 => 0x3a, 12 => 0x61, 13 => 0x66 },
	'colortempunknown' => { 11 => 0x21 },
	'colortempunknown10' => { 11 => 0x76, 13 => 0xa2 },
	'colortempunknown11' => { 11 => 0x7b, 13 => 0xa7 },
	'colortempunknown12' => { 11 => 0x80 },
	'colortempunknown13' => { 11 => 0x85 },
	'colortempunknown14' => { 11 => 0x8a },
	'colortempunknown15' => { 11 => 0x8f },
	'colortempunknown16' => { 11 => 0xa3 },
	'colortempunknown2' => { 11 => 0x4e, 13 => 0x7a },
	'colortempunknown3' => { 11 => 0x53, 13 => 0x7f },
	'colortempunknown4' => { 11 => 0x58, 13 => 0x84 },
	'colortempunknown5' => { 11 => 0x5d, 13 => 0x89 },
	'colortempunknown6' => { 11 => 0x62, 13 => 0x8e },
	'colortempunknown7' => { 11 => 0x67, 13 => 0x93 },
	'colortempunknown8' => { 11 => 0x6c, 13 => 0x98 },
	'colortempunknown9' => { 11 => 0x71, 13 => 0x9d },
	'colortone' => { 2 => 0x6f, 4 => 0x77, 8 => 0x2a, 14 => 0x2 },
	'colortoneadj' => { 47 => 0x11e },
	'colortonefaithful' => { 6 => 0x107 },
	'colortonelandscape' => { 6 => 0x105 },
	'colortoneneutral' => { 6 => 0x106 },
	'colortoneportrait' => { 6 => 0x104 },
	'colortonestandard' => { 6 => 0x103 },
	'colortoneuserdef1' => { 6 => 0x109 },
	'colortoneuserdef2' => { 6 => 0x10a },
	'colortoneuserdef3' => { 6 => 0x10b },
	'comment' => { 0 => 0x2, 54 => 'Comment', 76 => 'Comment', 135 => 'Comment' },
	'componentsconfiguration' => { 53 => 0x9101, 81 => 'Components', 169 => 'ComponentsConfiguration' },
	'componentversion' => { 43 => 0x80c },
	'composer' => { 176 => 'composer' },
	'compressedbitsperpixel' => { 53 => 0x9102, 169 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 93 => 0x40, 129 => 0x40 },
	'compression' => { 53 => 0x103, 173 => 'Compression' },
	'compressionfactor' => { 124 => 0x50d },
	'compressionratio' => { 81 => 'Compression', 129 => 0x1034 },
	'constrainedcropheight' => { 47 => 0x266, 149 => 0xd6 },
	'constrainedcropwidth' => { 47 => 0x262, 149 => 0xd5 },
	'contact' => { 59 => 0x76 },
	'contentlocationcode' => { 59 => 0x1a },
	'contentlocationname' => { 59 => 0x1b },
	'continuousdrive' => { 8 => 0x5 },
	'continuousshootingspeed' => { 30 => 0x610 },
	'continuousshotlimit' => { 30 => 0x611 },
	'contrast' => { 2 => 0x73, 4 => 0x75, 8 => 0xd, 49 => 0xc, 50 => [0x3012,0x20], 53 => [0xa408,0xfe54], 57 => [0x1004,0x1006], 75 => 'Contrast', 89 => 0x20, 90 => 0x31, 91 => 0x27, 92 => 0x19, 95 => 0x2, 107 => 0x33, 129 => 0x1029, 136 => [0x2c,0x39], 145 => 0x20, 148 => 0xc, 158 => 0xd, 166 => 'Contrast', 169 => 'Contrast' },
	'contrastadj' => { 47 => 0x115 },
	'contrastfaithful' => { 6 => 0xec },
	'contrastlandscape' => { 6 => 0xea },
	'contrastmonochrome' => { 6 => 0xed },
	'contrastneutral' => { 6 => 0xeb },
	'contrastportrait' => { 6 => 0xe9 },
	'contrastsetting' => { 124 => 0x505, 132 => 0x1012 },
	'contraststandard' => { 6 => 0xe8 },
	'contrastuserdef1' => { 6 => 0xee },
	'contrastuserdef2' => { 6 => 0xef },
	'contrastuserdef3' => { 6 => 0xf0 },
	'contributedmediaduration' => { 176 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 176 => 'contributedMediaManaged' },
	'contributedmediapath' => { 176 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 176 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 176 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 176 => 'contributedMediaWebStatement' },
	'contributor' => { 167 => 'contributor' },
	'contributors' => { 76 => 'Contributors' },
	'controlmode' => { 27 => 0x12 },
	'conversionlens' => { 136 => 0x35 },
	'converter' => { 53 => 0xfe4d, 111 => 0xb },
	'converttograyscale' => { 166 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 53 => 0x8298, 76 => 'Copyright', 135 => 'Copyright', 154 => 'Copyright', 173 => 'Copyright', 176 => 'copyright' },
	'copyrightflag' => { 152 => 0x40a },
	'copyrightnotice' => { 59 => 0x74 },
	'coringfilter' => { 128 => 0x310, 129 => 0x102d, 132 => 0x310 },
	'coringvalues' => { 128 => 0x311, 132 => 0x311 },
	'country' => { 80 => 'Country', 172 => 'Country' },
	'country-primarylocationcode' => { 59 => 0x64 },
	'country-primarylocationname' => { 59 => 0x65 },
	'countrycode' => { 150 => 'CountryCode', 170 => 'CountryCode' },
	'coverage' => { 167 => 'coverage' },
	'cpufirmwareversion' => { 145 => 0x28 },
	'crc32' => { 168 => 'crc32' },
	'createdate' => { 53 => 0x9004, 76 => 'CreateDate', 133 => 'CreationDate', 154 => 'CreationDate', 174 => 'CreateDate' },
	'creationdate' => { 171 => 'CreationDate' },
	'creationtime' => { 135 => 'Creation Time' },
	'creator' => { 133 => 'Creator', 154 => 'Creator', 167 => 'creator', 171 => 'Creator' },
	'creatorcontactinfociadrcity' => { 170 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 170 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 170 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 170 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 170 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 170 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 170 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 170 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 174 => 'CreatorTool' },
	'credit' => { 59 => 0x6e, 172 => 'Credit' },
	'creditlinereq' => { 178 => 'CreditLineReq' },
	'cropactive' => { 47 => 0x244 },
	'cropangle' => { 166 => 'CropAngle' },
	'cropaspectratio' => { 47 => 0x260 },
	'cropbottom' => { 56 => 0x9, 115 => 0x36, 149 => 0xdc, 166 => 'CropBottom' },
	'cropheight' => { 47 => 0x24c, 128 => 0x615, 132 => 0x615, 166 => 'CropHeight' },
	'crophispeed' => { 105 => 0x1b },
	'cropleft' => { 47 => 0x246, 56 => 0x6, 115 => 0x1e, 128 => 0x612, 132 => 0x612, 149 => 0xd9, 166 => 'CropLeft' },
	'cropoutputscale' => { 115 => 0xbe },
	'cropright' => { 56 => 0x8, 115 => 0x2e, 149 => 0xdb, 166 => 'CropRight' },
	'croprotation' => { 56 => 0xb },
	'croptop' => { 47 => 0x248, 56 => 0x7, 115 => 0x26, 128 => 0x613, 132 => 0x613, 149 => 0xda, 166 => 'CropTop' },
	'cropunits' => { 166 => 'CropUnits' },
	'cropwidth' => { 47 => 0x24a, 128 => 0x614, 132 => 0x614, 166 => 'CropWidth' },
	'currenticcprofile' => { 53 => 0xc691 },
	'currentpreprofilematrix' => { 53 => 0xc692 },
	'curves' => { 118 => 0x76a43201 },
	'customrendered' => { 53 => 0xa401, 169 => 'CustomRendered' },
	'customsaturation' => { 124 => 0x503 },
	'd-lightinghq' => { 118 => 0x2175eb78 },
	'd-lightinghqselected' => { 118 => 0x6a6e36b6 },
	'd-lightinghs' => { 118 => 0xce5554aa },
	'd-lightinghsadjustment' => { 117 => 0x0 },
	'd-lightinghscolorboost' => { 116 => 0x2, 117 => 0x1 },
	'd-lightinghshighlight' => { 116 => 0x1 },
	'd-lightinghsshadow' => { 116 => 0x0 },
	'datacompressionmethod' => { 61 => 0x6e },
	'dataimprint' => { 89 => 0x34 },
	'date' => { 145 => 0x6, 167 => 'date' },
	'dateacquired' => { 163 => 'DateAcquired' },
	'datecreated' => { 59 => 0x37, 172 => 'DateCreated' },
	'datesent' => { 60 => 0x46 },
	'datestampmode' => { 21 => 0x1c },
	'datetime' => { 173 => 'DateTime' },
	'datetimedigitized' => { 169 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 46 => 0x0, 53 => 0x9003, 76 => 'OriginalDate', 169 => 'DateTimeOriginal' },
	'datetimestamp' => { 64 => 0x64 },
	'declination' => { 84 => 'Declination' },
	'decposition' => { 89 => 0x32 },
	'defaultcroporigin' => { 53 => 0xc61f },
	'defaultcropsize' => { 53 => 0xc620 },
	'defaultscale' => { 53 => 0xc61e },
	'defringe' => { 166 => 'Defringe' },
	'deletedimagecount' => { 105 => 0xa6 },
	'derivedfromdocumentid' => { 177 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 177 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 177 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 177 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 177 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 177 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 177 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 177 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 177 => 'DerivedFromVersionID' },
	'description' => { 135 => 'Description', 167 => 'description' },
	'destination' => { 60 => 0x5 },
	'destinationcity' => { 145 => 0x24 },
	'destinationcitycode' => { 148 => 0x1001 },
	'destinationdst' => { 145 => 0x26 },
	'developmentdynamicrange' => { 57 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 169 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 169 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 169 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 30 => 0x706 },
	'digitalcreationdate' => { 59 => 0x3e },
	'digitalcreationtime' => { 59 => 0x3f },
	'digitalgain' => { 26 => 0xb },
	'digitalgem' => { 102 => 0x0 },
	'digitalice' => { 110 => 0x100 },
	'digitalroc' => { 109 => 0x0 },
	'digitalzoom' => { 8 => 0xc, 49 => 0xa, 64 => 0x68, 75 => 'DigitalZoom', 89 => 0xc, 105 => 0x86, 111 => 0xa, 129 => 0x204, 145 => 0x1e, 148 => 0xa, 157 => 0x204 },
	'digitalzoomon' => { 157 => 0x21b },
	'digitalzoomratio' => { 53 => 0xa404, 169 => 'DigitalZoomRatio' },
	'directory' => { 54 => 'Directory' },
	'disclaimer' => { 135 => 'Disclaimer' },
	'displayaperture' => { 8 => 0x23 },
	'displayedunitsx' => { 153 => 0x2 },
	'displayedunitsy' => { 153 => 0x6 },
	'distance1' => { 64 => 0x28 },
	'distance2' => { 64 => 0x2c },
	'distance3' => { 64 => 0x30 },
	'distance4' => { 64 => 0x34 },
	'distortioncorrection' => { 124 => 0x50b },
	'distortioncorrection2' => { 128 => 0x1011 },
	'dngbackwardversion' => { 53 => 0xc613 },
	'dnglensinfo' => { 53 => 0xc630 },
	'dngversion' => { 53 => 0xc612 },
	'document' => { 135 => 'Document' },
	'documenthistory' => { 59 => 0xe7 },
	'documentid' => { 177 => 'DocumentID' },
	'documentname' => { 53 => 0x10d },
	'documentnotes' => { 59 => 0xe6 },
	'dotrange' => { 53 => 0x150 },
	'drivemode' => { 89 => 0x6, 92 => 0x1e, 124 => 0x600, 145 => 0x34, 158 => 0x3 },
	'drivemode2' => { 147 => 0x7 },
	'dspfirmwareversion' => { 145 => 0x27 },
	'duration' => { 74 => 'Duration', 88 => 'Duration', 176 => 'duration' },
	'dynamicrange' => { 57 => 0x1400 },
	'dynamicrangemax' => { 47 => 0x7c },
	'dynamicrangemin' => { 47 => 0x7a },
	'dynamicrangeoptimizer' => { 159 => 0xb025 },
	'dynamicrangesetting' => { 57 => 0x1402 },
	'easymode' => { 8 => 0xb },
	'edgenoisereduction' => { 119 => 0x4 },
	'editorialupdate' => { 59 => 0x8 },
	'editstatus' => { 59 => 0x7, 150 => 'EditStatus' },
	'effectivelv' => { 145 => 0x2d },
	'elevation' => { 84 => 'Elevation' },
	'email' => { 76 => 'EMail' },
	'engineer' => { 176 => 'engineer' },
	'enhancedarktones' => { 113 => 0x8 },
	'enhancement' => { 49 => 0x16, 50 => 0x3016 },
	'enhancer' => { 128 => 0x300 },
	'enhancervalues' => { 128 => 0x301 },
	'envelopenumber' => { 60 => 0x28 },
	'envelopepriority' => { 60 => 0x3c },
	'enveloperecordversion' => { 60 => 0x0 },
	'epsonimageheight' => { 129 => 0x20c },
	'epsonimagewidth' => { 129 => 0x20b },
	'epsonsoftware' => { 129 => 0x20d },
	'equipmentinstitution' => { 160 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 160 => 'EquipmentManufacturer' },
	'equipmentversion' => { 125 => 0x0 },
	'ettlii' => { 30 => 0x304, 31 => 0xd, 32 => 0xe, 33 => 0x7, 34 => 0x7, 35 => 0xe },
	'event' => { 162 => 'Event' },
	'excursiontolerance' => { 61 => 0x82 },
	'exifbyteorder' => { 54 => 'ExifByteOrder' },
	'exifcamerainfo' => { 59 => 0xe8 },
	'exifimageheight' => { 53 => 0xa003, 169 => 'PixelYDimension' },
	'exifimagewidth' => { 53 => 0xa002, 169 => 'PixelXDimension' },
	'exifversion' => { 53 => 0x9000, 169 => 'ExifVersion' },
	'expirationdate' => { 59 => 0x25 },
	'expirationtime' => { 59 => 0x26 },
	'exposure' => { 53 => 0xfe51, 166 => 'Exposure' },
	'exposurebracketstepsize' => { 147 => 0x8 },
	'exposurebracketvalue' => { 105 => 0x19 },
	'exposurecompensation' => { 27 => 0x6, 39 => 0x0, 53 => 0x9204, 64 => 0x24, 75 => 'ExposureComp', 89 => 0xd, 90 => 0x53, 91 => 0x1e, 92 => 0x1, 129 => 0x1006, 145 => 0x16, 158 => [0xc,0x35], 169 => 'ExposureBiasValue' },
	'exposuredifference' => { 105 => 0xe },
	'exposureindex' => { 53 => 0xa215, 169 => 'ExposureIndex' },
	'exposurelevelincrements' => { 28 => 0x6, 29 => 0x6, 30 => 0x101, 31 => 0x5, 32 => 0x6, 33 => 0x5, 34 => 0x5, 35 => 0x6, 36 => 0x4 },
	'exposuremode' => { 53 => 0xa402, 75 => 'ExposureMode', 89 => 0x1, 90 => 0xa, 91 => 0x0, 92 => 0x0, 124 => 0x200, 158 => 0x8, 159 => 0xb041, 169 => 'ExposureMode' },
	'exposuremodeinmanual' => { 30 => 0x10b },
	'exposureprogram' => { 53 => 0x8822, 169 => 'ExposureProgram' },
	'exposuretime' => { 1 => 0x4, 2 => 0x4, 3 => 0x4, 4 => 0x4, 6 => 0x4, 7 => 0x6, 27 => 0x16, 53 => 0x829a, 63 => 0xfd05, 64 => 0x20, 65 => 0xfa24, 67 => 0xf104, 71 => 0x38, 75 => 'ExposureTime', 89 => 0x9, 90 => 0x35, 91 => 0x48, 145 => 0x12, 158 => 0x32, 169 => 'ExposureTime' },
	'exposuretime2' => { 158 => 0x33 },
	'exposurewarning' => { 57 => 0x1302 },
	'extendedwbdetect' => { 124 => 0x902 },
	'extender' => { 125 => 0x301 },
	'extenderfirmwareversion' => { 125 => 0x304 },
	'extendermagnification' => { 77 => 'Magnification' },
	'extendermake' => { 77 => 'Make' },
	'extendermodel' => { 77 => 'Model', 125 => 0x303 },
	'extenderserialnumber' => { 77 => 'SerialNumber', 125 => 0x302 },
	'externalflash' => { 127 => 0x1201 },
	'externalflashae1' => { 129 => 0x101f },
	'externalflashae1_0' => { 129 => 0x101b },
	'externalflashae2' => { 129 => 0x1020 },
	'externalflashae2_0' => { 129 => 0x101c },
	'externalflashbounce' => { 127 => 0x1204, 129 => 0x1026 },
	'externalflashguidenumber' => { 127 => 0x1203 },
	'externalflashgvalue' => { 129 => 0x1025 },
	'externalflashmode' => { 129 => 0x1028, 143 => 0x2 },
	'externalflashzoom' => { 127 => 0x1205, 129 => 0x1027 },
	'face0position' => { 16 => 0x8 },
	'face1position' => { 16 => 0xa },
	'face2position' => { 16 => 0xc },
	'face3position' => { 16 => 0xe },
	'face4position' => { 16 => 0x10 },
	'face5position' => { 16 => 0x12 },
	'face6position' => { 16 => 0x14 },
	'face7position' => { 16 => 0x16 },
	'face8position' => { 16 => 0x18 },
	'facedetect' => { 128 => 0x1200 },
	'facedetectarea' => { 128 => 0x1201 },
	'facedetectframeheight' => { 16 => 0x4 },
	'facedetectframewidth' => { 16 => 0x3 },
	'facesdetected' => { 16 => 0x2, 17 => 0x2 },
	'ffid' => { 168 => 'ffid' },
	'fieldcount' => { 129 => 0x103f },
	'filedatarate' => { 176 => 'fileDataRate' },
	'fileformat' => { 41 => 0x0, 60 => 0x14 },
	'filemodifydate' => { 54 => 'FileModifyDate' },
	'filename' => { 54 => 'FileName' },
	'filenumber' => { 3 => 0x172, 18 => 0x1, 21 => 0x8, 43 => 0x1817 },
	'filenumbermemory' => { 89 => 0x1a },
	'filesource' => { 53 => 0xa300, 57 => 0x8000, 169 => 'FileSource' },
	'fileversion' => { 60 => 0x16 },
	'fillflashautoreduction' => { 28 => 0xe, 29 => 0xe, 36 => 0xa },
	'filllight' => { 166 => 'FillLight' },
	'fillorder' => { 53 => 0x10a },
	'filmmode' => { 57 => 0x1401, 136 => 0x42 },
	'filmtype' => { 110 => 0x2 },
	'filter' => { 50 => 0x3017 },
	'filtereffect' => { 18 => 0xe, 107 => 0x37 },
	'filtereffectmonochrome' => { 6 => 0xff },
	'finderdisplayduringexposure' => { 29 => 0x1 },
	'firmware' => { 129 => 0x405, 158 => [0x17,0x3b], 164 => 'Firmware' },
	'firmwaredate' => { 50 => 0x2001 },
	'firmwareid' => { 94 => 0x0 },
	'firmwarerevision' => { 6 => 0xa4, 21 => 0x1e },
	'firmwareversion' => { 3 => 0x136, 5 => 0xff, 75 => 'FirmwareVersion', 136 => 0x2 },
	'fixtureidentifier' => { 59 => 0x16 },
	'flash' => { 53 => 0x9209, 90 => 0x1f, 91 => 0x15 },
	'flashactivity' => { 8 => 0x1c },
	'flashadump' => { 145 => 0x20a },
	'flashbdump' => { 145 => 0x20b },
	'flashbias' => { 136 => 0x24 },
	'flashbits' => { 8 => 0x1d },
	'flashchargelevel' => { 129 => 0x1010 },
	'flashcommandermode' => { 101 => '9.1' },
	'flashcompensation' => { 164 => 'FlashCompensation' },
	'flashcontrolmode' => { 101 => '9.2' },
	'flashdevice' => { 129 => 0x1005 },
	'flashdistance' => { 50 => 0x2034 },
	'flashenergy' => { 53 => 0xa20b, 169 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 105 => 0x18 },
	'flashexposurecomp' => { 27 => 0xf, 57 => 0x1011, 78 => 'ExposureComp', 89 => 0x23, 93 => 0x104, 101 => 0xa, 105 => 0x12, 129 => 0x1023, 145 => 0x4d, 158 => 0x3a },
	'flashexposurecompensation' => { 124 => 0x401 },
	'flashfired' => { 64 => 0x5d, 78 => 'Fired', 89 => 0x14, 169 => 'FlashFired' },
	'flashfiring' => { 30 => 0x306, 31 => 0x6, 32 => 0x7, 35 => 0x7 },
	'flashfirmwareversion' => { 125 => 0x1002 },
	'flashfocallength' => { 101 => 0xb },
	'flashfunction' => { 169 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 101 => 0xf },
	'flashgroupaexposurecomp' => { 101 => 0x11 },
	'flashgroupaoutput' => { 101 => 0x11 },
	'flashgroupbcontrolmode' => { 101 => 0x10 },
	'flashgroupbexposurecomp' => { 101 => 0x12 },
	'flashgroupboutput' => { 101 => 0x12 },
	'flashguidenumber' => { 27 => 0xd, 40 => 0x0, 78 => 'GuideNumber' },
	'flashinfoversion' => { 101 => 0x0 },
	'flashintensity' => { 49 => [0x19,0x5] },
	'flashmake' => { 78 => 'Make' },
	'flashmanufacturer' => { 163 => 'FlashManufacturer' },
	'flashmetering' => { 89 => 0x3f },
	'flashmode' => { 49 => 0x4, 64 => 0x5c, 78 => 'Mode', 89 => 0x2, 90 => 0x20, 91 => 0x16, 105 => 0x87, 124 => 0x400, 129 => 0x1004, 145 => 0xc, 148 => 0x4, 155 => 0x20, 157 => 0x225, 169 => 'FlashMode' },
	'flashmodecode' => { 143 => 0x1 },
	'flashmodel' => { 78 => 'Model', 125 => 0x1001, 163 => 'FlashModel' },
	'flashoutput' => { 27 => 0x21, 101 => 0xa },
	'flashpixversion' => { 53 => 0xa000, 169 => 'FlashpixVersion' },
	'flashredeyemode' => { 169 => 'FlashRedEyeMode' },
	'flashreturn' => { 169 => 'FlashReturn' },
	'flashserialnumber' => { 78 => 'SerialNumber', 125 => 0x1003 },
	'flashsetting' => { 105 => 0x8 },
	'flashstatus' => { 143 => 0x0 },
	'flashsyncspeedav' => { 28 => 0x3, 30 => 0x10f, 31 => 0x2, 32 => 0x3, 33 => 0x2, 34 => 0x2, 35 => 0x3, 36 => 0x6 },
	'flashthreshold' => { 40 => 0x1 },
	'flashtype' => { 78 => 'Type', 105 => 0x9, 125 => 0x1000 },
	'flickerreduce' => { 157 => 0x218 },
	'fliphorizontal' => { 118 => 0x76a43206 },
	'fnumber' => { 3 => 0x3, 6 => 0x3, 7 => 0x5, 27 => 0x15, 53 => 0x829d, 63 => 0xfd04, 64 => 0x1e, 65 => 0xfa23, 67 => 0xf103, 71 => 0x3c, 82 => 'FNumber', 89 => 0xa, 90 => 0x36, 91 => 0x47, 145 => 0x13, 158 => 0x31, 169 => 'FNumber' },
	'focallength' => { 1 => 0xa, 2 => 0x9, 3 => 0x1d, 4 => 0x9, 5 => 0x1d, 6 => 0x28, 20 => 0x1, 50 => 0x1d, 53 => 0x920a, 82 => 'FocalLength', 89 => 0x12, 145 => 0x1d, 169 => 'FocalLength' },
	'focallengthin35mmformat' => { 53 => 0xa405, 169 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 125 => 0x103, 129 => 0x205 },
	'focalplaneresolutionunit' => { 53 => 0xa210, 169 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 53 => 0xa20e, 169 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 20 => 0x2 },
	'focalplaneyresolution' => { 53 => 0xa20f, 169 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 20 => 0x3 },
	'focaltype' => { 2 => 0x2d, 20 => 0x0 },
	'focalunits' => { 8 => 0x19 },
	'focus' => { 111 => 0x8 },
	'focusarea' => { 89 => 0x31 },
	'focuscontinuous' => { 8 => 0x20 },
	'focusdistance' => { 82 => 'FocusDistance', 89 => 0x13, 127 => 0x305 },
	'focusdistancelower' => { 3 => 0x45, 5 => 0x45, 27 => 0x14 },
	'focusdistanceupper' => { 3 => 0x43, 5 => 0x43, 27 => 0x13 },
	'focusinfoversion' => { 127 => 0x0 },
	'focusingscreen' => { 29 => 0x0, 30 => 0x80b, 35 => 0x0 },
	'focusmode' => { 8 => 0x7, 49 => 0x3, 50 => [0x3003,0xd], 57 => 0x1021, 64 => 0x38, 75 => 'FocusMode', 89 => 0x30, 91 => 0xe, 105 => 0x7, 124 => 0x301, 129 => 0x100b, 136 => 0x7, 145 => 0xd, 148 => 0x3 },
	'focuspixel' => { 57 => 0x1023 },
	'focusposition' => { 145 => 0x10 },
	'focusprocess' => { 124 => 0x302 },
	'focusrange' => { 8 => 0x12, 129 => 0x100a },
	'focussetting' => { 158 => 0x6 },
	'focusstepcount' => { 127 => 0x301, 129 => 0x100e },
	'focusstepinfinity' => { 127 => 0x303 },
	'focusstepnear' => { 127 => 0x304 },
	'focuswarning' => { 57 => 0x1301 },
	'foldername' => { 89 => 0x27 },
	'fontschildfontfiles' => { 180 => 'FontsChildFontFiles' },
	'fontscomposite' => { 180 => 'FontsComposite' },
	'fontsfontface' => { 180 => 'FontsFontFace' },
	'fontsfontfamily' => { 180 => 'FontsFontFamily' },
	'fontsfontfilename' => { 180 => 'FontsFontFileName' },
	'fontsfontname' => { 180 => 'FontsFontName' },
	'fontsfonttype' => { 180 => 'FontsFontType' },
	'fontsversionstring' => { 180 => 'FontsVersionString' },
	'for' => { 154 => 'For' },
	'format' => { 167 => 'format' },
	'framenum' => { 149 => 0xd7 },
	'framenumber' => { 57 => 0x8003, 145 => 0x29 },
	'freebytes' => { 43 => 0x1 },
	'freememorycardimages' => { 90 => [0x37,0x54], 91 => [0x2d,0x4a] },
	'fujiflashmode' => { 57 => 0x1010 },
	'fullsizeimage' => { 81 => 'data' },
	'fullsizeimagename' => { 81 => '1Name' },
	'fullsizeimagetype' => { 81 => '0Type' },
	'gainbase' => { 128 => 0x610 },
	'gaincontrol' => { 53 => 0xa407, 169 => 'GainControl' },
	'gamma' => { 53 => 0xa500 },
	'gammacompensatedvalue' => { 61 => 0x91 },
	'genre' => { 176 => 'genre' },
	'globalaltitude' => { 152 => 0x419 },
	'globalangle' => { 152 => 0x40d },
	'gpsaltitude' => { 58 => 0x6, 79 => 'Altitude', 169 => 'GPSAltitude' },
	'gpsaltituderef' => { 58 => 0x5, 169 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 58 => 0x1c, 169 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 58 => 0x1d },
	'gpsdatetime' => { 79 => 'DateTime', 169 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 58 => 0x18, 79 => 'Bearing', 169 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 58 => 0x17, 169 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 58 => 0x1a, 79 => 'Distance', 169 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 58 => 0x19, 169 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 58 => 0x14, 169 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 58 => 0x13 },
	'gpsdestlongitude' => { 58 => 0x16, 169 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 58 => 0x15 },
	'gpsdifferential' => { 58 => 0x1e, 79 => 'Differential', 169 => 'GPSDifferential' },
	'gpsdop' => { 58 => 0xb, 169 => 'GPSDOP' },
	'gpsimgdirection' => { 58 => 0x11, 169 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 58 => 0x10, 169 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 58 => 0x2, 79 => 'Latitude', 169 => 'GPSLatitude' },
	'gpslatituderef' => { 58 => 0x1 },
	'gpslongitude' => { 58 => 0x4, 79 => 'Longitude', 169 => 'GPSLongitude' },
	'gpslongituderef' => { 58 => 0x3 },
	'gpsmapdatum' => { 58 => 0x12, 79 => 'Datum', 169 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 58 => 0xa, 79 => 'MeasureMode', 169 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 58 => 0x1b, 169 => 'GPSProcessingMethod' },
	'gpssatellites' => { 58 => 0x8, 79 => 'Satellites', 169 => 'GPSSatellites' },
	'gpsspeed' => { 58 => 0xd, 79 => 'Speed', 169 => 'GPSSpeed' },
	'gpsspeedref' => { 58 => 0xc, 169 => 'GPSSpeedRef' },
	'gpsstatus' => { 58 => 0x9, 169 => 'GPSStatus' },
	'gpstimestamp' => { 58 => 0x7 },
	'gpstrack' => { 58 => 0xf, 79 => 'Heading', 169 => 'GPSTrack' },
	'gpstrackref' => { 58 => 0xe, 169 => 'GPSTrackRef' },
	'gpsversionid' => { 58 => 0x0, 169 => 'GPSVersionID' },
	'gradation' => { 124 => 0x50f },
	'grayresponseunit' => { 53 => 0x122 },
	'greencurvelimits' => { 47 => 0x1c4 },
	'greencurvepoints' => { 47 => 0x19a },
	'greenhue' => { 166 => 'GreenHue' },
	'greensaturation' => { 166 => 'GreenSaturation' },
	'halftonehints' => { 53 => 0x141 },
	'hascrop' => { 166 => 'HasCrop' },
	'hassettings' => { 166 => 'HasSettings' },
	'headline' => { 59 => 0x69, 172 => 'Headline' },
	'hierarchicalsubject' => { 161 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 30 => 0x202, 105 => 0xb1 },
	'highlight' => { 158 => 0xf },
	'highlightrecovery' => { 166 => 'HighlightRecovery' },
	'highlighttonepriority' => { 30 => 0x203 },
	'history' => { 172 => 'History' },
	'historyaction' => { 177 => 'HistoryAction' },
	'historyinstanceid' => { 177 => 'HistoryInstanceID' },
	'historyparameters' => { 177 => 'HistoryParameters' },
	'historysoftwareagent' => { 177 => 'HistorySoftwareAgent' },
	'historywhen' => { 177 => 'HistoryWhen' },
	'hometowncity' => { 50 => 0x3006, 145 => 0x23 },
	'hometowncitycode' => { 148 => 0x1000 },
	'hometowndst' => { 145 => 0x25 },
	'hostcomputer' => { 53 => 0x13c },
	'hue' => { 95 => 0x3b },
	'hueadjustment' => { 90 => 0x4a, 91 => 0x40, 105 => 0x92, 107 => 0x36 },
	'hueadjustmentaqua' => { 166 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 166 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 166 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 166 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 166 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 166 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 166 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 166 => 'HueAdjustmentYellow' },
	'huesetting' => { 132 => 0x1011 },
	'icc_profile' => { 54 => 'ICC_Profile' },
	'iccprofilename' => { 172 => 'ICCProfile' },
	'identifier' => { 167 => 'identifier', 174 => 'Identifier' },
	'imageadjustment' => { 105 => 0x80, 111 => 0x5 },
	'imageareaoffset' => { 145 => 0x38 },
	'imageauthentication' => { 105 => 0x20 },
	'imageboundary' => { 105 => 0x16 },
	'imagecount' => { 105 => 0xa5 },
	'imagedatasize' => { 105 => 0xa2 },
	'imagedescription' => { 53 => 0x10e, 173 => 'ImageDescription' },
	'imagedustoff' => { 118 => 0xfe443a45 },
	'imageheight' => { 53 => 0x101, 94 => 0xc, 173 => 'ImageLength' },
	'imagehistory' => { 53 => 0x9213 },
	'imagenumber' => { 6 => 0xd0, 53 => 0x9211, 75 => 'ImageNumber', 90 => 0xae, 91 => 0x5e, 164 => 'ImageNumber' },
	'imagenumber2' => { 91 => 0x62 },
	'imageoptimization' => { 105 => 0xa9 },
	'imageorientation' => { 59 => 0x83 },
	'imageprocessing' => { 105 => 0x1a, 145 => 0x32 },
	'imageprocessingcount' => { 145 => 0x41 },
	'imageprocessingversion' => { 128 => 0x0 },
	'imagequality' => { 75 => 'ImageQuality', 136 => 0x1 },
	'imagequality2' => { 124 => 0x603 },
	'imagesize' => { 81 => 'ImageSize' },
	'imagesourcedata' => { 53 => 0x935c },
	'imagestabilization' => { 8 => 0x22, 50 => 0x3020, 75 => 'ImageStabilization', 90 => 0xbd, 91 => 0x71, 92 => 0x87, 93 => [0x18,0x107,0x113], 105 => 0xac, 127 => 0x1600, 136 => 0x1a, 159 => 0xb026 },
	'imagetone' => { 145 => 0x4f },
	'imagetype' => { 59 => 0x82 },
	'imageuniqueid' => { 53 => 0xa420, 169 => 'ImageUniqueID' },
	'imagewidth' => { 53 => 0x100, 94 => 0xe, 173 => 'ImageWidth' },
	'incrementaltemperature' => { 166 => 'IncrementalTemperature' },
	'incrementaltint' => { 166 => 'IncrementalTint' },
	'infinitylensstep' => { 129 => 0x103b },
	'infobuttonwhenshooting' => { 30 => 0x409 },
	'inkset' => { 53 => 0x14c },
	'instanceid' => { 177 => 'InstanceID' },
	'instructions' => { 172 => 'Instructions' },
	'instrument' => { 176 => 'instrument' },
	'intellectualgenre' => { 170 => 'IntellectualGenre' },
	'interchangecolorspace' => { 61 => 0x40 },
	'internalflash' => { 89 => 0x2b, 127 => 0x1208 },
	'internalflashae1' => { 129 => 0x1021 },
	'internalflashae1_0' => { 129 => 0x101d },
	'internalflashae2' => { 129 => 0x1022 },
	'internalflashae2_0' => { 129 => 0x101e },
	'internalflashmagni' => { 143 => 0x3 },
	'internalflashtable' => { 129 => 0x1024 },
	'internalserialnumber' => { 21 => 0x96, 57 => 0x10, 125 => 0x102, 136 => 0x25, 141 => 0x4 },
	'interopindex' => { 53 => 0x1 },
	'interopversion' => { 53 => 0x2 },
	'intervallength' => { 89 => 0x10 },
	'intervalmode' => { 89 => 0x26 },
	'intervalnumber' => { 89 => 0x11 },
	'introtime' => { 176 => 'introTime' },
	'iptc-naa' => { 53 => 0x83bb },
	'iptcbitspersample' => { 61 => 0x56 },
	'iptcimageheight' => { 61 => 0x1e },
	'iptcimagerotation' => { 61 => 0x66 },
	'iptcimagewidth' => { 61 => 0x14 },
	'iptcpicturenumber' => { 61 => 0xa },
	'iptcpixelheight' => { 61 => 0x32 },
	'iptcpixelwidth' => { 61 => 0x28 },
	'iso' => { 2 => 0x75, 3 => 0x6, 4 => 0x79, 6 => 0x6, 7 => 0x0, 49 => 0x14, 50 => [0x3014,0x14], 53 => 0x8827, 63 => 0xfd06, 64 => 0x60, 65 => [0xfa2e,0xfa46], 66 => [0x27,0x28], 67 => 0xf105, 71 => 0x4e, 75 => 'ISO', 89 => 0x8, 103 => 0x0, 105 => 0x2, 137 => 0x17, 145 => 0x14, 148 => 0x14, 169 => 'ISOSpeedRatings' },
	'iso2' => { 103 => 0x6 },
	'isoexpansion' => { 30 => 0x103, 31 => 0x7, 32 => 0x8, 35 => 0x8, 103 => 0x4 },
	'isoexpansion2' => { 103 => 0xa },
	'isofloor' => { 147 => 0x6 },
	'isoselection' => { 105 => 0xf },
	'isosetting' => { 64 => 0x5e, 75 => 'ISOSetting', 89 => 0x24, 90 => 0x26, 91 => 0x1c, 95 => 0x6, 105 => 0x13, 155 => 0x27 },
	'isospeedexpansion' => { 29 => 0x3 },
	'isospeedincrements' => { 30 => 0x102 },
	'isospeedrange' => { 30 => 0x103 },
	'isovalue' => { 129 => 0x1001 },
	'jobid' => { 59 => 0xb8 },
	'jobrefid' => { 175 => 'JobRefId' },
	'jobrefname' => { 175 => 'JobRefName' },
	'jobrefurl' => { 175 => 'JobRefUrl' },
	'jpegquality' => { 2 => 0x66 },
	'jpgfromraw' => { 43 => 0x2007, 51 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 53 => [0x117,0x202] },
	'jpgfromrawstart' => { 53 => [0x111,0x201] },
	'jpgrecordedpixels' => { 147 => 0xe },
	'key' => { 176 => 'key' },
	'keywords' => { 59 => 0x19, 76 => 'Keywords', 133 => 'Keywords', 154 => 'Keywords', 171 => 'Keywords' },
	'kodakimageheight' => { 63 => 0xf908, 64 => 0xe, 65 => [0xfa1e,0xfa52], 70 => 0x70 },
	'kodakimagewidth' => { 63 => 0xf907, 64 => 0xc, 65 => [0xfa1d,0xfa51], 70 => 0x6c },
	'kodakinfotype' => { 63 => 0xfa00 },
	'kodakmaker' => { 70 => 0x8 },
	'kodakmodel' => { 64 => 0x0, 70 => 0x28 },
	'label' => { 135 => 'Label', 174 => 'Label' },
	'language' => { 167 => 'language' },
	'languageidentifier' => { 59 => 0x87 },
	'lastfilenumber' => { 89 => 0x1b },
	'lastkeywordiptc' => { 163 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 163 => 'LastKeywordXMP' },
	'lasturl' => { 177 => 'LastURL' },
	'lcddisplayatpoweron' => { 34 => 0xa },
	'lcddisplayreturntoshoot' => { 35 => 0x12 },
	'lcdilluminationduringbulb' => { 30 => 0x408 },
	'lcdpanels' => { 29 => 0x8 },
	'lcheditor' => { 118 => 0x8ae85e },
	'legacyiptcdigest' => { 172 => 'LegacyIPTCDigest' },
	'lens' => { 53 => 0xfdea, 105 => 0x84, 158 => 0xa, 164 => 'Lens' },
	'lensafstopbutton' => { 28 => 0x11, 29 => 0x13, 30 => 0x506, 31 => 0x10, 32 => 0x12, 35 => 0x13, 36 => 0x9 },
	'lensaperturerange' => { 158 => 0x30 },
	'lenscodes' => { 144 => [0x4,0x5] },
	'lensdataversion' => { 104 => 0x0 },
	'lensdistortionparams' => { 129 => 0x206 },
	'lensdrivenoaf' => { 30 => 0x505 },
	'lensfirmwareversion' => { 125 => 0x204 },
	'lensfstops' => { 104 => 0x7, 105 => 0x8b },
	'lensid' => { 93 => 0x10c, 159 => 0xb027 },
	'lensidnumber' => { 104 => 0x6 },
	'lensinfo' => { 164 => 'LensInfo' },
	'lensmake' => { 82 => 'Make' },
	'lensmanufacturer' => { 163 => 'LensManufacturer' },
	'lensmodel' => { 82 => 'Model', 163 => 'LensModel' },
	'lensproperties' => { 125 => 0x20b },
	'lensserialnumber' => { 82 => 'SerialNumber', 125 => 0x202, 136 => 0x52 },
	'lenstemperature' => { 129 => 0x1008 },
	'lenstype' => { 1 => 0xd, 2 => 0xd, 3 => 0x112, 4 => 0xd, 5 => 0xd7, 6 => [0xd,0x98], 8 => 0x16, 21 => 0x95, 105 => 0x83, 125 => 0x201, 136 => 0x51, 144 => 0x0, 145 => 0x3f },
	'license' => { 165 => 'license' },
	'licensetype' => { 168 => 'licensetype' },
	'lightcondition' => { 129 => 0x1009 },
	'lightreading' => { 145 => 0x15 },
	'lightsource' => { 53 => 0x9208, 105 => 0x90, 132 => 0x1000, 169 => 'LightSource' },
	'lightsourcespecial' => { 157 => 0x21d },
	'lightvaluecenter' => { 129 => 0x103d },
	'lightvalueperiphery' => { 129 => 0x103e },
	'linearresponselimit' => { 53 => 0xc62e },
	'liveviewexposuresimulation' => { 30 => 0x810 },
	'localcaption' => { 59 => 0x79 },
	'localizedcameramodel' => { 53 => 0xc615 },
	'location' => { 162 => 'Location', 170 => 'Location' },
	'lockmicrophonebutton' => { 30 => 0x709 },
	'logcomment' => { 176 => 'logComment' },
	'longexposurenoisereduction' => { 30 => 0x201, 31 => 0x1, 32 => 0x2, 33 => 0x1, 34 => 0x1, 35 => 0x2, 36 => 0x1, 159 => 0xb04e },
	'longfocal' => { 1 => 0x10, 2 => 0x13, 3 => 0x115, 4 => 0x13, 5 => 0xda, 6 => 0x95, 8 => 0x17 },
	'loop' => { 176 => 'loop' },
	'luminanceadjustmentaqua' => { 166 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 166 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 166 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 166 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 166 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 166 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 166 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 166 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 48 => 0xbe },
	'luminancesmoothing' => { 166 => 'LuminanceSmoothing' },
	'macro' => { 57 => 0x1020, 129 => 0x202, 155 => 0x21, 157 => 0x202, 159 => 0xb040 },
	'macromode' => { 8 => 0x1, 89 => 0xb, 124 => 0x300, 136 => 0x1c },
	'magnifiedview' => { 32 => 0x11, 34 => 0x9 },
	'make' => { 44 => 0x0, 53 => 0x10f, 75 => 'Make', 135 => 'Make', 137 => 0x10f, 173 => 'Make' },
	'makernote' => { 169 => 'MakerNote' },
	'makernotecanon' => { 52 => 'MakN', 53 => 0x927c },
	'makernotecasio' => { 52 => 'MakN', 53 => 0x927c },
	'makernotecasio2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotefujifilm' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp6' => { 52 => 'MakN', 53 => 0x927c },
	'makernotejvc' => { 52 => 'MakN', 53 => 0x927c },
	'makernotejvctext' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak1a' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak1b' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak5' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak6a' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak6b' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak7' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodakifd' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodakunknown' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekyocera' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteleica' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteminolta' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteminolta2' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteminolta3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotenikon' => { 52 => 'MakN', 53 => 0x927c },
	'makernotenikon2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotenikon3' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteoffset' => { 157 => 0xff },
	'makernoteolympus' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteolympus2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepanasonic' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepanasonic2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotericoh' => { 52 => 'MakN', 53 => 0x927c },
	'makernotericohtext' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesafety' => { 53 => 0xc635 },
	'makernotesanyo' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesanyoc4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesanyopatch' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesigma' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesony' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesony2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesonysrf' => { 52 => 'MakN', 53 => 0x927c },
	'makernotetype' => { 156 => 0x1 },
	'makernoteunknown' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteversion' => { 93 => 0x0, 105 => 0x1, 129 => 0x0, 136 => 0x8000, 156 => 0x2, 158 => 0x1d },
	'managedfromdocumentid' => { 177 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 177 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 177 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 177 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 177 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 177 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 177 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 177 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 177 => 'ManagedFromVersionID' },
	'manager' => { 177 => 'Manager' },
	'managervariant' => { 177 => 'ManagerVariant' },
	'manageto' => { 177 => 'ManageTo' },
	'manageui' => { 177 => 'ManageUI' },
	'manometerpressure' => { 124 => 0x900 },
	'manometerreading' => { 124 => 0x901 },
	'manualflash' => { 127 => 0x1209 },
	'manualflashoutput' => { 8 => 0x29 },
	'manualfocusdistance' => { 105 => 0x85, 129 => 0x100c, 157 => 0x223 },
	'manualtv' => { 29 => 0x5, 30 => 0x705 },
	'manufacturedate' => { 141 => 0x1 },
	'marked' => { 179 => 'Marked' },
	'markerscomment' => { 176 => 'markersComment' },
	'markersduration' => { 176 => 'markersDuration' },
	'markerslocation' => { 176 => 'markersLocation' },
	'markersname' => { 176 => 'markersName' },
	'markersstarttime' => { 176 => 'markersStartTime' },
	'markerstarget' => { 176 => 'markersTarget' },
	'markerstype' => { 176 => 'markersType' },
	'maskedareas' => { 53 => 0xc68e },
	'masterdocumentid' => { 59 => 0xb9 },
	'mastergain' => { 110 => 0x50 },
	'maxaperture' => { 8 => 0x1a, 67 => 0x6103, 82 => 'MaxAperture', 89 => 0x17 },
	'maxapertureatcurrentfocal' => { 125 => 0x20a },
	'maxapertureatmaxfocal' => { 57 => 0x1407, 82 => 'MaxApertureAtMaxFocal', 104 => 0xb, 125 => 0x206 },
	'maxapertureatminfocal' => { 57 => 0x1406, 104 => 0xa, 125 => 0x205 },
	'maxaperturevalue' => { 53 => 0x9205, 169 => 'MaxApertureValue' },
	'maxfocallength' => { 57 => 0x1405, 82 => 'MaxFocalLength', 104 => 0x9, 125 => 0x208 },
	'maximumdensityrange' => { 61 => 0x8c },
	'maxpagesizeh' => { 180 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 180 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 180 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 53 => 0x119 },
	'mcuversion' => { 104 => 0xc },
	'md5digest' => { 83 => 'zmd5' },
	'measuredev' => { 27 => 0x3, 43 => 0x1814, 75 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 28 => 0xb, 31 => 0xa, 32 => 0xb, 35 => 0xb },
	'menubuttonreturn' => { 36 => 0xb },
	'metadatadate' => { 174 => 'MetadataDate' },
	'metadatamoddate' => { 176 => 'metadataModDate' },
	'meteringmode' => { 8 => 0x11, 53 => 0x9207, 64 => 0x1c, 89 => 0x7, 90 => 0x25, 124 => 0x202, 145 => 0x17, 158 => 0x9, 169 => 'MeteringMode' },
	'mieversion' => { 83 => '0Vers' },
	'minaperture' => { 8 => 0x1b, 82 => 'MinAperture' },
	'minfocallength' => { 57 => 0x1404, 82 => 'MinFocalLength', 104 => 0x8, 125 => 0x207 },
	'minoltadate' => { 89 => 0x15 },
	'minoltaimagesize' => { 89 => 0x4, 90 => 0xc, 91 => 0x2, 93 => 0x103 },
	'minoltamodelid' => { 89 => 0x25 },
	'minoltaquality' => { 89 => 0x5, 90 => 0xd, 91 => 0x3, 93 => [0x102,0x103], 129 => [0x102,0x103] },
	'minoltatime' => { 89 => 0x16 },
	'minsamplevalue' => { 53 => 0x118 },
	'mirrorlockup' => { 28 => 0xc, 29 => 0xc, 30 => 0x60f, 31 => 0xb, 32 => 0xc, 33 => 0x6, 34 => 0x6, 35 => 0xc, 36 => 0x3 },
	'moddate' => { 171 => 'ModDate' },
	'model' => { 44 => 0x6, 53 => 0x110, 75 => 'Model', 135 => 'Model', 137 => 0x110, 173 => 'Model' },
	'modelrevision' => { 141 => 0x2 },
	'modifiedcolortemp' => { 22 => 0x9 },
	'modifieddigitalgain' => { 22 => 0xb },
	'modifiedparamflag' => { 19 => 0x1 },
	'modifiedpicturestyle' => { 22 => 0xa },
	'modifiedsaturation' => { 124 => 0x504 },
	'modifiedsensorbluelevel' => { 22 => 0x5 },
	'modifiedsensorredlevel' => { 22 => 0x4 },
	'modifiedsharpness' => { 22 => 0x2 },
	'modifiedsharpnessfreq' => { 22 => 0x3 },
	'modifiedtonecurve' => { 22 => 0x1 },
	'modifiedwhitebalance' => { 22 => 0x8 },
	'modifiedwhitebalanceblue' => { 22 => 0x7 },
	'modifiedwhitebalancered' => { 22 => 0x6 },
	'modifydate' => { 53 => 0x132, 76 => 'ModifyDate', 133 => 'ModDate', 134 => 'tIME', 154 => 'ModDate', 174 => 'ModifyDate' },
	'moirefilter' => { 53 => 0xfe58 },
	'monochromecontrast' => { 48 => 0x78 },
	'monochromefiltereffect' => { 48 => 0x74 },
	'monochromelinear' => { 48 => 0x7a },
	'monochromesharpness' => { 48 => 0x7c },
	'monochrometoningeffect' => { 48 => 0x76 },
	'monthdaycreated' => { 64 => 0x12, 71 => 0xe },
	'multiexposureautogain' => { 106 => 0x3 },
	'multiexposuremode' => { 106 => 0x1 },
	'multiexposureshots' => { 106 => 0x2 },
	'multiexposureversion' => { 106 => 0x0 },
	'multisample' => { 110 => 0x40 },
	'mycolormode' => { 23 => 0x2 },
	'nativedigest' => { 169 => 'NativeDigest', 173 => 'NativeDigest' },
	'ndfilter' => { 27 => 0x1c },
	'nearlensstep' => { 129 => 0x103c },
	'nefcompression' => { 105 => 0x93 },
	'newsphotoversion' => { 61 => 0x0 },
	'nickname' => { 174 => 'Nickname' },
	'nikoncaptureversion' => { 105 => 0xe09 },
	'noisefilter' => { 124 => 0x527 },
	'noisereduction' => { 18 => 0x8, 57 => 0x100b, 90 => 0xb0, 91 => 0x60, 92 => 0x3f, 105 => 0x95, 118 => 0x753dcbc0, 124 => 0x50a, 129 => 0x103a, 136 => 0x2d, 145 => 0x49 },
	'noisereduction2' => { 128 => 0x1010 },
	'noisereductionintensity' => { 119 => 0x9 },
	'noisereductionmethod' => { 119 => 0x11 },
	'noisereductionsharpness' => { 119 => 0xd },
	'npages' => { 180 => 'NPages' },
	'nullrecord' => { 43 => 0x0 },
	'numberofbeats' => { 176 => 'numberOfBeats' },
	'numindexentries' => { 61 => 0x54 },
	'objectattributereference' => { 59 => 0x4 },
	'objectcycle' => { 59 => 0x4b },
	'objectdistance' => { 49 => 0x6, 50 => 0x2022 },
	'objectname' => { 59 => 0x5 },
	'objectpreviewdata' => { 59 => 0xca },
	'objectpreviewfileformat' => { 59 => 0xc8 },
	'objectpreviewfileversion' => { 59 => 0xc9 },
	'objecttypereference' => { 59 => 0x3 },
	'oecfcolumns' => { 169 => 'OECFColumns' },
	'oecfnames' => { 169 => 'OECFNames' },
	'oecfrows' => { 169 => 'OECFRows' },
	'oecfvalues' => { 169 => 'OECFValues' },
	'offsetschema' => { 53 => 0xea1d },
	'oldsubfiletype' => { 53 => 0xff },
	'olympusimageheight' => { 129 => 0x102f },
	'olympusimagewidth' => { 129 => 0x102e },
	'onetouchwb' => { 129 => 0x302 },
	'opticalzoom' => { 65 => 0xfa3d, 67 => [0x6006,0xf006], 68 => 0x1000, 69 => 0xf, 71 => 0x1e, 82 => 'OpticalZoom' },
	'opticalzoomcode' => { 27 => 0xa },
	'opticalzoommode' => { 136 => 0x34 },
	'opticalzoomon' => { 157 => 0x219 },
	'ordernumber' => { 57 => 0x8002 },
	'orientation' => { 53 => 0x112, 137 => 0x112, 173 => 'Orientation' },
	'originaldecisiondata' => { 51 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 21 => 0x83 },
	'originalfilename' => { 43 => 0x816, 72 => 0x20 },
	'originalimageheight' => { 56 => 0x1 },
	'originalimagewidth' => { 56 => 0x0 },
	'originalrawfiledata' => { 53 => 0xc68c },
	'originalrawfilename' => { 53 => 0xc68b },
	'originaltransmissionreference' => { 59 => 0x67 },
	'originatingprogram' => { 59 => 0x41 },
	'os' => { 168 => 'os' },
	'outcue' => { 176 => 'outCue' },
	'outputheight' => { 115 => 0xce },
	'outputheightinches' => { 115 => 0x96 },
	'outputpixels' => { 115 => 0xd6 },
	'outputresolution' => { 115 => 0xb6 },
	'outputwidth' => { 115 => 0xc6 },
	'outputwidthinches' => { 115 => 0x8e },
	'owner' => { 179 => 'Owner' },
	'ownerid' => { 59 => 0xbc },
	'ownername' => { 21 => 0x9, 43 => 0x810, 53 => 0xfde8, 75 => 'OwnerName', 164 => 'OwnerName' },
	'padding' => { 53 => 0xea1c },
	'pagename' => { 53 => 0x11d },
	'pagenumber' => { 53 => 0x129 },
	'panasonicexifversion' => { 136 => 0x26 },
	'panasonicrawversion' => { 137 => 0x1 },
	'panoramadirection' => { 24 => 0x5 },
	'panoramaframe' => { 24 => 0x2 },
	'panoramamode' => { 64 => 0x3c, 124 => 0x601 },
	'parametricdarks' => { 166 => 'ParametricDarks' },
	'parametrichighlights' => { 166 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 166 => 'ParametricHighlightSplit' },
	'parametriclights' => { 166 => 'ParametricLights' },
	'parametricmidtonesplit' => { 166 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 166 => 'ParametricShadows' },
	'parametricshadowsplit' => { 166 => 'ParametricShadowSplit' },
	'patientid' => { 160 => 'PatientID' },
	'patientsbirthdate' => { 160 => 'PatientDOB' },
	'patientsname' => { 160 => 'PatientName' },
	'patientssex' => { 160 => 'PatientSex' },
	'pdfversion' => { 171 => 'PDFVersion' },
	'pentaximagesize' => { 145 => 0x9 },
	'pentaxmodelid' => { 141 => 0x0, 145 => 0x5 },
	'pentaxmodeltype' => { 145 => 0x1 },
	'pentaxversion' => { 145 => 0x0 },
	'people' => { 162 => 'People' },
	'pf0customfuncregistration' => { 38 => 0x1 },
	'pf10retainprogramshift' => { 38 => 0xb },
	'pf13drivepriority' => { 38 => 0xe },
	'pf14disablefocussearch' => { 38 => 0xf },
	'pf15disableafassistbeam' => { 38 => 0x10 },
	'pf16autofocuspointshoot' => { 38 => 0x11 },
	'pf17disableafpointsel' => { 38 => 0x12 },
	'pf18enableautoafpointsel' => { 38 => 0x13 },
	'pf19continuousshootspeed' => { 38 => 0x14 },
	'pf19shootingspeedhigh' => { 37 => 0xa },
	'pf19shootingspeedlow' => { 37 => 0x9 },
	'pf1disableshootingmodes' => { 38 => 0x2 },
	'pf1value' => { 37 => 0x1 },
	'pf20limitcontinousshots' => { 38 => 0x15 },
	'pf20maxcontinousshots' => { 37 => 0xb },
	'pf21enablequietoperation' => { 38 => 0x16 },
	'pf23felocktime' => { 37 => 0xd },
	'pf23postreleasetime' => { 37 => 0xe },
	'pf23settimerlengths' => { 38 => 0x18 },
	'pf23shutterbuttontime' => { 37 => 0xc },
	'pf24lightlcdduringbulb' => { 38 => 0x19 },
	'pf25aemode' => { 37 => 0xf },
	'pf25afmode' => { 37 => 0x12 },
	'pf25afpointsel' => { 37 => 0x13 },
	'pf25colormatrix' => { 37 => 0x17 },
	'pf25defaultclearsettings' => { 38 => 0x1a },
	'pf25drivemode' => { 37 => 0x11 },
	'pf25imagesize' => { 37 => 0x14 },
	'pf25meteringmode' => { 37 => 0x10 },
	'pf25parameters' => { 37 => 0x16 },
	'pf25wbmode' => { 37 => 0x15 },
	'pf26shortenreleaselag' => { 38 => 0x1b },
	'pf27reversedialrotation' => { 38 => 0x1c },
	'pf27value' => { 37 => 0x18 },
	'pf28noquickdialexpcomp' => { 38 => 0x1d },
	'pf29quickdialswitchoff' => { 38 => 0x1e },
	'pf2disablemeteringmodes' => { 38 => 0x3 },
	'pf2value' => { 37 => 0x2 },
	'pf30enlargementmode' => { 38 => 0x1f },
	'pf31originaldecisiondata' => { 38 => 0x20 },
	'pf3manualexposuremetering' => { 38 => 0x4 },
	'pf3value' => { 37 => 0x3 },
	'pf4exposuretimelimits' => { 38 => 0x5 },
	'pf4exposuretimemax' => { 37 => 0x5 },
	'pf4exposuretimemin' => { 37 => 0x4 },
	'pf5aperturelimits' => { 38 => 0x6 },
	'pf5aperturemax' => { 37 => 0x7 },
	'pf5aperturemin' => { 37 => 0x6 },
	'pf6presetshootingmodes' => { 38 => 0x7 },
	'pf7bracketcontinuousshoot' => { 38 => 0x8 },
	'pf8bracketshots' => { 37 => 0x8 },
	'pf8setbracketshots' => { 38 => 0x9 },
	'pf9changebracketsequence' => { 38 => 0xa },
	'phonenumber' => { 76 => 'Phone' },
	'photoeffect' => { 8 => 0x28 },
	'photoeffects' => { 118 => 0xab5eca5e },
	'photoeffectsblue' => { 120 => 0x8 },
	'photoeffectsgreen' => { 120 => 0x6 },
	'photoeffectsred' => { 120 => 0x4 },
	'photoeffectstype' => { 120 => 0x0 },
	'photometricinterpretation' => { 53 => 0x106, 173 => 'PhotometricInterpretation' },
	'photoshopquality' => { 151 => 0x0 },
	'pictinfo' => { 157 => 0x208 },
	'picturecontroladjust' => { 107 => 0x30 },
	'picturecontrolbase' => { 107 => 0x18 },
	'picturecontrolname' => { 107 => 0x4 },
	'picturecontrolquickadjust' => { 107 => 0x31 },
	'picturecontrolversion' => { 107 => 0x0 },
	'picturefinish' => { 90 => 0x71 },
	'picturemode' => { 57 => 0x1031, 124 => 0x520, 145 => [0xb,0x33] },
	'picturemode2' => { 147 => 0x0 },
	'picturemodebwfilter' => { 124 => 0x525 },
	'picturemodecontrast' => { 124 => 0x523 },
	'picturemodehue' => { 124 => 0x522 },
	'picturemodesaturation' => { 124 => 0x521 },
	'picturemodesharpness' => { 124 => 0x524 },
	'picturemodetone' => { 124 => 0x526 },
	'picturestyle' => { 1 => [0x4b,0x51], 2 => 0x6c, 3 => 0x86, 4 => 0x73, 6 => 0x6c, 26 => 0xa, 48 => 0x4 },
	'planarconfiguration' => { 53 => 0x11c, 173 => 'PlanarConfiguration' },
	'platenames' => { 180 => 'PlateNames' },
	'pngwarning' => { 135 => 'Warning' },
	'postalcode' => { 80 => 'PostalCode' },
	'powersource' => { 140 => 0x0 },
	'precaptureframes' => { 129 => 0x300 },
	'predictor' => { 53 => 0x13d },
	'prefs' => { 59 => 0xdd, 150 => 'Prefs' },
	'preservedfilename' => { 177 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 25 => 0x6 },
	'previewfocalplaneyresolution' => { 25 => 0x8 },
	'previewheight' => { 65 => 0xfa58 },
	'previewimage' => { 50 => 0x2000, 51 => 'PreviewImage', 52 => 'MakN', 53 => 0x927c, 55 => 0x4, 85 => 'data', 93 => 0x81, 129 => 0x280, 137 => 0x2e, 159 => 0x2001 },
	'previewimageborders' => { 145 => 0x3e },
	'previewimageheight' => { 25 => 0x4 },
	'previewimagelength' => { 25 => 0x2, 50 => 0x3, 53 => [0x117,0x202], 93 => 0x89, 108 => 0x202, 124 => 0x102, 129 => 0x1037, 145 => 0x3, 155 => 0x1e, 158 => 0x1b },
	'previewimagename' => { 85 => '1Name' },
	'previewimagesize' => { 50 => 0x2, 85 => 'ImageSize', 145 => 0x2, 158 => 0x1c },
	'previewimagestart' => { 25 => 0x5, 50 => 0x4, 53 => [0x111,0x201], 93 => 0x88, 108 => 0x201, 124 => 0x101, 129 => 0x1036, 145 => 0x4, 155 => 0x1c, 158 => 0x1a },
	'previewimagetype' => { 85 => '0Type' },
	'previewimagevalid' => { 124 => 0x100, 129 => 0x1035 },
	'previewimagewidth' => { 25 => 0x3 },
	'previewquality' => { 25 => 0x1 },
	'previewwidth' => { 65 => 0xfa57 },
	'primarychromaticities' => { 53 => 0x13f, 173 => 'PrimaryChromaticities' },
	'printim' => { 53 => 0xc4a5 },
	'privatertkinfo' => { 161 => 'privateRTKInfo' },
	'processingsoftware' => { 53 => 0xb },
	'producer' => { 133 => 'Producer', 171 => 'Producer' },
	'productid' => { 60 => 0x32 },
	'programiso' => { 136 => 0x3c },
	'programmode' => { 95 => 0x5 },
	'programshift' => { 105 => 0xd },
	'programversion' => { 59 => 0x46 },
	'projectrefpath' => { 176 => 'projectRefPath' },
	'projectreftype' => { 176 => 'projectRefType' },
	'province-state' => { 59 => 0x5f },
	'publisher' => { 167 => 'publisher' },
	'pulldown' => { 176 => 'pullDown' },
	'quality' => { 0 => 0x1, 8 => 0x3, 49 => 0x2, 50 => 0x3002, 57 => 0x1000, 64 => 0x9, 105 => 0x4, 111 => 0x3, 129 => 0x201, 145 => 0x8, 148 => 0x2, 158 => 0x16, 159 => 0xb047 },
	'qualitymode' => { 50 => 0x8 },
	'quantizationmethod' => { 61 => 0x78 },
	'quickcontroldialinmeter' => { 30 => 0x703 },
	'quickshot' => { 157 => 0x213 },
	'rasterizedcaption' => { 59 => 0x7d },
	'rating' => { 53 => 0x4746, 149 => 0xdf, 168 => 'rating', 174 => 'Rating' },
	'ratingpercent' => { 53 => 0x4749, 163 => 'Rating' },
	'rawandjpgrecording' => { 28 => 0x8, 147 => 0xd },
	'rawbrightnessadj' => { 47 => 0x38 },
	'rawcoloradj' => { 47 => 0x2e },
	'rawcolortoneadj' => { 48 => 0x1a },
	'rawcontrastadj' => { 48 => 0x1e },
	'rawcropbottom' => { 149 => 0xd4 },
	'rawcropleft' => { 149 => 0xd1 },
	'rawcropright' => { 149 => 0xd3 },
	'rawcroptop' => { 149 => 0xd2 },
	'rawcustomsaturation' => { 47 => 0x30 },
	'rawcustomtone' => { 47 => 0x34 },
	'rawdatauniqueid' => { 53 => 0xc65d },
	'rawdepth' => { 94 => 0x10 },
	'rawdevautogradation' => { 131 => 0x119 },
	'rawdevcolorspace' => { 130 => 0x108, 131 => 0x109 },
	'rawdevcontrastvalue' => { 130 => 0x106, 131 => 0x105 },
	'rawdeveditstatus' => { 130 => 0x10b },
	'rawdevengine' => { 130 => 0x109, 131 => 0x10b },
	'rawdevexposurebiasvalue' => { 130 => 0x100, 131 => 0x100 },
	'rawdevgradation' => { 131 => 0x112 },
	'rawdevgraypoint' => { 130 => 0x103, 131 => 0x104 },
	'rawdevmemorycoloremphasis' => { 130 => 0x105, 131 => 0x108 },
	'rawdevnoisereduction' => { 130 => 0x10a, 131 => 0x10a },
	'rawdevpicturemode' => { 131 => 0x10c },
	'rawdevpm_bwfilter' => { 131 => 0x110 },
	'rawdevpmcontrast' => { 131 => 0x10e },
	'rawdevpmnoisefilter' => { 131 => 0x120 },
	'rawdevpmpicturetone' => { 131 => 0x111 },
	'rawdevpmsaturation' => { 131 => 0x10d },
	'rawdevpmsharpness' => { 131 => 0x10f },
	'rawdevsaturation3' => { 131 => 0x113 },
	'rawdevsaturationemphasis' => { 130 => 0x104, 131 => 0x107 },
	'rawdevsettings' => { 130 => 0x10c },
	'rawdevsharpnessvalue' => { 130 => 0x107, 131 => 0x106 },
	'rawdevversion' => { 130 => 0x0, 131 => 0x0 },
	'rawdevwbfineadjustment' => { 130 => 0x102, 131 => 0x103 },
	'rawdevwhitebalance' => { 131 => 0x101 },
	'rawdevwhitebalancevalue' => { 130 => 0x101, 131 => 0x102 },
	'rawfile' => { 53 => 0xfe4c },
	'rawfilename' => { 166 => 'RawFileName' },
	'rawhighlightpoint' => { 48 => 0x24 },
	'rawimagecenter' => { 105 => 0x99 },
	'rawimagesize' => { 145 => 0x39 },
	'rawinfoversion' => { 132 => 0x0 },
	'rawjpgheight' => { 45 => 0x4 },
	'rawjpgquality' => { 18 => 0x6, 45 => 0x1 },
	'rawjpgsize' => { 18 => 0x7, 45 => 0x2 },
	'rawjpgwidth' => { 45 => 0x3 },
	'rawlinear' => { 48 => 0x20 },
	'rawsaturationadj' => { 48 => 0x1c },
	'rawshadowpoint' => { 48 => 0x26 },
	'rawsharpnessadj' => { 48 => 0x22 },
	'recordid' => { 43 => 0x1804 },
	'recordingmode' => { 49 => 0x1, 148 => 0x1 },
	'recordmode' => { 8 => 0x9, 50 => 0x3000 },
	'recordshutterrelease' => { 157 => 0x217 },
	'redbalance' => { 129 => 0x1017, 137 => 0x11, 145 => 0x1c },
	'redcurvelimits' => { 47 => 0x18a },
	'redcurvepoints' => { 47 => 0x160 },
	'redeyecorrection' => { 121 => 0x0 },
	'redhue' => { 166 => 'RedHue' },
	'redsaturation' => { 166 => 'RedSaturation' },
	'referenceblackwhite' => { 53 => 0x214, 173 => 'ReferenceBlackWhite' },
	'referencedate' => { 59 => 0x2f },
	'referencenumber' => { 59 => 0x32 },
	'references' => { 76 => 'References' },
	'referenceservice' => { 59 => 0x2d },
	'relatedaudiofile' => { 74 => 'data' },
	'relatedaudiofilename' => { 74 => '1Name' },
	'relatedaudiofiletype' => { 74 => '0Type' },
	'relatedimagefileformat' => { 53 => 0x1000 },
	'relatedimageheight' => { 53 => 0x1002 },
	'relatedimagewidth' => { 53 => 0x1001 },
	'relatedsoundfile' => { 53 => 0xa004, 169 => 'RelatedSoundFile' },
	'relatedvideofile' => { 88 => 'data' },
	'relatedvideofilename' => { 88 => '1Name' },
	'relatedvideofiletype' => { 88 => '0Type' },
	'relation' => { 167 => 'relation' },
	'relativepeakaudiofilepath' => { 176 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 176 => 'relativeTimestamp' },
	'releasedate' => { 59 => 0x1e, 176 => 'releaseDate' },
	'releasesetting' => { 43 => 0x1016 },
	'releasetime' => { 59 => 0x23 },
	'renditionclass' => { 177 => 'RenditionClass' },
	'renditionofdocumentid' => { 177 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 177 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 177 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 177 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 177 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 177 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 177 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 177 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 177 => 'RenditionOfVersionID' },
	'renditionparams' => { 177 => 'RenditionParams' },
	'repeatingflashcount' => { 101 => 0xd },
	'repeatingflashrate' => { 101 => 0xc },
	'resampleparamsquality' => { 176 => 'resampleParamsQuality' },
	'resaved' => { 157 => 0x21e },
	'resolution' => { 81 => 'Resolution' },
	'resolutionmode' => { 158 => 0x4 },
	'resolutionunit' => { 53 => 0x128, 62 => 0x2, 173 => 'ResolutionUnit' },
	'retouchhistory' => { 105 => 0x9e },
	'reuseallowed' => { 178 => 'ReuseAllowed' },
	'revision' => { 168 => 'revision' },
	'rgbcurvelimits' => { 47 => 0x238 },
	'rgbcurvepoints' => { 47 => 0x20e },
	'ricohdate' => { 155 => 0x6 },
	'ricohimageheight' => { 155 => 0x2 },
	'ricohimagewidth' => { 155 => 0x0 },
	'rightascension' => { 84 => 'RightAscension' },
	'rights' => { 167 => 'rights' },
	'romoperationmode' => { 43 => 0x80d },
	'rotation' => { 7 => 0x17, 42 => 0x3, 47 => 0x26e, 56 => 0x4, 84 => 'Rotation', 90 => [0x65,0x50], 91 => 0x46, 92 => 0x5a, 118 => 0x76a43207, 136 => 0x30, 149 => 0xd8 },
	'routing' => { 154 => 'Routing' },
	'rowsperstrip' => { 53 => 0x116 },
	'safetyshift' => { 30 => 0x108 },
	'safetyshiftinavortv' => { 28 => 0x10, 29 => 0x10, 31 => 0xf, 32 => 0x10, 35 => 0x10 },
	'samplebits' => { 74 => 'SampleBits' },
	'samplerate' => { 74 => 'SampleRate' },
	'samplesperpixel' => { 53 => 0x115, 173 => 'SamplesPerPixel' },
	'samplestructure' => { 61 => 0x5a },
	'sanyoquality' => { 157 => 0x201 },
	'sanyothumbnail' => { 157 => 0x100 },
	'saturation' => { 2 => 0x6e, 4 => 0x76, 8 => 0xe, 14 => 0x1, 49 => 0xd, 50 => [0x3013,0x1f], 53 => [0xa409,0xfe55], 57 => 0x1003, 75 => 'Saturation', 89 => 0x1f, 90 => 0x32, 91 => 0x28, 92 => 0x1a, 95 => 0x1, 105 => [0x94,0xaa], 107 => 0x35, 136 => 0x40, 145 => 0x1f, 148 => 0xd, 155 => 0x28, 158 => 0x10, 166 => 'Saturation', 169 => 'Saturation' },
	'saturationadj' => { 47 => 0x116 },
	'saturationadjustmentaqua' => { 166 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 166 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 166 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 166 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 166 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 166 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 166 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 166 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 6 => 0xfe },
	'saturationlandscape' => { 6 => 0xfc },
	'saturationneutral' => { 6 => 0xfd },
	'saturationportrait' => { 6 => 0xfb },
	'saturationsetting' => { 132 => 0x1010 },
	'saturationstandard' => { 6 => 0xfa },
	'saturationuserdef1' => { 6 => 0x100 },
	'saturationuserdef2' => { 6 => 0x101 },
	'saturationuserdef3' => { 6 => 0x102 },
	'saveid' => { 177 => 'SaveID' },
	'scaledresolution' => { 115 => 0x9e },
	'scaletype' => { 176 => 'scaleType' },
	'scanningdirection' => { 61 => 0x64 },
	'scene' => { 170 => 'Scene', 176 => 'scene' },
	'scenearea' => { 127 => 0x211, 129 => 0x1031 },
	'sceneassist' => { 105 => 0x9c },
	'scenecapturetype' => { 53 => 0xa406, 169 => 'SceneCaptureType' },
	'scenedetect' => { 127 => 0x210, 129 => 0x1030 },
	'scenedetectdata' => { 127 => 0x212, 129 => 0x1033 },
	'scenemode' => { 65 => 0xfa02, 93 => 0x100, 105 => 0x8f, 124 => 0x509, 129 => 0x403, 136 => 0x8001, 159 => 0xb023 },
	'scenemodeused' => { 67 => [0x6002,0xf002] },
	'sceneselect' => { 157 => 0x21f },
	'scenetype' => { 53 => 0xa301, 169 => 'SceneType' },
	'securityclassification' => { 53 => 0x9212 },
	'selectableafpoint' => { 30 => 0x509 },
	'selftimer' => { 8 => 0x2, 50 => 0x3001, 136 => 0x2e, 157 => 0x214 },
	'selftimer2' => { 27 => 0x1d },
	'selftimermode' => { 53 => 0x882b },
	'selftimertime' => { 43 => 0x1806 },
	'seminfo' => { 53 => 0x8546 },
	'sensingmethod' => { 53 => 0xa217, 169 => 'SensingMethod' },
	'sensitivityadjust' => { 145 => 0x40 },
	'sensorbluelevel' => { 26 => 0x5 },
	'sensorcleaning' => { 36 => 0xd },
	'sensorfullheight' => { 63 => 0xf904 },
	'sensorfullwidth' => { 63 => 0xf903 },
	'sensorheight' => { 63 => 0xf901, 65 => 0xfa21, 94 => 0x8 },
	'sensorpixelsize' => { 105 => 0x9a },
	'sensorredlevel' => { 26 => 0x4 },
	'sensorsize' => { 75 => 'SensorSize' },
	'sensortemperature' => { 127 => 0x1500, 129 => 0x1007 },
	'sensorwidth' => { 63 => 0xf900, 65 => 0xfa20, 94 => 0xa },
	'sequencenumber' => { 27 => 0x9, 50 => 0x301c, 57 => 0x1101, 64 => 0x1d, 136 => 0x2b },
	'sequenceshotinterval' => { 157 => 0x224 },
	'sequentialshot' => { 157 => 0x20e },
	'serialnumber' => { 21 => 0xc, 43 => 0x180b, 53 => 0xfde9, 63 => 0xfa04, 65 => 0xfa19, 73 => 0x0, 75 => 'SerialNumber', 105 => 0xa0, 125 => 0x101, 129 => [0x404,0x101a], 158 => 0x2, 164 => 'SerialNumber' },
	'serialnumberformat' => { 21 => 0x15, 43 => 0x183b },
	'seriesdatetime' => { 160 => 'SeriesDateTime' },
	'seriesdescription' => { 160 => 'SeriesDescription' },
	'seriesmodality' => { 160 => 'SeriesModality' },
	'seriesnumber' => { 160 => 'SeriesNumber' },
	'serviceidentifier' => { 60 => 0x1e },
	'setbuttoncrosskeysfunc' => { 33 => 0x0, 34 => 0x0 },
	'setbuttonfunction' => { 28 => 0x1, 36 => 0xc },
	'setbuttonwhenshooting' => { 30 => 0x704 },
	'setfunctionwhenshooting' => { 31 => 0x0, 32 => 0x1, 35 => 0x1 },
	'shadingcompensation' => { 124 => 0x50c },
	'shadingcompensation2' => { 128 => 0x1012 },
	'shadow' => { 158 => 0xe },
	'shadows' => { 53 => 0xfe52, 166 => 'Shadows' },
	'shadowscale' => { 53 => 0xc633 },
	'shadowtint' => { 166 => 'ShadowTint' },
	'shakereduction' => { 146 => 0x1 },
	'sharpendetail' => { 166 => 'SharpenDetail' },
	'sharpenedgemasking' => { 166 => 'SharpenEdgeMasking' },
	'sharpenradius' => { 166 => 'SharpenRadius' },
	'sharpness' => { 1 => [0x42,0x48], 2 => 0x72, 4 => 0x74, 8 => 0xf, 26 => 0x2, 49 => 0xb, 50 => [0x3011,0x21], 53 => [0xa40a,0xfe56], 57 => 0x1001, 64 => 0x6b, 71 => 0x37, 75 => 'Sharpness', 89 => 0x21, 90 => 0x30, 91 => 0x26, 92 => 0x18, 95 => 0x3, 105 => 0x6, 107 => 0x32, 129 => 0x100f, 136 => 0x41, 145 => 0x21, 148 => 0xb, 155 => 0x22, 156 => 0x1003, 158 => 0x11, 166 => 'Sharpness', 169 => 'Sharpness' },
	'sharpnessfactor' => { 129 => 0x102a },
	'sharpnessfaithful' => { 6 => 0xf5 },
	'sharpnessfrequency' => { 1 => [0x41,0x47], 26 => 0x3 },
	'sharpnesslandscape' => { 6 => 0xf3 },
	'sharpnessmonochrome' => { 6 => 0xf6 },
	'sharpnessneutral' => { 6 => 0xf4 },
	'sharpnessportrait' => { 6 => 0xf2 },
	'sharpnesssetting' => { 124 => 0x506, 132 => 0x1013 },
	'sharpnessstandard' => { 6 => 0xf1 },
	'sharpnessuserdef1' => { 6 => 0xf7 },
	'sharpnessuserdef2' => { 6 => 0xf8 },
	'sharpnessuserdef3' => { 6 => 0xf9 },
	'shootingmode' => { 75 => 'ShootingMode', 105 => 0x89, 136 => 0x1f },
	'shortdescription' => { 168 => 'shortdescription' },
	'shortdocumentid' => { 59 => 0xba },
	'shortfocal' => { 1 => 0xe, 2 => 0x11, 3 => 0x113, 4 => 0x11, 5 => 0xd8, 6 => 0x93, 8 => 0x18 },
	'shortownername' => { 6 => 0xac },
	'shortreleasetimelag' => { 30 => 0x80d },
	'shotdate' => { 176 => 'shotDate' },
	'shotlocation' => { 176 => 'shotLocation' },
	'shotname' => { 176 => 'shotName' },
	'shutter-aelock' => { 28 => 0x4, 31 => 0x3, 32 => 0x4, 33 => 0x3, 34 => 0x3, 35 => 0x4, 36 => 0x2 },
	'shutteraelbutton' => { 29 => 0x4 },
	'shutterbuttonafonbutton' => { 30 => 0x701 },
	'shuttercount' => { 3 => 0x176, 18 => 0x1, 145 => 0x5d },
	'shuttercurtainsync' => { 28 => 0xf, 29 => 0xf, 30 => 0x305, 31 => 0xe, 32 => 0xf, 33 => 0x8, 34 => 0x8, 35 => 0xf, 36 => 0x8 },
	'shuttermode' => { 64 => 0x1b },
	'shutterreleasemethod' => { 43 => 0x1010 },
	'shutterreleasenocfcard' => { 28 => 0x2, 29 => 0x2, 36 => 0xf },
	'shutterreleasetiming' => { 43 => 0x1011 },
	'shutterspeedrange' => { 30 => 0x10c },
	'shutterspeedvalue' => { 53 => 0x9201, 129 => 0x1000, 169 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 172 => 'SidecarForExtension' },
	'similarityindex' => { 59 => 0xe4 },
	'slowshutter' => { 27 => 0x8 },
	'slowsync' => { 57 => 0x1030 },
	'smoothness' => { 53 => 0xfe57 },
	'software' => { 53 => 0x131, 76 => 'Software', 135 => 'Software', 158 => 0x18, 173 => 'Software' },
	'softwareversion' => { 157 => 0x207 },
	'source' => { 59 => 0x73, 135 => 'Source', 167 => 'source', 168 => 'source', 172 => 'Source' },
	'sourceresolution' => { 115 => 0xae },
	'spatialfrequencyresponsecolumns' => { 169 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 169 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 169 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 169 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 176 => 'speakerPlacement' },
	'specialinstructions' => { 59 => 0x28 },
	'specialmode' => { 129 => 0x200, 157 => 0x200 },
	'spectralsensitivity' => { 53 => 0x8824, 169 => 'SpectralSensitivity' },
	'splittoningbalance' => { 166 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 166 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 166 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 166 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 166 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 89 => 0x2d },
	'spotfocuspointy' => { 89 => 0x2e },
	'spotmeteringmode' => { 8 => 0x27 },
	'spotmeterlinktoafpoint' => { 30 => 0x107 },
	'srfocallength' => { 146 => 0x3 },
	'srhalfpresstime' => { 146 => 0x2 },
	'srresult' => { 146 => 0x0 },
	'starttimecodetimeformat' => { 176 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 176 => 'startTimecodeTimeValue' },
	'state' => { 80 => 'State', 172 => 'State' },
	'status' => { 162 => 'Status' },
	'storagemethod' => { 94 => 0x12 },
	'straightenangle' => { 118 => 0x2fc08431 },
	'stretchmode' => { 176 => 'stretchMode' },
	'studydatetime' => { 160 => 'StudyDateTime' },
	'studydescription' => { 160 => 'StudyDescription' },
	'studyid' => { 160 => 'StudyID' },
	'studyphysician' => { 160 => 'StudyPhysician' },
	'sub-location' => { 59 => 0x5c },
	'subfiledata' => { 83 => 'data' },
	'subfiledirectory' => { 83 => '1Directory' },
	'subfilemimetype' => { 83 => '2MIME' },
	'subfilename' => { 83 => '1Name' },
	'subfileresource' => { 83 => 'rsrc' },
	'subfiletype' => { 53 => 0xfe, 83 => '0Type' },
	'subject' => { 133 => 'Subject', 154 => 'Subject', 167 => 'subject', 171 => 'Subject' },
	'subjectarea' => { 169 => 'SubjectArea' },
	'subjectcode' => { 170 => 'SubjectCode' },
	'subjectdistance' => { 53 => 0x9206, 64 => 0x3e, 169 => 'SubjectDistance' },
	'subjectdistancerange' => { 53 => 0xa40c, 169 => 'SubjectDistanceRange' },
	'subjectlocation' => { 53 => [0x9214,0xa214], 169 => 'SubjectLocation' },
	'subjectprogram' => { 89 => 0x22 },
	'subjectreference' => { 59 => 0xc },
	'subsectime' => { 53 => 0x9290 },
	'subsectimedigitized' => { 53 => 0x9292 },
	'subsectimeoriginal' => { 53 => 0x9291 },
	'superimposeddisplay' => { 28 => 0xa, 30 => 0x510, 31 => 0x9, 32 => 0xa, 35 => 0xa, 36 => 0xe },
	'supplementalcategories' => { 59 => 0x14, 172 => 'SupplementalCategories' },
	'supplementaltype' => { 61 => 0x37 },
	'svisosetting' => { 147 => 0x14 },
	'switchtoregisteredafpoint' => { 29 => 0x12, 30 => 0x50a },
	'tagged' => { 149 => 0xdd },
	'tapename' => { 176 => 'tapeName' },
	'targetaperture' => { 27 => 0x4 },
	'targetcompressionratio' => { 41 => 0x1 },
	'targetdistancesetting' => { 43 => 0x1807 },
	'targetexposuretime' => { 27 => 0x5 },
	'targetimagetype' => { 43 => 0x100a },
	'teleconverter' => { 93 => 0x105 },
	'temperature' => { 166 => 'Temperature' },
	'tempo' => { 176 => 'tempo' },
	'thresholding' => { 53 => 0x107 },
	'thumbnailfilename' => { 43 => 0x817 },
	'thumbnailheight' => { 65 => 0xfa55 },
	'thumbnailimage' => { 43 => 0x2008, 51 => 'ThumbnailImage', 55 => 0x3, 86 => 'data', 129 => 0x100 },
	'thumbnailimagename' => { 86 => '1Name' },
	'thumbnailimagesize' => { 86 => 'ImageSize' },
	'thumbnailimagetype' => { 86 => '0Type' },
	'thumbnailimagevalidarea' => { 21 => 0x13 },
	'thumbnaillength' => { 53 => 0x202 },
	'thumbnailoffset' => { 53 => 0x201 },
	'thumbnailsformat' => { 174 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 174 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 174 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 174 => 'ThumbnailsWidth' },
	'thumbnailwidth' => { 65 => 0xfa54 },
	'tilelength' => { 53 => 0x143 },
	'tilewidth' => { 53 => 0x142 },
	'time' => { 145 => 0x7 },
	'timecreated' => { 59 => 0x3c, 64 => 0x14, 71 => 0x10, 150 => 'TimeCreated' },
	'timerlength' => { 30 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 176 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 176 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 176 => 'timeScaleParamsQuality' },
	'timesent' => { 60 => 0x50 },
	'timesignature' => { 176 => 'timeSignature' },
	'timesincepoweron' => { 136 => 0x29 },
	'timestamp' => { 3 => 0x45e, 6 => 0x11c, 135 => 'TimeStamp' },
	'timezonecode' => { 46 => 0x1 },
	'timezoneinfo' => { 46 => 0x2 },
	'timezoneoffset' => { 53 => 0x882a },
	'tint' => { 166 => 'Tint' },
	'title' => { 76 => 'Title', 133 => 'Title', 135 => 'Title', 154 => 'Title', 167 => 'title', 171 => 'Title' },
	'tonecomp' => { 105 => 0x81 },
	'tonecurve' => { 26 => 0x1, 145 => 0x402, 166 => 'ToneCurve' },
	'tonecurveactive' => { 47 => 0x110 },
	'tonecurvename' => { 166 => 'ToneCurveName' },
	'tonecurveproperty' => { 47 => 0x3c },
	'tonecurves' => { 145 => 0x403 },
	'toningeffect' => { 18 => 0xf, 105 => 0xb3, 107 => 0x38 },
	'toningeffectmonochrome' => { 6 => 0x108 },
	'toningsaturation' => { 107 => 0x39 },
	'totalzoom' => { 64 => 0x62 },
	'tracknumber' => { 176 => 'trackNumber' },
	'trailersignature' => { 83 => 'zmie' },
	'transferfunction' => { 173 => 'TransferFunction' },
	'transmissionreference' => { 172 => 'TransmissionReference' },
	'travelday' => { 136 => 0x36 },
	'ttl_da_adown' => { 143 => 0x5 },
	'ttl_da_aup' => { 143 => 0x4 },
	'ttl_da_bdown' => { 143 => 0x7 },
	'ttl_da_bup' => { 143 => 0x6 },
	'tvvalue' => { 39 => 0x1 },
	'type' => { 167 => 'type' },
	'uniquecameramodel' => { 53 => 0xc614 },
	'uniquedocumentid' => { 59 => 0xbb },
	'uniqueobjectname' => { 60 => 0x64 },
	'unknownblock' => { 128 => 0x1103 },
	'unknowncompensation' => { 158 => 0xc },
	'unknownnumber' => { 43 => 0x180b },
	'unsharp1color' => { 122 => 0x13 },
	'unsharp1halowidth' => { 122 => 0x19 },
	'unsharp1intensity' => { 122 => 0x17 },
	'unsharp1threshold' => { 122 => 0x1b },
	'unsharp2color' => { 122 => 0x2e },
	'unsharp2halowidth' => { 122 => 0x34 },
	'unsharp2intensity' => { 122 => 0x32 },
	'unsharp2threshold' => { 122 => 0x36 },
	'unsharp3color' => { 122 => 0x49 },
	'unsharp3halowidth' => { 122 => 0x4f },
	'unsharp3intensity' => { 122 => 0x4d },
	'unsharp3threshold' => { 122 => 0x51 },
	'unsharp4color' => { 122 => 0x64 },
	'unsharp4halowidth' => { 122 => 0x6a },
	'unsharp4intensity' => { 122 => 0x68 },
	'unsharp4threshold' => { 122 => 0x6c },
	'unsharpcount' => { 122 => 0x0 },
	'unsharpmask' => { 118 => 0x76a43200 },
	'urgency' => { 59 => 0xa, 172 => 'Urgency' },
	'url' => { 76 => 'URL', 135 => 'URL', 152 => 0x40b },
	'usablemeteringmodes' => { 30 => 0x10a },
	'usableshootingmodes' => { 30 => 0x109 },
	'usageterms' => { 179 => 'UsageTerms' },
	'usercomment' => { 43 => 0x805, 53 => 0x9286, 169 => 'UserComment' },
	'userdef1picturestyle' => { 6 => 0x10c },
	'userdef2picturestyle' => { 6 => 0x10e },
	'userdef3picturestyle' => { 6 => 0x110 },
	'userfields' => { 162 => 'UserFields' },
	'usmlenselectronicmf' => { 29 => 0x7, 30 => 0x501 },
	'utmeasting' => { 87 => 'Easting' },
	'utmmapdatum' => { 87 => 'Datum' },
	'utmnorthing' => { 87 => 'Northing' },
	'utmzone' => { 87 => 'Zone' },
	'validbits' => { 128 => 0x611, 129 => 0x102c },
	'validpixeldepth' => { 132 => 0x611 },
	'variousmodes' => { 64 => 0x26 },
	'variousmodes2' => { 64 => 0x3a },
	'variprogram' => { 105 => 0xab },
	'version' => { 57 => 0x0, 154 => 'Version', 166 => 'Version' },
	'versionid' => { 177 => 'VersionID' },
	'versionscomments' => { 177 => 'VersionsComments' },
	'versionseventaction' => { 177 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 177 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 177 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 177 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 177 => 'VersionsEventWhen' },
	'versionsmodifier' => { 177 => 'VersionsModifier' },
	'versionsmodifydate' => { 177 => 'VersionsModifyDate' },
	'versionsversion' => { 177 => 'VersionsVersion' },
	'vibrance' => { 166 => 'Vibrance' },
	'vibrationreduction' => { 112 => 0x4 },
	'videoalphamode' => { 176 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 176 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 176 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 176 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 176 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 176 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 176 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 176 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 176 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 176 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 176 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 176 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 176 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 176 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 176 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 176 => 'videoColorSpace' },
	'videocompressor' => { 176 => 'videoCompressor' },
	'videofieldorder' => { 176 => 'videoFieldOrder' },
	'videoframerate' => { 176 => 'videoFrameRate' },
	'videoframesizeh' => { 176 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 176 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 176 => 'videoFrameSizeW' },
	'videomoddate' => { 176 => 'videoModDate' },
	'videopixelaspectratio' => { 176 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 176 => 'videoPixelDepth' },
	'viewinfoduringexposure' => { 30 => 0x407 },
	'vignetteamount' => { 166 => 'VignetteAmount' },
	'vignettecontrol' => { 118 => 0x76a43205 },
	'vignettecontrolintensity' => { 118 => 0xac6bd5c0 },
	'vignettemidpoint' => { 166 => 'VignetteMidpoint' },
	'voicememo' => { 157 => 0x216 },
	'vrdoffset' => { 21 => 0xd0 },
	'vrinfoversion' => { 112 => 0x0 },
	'wb_glevel' => { 128 => 0x11f },
	'wb_glevel3000k' => { 128 => 0x113 },
	'wb_glevel3300k' => { 128 => 0x114 },
	'wb_glevel3600k' => { 128 => 0x115 },
	'wb_glevel3900k' => { 128 => 0x116 },
	'wb_glevel4000k' => { 128 => 0x117 },
	'wb_glevel4300k' => { 128 => 0x118 },
	'wb_glevel4500k' => { 128 => 0x119 },
	'wb_glevel4800k' => { 128 => 0x11a },
	'wb_glevel5300k' => { 128 => 0x11b },
	'wb_glevel6000k' => { 128 => 0x11c },
	'wb_glevel6600k' => { 128 => 0x11d },
	'wb_glevel7500k' => { 128 => 0x11e },
	'wb_rbgglevels' => { 98 => 0x0 },
	'wb_rblevels' => { 128 => 0x100 },
	'wb_rblevels3000k' => { 128 => 0x102 },
	'wb_rblevels3300k' => { 128 => 0x103 },
	'wb_rblevels3600k' => { 128 => 0x104 },
	'wb_rblevels3900k' => { 128 => 0x105 },
	'wb_rblevels4000k' => { 128 => 0x106 },
	'wb_rblevels4300k' => { 128 => 0x107 },
	'wb_rblevels4500k' => { 128 => 0x108 },
	'wb_rblevels4800k' => { 128 => 0x109 },
	'wb_rblevels5300k' => { 128 => 0x10a },
	'wb_rblevels6000k' => { 128 => 0x10b },
	'wb_rblevels6600k' => { 128 => 0x10c },
	'wb_rblevels7500k' => { 128 => 0x10d },
	'wb_rblevelsauto' => { 132 => 0x110 },
	'wb_rblevelscloudy' => { 132 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 132 => 0x132 },
	'wb_rblevelscwb1' => { 128 => 0x10e },
	'wb_rblevelscwb2' => { 128 => 0x10f },
	'wb_rblevelscwb3' => { 128 => 0x110 },
	'wb_rblevelscwb4' => { 128 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 132 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 132 => 0x131 },
	'wb_rblevelseveningsunlight' => { 132 => 0x124 },
	'wb_rblevelsfineweather' => { 132 => 0x122 },
	'wb_rblevelsshade' => { 132 => 0x120 },
	'wb_rblevelstungsten' => { 132 => 0x123 },
	'wb_rblevelsused' => { 132 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 132 => 0x133 },
	'wb_rgbglevels' => { 100 => 0x0 },
	'wb_rggblevels' => { 99 => 0x0 },
	'wb_rggblevelsasshot' => { 10 => 0x19, 11 => 0x18, 12 => 0x3f, 13 => 0x3f },
	'wb_rggblevelsauto' => { 9 => 0x0, 10 => 0x1e, 11 => 0x22, 12 => 0x44, 13 => 0x44 },
	'wb_rggblevelscloudy' => { 9 => 0xc, 10 => 0x2d, 11 => 0x31, 12 => 0x58, 13 => 0x5d, 145 => 0x20f },
	'wb_rggblevelscustom' => { 9 => 0x1c, 12 => 0x80 },
	'wb_rggblevelscustom1' => { 10 => 0x41 },
	'wb_rggblevelscustom2' => { 10 => 0x46 },
	'wb_rggblevelsdaylight' => { 9 => 0x4, 10 => 0x23, 11 => 0x27, 12 => 0x4e, 13 => 0x53, 145 => 0x20d },
	'wb_rggblevelsflash' => { 9 => 0x18, 10 => 0x3c, 11 => 0x45, 12 => 0x6c, 13 => 0x71, 145 => 0x214 },
	'wb_rggblevelsfluorescent' => { 9 => 0x14, 10 => 0x37, 11 => 0x3b, 12 => 0x62, 13 => 0x67 },
	'wb_rggblevelsfluorescentd' => { 145 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 145 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 145 => 0x213 },
	'wb_rggblevelskelvin' => { 9 => 0x20, 11 => 0x40, 12 => 0x67, 13 => 0x6c },
	'wb_rggblevelsmeasured' => { 12 => 0x49, 13 => 0x49 },
	'wb_rggblevelspc1' => { 11 => 0x90, 12 => 0x71 },
	'wb_rggblevelspc2' => { 11 => 0x95, 12 => 0x76 },
	'wb_rggblevelspc3' => { 11 => 0x9a, 12 => 0x7b },
	'wb_rggblevelsshade' => { 9 => 0x8, 10 => 0x28, 11 => 0x2c, 12 => 0x53, 13 => 0x58, 145 => 0x20e },
	'wb_rggblevelstungsten' => { 9 => 0x10, 10 => 0x32, 11 => 0x36, 12 => 0x5d, 13 => 0x62, 145 => 0x210 },
	'wb_rggblevelsunknown' => { 11 => 0x1d },
	'wb_rggblevelsunknown10' => { 11 => 0x72, 13 => 0x9e },
	'wb_rggblevelsunknown11' => { 11 => 0x77, 13 => 0xa3 },
	'wb_rggblevelsunknown12' => { 11 => 0x7c },
	'wb_rggblevelsunknown13' => { 11 => 0x81 },
	'wb_rggblevelsunknown14' => { 11 => 0x86 },
	'wb_rggblevelsunknown15' => { 11 => 0x8b },
	'wb_rggblevelsunknown16' => { 11 => 0x9f },
	'wb_rggblevelsunknown2' => { 11 => 0x4a, 13 => 0x76 },
	'wb_rggblevelsunknown3' => { 11 => 0x4f, 13 => 0x7b },
	'wb_rggblevelsunknown4' => { 11 => 0x54, 13 => 0x80 },
	'wb_rggblevelsunknown5' => { 11 => 0x59, 13 => 0x85 },
	'wb_rggblevelsunknown6' => { 11 => 0x5e, 13 => 0x8a },
	'wb_rggblevelsunknown7' => { 11 => 0x63, 13 => 0x8f },
	'wb_rggblevelsunknown8' => { 11 => 0x68, 13 => 0x94 },
	'wb_rggblevelsunknown9' => { 11 => 0x6d, 13 => 0x99 },
	'wbadjbluebalance' => { 123 => 0x8 },
	'wbadjcolortemp' => { 47 => 0x1a },
	'wbadjlighting' => { 123 => 0x15 },
	'wbadjmode' => { 123 => 0x10 },
	'wbadjredbalance' => { 123 => 0x0 },
	'wbadjrgblevels' => { 47 => 0x8 },
	'wbadjtemperature' => { 123 => 0x18 },
	'wbadjustab' => { 136 => 0x46 },
	'wbadjustgm' => { 136 => 0x47 },
	'wbbluelevel' => { 136 => 0x8006, 137 => 0x26 },
	'wbbracketmode' => { 18 => 0x9 },
	'wbbracketvalueab' => { 18 => 0xc },
	'wbbracketvaluegm' => { 18 => 0xd },
	'wbfinetuneactive' => { 47 => 0x24 },
	'wbfinetunesaturation' => { 47 => 0x28 },
	'wbfinetunetone' => { 47 => 0x2c },
	'wbgreenlevel' => { 136 => 0x8005, 137 => 0x25 },
	'wblevels' => { 96 => 0x4 },
	'wbmediaimagesizesetting' => { 30 => 0x708 },
	'wbmode' => { 95 => 0x4, 129 => 0x1015 },
	'wbredlevel' => { 136 => 0x8004, 137 => 0x24 },
	'wbscale' => { 96 => 0x0 },
	'wbshiftab' => { 26 => 0xc, 142 => 0x10 },
	'wbshiftgm' => { 26 => 0xd },
	'wbshiftmg' => { 142 => 0x11 },
	'webstatement' => { 179 => 'WebStatement' },
	'whitebalance' => { 1 => [0x44,0x4a], 2 => 0x36, 3 => 0x5e, 4 => 0x36, 5 => 0x6f, 6 => 0x54, 26 => 0x8, 27 => 0x7, 49 => 0x7, 50 => [0x19,0x2012], 53 => [0xa403,0xfe4e], 57 => 0x1002, 64 => 0x40, 89 => 0x3, 90 => 0xe, 91 => 0x4, 92 => 0xb, 105 => 0x5, 111 => 0x7, 136 => 0x3, 145 => 0x19, 148 => 0x7, 155 => 0x26, 158 => [0x3c,0x7], 166 => 'WhiteBalance', 169 => 'WhiteBalance' },
	'whitebalance2' => { 124 => 0x500 },
	'whitebalanceadj' => { 47 => 0x18, 118 => 0x76a43204 },
	'whitebalancebias' => { 50 => 0x2011, 129 => 0x304, 136 => 0x23 },
	'whitebalanceblue' => { 26 => 0x7 },
	'whitebalancebracket' => { 124 => 0x502, 129 => 0x303 },
	'whitebalancecomp' => { 132 => 0x1001 },
	'whitebalancefinetune' => { 57 => 0x100a, 105 => 0xb },
	'whitebalancemode' => { 145 => 0x1a },
	'whitebalancered' => { 26 => 0x6 },
	'whitebalancetemperature' => { 124 => 0x501 },
	'whiteboard' => { 129 => 0x301 },
	'whitepoint' => { 53 => 0x13e, 145 => 0x201, 173 => 'WhitePoint' },
	'widefocuszone' => { 89 => 0x2f },
	'widerange' => { 157 => 0x20f },
	'workcolorspace' => { 47 => 0x270 },
	'worldtimelocation' => { 136 => 0x3a, 145 => 0x22 },
	'writer-editor' => { 59 => 0x7a },
	'x3filllight' => { 158 => 0x12 },
	'xmp' => { 54 => 'XMP' },
	'xpauthor' => { 53 => 0x9c9d },
	'xpcomment' => { 53 => 0x9c9c },
	'xpkeywords' => { 53 => 0x9c9e },
	'xposition' => { 53 => 0x11e },
	'xpsubject' => { 53 => 0x9c9f },
	'xptitle' => { 53 => 0x9c9b },
	'xresolution' => { 53 => 0x11a, 62 => 0x3, 153 => 0x0, 173 => 'XResolution' },
	'xyresolution' => { 56 => 0x3 },
	'ycbcrcoefficients' => { 53 => 0x211, 173 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 53 => 0x213, 173 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 53 => 0x212, 173 => 'YCbCrSubSampling' },
	'yearcreated' => { 64 => 0x10, 71 => 0xc },
	'yposition' => { 53 => 0x11f },
	'yresolution' => { 53 => 0x11b, 62 => 0x5, 153 => 0x4, 173 => 'YResolution' },
	'zonematching' => { 93 => 0x10a, 95 => 0x3a, 159 => 0xb024 },
	'zonematchingon' => { 91 => 0x75 },
	'zoomsourcewidth' => { 8 => 0x24 },
	'zoomstepcount' => { 127 => 0x300, 129 => 0x100d },
	'zoomtargetwidth' => { 8 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'aelockbutton' => 1,
	'afaperture' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareaillumination' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationnotes' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshotneutral' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'autobracketmode' => 1,
	'autobracketorder' => 1,
	'autofp' => 1,
	'autoisomax' => 1,
	'autoisominshutterspeed' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'beep' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerafarea' => 1,
	'centerdarkrect' => 1,
	'centerweightedareasize' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalance4' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commanddials' => 1,
	'commanderchannel' => 1,
	'commandergroupa_manualoutput' => 1,
	'commandergroupa_ttl-aacomp' => 1,
	'commandergroupamode' => 1,
	'commandergroupb_manualoutput' => 1,
	'commandergroupb_ttl-aacomp' => 1,
	'commandergroupbmode' => 1,
	'commanderinternalflash' => 1,
	'commanderinternalmanualoutput' => 1,
	'commanderinternalttlcomp' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'dinf' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepsize' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exitpupilposition' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposuredelaymode' => 1,
	'exposureinfo' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashshutterspeed' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusareaselection' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'functionbutton' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'griddisplay' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightendpoints' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illumination' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagereview' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'maindialexposurecomp' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mb-d80batteries' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meteringtime' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelingflash' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'monitorofftime' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nomemorycard' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'notes' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrol' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'remoteonduration' => 1,
	'renderingintent' => 1,
	'repeatingflashoutput' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo0208' => 1,
	'shotinfo02xx' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'supermacro' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transform' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowninfo' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrpeak' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewfinderwarning' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vr_0x66' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grbglevels' => 1,
	'wb_grgblevels' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2008, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
