# This file was automatically generated by Dist::Zilla::Plugin::MakeMaker v5.039.
use strict;
use warnings;

use 5.008001;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Execute code after a scope finished compilation",
  "AUTHOR" => "Florian Ragwitz <rafl\@debian.org>, Peter Rabbitson <ribasushi\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Config" => 0,
    "ExtUtils::CBuilder" => "0.27",
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0
  },
  "DISTNAME" => "B-Hooks-EndOfScope",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME" => "B::Hooks::EndOfScope",
  "PREREQ_PM" => {
    "Module::Implementation" => "0.05",
    "Sub::Exporter::Progressive" => "0.001006",
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Glob" => 0,
    "File::Spec" => 0,
    "IPC::Open2" => 0,
    "Test::More" => "0.89"
  },
  "VERSION" => "0.16",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "ExtUtils::MakeMaker" => 0,
  "File::Glob" => 0,
  "File::Spec" => 0,
  "IPC::Open2" => 0,
  "Module::Implementation" => "0.05",
  "Sub::Exporter::Progressive" => "0.001006",
  "Test::More" => "0.89",
  "strict" => 0,
  "warnings" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.016
if (can_xs()) {
  requires('Variable::Magic', '0.48');

  # make sure we smoke the pure-perl version fallback
  test_requires('Devel::Hide', '0.0007') if is_smoker();
}
else {
  requires('constant');
  if ($] < '5.010') {
    requires('Scalar::Util');
    requires('base');
  } else {
    requires('Hash::Util::FieldHash');
    requires('Tie::Hash');
  }
}


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.016
sub can_cc {
  my @chunks = split(/ /, $Config::Config{cc});

  # $Config{cc} may contain args; try to find out the program part
  while (@chunks) {
    return can_run("@chunks") || (pop(@chunks), next);
  }

  return 0;
}

sub can_run {
  my ($cmd) = @_;

  return $cmd if -x $cmd;
  if (my $found_cmd = MM->maybe_command($cmd)) {
    return $found_cmd;
  }

  for my $dir ((split /$Config::Config{path_sep}/, $ENV{PATH}), '.') {
    next if $dir eq '';
    require File::Spec;
    my $abs = File::Spec->catfile($dir, $cmd);
    return $abs if (-x $abs or $abs = MM->maybe_command($abs));
  }

  return;
}

sub can_xs {
  # Do we have the configure_requires checker?
  unless (eval 'require ExtUtils::CBuilder; ExtUtils::CBuilder->VERSION(0.27); 1') {
    # They don't obey configure_requires, so it is someone old and delicate.
    # Try to avoid hurting them by falling back to an older simpler test.
    return can_cc();
  }

  # Do we have a working C compiler
  my $builder = ExtUtils::CBuilder->new(quiet => 1);
  unless ( $builder->have_compiler ) {
    # No working C compiler
    return 0;
  }

  # Write a C file representative of what XS becomes
  require File::Temp;
  my ( $FH, $tmpfile ) = File::Temp::tempfile(
    "compilexs-XXXXX",
    SUFFIX => '.c',
  );
  binmode $FH;
  print $FH <<'END_C';
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

int main(int argc, char **argv) {
    return 0;
}

int boot_sanexs() {
    return 1;
}

END_C
  close $FH;

  # Can the C compiler access the same headers XS does
  my @libs   = ();
  my $object = undef;
  eval {
    local $^W = 0;
    $object = $builder->compile(
      source => $tmpfile,
    );
    @libs = $builder->link(
      objects     => $object,
      module_name => 'sanexs',
    );
  };
  my $result = $@ ? 0 : 1;

  # Clean up all the build files
  foreach ( $tmpfile, $object, @libs ) {
    next unless defined $_;
    1 while unlink;
  }

  return $result;
}

sub is_smoker {
  return $ENV{AUTOMATED_TESTING} ? 1 : 0;
}

# Fix Cygwin bug on maybe_command(), fixed in EUMM 6.69_04
BEGIN { if ( $^O eq 'cygwin' ) {
  require ExtUtils::MM_Cygwin;
  require ExtUtils::MM_Win32;
  {
    no warnings 'redefine';
    package ExtUtils::MM_Cygwin;
    sub maybe_command {
      my ($self, $file) = @_;
      my $cygpath = Cygwin::posix_to_win_path('/', 1);
      my $filepath = Cygwin::posix_to_win_path($file, 1);
      return (substr($filepath,0,length($cygpath)) eq $cygpath)
        ? $self->SUPER::maybe_command($file) # Unix
        : ExtUtils::MM_Win32->maybe_command($file); # Win32
    }
  }
} }

sub requires {
  goto &runtime_requires;
}

sub runtime_requires {
  my ($module, $version_or_range) = @_;
  $version_or_range = '0' if not $version_or_range;
  $WriteMakefileArgs{PREREQ_PM}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub test_requires {
  my ($module, $version_or_range) = @_;
  $version_or_range = '0' if not $version_or_range;
  $WriteMakefileArgs{TEST_REQUIRES}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}
